/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.MapImage;
import org.openstreetmap.josm.gui.mappaint.NodeElemStyle;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.xml.XmlStyleSource;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.gui.preferences.map.MapPaintPreference;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public final class MapPaintStyles {
    private static ElemStyles styles = new ElemStyles();
    protected static final CopyOnWriteArrayList<MapPaintSylesUpdateListener> listeners = new CopyOnWriteArrayList();

    public static ElemStyles getStyles() {
        return styles;
    }

    public static ImageProvider getIconProvider(IconReference ref, boolean test) {
        String namespace = ref.source.getPrefName();
        ImageProvider i = new ImageProvider(ref.iconName).setDirs(MapPaintStyles.getIconSourceDirs(ref.source)).setId("mappaint." + namespace).setArchive(ref.source.zipIcons).setInArchiveDir(ref.source.getZipEntryDirName()).setOptional(true);
        if (test && i.get() == null) {
            Main.warn("Mappaint style \"" + namespace + "\" (" + ref.source.getDisplayString() + ") icon \"" + ref.iconName + "\" not found.");
            return null;
        }
        return i;
    }

    public static ImageIcon getIcon(IconReference ref, int width, int height) {
        String namespace = ref.source.getPrefName();
        ImageIcon i = MapPaintStyles.getIconProvider(ref, false).setWidth(width).setHeight(height).get();
        if (i == null) {
            Main.warn("Mappaint style \"" + namespace + "\" (" + ref.source.getDisplayString() + ") icon \"" + ref.iconName + "\" not found.");
            return null;
        }
        return i;
    }

    public static ImageIcon getNoIcon_Icon(StyleSource source) {
        return new ImageProvider("misc/no_icon").setDirs(MapPaintStyles.getIconSourceDirs(source)).setId("mappaint." + source.getPrefName()).setArchive(source.zipIcons).setInArchiveDir(source.getZipEntryDirName()).setOptional(true).get();
    }

    public static ImageIcon getNodeIcon(Tag tag) {
        return MapPaintStyles.getNodeIcon(tag, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon getNodeIcon(Tag tag, boolean includeDeprecatedIcon) {
        if (tag != null) {
            StyleCache.StyleList styleList;
            DataSet ds = new DataSet();
            Node virtualNode = new Node(LatLon.ZERO);
            virtualNode.put(tag.getKey(), tag.getValue());
            MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().lock();
            try {
                ds.addPrimitive(virtualNode);
                styleList = (StyleCache.StyleList)MapPaintStyles.getStyles().generateStyles((OsmPrimitive)virtualNode, (double)0.5, (boolean)false).a;
                ds.removePrimitive(virtualNode);
            }
            finally {
                MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().unlock();
            }
            if (styleList != null) {
                for (ElemStyle style : styleList) {
                    MapImage mapImage;
                    if (!(style instanceof NodeElemStyle) || (mapImage = ((NodeElemStyle)style).mapImage) == null) continue;
                    if (includeDeprecatedIcon || mapImage.name == null || !"misc/deprecated.png".equals(mapImage.name)) {
                        return new ImageIcon(mapImage.getImage(false));
                    }
                    return null;
                }
            }
        }
        return null;
    }

    public static List<String> getIconSourceDirs(StyleSource source) {
        LinkedList<String> dirs = new LinkedList<String>();
        File sourceDir = source.getLocalSourceDir();
        if (sourceDir != null) {
            dirs.add(sourceDir.getPath());
        }
        Collection<String> prefIconDirs = Main.pref.getCollection("mappaint.icon.sources");
        for (String fileset : prefIconDirs) {
            String[] a = fileset.indexOf(61) >= 0 ? fileset.split("=", 2) : new String[]{"", fileset};
            if (a[0].length() != 0 && !source.getPrefName().equals(a[0])) continue;
            dirs.add(a[1]);
        }
        if (Main.pref.getBoolean("mappaint.icon.enable-defaults", true)) {
            dirs.add("resource://images/styles/standard/");
            dirs.add("resource://images/styles/");
        }
        return dirs;
    }

    public static void readFromPreferences() {
        styles.clear();
        List<SourceEntry> sourceEntries = MapPaintPreference.MapPaintPrefHelper.INSTANCE.get();
        for (SourceEntry entry : sourceEntries) {
            StyleSource source = MapPaintStyles.fromSourceEntry(entry);
            if (source == null) continue;
            styles.add(source);
        }
        for (StyleSource source : styles.getStyleSources()) {
            MapPaintStyles.loadStyleForFirstTime(source);
        }
        MapPaintStyles.fireMapPaintSylesUpdated();
    }

    private static void loadStyleForFirstTime(StyleSource source) {
        long startTime = System.currentTimeMillis();
        source.loadStyleSource();
        if (Main.pref.getBoolean("mappaint.auto_reload_local_styles", true) && source.isLocal()) {
            try {
                Main.fileWatcher.registerStyleSource(source);
            }
            catch (IOException e) {
                Main.error(e);
            }
        }
        if (Main.isDebugEnabled()) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            Main.debug("Initializing map style " + source.url + " completed in " + Utils.getDurationString(elapsedTime));
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static StyleSource fromSourceEntry(SourceEntry entry) {
        block30: {
            block29: {
                cf = null;
                try {
                    mimes = new HashSet<String>();
                    mimes.addAll(Arrays.asList("application/xml, text/xml, text/plain; q=0.8, application/zip, application/octet-stream; q=0.5".split(", ")));
                    mimes.addAll(Arrays.asList("text/x-mapcss, text/mapcss, text/css; q=0.9, text/plain; q=0.8, application/zip, application/octet-stream; q=0.5".split(", ")));
                    cf = new CachedFile(entry.url).setHttpAccept(Utils.join(", ", mimes));
                    zipEntryPath = cf.findZipEntryPath("mapcss", "style");
                    if (zipEntryPath != null) {
                        entry.isZip = true;
                        entry.zipEntryPath = zipEntryPath;
                        return new MapCSSStyleSource(entry);
                    }
                    zipEntryPath = cf.findZipEntryPath("xml", "style");
                    if (zipEntryPath != null) {
                        return new XmlStyleSource(entry);
                    }
                    if (entry.url.toLowerCase().endsWith(".mapcss")) {
                        return new MapCSSStyleSource(entry);
                    }
                    if (entry.url.toLowerCase().endsWith(".xml")) {
                        return new XmlStyleSource(entry);
                    }
                    reader = new InputStreamReader(cf.getInputStream(), StandardCharsets.UTF_8);
                    var5_6 = null;
                    ** try [egrp 1[TRYBLOCK] [3, 5 : 186->268)] { 
lbl24:
                    // 1 sources

                    break block29;
lbl25:
                    // 1 sources

                    catch (Throwable var6_9) {
                        var5_6 = var6_9;
                        throw var6_9;
                    }
                }
                catch (IOException e) {
                    Main.warn(I18n.tr("Failed to load Mappaint styles from ''{0}''. Exception was: {1}", new Object[]{entry.url, e.toString()}));
                    Main.error(e);
                    return null;
                }
            }
            block21: while (true) {
                c = reader.read();
                switch (c) {
                    case -1: {
                        ** break;
lbl38:
                        // 1 sources

                        break block30;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        continue block21;
                    }
                    case 60: {
                        return new XmlStyleSource(entry);
                    }
                    default: {
                        return new MapCSSStyleSource(entry);
                    }
                }
                break;
            }
lbl45:
            // 1 sources

            finally {
                if (reader != null) {
                    if (var5_6 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable x2) {
                            var5_6.addSuppressed(x2);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        Main.warn("Could not detect style type. Using default (xml).");
        return new XmlStyleSource(entry);
    }

    public static void reloadStyles(int ... sel) {
        ArrayList<StyleSource> toReload = new ArrayList<StyleSource>();
        List<StyleSource> data = styles.getStyleSources();
        for (int i : sel) {
            toReload.add(data.get(i));
        }
        Main.worker.submit(new MapPaintStyleLoader(toReload));
    }

    public static void moveStyles(int[] sel, int delta) {
        if (!MapPaintStyles.canMoveStyles(sel, delta)) {
            return;
        }
        int[] selSorted = Utils.copyArray(sel);
        Arrays.sort(selSorted);
        ArrayList<StyleSource> data = new ArrayList<StyleSource>(styles.getStyleSources());
        for (int row : selSorted) {
            StyleSource t1 = (StyleSource)data.get(row);
            StyleSource t2 = (StyleSource)data.get(row + delta);
            data.set(row, t2);
            data.set(row + delta, t1);
        }
        styles.setStyleSources(data);
        MapPaintPreference.MapPaintPrefHelper.INSTANCE.put(data);
        MapPaintStyles.fireMapPaintSylesUpdated();
        styles.clearCached();
        Main.map.mapView.repaint();
    }

    public static boolean canMoveStyles(int[] sel, int i) {
        if (sel.length == 0) {
            return false;
        }
        int[] selSorted = Utils.copyArray(sel);
        Arrays.sort(selSorted);
        if (i < 0) {
            return selSorted[0] >= -i;
        }
        if (i > 0) {
            return selSorted[selSorted.length - 1] <= styles.getStyleSources().size() - 1 - i;
        }
        return true;
    }

    public static void toggleStyleActive(int ... sel) {
        List<StyleSource> data = styles.getStyleSources();
        for (int p : sel) {
            StyleSource s = data.get(p);
            s.active = !s.active;
        }
        MapPaintPreference.MapPaintPrefHelper.INSTANCE.put(data);
        if (sel.length == 1) {
            MapPaintStyles.fireMapPaintStyleEntryUpdated(sel[0]);
        } else {
            MapPaintStyles.fireMapPaintSylesUpdated();
        }
        styles.clearCached();
        Main.map.mapView.repaint();
    }

    public static void addStyle(SourceEntry entry) {
        StyleSource source = MapPaintStyles.fromSourceEntry(entry);
        if (source != null) {
            styles.add(source);
            MapPaintStyles.loadStyleForFirstTime(source);
            MapPaintPreference.MapPaintPrefHelper.INSTANCE.put(styles.getStyleSources());
            MapPaintStyles.fireMapPaintSylesUpdated();
            styles.clearCached();
            Main.map.mapView.repaint();
        }
    }

    public static void addMapPaintSylesUpdateListener(MapPaintSylesUpdateListener listener) {
        if (listener != null) {
            listeners.addIfAbsent(listener);
        }
    }

    public static void removeMapPaintSylesUpdateListener(MapPaintSylesUpdateListener listener) {
        listeners.remove(listener);
    }

    public static void fireMapPaintSylesUpdated() {
        for (MapPaintSylesUpdateListener l : listeners) {
            l.mapPaintStylesUpdated();
        }
    }

    public static void fireMapPaintStyleEntryUpdated(int idx) {
        for (MapPaintSylesUpdateListener l : listeners) {
            l.mapPaintStyleEntryUpdated(idx);
        }
    }

    public static interface MapPaintSylesUpdateListener {
        public void mapPaintStylesUpdated();

        public void mapPaintStyleEntryUpdated(int var1);
    }

    public static class MapPaintStyleLoader
    extends PleaseWaitRunnable {
        private boolean canceled;
        private Collection<StyleSource> sources;

        public MapPaintStyleLoader(Collection<StyleSource> sources) {
            super(I18n.tr("Reloading style sources", new Object[0]));
            this.sources = sources;
        }

        @Override
        protected void cancel() {
            this.canceled = true;
        }

        @Override
        protected void finish() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapPaintStyles.fireMapPaintSylesUpdated();
                    styles.clearCached();
                    if (Main.isDisplayingMapView()) {
                        Main.map.mapView.preferenceChanged(null);
                        Main.map.mapView.repaint();
                    }
                }
            });
        }

        @Override
        protected void realRun() {
            ProgressMonitor monitor = this.getProgressMonitor();
            monitor.setTicksCount(this.sources.size());
            for (StyleSource s : this.sources) {
                if (this.canceled) {
                    return;
                }
                monitor.subTask(I18n.tr("loading style ''{0}''...", s.getDisplayString()));
                s.loadStyleSource();
                monitor.worked(1);
            }
        }
    }

    public static class IconReference {
        public final String iconName;
        public final StyleSource source;

        public IconReference(String iconName, StyleSource source) {
            this.iconName = iconName;
            this.source = source;
        }

        public String toString() {
            return "IconReference{iconName='" + this.iconName + "' source='" + this.source.getDisplayString() + "'}";
        }
    }

    public static class TagKeyReference {
        public final String key;

        public TagKeyReference(String key) {
            this.key = key;
        }

        public String toString() {
            return "TagKeyReference{key='" + this.key + "'}";
        }
    }
}

