/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Objects;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.mappaint.BoxTextElemStyle;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class MapImage {
    private BufferedImage img;
    public int alpha = 255;
    public String name;
    public StyleSource source;
    public int width = -1;
    public int height = -1;
    public int offsetX = 0;
    public int offsetY = 0;
    private boolean temporary;
    private BufferedImage disabledImgCache;

    public MapImage(String name, StyleSource source) {
        this.name = name;
        this.source = source;
    }

    public BufferedImage getImage(boolean disabled) {
        if (disabled) {
            return this.getDisabled();
        }
        return this.getImage();
    }

    private BufferedImage getDisabled() {
        Image disImg;
        if (this.disabledImgCache != null) {
            return this.disabledImgCache;
        }
        if (this.img == null) {
            this.getImage();
        }
        if ((disImg = GuiHelper.getDisabledImage(this.img)) instanceof BufferedImage) {
            this.disabledImgCache = (BufferedImage)disImg;
        } else {
            this.disabledImgCache = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            Graphics g = this.disabledImgCache.getGraphics();
            g.drawImage(disImg, 0, 0, null);
            g.dispose();
        }
        return this.disabledImgCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getImage() {
        if (this.img != null) {
            return this.img;
        }
        this.temporary = false;
        new ImageProvider(this.name).setDirs(MapPaintStyles.getIconSourceDirs(this.source)).setId("mappaint." + this.source.getPrefName()).setArchive(this.source.zipIcons).setInArchiveDir(this.source.getZipEntryDirName()).setWidth(this.width).setHeight(this.height).setOptional(true).getInBackground(new ImageProvider.ImageCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finished(ImageIcon result) {
                MapImage mapImage = MapImage.this;
                synchronized (mapImage) {
                    if (result == null) {
                        ImageIcon noIcon = MapPaintStyles.getNoIcon_Icon(MapImage.this.source);
                        MapImage.this.img = noIcon == null ? null : (BufferedImage)noIcon.getImage();
                    } else {
                        MapImage.this.img = (BufferedImage)MapImage.this.rescale(result.getImage());
                    }
                    if (MapImage.this.temporary) {
                        MapImage.this.disabledImgCache = null;
                        Main.map.mapView.preferenceChanged(null);
                        Main.map.mapView.repaint();
                    }
                    MapImage.this.temporary = false;
                }
            }
        });
        MapImage mapImage = this;
        synchronized (mapImage) {
            if (this.img == null) {
                this.img = (BufferedImage)ImageProvider.get("clock").getImage();
                this.temporary = true;
            }
        }
        return this.img;
    }

    public int getWidth() {
        return this.getImage().getWidth(null);
    }

    public int getHeight() {
        return this.getImage().getHeight(null);
    }

    public float getAlphaFloat() {
        return Utils.color_int2float(this.alpha).floatValue();
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public BoxTextElemStyle.BoxProvider getBoxProvider() {
        return new MapImageBoxProvider();
    }

    private Image rescale(Image image) {
        if (image == null) {
            return null;
        }
        if (this.mustRescale(image)) {
            return ImageProvider.createBoundedImage(image, 16);
        }
        return image;
    }

    private boolean mustRescale(Image image) {
        return this.width == -1 && image.getWidth(null) > 48 && this.height == -1 && image.getHeight(null) > 48;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MapImage other = (MapImage)obj;
        return this.alpha == other.alpha && Objects.equals(this.name, other.name) && Objects.equals(this.source, other.source) && this.width == other.width && this.height == other.height;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + this.alpha;
        hash = 67 * hash + this.name.hashCode();
        hash = 67 * hash + this.source.hashCode();
        hash = 67 * hash + this.width;
        hash = 67 * hash + this.height;
        return hash;
    }

    public String toString() {
        return this.name;
    }

    protected class MapImageBoxProvider
    implements BoxTextElemStyle.BoxProvider {
        protected MapImageBoxProvider() {
        }

        @Override
        public BoxTextElemStyle.BoxProviderResult get() {
            return new BoxTextElemStyle.BoxProviderResult(this.box(), MapImage.this.temporary);
        }

        private Rectangle box() {
            int w = MapImage.this.getWidth();
            int h = MapImage.this.getHeight();
            if (MapImage.this.mustRescale(MapImage.this.getImage())) {
                w = 16;
                h = 16;
            }
            return new Rectangle(-w / 2, -h / 2, w, h);
        }

        private MapImage getParent() {
            return MapImage.this;
        }

        public int hashCode() {
            return MapImage.this.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BoxTextElemStyle.BoxProvider)) {
                return false;
            }
            if (obj instanceof MapImageBoxProvider) {
                MapImageBoxProvider other = (MapImageBoxProvider)obj;
                return MapImage.this.equals(other.getParent());
            }
            if (MapImage.this.temporary) {
                return false;
            }
            BoxTextElemStyle.BoxProvider other = (BoxTextElemStyle.BoxProvider)obj;
            BoxTextElemStyle.BoxProviderResult resultOther = other.get();
            if (resultOther.isTemporary()) {
                return false;
            }
            return this.box().equals(resultOther.getBox());
        }
    }
}

