/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.BasicStroke;
import java.awt.Color;
import java.util.Arrays;
import java.util.Objects;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.mapcss.Instruction;
import org.openstreetmap.josm.tools.Utils;

public class LineElemStyle
extends ElemStyle {
    public static final LineElemStyle UNTAGGED_WAY = LineElemStyle.createSimpleLineStyle(null, false);
    private BasicStroke line;
    public Color color;
    public Color dashesBackground;
    public float offset;
    public float realWidth;
    private BasicStroke dashesLine;

    public static LineElemStyle createSimpleLineStyle(Color color, boolean isAreaEdge) {
        MultiCascade mc = new MultiCascade();
        Cascade c = mc.getOrCreateCascade("default");
        c.put("width", Keyword.DEFAULT);
        c.put("color", color != null ? color : PaintColors.UNTAGGED.get());
        c.put("opacity", Float.valueOf(1.0f));
        if (isAreaEdge) {
            c.put("z-index", Float.valueOf(-3.0f));
        }
        return LineElemStyle.createLine(new Environment(null, mc, "default", null));
    }

    protected LineElemStyle(Cascade c, float default_major_z_index, BasicStroke line, Color color, BasicStroke dashesLine, Color dashesBackground, float offset, float realWidth) {
        super(c, default_major_z_index);
        this.line = line;
        this.color = color;
        this.dashesLine = dashesLine;
        this.dashesBackground = dashesBackground;
        this.offset = offset;
        this.realWidth = realWidth;
    }

    public static LineElemStyle createLine(Environment env) {
        return LineElemStyle.createImpl(env, LineType.NORMAL);
    }

    public static LineElemStyle createLeftCasing(Environment env) {
        LineElemStyle leftCasing = LineElemStyle.createImpl(env, LineType.LEFT_CASING);
        if (leftCasing != null) {
            leftCasing.isModifier = true;
        }
        return leftCasing;
    }

    public static LineElemStyle createRightCasing(Environment env) {
        LineElemStyle rightCasing = LineElemStyle.createImpl(env, LineType.RIGHT_CASING);
        if (rightCasing != null) {
            rightCasing.isModifier = true;
        }
        return rightCasing;
    }

    public static LineElemStyle createCasing(Environment env) {
        LineElemStyle casing = LineElemStyle.createImpl(env, LineType.CASING);
        if (casing != null) {
            casing.isModifier = true;
        }
        return casing;
    }

    private static LineElemStyle createImpl(Environment env, LineType type) {
        float miterlimit;
        Integer pAlpha;
        Float width;
        Cascade c = env.mc.getCascade(env.layer);
        Cascade c_def = env.mc.getCascade("default");
        switch (type) {
            case NORMAL: {
                width = LineElemStyle.getWidth(c, "width", LineElemStyle.getWidth(c_def, "width", null));
                break;
            }
            case CASING: {
                Instruction.RelativeFloat rel_casingWidth;
                Float casingWidth = c.get(type.prefix + "width", null, Float.class, true);
                if (casingWidth == null && (rel_casingWidth = c.get(type.prefix + "width", null, Instruction.RelativeFloat.class, true)) != null) {
                    casingWidth = Float.valueOf(rel_casingWidth.val / 2.0f);
                }
                if (casingWidth == null) {
                    return null;
                }
                width = LineElemStyle.getWidth(c, "width", LineElemStyle.getWidth(c_def, "width", null));
                if (width == null) {
                    width = Float.valueOf(0.0f);
                }
                width = Float.valueOf(width.floatValue() + 2.0f * casingWidth.floatValue());
                break;
            }
            case LEFT_CASING: 
            case RIGHT_CASING: {
                width = LineElemStyle.getWidth(c, type.prefix + "width", null);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (width == null) {
            return null;
        }
        float realWidth = c.get(type.prefix + "real-width", Float.valueOf(0.0f), Float.class).floatValue();
        if (realWidth > 0.0f && MapPaintSettings.INSTANCE.isUseRealWidth()) {
            String widthTag = env.osm.get("width");
            if (widthTag == null) {
                widthTag = env.osm.get("est_width");
            }
            if (widthTag != null) {
                try {
                    realWidth = Float.valueOf(widthTag).floatValue();
                }
                catch (NumberFormatException nfe) {
                    Main.warn(nfe);
                }
            }
        }
        Float offset = c.get("offset", Float.valueOf(0.0f), Float.class);
        switch (type) {
            case NORMAL: {
                break;
            }
            case CASING: {
                offset = Float.valueOf(offset.floatValue() + c.get(type.prefix + "offset", Float.valueOf(0.0f), Float.class).floatValue());
                break;
            }
            case LEFT_CASING: 
            case RIGHT_CASING: {
                Float baseWidthOnDefault = LineElemStyle.getWidth(c_def, "width", null);
                Float baseWidth = LineElemStyle.getWidth(c, "width", baseWidthOnDefault);
                if (baseWidth == null || baseWidth.floatValue() < 2.0f) {
                    baseWidth = Float.valueOf(2.0f);
                }
                float casingOffset = c.get(type.prefix + "offset", Float.valueOf(0.0f), Float.class).floatValue();
                casingOffset += baseWidth.floatValue() / 2.0f + width.floatValue() / 2.0f;
                if (type == LineType.RIGHT_CASING) {
                    casingOffset *= -1.0f;
                }
                offset = Float.valueOf(offset.floatValue() + casingOffset);
            }
        }
        int alpha = 255;
        Color color = c.get(type.prefix + "color", null, Color.class);
        if (color != null) {
            alpha = color.getAlpha();
        }
        if (type == LineType.NORMAL && color == null) {
            color = c.get("fill-color", null, Color.class);
        }
        if (color == null) {
            color = PaintColors.UNTAGGED.get();
        }
        if ((pAlpha = Utils.color_float2int(c.get(type.prefix + "opacity", null, Float.class))) != null) {
            alpha = pAlpha;
        }
        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
        float[] dashes = c.get(type.prefix + "dashes", null, float[].class, true);
        if (dashes != null) {
            boolean hasPositive = false;
            for (float f : dashes) {
                if (f > 0.0f) {
                    hasPositive = true;
                }
                if (!(f < 0.0f)) continue;
                dashes = null;
                break;
            }
            if (!hasPositive || dashes != null && dashes.length == 0) {
                dashes = null;
            }
        }
        float dashesOffset = c.get(type.prefix + "dashes-offset", Float.valueOf(0.0f), Float.class).floatValue();
        Color dashesBackground = c.get(type.prefix + "dashes-background-color", null, Color.class);
        if (dashesBackground != null) {
            pAlpha = Utils.color_float2int(c.get(type.prefix + "dashes-background-opacity", null, Float.class));
            if (pAlpha != null) {
                alpha = pAlpha;
            }
            dashesBackground = new Color(dashesBackground.getRed(), dashesBackground.getGreen(), dashesBackground.getBlue(), alpha);
        }
        Integer cap = null;
        Keyword capKW = c.get(type.prefix + "linecap", null, Keyword.class);
        if (capKW != null) {
            if ("none".equals(capKW.val)) {
                cap = 0;
            } else if ("round".equals(capKW.val)) {
                cap = 1;
            } else if ("square".equals(capKW.val)) {
                cap = 2;
            }
        }
        if (cap == null) {
            cap = dashes != null ? 0 : 1;
        }
        Integer join = null;
        Keyword joinKW = c.get(type.prefix + "linejoin", null, Keyword.class);
        if (joinKW != null) {
            if ("round".equals(joinKW.val)) {
                join = 1;
            } else if ("miter".equals(joinKW.val)) {
                join = 0;
            } else if ("bevel".equals(joinKW.val)) {
                join = 2;
            }
        }
        if (join == null) {
            join = 1;
        }
        if ((miterlimit = c.get(type.prefix + "miterlimit", Float.valueOf(10.0f), Float.class).floatValue()) < 1.0f) {
            miterlimit = 10.0f;
        }
        BasicStroke line = new BasicStroke(width.floatValue(), cap, join, miterlimit, dashes, dashesOffset);
        BasicStroke dashesLine = null;
        if (dashes != null && dashesBackground != null) {
            float[] dashes2 = new float[dashes.length];
            System.arraycopy(dashes, 0, dashes2, 1, dashes.length - 1);
            dashes2[0] = dashes[dashes.length - 1];
            dashesLine = new BasicStroke(width.floatValue(), cap, join, miterlimit, dashes2, dashes2[0] + dashesOffset);
        }
        return new LineElemStyle(c, type.default_major_z_index, line, color, dashesLine, dashesBackground, offset.floatValue(), realWidth);
    }

    @Override
    public void paintPrimitive(OsmPrimitive primitive, MapPaintSettings paintSettings, StyledMapRenderer painter, boolean selected, boolean outermember, boolean member) {
        Way w = (Way)primitive;
        boolean showOrientation = !this.isModifier && (selected || paintSettings.isShowDirectionArrow()) && !paintSettings.isUseRealWidth();
        boolean showOneway = !this.isModifier && !selected && !paintSettings.isUseRealWidth() && paintSettings.isShowOnewayArrow() && w.hasDirectionKeys();
        boolean onewayReversed = w.reversedDirection();
        boolean showOnlyHeadArrowOnly = showOrientation && !selected && paintSettings.isShowHeadArrowOnly();
        Color myDashedColor = this.dashesBackground;
        BasicStroke myLine = this.line;
        BasicStroke myDashLine = this.dashesLine;
        if (this.realWidth > 0.0f && paintSettings.isUseRealWidth() && !showOrientation) {
            float myWidth = (int)(100.0f / (float)(painter.getCircum() / (double)this.realWidth));
            if (myWidth < this.line.getLineWidth()) {
                myWidth = this.line.getLineWidth();
            }
            myLine = new BasicStroke(myWidth, this.line.getEndCap(), this.line.getLineJoin(), this.line.getMiterLimit(), this.line.getDashArray(), this.line.getDashPhase());
            if (this.dashesLine != null) {
                myDashLine = new BasicStroke(myWidth, this.dashesLine.getEndCap(), this.dashesLine.getLineJoin(), this.dashesLine.getMiterLimit(), this.dashesLine.getDashArray(), this.dashesLine.getDashPhase());
            }
        }
        Color myColor = this.color;
        if (selected) {
            myColor = paintSettings.getSelectedColor(this.color.getAlpha());
        } else if (member || outermember) {
            myColor = paintSettings.getRelationSelectedColor(this.color.getAlpha());
        } else if (w.isDisabled()) {
            myColor = paintSettings.getInactiveColor();
            myDashedColor = paintSettings.getInactiveColor();
        }
        painter.drawWay(w, myColor, myLine, myDashLine, myDashedColor, this.offset, showOrientation, showOnlyHeadArrowOnly, showOneway, onewayReversed);
        if (paintSettings.isShowOrderNumber() && !painter.isInactiveMode()) {
            int orderNumber = 0;
            Node lastN = null;
            for (Node n : w.getNodes()) {
                if (lastN != null) {
                    painter.drawOrderNumber(lastN, n, ++orderNumber, myColor);
                }
                lastN = n;
            }
        }
    }

    @Override
    public boolean isProperLineStyle() {
        return !this.isModifier;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        LineElemStyle other = (LineElemStyle)obj;
        return Objects.equals(this.line, other.line) && Objects.equals(this.color, other.color) && Objects.equals(this.dashesLine, other.dashesLine) && Objects.equals(this.dashesBackground, other.dashesBackground) && this.offset == other.offset && this.realWidth == other.realWidth;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 29 * hash + this.line.hashCode();
        hash = 29 * hash + this.color.hashCode();
        hash = 29 * hash + (this.dashesLine != null ? this.dashesLine.hashCode() : 0);
        hash = 29 * hash + (this.dashesBackground != null ? this.dashesBackground.hashCode() : 0);
        hash = 29 * hash + Float.floatToIntBits(this.offset);
        hash = 29 * hash + Float.floatToIntBits(this.realWidth);
        return hash;
    }

    @Override
    public String toString() {
        return "LineElemStyle{" + super.toString() + "width=" + this.line.getLineWidth() + " realWidth=" + this.realWidth + " color=" + Utils.toString(this.color) + " dashed=" + Arrays.toString(this.line.getDashArray()) + (this.line.getDashPhase() == 0.0f ? "" : " dashesOffses=" + this.line.getDashPhase()) + " dashedColor=" + Utils.toString(this.dashesBackground) + " linejoin=" + this.linejoinToString(this.line.getLineJoin()) + " linecap=" + this.linecapToString(this.line.getEndCap()) + (this.offset == 0.0f ? "" : " offset=" + this.offset) + '}';
    }

    public String linejoinToString(int linejoin) {
        switch (linejoin) {
            case 2: {
                return "bevel";
            }
            case 1: {
                return "round";
            }
            case 0: {
                return "miter";
            }
        }
        return null;
    }

    public String linecapToString(int linecap) {
        switch (linecap) {
            case 0: {
                return "none";
            }
            case 1: {
                return "round";
            }
            case 2: {
                return "square";
            }
        }
        return null;
    }

    public static enum LineType {
        NORMAL("", 3.0f),
        CASING("casing-", 2.0f),
        LEFT_CASING("left-casing-", 2.1f),
        RIGHT_CASING("right-casing-", 2.1f);

        public final String prefix;
        public final float default_major_z_index;

        private LineType(String prefix, float default_major_z_index) {
            this.prefix = prefix;
            this.default_major_z_index = default_major_z_index;
        }
    }
}

