/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.LanguageInfo;

public abstract class LabelCompositionStrategy {
    public abstract String compose(OsmPrimitive var1);

    public static class DeriveLabelFromNameTagsCompositionStrategy
    extends LabelCompositionStrategy {
        private static final String[] DEFAULT_NAME_TAGS = new String[]{"name:" + LanguageInfo.getJOSMLocaleCode(), "name", "int_name", "ref", "operator", "brand", "addr:housenumber"};
        private static final String[] DEFAULT_NAME_COMPLEMENT_TAGS = new String[]{"capacity"};
        private List<String> nameTags = new ArrayList<String>();
        private List<String> nameComplementTags = new ArrayList<String>();

        public DeriveLabelFromNameTagsCompositionStrategy() {
            this.initNameTagsFromPreferences();
        }

        private static List<String> buildNameTags(List<String> nameTags) {
            if (nameTags == null) {
                nameTags = Collections.emptyList();
            }
            ArrayList<String> result = new ArrayList<String>();
            for (String tag : nameTags) {
                if (tag == null || (tag = tag.trim()).isEmpty()) continue;
                result.add(tag);
            }
            return result;
        }

        public void setNameTags(List<String> nameTags) {
            this.nameTags = DeriveLabelFromNameTagsCompositionStrategy.buildNameTags(nameTags);
        }

        public void setNameComplementTags(List<String> nameComplementTags) {
            this.nameComplementTags = DeriveLabelFromNameTagsCompositionStrategy.buildNameTags(nameComplementTags);
        }

        public List<String> getNameTags() {
            return Collections.unmodifiableList(this.nameTags);
        }

        public List<String> getNameComplementTags() {
            return Collections.unmodifiableList(this.nameComplementTags);
        }

        public final void initNameTagsFromPreferences() {
            if (Main.pref == null) {
                this.nameTags = new ArrayList<String>(Arrays.asList(DEFAULT_NAME_TAGS));
                this.nameComplementTags = new ArrayList<String>(Arrays.asList(DEFAULT_NAME_COMPLEMENT_TAGS));
            } else {
                this.nameTags = new ArrayList<String>(Main.pref.getCollection("mappaint.nameOrder", Arrays.asList(DEFAULT_NAME_TAGS)));
                this.nameComplementTags = new ArrayList<String>(Main.pref.getCollection("mappaint.nameComplementOrder", Arrays.asList(DEFAULT_NAME_COMPLEMENT_TAGS)));
            }
        }

        private String getPrimitiveName(OsmPrimitive n) {
            String rn2;
            String name = null;
            if (!n.hasKeys()) {
                return null;
            }
            Iterator<String> i$ = this.nameTags.iterator();
            while (i$.hasNext() && (name = n.get(rn2 = i$.next())) == null) {
            }
            for (String rn2 : this.nameComplementTags) {
                String comp = n.get(rn2);
                if (comp == null) continue;
                if (name == null) {
                    name = comp;
                    break;
                }
                name = name + " (" + comp + ")";
                break;
            }
            return name;
        }

        @Override
        public String compose(OsmPrimitive primitive) {
            if (primitive == null) {
                return null;
            }
            return this.getPrimitiveName(primitive);
        }

        public String toString() {
            return "{" + this.getClass().getSimpleName() + "}";
        }
    }

    public static class TagLookupCompositionStrategy
    extends LabelCompositionStrategy {
        private String defaultLabelTag;

        public TagLookupCompositionStrategy(String defaultLabelTag) {
            if (defaultLabelTag != null && (defaultLabelTag = defaultLabelTag.trim()).isEmpty()) {
                defaultLabelTag = null;
            }
            this.defaultLabelTag = defaultLabelTag;
        }

        @Override
        public String compose(OsmPrimitive primitive) {
            if (this.defaultLabelTag == null) {
                return null;
            }
            if (primitive == null) {
                return null;
            }
            return primitive.get(this.defaultLabelTag);
        }

        public String getDefaultLabelTag() {
            return this.defaultLabelTag;
        }

        public String toString() {
            return "{" + this.getClass().getSimpleName() + " defaultLabelTag=" + this.defaultLabelTag + "}";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.defaultLabelTag == null ? 0 : this.defaultLabelTag.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TagLookupCompositionStrategy other = (TagLookupCompositionStrategy)obj;
            return !(this.defaultLabelTag == null ? other.defaultLabelTag != null : !this.defaultLabelTag.equals(other.defaultLabelTag));
        }
    }

    public static class StaticLabelCompositionStrategy
    extends LabelCompositionStrategy {
        private String defaultLabel;

        public StaticLabelCompositionStrategy(String defaultLabel) {
            this.defaultLabel = defaultLabel;
        }

        @Override
        public String compose(OsmPrimitive primitive) {
            return this.defaultLabel;
        }

        public String getDefaultLabel() {
            return this.defaultLabel;
        }

        public String toString() {
            return "{" + this.getClass().getSimpleName() + " defaultLabel=" + this.defaultLabel + "}";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.defaultLabel == null ? 0 : this.defaultLabel.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StaticLabelCompositionStrategy other = (StaticLabelCompositionStrategy)obj;
            return !(this.defaultLabel == null ? other.defaultLabel != null : !this.defaultLabel.equals(other.defaultLabel));
        }
    }
}

