/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.mappaint.AreaElemStyle;
import org.openstreetmap.josm.gui.mappaint.BoxTextElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.LineElemStyle;
import org.openstreetmap.josm.gui.mappaint.LineTextElemStyle;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.NodeElemStyle;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.RepeatImageElemStyle;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.TextElement;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public class ElemStyles {
    private List<StyleSource> styleSources = new ArrayList<StyleSource>();
    private boolean drawMultipolygon;
    private int cacheIdx = 1;
    private boolean defaultNodes;
    private boolean defaultLines;
    private int defaultNodesIdx;
    private int defaultLinesIdx;

    public void clearCached() {
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                ElemStyles.this.cacheIdx++;
            }
        });
    }

    public List<StyleSource> getStyleSources() {
        return Collections.unmodifiableList(this.styleSources);
    }

    public StyleCache.StyleList get(OsmPrimitive osm, double scale, NavigatableComponent nc) {
        return (StyleCache.StyleList)this.getStyleCacheWithRange((OsmPrimitive)osm, (double)scale, (NavigatableComponent)nc).a;
    }

    public Pair<StyleCache.StyleList, Range> getStyleCacheWithRange(OsmPrimitive osm, double scale, NavigatableComponent nc) {
        if (osm.mappaintStyle == null || osm.mappaintCacheIdx != this.cacheIdx || scale <= 0.0) {
            osm.mappaintStyle = StyleCache.EMPTY_STYLECACHE;
        } else {
            Pair<StyleCache.StyleList, Range> lst = osm.mappaintStyle.getWithRange(scale);
            if (lst.a != null) {
                return lst;
            }
        }
        Pair<StyleCache.StyleList, Range> p = this.getImpl(osm, scale, nc);
        if (osm instanceof Node && this.isDefaultNodes()) {
            if (((StyleCache.StyleList)p.a).isEmpty()) {
                p.a = TextElement.AUTO_LABEL_COMPOSITION_STRATEGY.compose(osm) != null ? NodeElemStyle.DEFAULT_NODE_STYLELIST_TEXT : NodeElemStyle.DEFAULT_NODE_STYLELIST;
            } else {
                boolean hasNonModifier = false;
                boolean hasText = false;
                for (ElemStyle s : (StyleCache.StyleList)p.a) {
                    if (s instanceof BoxTextElemStyle) {
                        hasText = true;
                        continue;
                    }
                    if (s.isModifier) continue;
                    hasNonModifier = true;
                }
                if (!hasNonModifier) {
                    p.a = new StyleCache.StyleList((StyleCache.StyleList)p.a, (ElemStyle)NodeElemStyle.SIMPLE_NODE_ELEMSTYLE);
                    if (!hasText && TextElement.AUTO_LABEL_COMPOSITION_STRATEGY.compose(osm) != null) {
                        p.a = new StyleCache.StyleList((StyleCache.StyleList)p.a, (ElemStyle)BoxTextElemStyle.SIMPLE_NODE_TEXT_ELEMSTYLE);
                    }
                }
            }
        } else if (osm instanceof Way && this.isDefaultLines()) {
            boolean hasProperLineStyle = false;
            for (ElemStyle s : (StyleCache.StyleList)p.a) {
                if (!s.isProperLineStyle()) continue;
                hasProperLineStyle = true;
                break;
            }
            if (!hasProperLineStyle) {
                AreaElemStyle area = Utils.find((Iterable)p.a, AreaElemStyle.class);
                LineElemStyle line = area == null ? LineElemStyle.UNTAGGED_WAY : LineElemStyle.createSimpleLineStyle(area.color, true);
                p.a = new StyleCache.StyleList((StyleCache.StyleList)p.a, (ElemStyle)line);
            }
        }
        StyleCache style = osm.mappaintStyle != null ? osm.mappaintStyle : StyleCache.EMPTY_STYLECACHE;
        try {
            osm.mappaintStyle = style.put((StyleCache.StyleList)p.a, (Range)p.b);
        }
        catch (StyleCache.RangeViolatedError e) {
            throw new AssertionError("Range violated. object: " + osm.getPrimitiveId() + ", current style: " + osm.mappaintStyle + ", scale: " + scale + ", new stylelist: " + p.a + ", new range: " + p.b, e);
        }
        osm.mappaintCacheIdx = this.cacheIdx;
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<StyleCache.StyleList, Range> getImpl(OsmPrimitive osm, double scale, NavigatableComponent nc) {
        if (osm instanceof Node) {
            return this.generateStyles(osm, scale, false);
        }
        if (osm instanceof Way) {
            Object mpArea;
            Multipolygon multipolygon;
            Pair<StyleCache.StyleList, Range> p = this.generateStyles(osm, scale, false);
            boolean isOuterWayOfSomeMP = false;
            Color wayColor = null;
            for (OsmPrimitive referrer : osm.getReferrers()) {
                Pair<StyleCache.StyleList, Range> mpElemStyles;
                Relation r = (Relation)referrer;
                if (!this.drawMultipolygon || !r.isMultipolygon() || !r.isUsable() || !(multipolygon = MultipolygonCache.getInstance().get(nc, r)).getOuterWays().contains(osm)) continue;
                boolean hasIndependentLineStyle = false;
                if (!isOuterWayOfSomeMP) {
                    ArrayList<ElemStyle> tmp = new ArrayList<ElemStyle>(((StyleCache.StyleList)p.a).size());
                    for (ElemStyle s : (StyleCache.StyleList)p.a) {
                        if (s instanceof AreaElemStyle) {
                            wayColor = ((AreaElemStyle)s).color;
                            continue;
                        }
                        tmp.add(s);
                        if (!s.isProperLineStyle()) continue;
                        hasIndependentLineStyle = true;
                    }
                    p.a = new StyleCache.StyleList(tmp);
                    isOuterWayOfSomeMP = true;
                }
                if (hasIndependentLineStyle) continue;
                Relation i$ = r;
                synchronized (i$) {
                    mpElemStyles = this.getStyleCacheWithRange(r, scale, nc);
                }
                ElemStyle mpLine = null;
                for (ElemStyle s : (StyleCache.StyleList)mpElemStyles.a) {
                    if (!s.isProperLineStyle()) continue;
                    mpLine = s;
                    break;
                }
                p.b = Range.cut((Range)p.b, (Range)mpElemStyles.b);
                if (mpLine != null) {
                    p.a = new StyleCache.StyleList((StyleCache.StyleList)p.a, mpLine);
                    break;
                }
                if (wayColor != null || !this.isDefaultLines() || (mpArea = Utils.find((Iterable)mpElemStyles.a, AreaElemStyle.class)) == null) continue;
                wayColor = ((AreaElemStyle)mpArea).color;
            }
            if (isOuterWayOfSomeMP) {
                if (this.isDefaultLines()) {
                    boolean hasLineStyle = false;
                    for (ElemStyle s : (StyleCache.StyleList)p.a) {
                        if (!s.isProperLineStyle()) continue;
                        hasLineStyle = true;
                        break;
                    }
                    if (!hasLineStyle) {
                        p.a = new StyleCache.StyleList((StyleCache.StyleList)p.a, (ElemStyle)LineElemStyle.createSimpleLineStyle(wayColor, true));
                    }
                }
                return p;
            }
            if (!this.isDefaultLines()) {
                return p;
            }
            for (OsmPrimitive referrer : osm.getReferrers()) {
                Relation ref = (Relation)referrer;
                if (!this.drawMultipolygon || !ref.isMultipolygon() || !ref.isUsable() || !(multipolygon = MultipolygonCache.getInstance().get(nc, ref)).getInnerWays().contains(osm)) continue;
                p = this.generateStyles(osm, scale, false);
                boolean hasIndependentElemStyle = false;
                for (ElemStyle s : (StyleCache.StyleList)p.a) {
                    if (!s.isProperLineStyle() && !(s instanceof AreaElemStyle)) continue;
                    hasIndependentElemStyle = true;
                    break;
                }
                if (!hasIndependentElemStyle && !multipolygon.getOuterWays().isEmpty()) {
                    Color mpColor = null;
                    StyleCache.StyleList mpElemStyles = null;
                    mpArea = ref;
                    synchronized (mpArea) {
                        mpElemStyles = this.get(ref, scale, nc);
                    }
                    for (ElemStyle mpS : mpElemStyles) {
                        if (!(mpS instanceof AreaElemStyle)) continue;
                        mpColor = ((AreaElemStyle)mpS).color;
                        break;
                    }
                    p.a = new StyleCache.StyleList((StyleCache.StyleList)p.a, (ElemStyle)LineElemStyle.createSimpleLineStyle(mpColor, true));
                }
                return p;
            }
            return p;
        }
        if (osm instanceof Relation) {
            Pair<StyleCache.StyleList, Range> p = this.generateStyles(osm, scale, true);
            if (this.drawMultipolygon && ((Relation)osm).isMultipolygon() && !Utils.exists((Iterable)p.a, AreaElemStyle.class) && Main.pref.getBoolean("multipolygon.deprecated.outerstyle", true)) {
                Multipolygon multipolygon = MultipolygonCache.getInstance().get(nc, (Relation)osm);
                for (Way w : multipolygon.getOuterWays()) {
                    Pair<StyleCache.StyleList, Range> wayStyles = this.generateStyles(w, scale, false);
                    p.b = Range.cut((Range)p.b, (Range)wayStyles.b);
                    ElemStyle area = Utils.find((Iterable)wayStyles.a, AreaElemStyle.class);
                    if (area == null) continue;
                    p.a = new StyleCache.StyleList((StyleCache.StyleList)p.a, area);
                    break;
                }
            }
            return p;
        }
        return null;
    }

    public Pair<StyleCache.StyleList, Range> generateStyles(OsmPrimitive osm, double scale, boolean pretendWayIsClosed) {
        ArrayList<ElemStyle> sl = new ArrayList<ElemStyle>();
        MultiCascade mc = new MultiCascade();
        Environment env = new Environment(osm, mc, null, null);
        for (StyleSource styleSource : this.styleSources) {
            if (!styleSource.active) continue;
            styleSource.apply(mc, osm, scale, pretendWayIsClosed);
        }
        for (Map.Entry entry : mc.getLayers()) {
            if ("*".equals(entry.getKey())) continue;
            env.layer = (String)entry.getKey();
            if (osm instanceof Way) {
                ElemStyles.addIfNotNull(sl, AreaElemStyle.create(env));
                ElemStyles.addIfNotNull(sl, RepeatImageElemStyle.create(env));
                ElemStyles.addIfNotNull(sl, LineElemStyle.createLine(env));
                ElemStyles.addIfNotNull(sl, LineElemStyle.createLeftCasing(env));
                ElemStyles.addIfNotNull(sl, LineElemStyle.createRightCasing(env));
                ElemStyles.addIfNotNull(sl, LineElemStyle.createCasing(env));
                ElemStyles.addIfNotNull(sl, LineTextElemStyle.create(env));
                continue;
            }
            if (osm instanceof Node) {
                NodeElemStyle nodeStyle = NodeElemStyle.create(env);
                if (nodeStyle != null) {
                    sl.add(nodeStyle);
                    ElemStyles.addIfNotNull(sl, BoxTextElemStyle.create(env, nodeStyle.getBoxProvider()));
                    continue;
                }
                ElemStyles.addIfNotNull(sl, BoxTextElemStyle.create(env, NodeElemStyle.SIMPLE_NODE_ELEMSTYLE_BOXPROVIDER));
                continue;
            }
            if (!(osm instanceof Relation)) continue;
            if (((Relation)osm).isMultipolygon()) {
                ElemStyles.addIfNotNull(sl, AreaElemStyle.create(env));
                ElemStyles.addIfNotNull(sl, RepeatImageElemStyle.create(env));
                ElemStyles.addIfNotNull(sl, LineElemStyle.createLine(env));
                ElemStyles.addIfNotNull(sl, LineElemStyle.createCasing(env));
                ElemStyles.addIfNotNull(sl, LineTextElemStyle.create(env));
                continue;
            }
            if (!"restriction".equals(osm.get("type"))) continue;
            ElemStyles.addIfNotNull(sl, NodeElemStyle.create(env));
        }
        return new Pair<StyleCache.StyleList, Range>(new StyleCache.StyleList(sl), mc.range);
    }

    private static <T> void addIfNotNull(List<T> list, T obj) {
        if (obj != null) {
            list.add(obj);
        }
    }

    private boolean isDefaultNodes() {
        if (this.defaultNodesIdx == this.cacheIdx) {
            return this.defaultNodes;
        }
        this.defaultNodes = this.fromCanvas("default-points", true, Boolean.class);
        this.defaultNodesIdx = this.cacheIdx;
        return this.defaultNodes;
    }

    private boolean isDefaultLines() {
        if (this.defaultLinesIdx == this.cacheIdx) {
            return this.defaultLines;
        }
        this.defaultLines = this.fromCanvas("default-lines", true, Boolean.class);
        this.defaultLinesIdx = this.cacheIdx;
        return this.defaultLines;
    }

    private <T> T fromCanvas(String key, T def, Class<T> c) {
        MultiCascade mc = new MultiCascade();
        Relation r = new Relation();
        r.put("#canvas", "query");
        for (StyleSource s : this.styleSources) {
            if (!s.active) continue;
            s.apply(mc, r, 1.0, false);
        }
        return mc.getCascade("default").get(key, def, c);
    }

    public boolean isDrawMultipolygon() {
        return this.drawMultipolygon;
    }

    public void setDrawMultipolygon(boolean drawMultipolygon) {
        this.drawMultipolygon = drawMultipolygon;
    }

    void clear() {
        this.styleSources.clear();
    }

    void add(StyleSource style) {
        this.styleSources.add(style);
    }

    void setStyleSources(Collection<StyleSource> sources) {
        this.styleSources.clear();
        this.styleSources.addAll(sources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AreaElemStyle getAreaElemStyle(OsmPrimitive p, boolean pretendWayIsClosed) {
        MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().lock();
        try {
            if (MapPaintStyles.getStyles() == null) {
                AreaElemStyle areaElemStyle = null;
                return areaElemStyle;
            }
            for (ElemStyle s : (StyleCache.StyleList)MapPaintStyles.getStyles().generateStyles((OsmPrimitive)p, (double)1.0, (boolean)pretendWayIsClosed).a) {
                if (!(s instanceof AreaElemStyle)) continue;
                AreaElemStyle areaElemStyle = (AreaElemStyle)s;
                return areaElemStyle;
            }
            AreaElemStyle areaElemStyle = null;
            return areaElemStyle;
        }
        finally {
            MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().unlock();
        }
    }

    public static boolean hasAreaElemStyle(OsmPrimitive p, boolean pretendWayIsClosed) {
        return ElemStyles.getAreaElemStyle(p, pretendWayIsClosed) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasOnlyAreaElemStyle(OsmPrimitive p) {
        MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().lock();
        try {
            if (MapPaintStyles.getStyles() == null) {
                boolean bl = false;
                return bl;
            }
            StyleCache.StyleList styles = (StyleCache.StyleList)MapPaintStyles.getStyles().generateStyles((OsmPrimitive)p, (double)1.0, (boolean)false).a;
            if (styles.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            for (ElemStyle s : styles) {
                if (s instanceof AreaElemStyle) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().unlock();
        }
    }
}

