/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.StyleKeys;
import org.openstreetmap.josm.gui.mappaint.mapcss.Instruction;

public abstract class ElemStyle
implements StyleKeys {
    protected static final int ICON_IMAGE_IDX = 0;
    protected static final int ICON_WIDTH_IDX = 1;
    protected static final int ICON_HEIGHT_IDX = 2;
    protected static final int ICON_OPACITY_IDX = 3;
    protected static final int ICON_OFFSET_X_IDX = 4;
    protected static final int ICON_OFFSET_Y_IDX = 5;
    public static final String[] ICON_KEYS = new String[]{"icon-image", "icon-width", "icon-height", "icon-opacity", "icon-offset-x", "icon-offset-y"};
    public static final String[] REPEAT_IMAGE_KEYS = new String[]{"repeat-image", "repeat-image-width", "repeat-image-height", "repeat-image-opacity", null, null};
    public float major_z_index;
    public float z_index;
    public float object_z_index;
    public boolean isModifier;
    private static volatile String DEFAULT_FONT_NAME = null;
    private static volatile Float DEFAULT_FONT_SIZE = null;
    private static final Object lock = new Object();
    private static final Map<FontDescriptor, Font> FONT_MAP = new HashMap<FontDescriptor, Font>();

    public ElemStyle(float major_z_index, float z_index, float object_z_index, boolean isModifier) {
        this.major_z_index = major_z_index;
        this.z_index = z_index;
        this.object_z_index = object_z_index;
        this.isModifier = isModifier;
    }

    protected ElemStyle(Cascade c, float default_major_z_index) {
        this.major_z_index = c.get("major-z-index", Float.valueOf(default_major_z_index), Float.class).floatValue();
        this.z_index = c.get("z-index", Float.valueOf(0.0f), Float.class).floatValue();
        this.object_z_index = c.get("object-z-index", Float.valueOf(0.0f), Float.class).floatValue();
        this.isModifier = c.get("modifier", false, Boolean.class);
    }

    public abstract void paintPrimitive(OsmPrimitive var1, MapPaintSettings var2, StyledMapRenderer var3, boolean var4, boolean var5, boolean var6);

    public boolean isProperLineStyle() {
        return false;
    }

    protected static Float getWidth(Cascade c, String key, Float relativeTo) {
        Float width = c.get(key, null, Float.class, true);
        if (width != null) {
            if (width.floatValue() > 0.0f) {
                return width;
            }
        } else {
            Instruction.RelativeFloat width_rel;
            Keyword widthKW = c.get(key, null, Keyword.class, true);
            if (Keyword.THINNEST.equals(widthKW)) {
                return Float.valueOf(0.0f);
            }
            if (Keyword.DEFAULT.equals(widthKW)) {
                return Float.valueOf(MapPaintSettings.INSTANCE.getDefaultSegmentWidth());
            }
            if (relativeTo != null && (width_rel = c.get(key, null, Instruction.RelativeFloat.class, true)) != null) {
                return Float.valueOf(relativeTo.floatValue() + width_rel.val);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Float getDefaultFontSize() {
        Float s = DEFAULT_FONT_SIZE;
        if (s == null) {
            Object object = lock;
            synchronized (object) {
                s = DEFAULT_FONT_SIZE;
                if (s == null) {
                    DEFAULT_FONT_SIZE = s = Float.valueOf(Main.pref.getInteger("mappaint.fontsize", 8));
                }
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDefaultFontName() {
        String n = DEFAULT_FONT_NAME;
        if (n == null) {
            Object object = lock;
            synchronized (object) {
                n = DEFAULT_FONT_NAME;
                if (n == null) {
                    DEFAULT_FONT_NAME = n = Main.pref.get("mappaint.font", "Droid Sans");
                }
            }
        }
        return n;
    }

    private static Font getCachedFont(FontDescriptor fd) {
        Font f = FONT_MAP.get(fd);
        if (f != null) {
            return f;
        }
        f = new Font(fd.name, fd.style, fd.size);
        FONT_MAP.put(fd, f);
        return f;
    }

    private static Font getCachedFont(String name, int style, int size) {
        return ElemStyle.getCachedFont(new FontDescriptor(name, style, size));
    }

    protected static Font getFont(Cascade c, String s) {
        Font f;
        String name = c.get("font-family", ElemStyle.getDefaultFontName(), String.class);
        float size = c.get("font-size", ElemStyle.getDefaultFontSize(), Float.class).floatValue();
        int weight = 0;
        if ("bold".equalsIgnoreCase(c.get("font-weight", null, String.class))) {
            weight = 1;
        }
        int style = 0;
        if ("italic".equalsIgnoreCase(c.get("font-style", null, String.class))) {
            style = 2;
        }
        if ((f = ElemStyle.getCachedFont(name, style | weight, Math.round(size))).canDisplayUpTo(s) == -1) {
            return f;
        }
        return ElemStyle.getCachedFont("SansSerif", style | weight, Math.round(size));
    }

    public boolean equals(Object o) {
        if (!(o instanceof ElemStyle)) {
            return false;
        }
        ElemStyle s = (ElemStyle)o;
        return this.major_z_index == s.major_z_index && this.z_index == s.z_index && this.object_z_index == s.object_z_index && this.isModifier == s.isModifier;
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + Float.floatToIntBits(this.major_z_index);
        hash = 41 * hash + Float.floatToIntBits(this.z_index);
        hash = 41 * hash + Float.floatToIntBits(this.object_z_index);
        hash = 41 * hash + (this.isModifier ? 1 : 0);
        return hash;
    }

    public String toString() {
        return String.format("z_idx=[%s/%s/%s] ", Float.valueOf(this.major_z_index), Float.valueOf(this.z_index), Float.valueOf(this.object_z_index)) + (this.isModifier ? "modifier " : "");
    }

    private static class FontDescriptor {
        public String name;
        public int style;
        public int size;

        public FontDescriptor(String name, int style, int size) {
            this.name = name;
            this.style = style;
            this.size = size;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + this.size;
            result = 31 * result + this.style;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FontDescriptor other = (FontDescriptor)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.size != other.size) {
                return false;
            }
            return this.style == other.style;
        }
    }
}

