/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.mapcss.CSSColors;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.Utils;

public final class Cascade
implements Cloneable {
    public static final Cascade EMPTY_CASCADE = new Cascade();
    protected Map<String, Object> prop = new HashMap<String, Object>();
    private static final Pattern HEX_COLOR_PATTERN = Pattern.compile("#([0-9a-fA-F]{3}|[0-9a-fA-F]{6}|[0-9a-fA-F]{8})");

    public <T> T get(String key, T def, Class<T> klass) {
        return this.get(key, def, klass, false);
    }

    public <T> T get(String key, T def, Class<T> klass, boolean suppressWarnings) {
        if (def != null && !klass.isInstance(def)) {
            throw new IllegalArgumentException(def + " is not an instance of " + klass);
        }
        Object o = this.prop.get(key);
        if (o == null) {
            return def;
        }
        T res = Cascade.convertTo(o, klass);
        if (res == null) {
            if (!suppressWarnings) {
                Main.warn(String.format("Unable to convert property %s to type %s: found %s of type %s!", key, klass, o, o.getClass()));
            }
            return def;
        }
        return res;
    }

    public Object get(String key) {
        return this.prop.get(key);
    }

    public void put(String key, Object val) {
        this.prop.put(key, val);
    }

    public void putOrClear(String key, Object val) {
        if (val != null) {
            this.prop.put(key, val);
        } else {
            this.prop.remove(key);
        }
    }

    public void remove(String key) {
        this.prop.remove(key);
    }

    public static <T> T convertTo(Object o, Class<T> klass) {
        if (o == null) {
            return null;
        }
        if (klass.isInstance(o)) {
            return (T)o;
        }
        if (klass == Float.TYPE || klass == Float.class) {
            return (T)Cascade.toFloat(o);
        }
        if (klass == Double.TYPE || klass == Double.class) {
            if ((o = Cascade.toFloat(o)) != null) {
                o = new Double(((Float)o).floatValue());
            }
            return (T)o;
        }
        if (klass == Boolean.TYPE || klass == Boolean.class) {
            return (T)Cascade.toBool(o);
        }
        if (klass == float[].class) {
            return (T)Cascade.toFloatArray(o);
        }
        if (klass == Color.class) {
            return (T)Cascade.toColor(o);
        }
        if (klass == String.class) {
            if (o instanceof Keyword) {
                return (T)((Keyword)o).val;
            }
            if (o instanceof Color) {
                Color c = (Color)o;
                int alpha = c.getAlpha();
                if (alpha != 255) {
                    return (T)String.format("#%06x%02x", ((Color)o).getRGB() & 0xFFFFFF, alpha);
                }
                return (T)String.format("#%06x", ((Color)o).getRGB() & 0xFFFFFF);
            }
            return (T)o.toString();
        }
        return null;
    }

    private static Float toFloat(Object o) {
        if (o instanceof Number) {
            return Float.valueOf(((Number)o).floatValue());
        }
        if (o instanceof String && !((String)o).isEmpty()) {
            try {
                return Float.valueOf(Float.parseFloat((String)o));
            }
            catch (NumberFormatException e) {
                Main.debug("'" + o + "' cannot be converted to float");
            }
        }
        return null;
    }

    private static Boolean toBool(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        String s = null;
        if (o instanceof Keyword) {
            s = ((Keyword)o).val;
        } else if (o instanceof String) {
            s = (String)o;
        }
        if (s != null) {
            return !s.isEmpty() && !"false".equals(s) && !"no".equals(s) && !"0".equals(s) && !"0.0".equals(s);
        }
        if (o instanceof Number) {
            return ((Number)o).floatValue() != 0.0f;
        }
        if (o instanceof List) {
            return !((List)o).isEmpty();
        }
        if (o instanceof float[]) {
            return ((float[])o).length != 0;
        }
        return null;
    }

    private static float[] toFloatArray(Object o) {
        if (o instanceof float[]) {
            return (float[])o;
        }
        if (o instanceof List) {
            List l = (List)o;
            float[] a = new float[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                Float f = Cascade.toFloat(l.get(i));
                if (f == null) {
                    return null;
                }
                a[i] = f.floatValue();
            }
            return a;
        }
        Float f = Cascade.toFloat(o);
        if (f != null) {
            return new float[]{f.floatValue()};
        }
        return null;
    }

    private static Color toColor(Object o) {
        if (o instanceof Color) {
            return (Color)o;
        }
        if (o instanceof Keyword) {
            return CSSColors.get(((Keyword)o).val);
        }
        if (o instanceof String) {
            Color c = CSSColors.get((String)o);
            if (c != null) {
                return c;
            }
            if (HEX_COLOR_PATTERN.matcher((String)o).matches()) {
                return ColorHelper.html2color((String)o);
            }
        }
        return null;
    }

    public Cascade clone() {
        HashMap clonedProp = (HashMap)((HashMap)this.prop).clone();
        Cascade c = new Cascade();
        c.prop = clonedProp;
        return c;
    }

    public String toString() {
        StringBuilder res = new StringBuilder("Cascade{ ");
        for (String key : this.prop.keySet()) {
            res.append(key + ":");
            Object val = this.prop.get(key);
            if (val instanceof float[]) {
                res.append(Arrays.toString((float[])val));
            } else if (val instanceof Color) {
                res.append(Utils.toString((Color)val));
            } else if (val != null) {
                res.append(val.toString());
            }
            res.append("; ");
        }
        return res.append("}").toString();
    }

    public boolean containsKey(String key) {
        return this.prop.containsKey(key);
    }
}

