/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.awt.Rectangle;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.NodeElemStyle;
import org.openstreetmap.josm.gui.mappaint.TextElement;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class BoxTextElemStyle
extends ElemStyle {
    public static final Rectangle ZERO_BOX = new Rectangle(0, 0, 0, 0);
    public TextElement text;
    protected BoxProvider boxProvider;
    protected Rectangle box;
    public HorizontalTextAlignment hAlign;
    public VerticalTextAlignment vAlign;
    public static final BoxTextElemStyle SIMPLE_NODE_TEXT_ELEMSTYLE;
    private static volatile Color DEFAULT_TEXT_COLOR;

    public BoxTextElemStyle(Cascade c, TextElement text, BoxProvider boxProvider, Rectangle box, HorizontalTextAlignment hAlign, VerticalTextAlignment vAlign) {
        super(c, 5.0f);
        CheckParameterUtil.ensureParameterNotNull(text);
        CheckParameterUtil.ensureParameterNotNull((Object)hAlign);
        CheckParameterUtil.ensureParameterNotNull((Object)vAlign);
        this.text = text;
        this.boxProvider = boxProvider;
        this.box = box == null ? ZERO_BOX : box;
        this.hAlign = hAlign;
        this.vAlign = vAlign;
    }

    public static BoxTextElemStyle create(Environment env, BoxProvider boxProvider) {
        return BoxTextElemStyle.create(env, boxProvider, null);
    }

    public static BoxTextElemStyle create(Environment env, Rectangle box) {
        return BoxTextElemStyle.create(env, null, box);
    }

    public static BoxTextElemStyle create(Environment env, BoxProvider boxProvider, Rectangle box) {
        BoxTextElemStyle.initDefaultParameters();
        Cascade c = env.mc.getCascade(env.layer);
        TextElement text = TextElement.create(env, DEFAULT_TEXT_COLOR, false);
        if (text == null) {
            return null;
        }
        if (text.labelCompositionStrategy.compose(env.osm) == null) {
            return null;
        }
        HorizontalTextAlignment hAlign = HorizontalTextAlignment.RIGHT;
        Keyword hAlignKW = c.get("text-anchor-horizontal", Keyword.RIGHT, Keyword.class);
        if ("left".equals(hAlignKW.val)) {
            hAlign = HorizontalTextAlignment.LEFT;
        } else if ("center".equals(hAlignKW.val)) {
            hAlign = HorizontalTextAlignment.CENTER;
        } else if ("right".equals(hAlignKW.val)) {
            hAlign = HorizontalTextAlignment.RIGHT;
        }
        VerticalTextAlignment vAlign = VerticalTextAlignment.BOTTOM;
        String vAlignStr = c.get((String)"text-anchor-vertical", Keyword.BOTTOM, Keyword.class).val;
        if ("above".equals(vAlignStr)) {
            vAlign = VerticalTextAlignment.ABOVE;
        } else if ("top".equals(vAlignStr)) {
            vAlign = VerticalTextAlignment.TOP;
        } else if ("center".equals(vAlignStr)) {
            vAlign = VerticalTextAlignment.CENTER;
        } else if ("bottom".equals(vAlignStr)) {
            vAlign = VerticalTextAlignment.BOTTOM;
        } else if ("below".equals(vAlignStr)) {
            vAlign = VerticalTextAlignment.BELOW;
        }
        return new BoxTextElemStyle(c, text, boxProvider, box, hAlign, vAlign);
    }

    public Rectangle getBox() {
        if (this.boxProvider != null) {
            BoxProviderResult result = this.boxProvider.get();
            if (!result.isTemporary()) {
                this.box = result.getBox();
                this.boxProvider = null;
            }
            return result.getBox();
        }
        return this.box;
    }

    private static void initDefaultParameters() {
        if (DEFAULT_TEXT_COLOR != null) {
            return;
        }
        DEFAULT_TEXT_COLOR = PaintColors.TEXT.get();
    }

    @Override
    public void paintPrimitive(OsmPrimitive osm, MapPaintSettings settings, StyledMapRenderer painter, boolean selected, boolean outermember, boolean member) {
        if (osm instanceof Node) {
            painter.drawBoxText((Node)osm, this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BoxTextElemStyle other = (BoxTextElemStyle)obj;
        if (!this.text.equals(other.text)) {
            return false;
        }
        if (this.boxProvider != null) {
            if (!this.boxProvider.equals(other.boxProvider)) {
                return false;
            }
        } else {
            if (other.boxProvider != null) {
                return false;
            }
            if (!this.box.equals(other.box)) {
                return false;
            }
        }
        if (this.hAlign != other.hAlign) {
            return false;
        }
        return this.vAlign == other.vAlign;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 97 * hash + this.text.hashCode();
        hash = this.boxProvider != null ? 97 * hash + this.boxProvider.hashCode() : 97 * hash + this.box.hashCode();
        hash = 97 * hash + this.hAlign.hashCode();
        hash = 97 * hash + this.vAlign.hashCode();
        return hash;
    }

    @Override
    public String toString() {
        return "BoxTextElemStyle{" + super.toString() + " " + this.text.toStringImpl() + " box=" + this.box + " hAlign=" + (Object)((Object)this.hAlign) + " vAlign=" + (Object)((Object)this.vAlign) + '}';
    }

    static {
        MultiCascade mc = new MultiCascade();
        Cascade c = mc.getOrCreateCascade("default");
        c.put("text", Keyword.AUTO);
        Node n = new Node();
        n.put("name", "dummy");
        SIMPLE_NODE_TEXT_ELEMSTYLE = BoxTextElemStyle.create(new Environment(n, mc, "default", null), NodeElemStyle.SIMPLE_NODE_ELEMSTYLE.getBoxProvider());
        if (SIMPLE_NODE_TEXT_ELEMSTYLE == null) {
            throw new AssertionError();
        }
        DEFAULT_TEXT_COLOR = null;
    }

    public static class SimpleBoxProvider
    implements BoxProvider {
        private Rectangle box;

        public SimpleBoxProvider(Rectangle box) {
            this.box = box;
        }

        @Override
        public BoxProviderResult get() {
            return new BoxProviderResult(this.box, false);
        }

        public int hashCode() {
            return this.box.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BoxProvider)) {
                return false;
            }
            BoxProvider other = (BoxProvider)obj;
            BoxProviderResult resultOther = other.get();
            if (resultOther.isTemporary()) {
                return false;
            }
            return this.box.equals(resultOther.getBox());
        }
    }

    public static class BoxProviderResult {
        private Rectangle box;
        private boolean temporary;

        public BoxProviderResult(Rectangle box, boolean temporary) {
            this.box = box;
            this.temporary = temporary;
        }

        public Rectangle getBox() {
            return this.box;
        }

        public boolean isTemporary() {
            return this.temporary;
        }
    }

    public static interface BoxProvider {
        public BoxProviderResult get();
    }

    public static enum VerticalTextAlignment {
        ABOVE,
        TOP,
        CENTER,
        BOTTOM,
        BELOW;

    }

    public static enum HorizontalTextAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

