/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.util.Objects;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MapImage;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.TextElement;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Utils;

public class AreaElemStyle
extends ElemStyle {
    public Color color;
    public MapImage fillImage;
    public TextElement text;

    protected AreaElemStyle(Cascade c, Color color, MapImage fillImage, TextElement text) {
        super(c, 1.0f);
        CheckParameterUtil.ensureParameterNotNull(color);
        this.color = color;
        this.fillImage = fillImage;
        this.text = text;
    }

    public static AreaElemStyle create(Environment env) {
        Cascade c = env.mc.getCascade(env.layer);
        MapImage fillImage = null;
        Color color = null;
        MapPaintStyles.IconReference iconRef = c.get("fill-image", null, MapPaintStyles.IconReference.class);
        if (iconRef != null) {
            fillImage = new MapImage(iconRef.iconName, iconRef.source);
            color = new Color(fillImage.getImage(false).getRGB(fillImage.getWidth() / 2, fillImage.getHeight() / 2));
            fillImage.alpha = Math.min(255, Math.max(0, Main.pref.getInteger("mappaint.fill-image-alpha", 255)));
            Integer pAlpha = Utils.color_float2int(c.get("fill-opacity", null, Float.TYPE));
            if (pAlpha != null) {
                fillImage.alpha = pAlpha;
            }
        } else {
            color = c.get("fill-color", null, Color.class);
            if (color != null) {
                Integer pAlpha;
                int alpha = color.getAlpha();
                if (alpha == 255) {
                    alpha = Math.min(255, Math.max(0, Main.pref.getInteger("mappaint.fillalpha", 50)));
                }
                if ((pAlpha = Utils.color_float2int(c.get("fill-opacity", null, Float.TYPE))) != null) {
                    alpha = pAlpha;
                }
                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
            }
        }
        TextElement text = null;
        Keyword textPos = c.get("text-position", null, Keyword.class);
        if (textPos == null || "center".equals(textPos.val)) {
            text = TextElement.create(env, PaintColors.AREA_TEXT.get(), true);
        }
        if (color != null) {
            return new AreaElemStyle(c, color, fillImage, text);
        }
        return null;
    }

    @Override
    public void paintPrimitive(OsmPrimitive osm, MapPaintSettings paintSettings, StyledMapRenderer painter, boolean selected, boolean outermember, boolean member) {
        Color myColor = this.color;
        if (osm instanceof Way) {
            if (this.color != null) {
                if (selected) {
                    myColor = paintSettings.getSelectedColor(this.color.getAlpha());
                } else if (outermember) {
                    myColor = paintSettings.getRelationSelectedColor(this.color.getAlpha());
                }
            }
            painter.drawArea((Way)osm, myColor, this.fillImage, painter.isInactiveMode() || osm.isDisabled(), this.text);
        } else if (osm instanceof Relation) {
            if (this.color != null && (selected || outermember)) {
                myColor = paintSettings.getRelationSelectedColor(this.color.getAlpha());
            }
            painter.drawArea((Relation)osm, myColor, this.fillImage, painter.isInactiveMode() || osm.isDisabled(), this.text);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AreaElemStyle other = (AreaElemStyle)obj;
        if (!Objects.equals(this.fillImage, other.fillImage)) {
            return false;
        }
        if (!Objects.equals(this.color, other.color)) {
            return false;
        }
        return Objects.equals(this.text, other.text);
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 61 * hash + this.color.hashCode();
        hash = 61 * hash + (this.fillImage != null ? this.fillImage.hashCode() : 0);
        hash = 61 * hash + (this.text != null ? this.text.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        return "AreaElemStyle{" + super.toString() + "color=" + Utils.toString(this.color) + " fillImage=[" + this.fillImage + "]}";
    }
}

