/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.Extensions;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.CustomizeColor;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.JumpToMarkerActions;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.gui.layer.markerlayer.PlayHeadMarker;
import org.openstreetmap.josm.tools.AudioPlayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MarkerLayer
extends Layer
implements JumpToMarkerActions.JumpToMarkerLayer {
    public final List<Marker> data;
    private boolean mousePressed = false;
    public GpxLayer fromLayer = null;
    private Marker currentMarker;
    public AudioMarker syncAudioMarker = null;

    public MarkerLayer(GpxData indata, String name, File associatedFile, GpxLayer fromLayer) {
        super(name);
        this.setAssociatedFile(associatedFile);
        this.data = new ArrayList<Marker>();
        this.fromLayer = fromLayer;
        double firstTime = -1.0;
        String lastLinkedFile = "";
        for (WayPoint wpt : indata.waypoints) {
            Marker m;
            GpxLink oneLink;
            Iterator i$;
            double time = wpt.time;
            boolean wpt_has_link = wpt.attr.containsKey("meta.links");
            if (firstTime < 0.0 && wpt_has_link) {
                firstTime = time;
                i$ = wpt.getCollection("meta.links").iterator();
                if (i$.hasNext()) {
                    oneLink = (GpxLink)i$.next();
                    lastLinkedFile = oneLink.uri;
                }
            }
            if (wpt_has_link && (i$ = wpt.getCollection("meta.links").iterator()).hasNext()) {
                oneLink = (GpxLink)i$.next();
                String uri = oneLink.uri;
                if (!uri.equals(lastLinkedFile)) {
                    firstTime = time;
                }
                lastLinkedFile = uri;
            }
            Double offset = null;
            Extensions exts = (Extensions)wpt.get("meta.extensions");
            if (exts != null && exts.containsKey("offset")) {
                try {
                    offset = Double.parseDouble((String)exts.get("offset"));
                }
                catch (NumberFormatException nfe) {
                    Main.warn(nfe);
                }
            }
            if (offset == null) {
                offset = time - firstTime;
            }
            if ((m = Marker.createMarker(wpt, indata.storageFile, this, time, offset)) == null) continue;
            this.data.add(m);
        }
    }

    @Override
    public void hookUpMapView() {
        Main.map.mapView.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                boolean mousePressedInButton = false;
                if (e.getPoint() != null) {
                    for (Marker mkr : MarkerLayer.this.data) {
                        if (!mkr.containsPoint(e.getPoint())) continue;
                        mousePressedInButton = true;
                        break;
                    }
                }
                if (!mousePressedInButton) {
                    return;
                }
                MarkerLayer.this.mousePressed = true;
                if (MarkerLayer.this.isVisible()) {
                    Main.map.mapView.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent ev) {
                if (ev.getButton() != 1 || !MarkerLayer.this.mousePressed) {
                    return;
                }
                MarkerLayer.this.mousePressed = false;
                if (!MarkerLayer.this.isVisible()) {
                    return;
                }
                if (ev.getPoint() != null) {
                    for (Marker mkr : MarkerLayer.this.data) {
                        if (!mkr.containsPoint(ev.getPoint())) continue;
                        mkr.actionPerformed(new ActionEvent(this, 0, null));
                    }
                }
                Main.map.mapView.repaint();
            }
        });
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "marker_small");
    }

    @Override
    public Color getColor(boolean ignoreCustom) {
        String name = this.getName();
        return Main.pref.getColor(I18n.marktr("gps marker"), name != null ? "layer " + name : null, Color.gray);
    }

    public static Color getGenericColor() {
        return Main.pref.getColor(I18n.marktr("gps marker"), Color.gray);
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds box) {
        boolean showTextOrIcon = this.isTextOrIconShown();
        g.setColor(this.getColor(true));
        if (this.mousePressed) {
            boolean mousePressedTmp = this.mousePressed;
            Point mousePos = mv.getMousePosition();
            for (Marker mkr : this.data) {
                if (mousePos == null || !mkr.containsPoint(mousePos)) continue;
                mkr.paint(g, mv, mousePressedTmp, showTextOrIcon);
                mousePressedTmp = false;
            }
        } else {
            for (Marker mkr : this.data) {
                mkr.paint(g, mv, false, showTextOrIcon);
            }
        }
    }

    @Override
    public String getToolTipText() {
        return this.data.size() + " " + I18n.trn("marker", "markers", this.data.size(), new Object[0]);
    }

    @Override
    public void mergeFrom(Layer from) {
        MarkerLayer layer = (MarkerLayer)from;
        this.data.addAll(layer.data);
        Collections.sort(this.data, new Comparator<Marker>(){

            @Override
            public int compare(Marker o1, Marker o2) {
                return Double.compare(o1.time, o2.time);
            }
        });
    }

    @Override
    public boolean isMergable(Layer other) {
        return other instanceof MarkerLayer;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor v) {
        for (Marker mkr : this.data) {
            v.visit(mkr.getEastNorth());
        }
    }

    @Override
    public Object getInfoComponent() {
        return "<html>" + I18n.trn("{0} consists of {1} marker", "{0} consists of {1} markers", this.data.size(), this.getName(), this.data.size()) + "</html>";
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<AbstractAction> components = new ArrayList<AbstractAction>();
        components.add(LayerListDialog.getInstance().createShowHideLayerAction());
        components.add(new ShowHideMarkerText(this));
        components.add(LayerListDialog.getInstance().createDeleteLayerAction());
        components.add(Layer.SeparatorLayerAction.INSTANCE);
        components.add(new CustomizeColor(this));
        components.add(Layer.SeparatorLayerAction.INSTANCE);
        components.add(new SynchronizeAudio());
        if (Main.pref.getBoolean("marker.traceaudio", true)) {
            components.add(new MoveAudio());
        }
        components.add(new JumpToMarkerActions.JumpToNextMarker(this));
        components.add(new JumpToMarkerActions.JumpToPreviousMarker(this));
        components.add(new RenameLayerAction(this.getAssociatedFile(), this));
        components.add(Layer.SeparatorLayerAction.INSTANCE);
        components.add(new LayerListPopup.InfoAction(this));
        return components.toArray(new Action[components.size()]);
    }

    public boolean synchronizeAudioMarkers(AudioMarker startMarker) {
        this.syncAudioMarker = startMarker;
        if (this.syncAudioMarker != null && !this.data.contains(this.syncAudioMarker)) {
            this.syncAudioMarker = null;
        }
        if (this.syncAudioMarker == null) {
            for (Marker m : this.data) {
                if (!(m instanceof AudioMarker)) continue;
                this.syncAudioMarker = (AudioMarker)m;
                break;
            }
        }
        if (this.syncAudioMarker == null) {
            return false;
        }
        double adjustment = AudioPlayer.position() - this.syncAudioMarker.offset;
        boolean seenStart = false;
        try {
            URI uri = this.syncAudioMarker.url().toURI();
            for (Marker m : this.data) {
                AudioMarker ma;
                if (m == this.syncAudioMarker) {
                    seenStart = true;
                }
                if (!seenStart || !(m instanceof AudioMarker) || !(ma = (AudioMarker)m).url().toURI().equals(uri)) continue;
                ma.adjustOffset(adjustment);
            }
        }
        catch (URISyntaxException e) {
            Main.warn(e);
        }
        return true;
    }

    public AudioMarker addAudioMarker(double time, LatLon coor) {
        double offset = 0.0;
        AudioMarker am = null;
        for (Marker m : this.data) {
            if (m.getClass() != AudioMarker.class) continue;
            am = (AudioMarker)m;
            offset = time - am.time;
            break;
        }
        if (am == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No existing audio markers in this layer to offset from.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
            return null;
        }
        AudioMarker newAudioMarker = new AudioMarker(coor, null, AudioPlayer.url(), this, time, offset);
        ArrayList<Marker> newData = new ArrayList<Marker>();
        am = null;
        AudioMarker ret = newAudioMarker;
        for (Marker m : this.data) {
            if (m.getClass() == AudioMarker.class) {
                am = (AudioMarker)m;
                if (newAudioMarker != null && offset < am.offset) {
                    newAudioMarker.adjustOffset(am.syncOffset());
                    newData.add(newAudioMarker);
                    newAudioMarker = null;
                }
            }
            newData.add(m);
        }
        if (newAudioMarker != null) {
            if (am != null) {
                newAudioMarker.adjustOffset(am.syncOffset());
            }
            newData.add(newAudioMarker);
        }
        this.data.clear();
        this.data.addAll(newData);
        return ret;
    }

    @Override
    public void jumpToNextMarker() {
        if (this.currentMarker == null) {
            this.currentMarker = this.data.get(0);
        } else {
            boolean foundCurrent = false;
            for (Marker m : this.data) {
                if (foundCurrent) {
                    this.currentMarker = m;
                    break;
                }
                if (this.currentMarker != m) continue;
                foundCurrent = true;
            }
        }
        Main.map.mapView.zoomTo(this.currentMarker.getEastNorth());
    }

    @Override
    public void jumpToPreviousMarker() {
        if (this.currentMarker == null) {
            this.currentMarker = this.data.get(this.data.size() - 1);
        } else {
            boolean foundCurrent = false;
            for (int i = this.data.size() - 1; i >= 0; --i) {
                Marker m = this.data.get(i);
                if (foundCurrent) {
                    this.currentMarker = m;
                    break;
                }
                if (this.currentMarker != m) continue;
                foundCurrent = true;
            }
        }
        Main.map.mapView.zoomTo(this.currentMarker.getEastNorth());
    }

    public static void playAudio() {
        MarkerLayer.playAdjacentMarker(null, true);
    }

    public static void playNextMarker() {
        MarkerLayer.playAdjacentMarker(AudioMarker.recentlyPlayedMarker(), true);
    }

    public static void playPreviousMarker() {
        MarkerLayer.playAdjacentMarker(AudioMarker.recentlyPlayedMarker(), false);
    }

    private static Marker getAdjacentMarker(Marker startMarker, boolean next, Layer layer) {
        Marker previousMarker = null;
        boolean nextTime = false;
        if (layer.getClass() == MarkerLayer.class) {
            MarkerLayer markerLayer = (MarkerLayer)layer;
            for (Marker marker : markerLayer.data) {
                if (marker == startMarker) {
                    if (next) {
                        nextTime = true;
                        continue;
                    }
                    if (previousMarker == null) {
                        previousMarker = startMarker;
                    }
                    return previousMarker;
                }
                if (marker.getClass() != AudioMarker.class) continue;
                if (nextTime || startMarker == null) {
                    return marker;
                }
                previousMarker = marker;
            }
            if (nextTime) {
                return startMarker;
            }
        }
        return null;
    }

    private static void playAdjacentMarker(Marker startMarker, boolean next) {
        Marker m = null;
        if (!Main.isDisplayingMapView()) {
            return;
        }
        Layer l = Main.map.mapView.getActiveLayer();
        if (l != null) {
            m = MarkerLayer.getAdjacentMarker(startMarker, next, l);
        }
        if (m == null) {
            Layer layer;
            Iterator<Layer> i$ = Main.map.mapView.getAllLayers().iterator();
            while (i$.hasNext() && (m = MarkerLayer.getAdjacentMarker(startMarker, next, layer = i$.next())) == null) {
            }
        }
        if (m != null) {
            ((AudioMarker)m).play();
        }
    }

    private boolean isTextOrIconShown() {
        String current = Main.pref.get("marker.show " + this.getName(), "show");
        return "show".equalsIgnoreCase(current);
    }

    private class MoveAudio
    extends AbstractAction {
        public MoveAudio() {
            super(I18n.tr("Make Audio Marker at Play Head", new Object[0]), ImageProvider.get("addmarkers"));
            this.putValue("help", HelpUtil.ht("/Action/MakeAudioMarkerAtPlayHead"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!AudioPlayer.paused()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("You need to have paused audio at the point on the track where you want the marker.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                return;
            }
            PlayHeadMarker playHeadMarker = Main.map.mapView.playHeadMarker;
            if (playHeadMarker == null) {
                return;
            }
            MarkerLayer.this.addAudioMarker(playHeadMarker.time, playHeadMarker.getCoor());
            Main.map.mapView.repaint();
        }
    }

    private class SynchronizeAudio
    extends AbstractAction {
        public SynchronizeAudio() {
            super(I18n.tr("Synchronize Audio", new Object[0]), ImageProvider.get("audio-sync"));
            this.putValue("help", HelpUtil.ht("/Action/SynchronizeAudio"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!AudioPlayer.paused()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("You need to pause audio at the moment when you hear your synchronization cue.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                return;
            }
            AudioMarker recent = AudioMarker.recentlyPlayedMarker();
            if (MarkerLayer.this.synchronizeAudioMarkers(recent)) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Audio synchronized at point {0}.", MarkerLayer.this.syncAudioMarker.getText()), I18n.tr("Information", new Object[0]), 1);
            } else {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Unable to synchronize in layer being played.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
            }
        }
    }

    public static final class ShowHideMarkerText
    extends AbstractAction
    implements Layer.LayerAction {
        private final MarkerLayer layer;

        public ShowHideMarkerText(MarkerLayer layer) {
            super(I18n.tr("Show Text/Icons", new Object[0]), ImageProvider.get("dialogs", "showhide"));
            this.putValue("ShortDescription", I18n.tr("Toggle visible state of the marker text and icons.", new Object[0]));
            this.putValue("help", HelpUtil.ht("/Action/ShowHideTextIcons"));
            this.layer = layer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Main.pref.put("marker.show " + this.layer.getName(), this.layer.isTextOrIconShown() ? "hide" : "show");
            Main.map.mapView.repaint();
        }

        @Override
        public Component createMenuComponent() {
            JCheckBoxMenuItem showMarkerTextItem = new JCheckBoxMenuItem(this);
            showMarkerTextItem.setState(this.layer.isTextOrIconShown());
            return showMarkerTextItem;
        }

        @Override
        public boolean supportLayers(List<Layer> layers) {
            return layers.size() == 1 && layers.get(0) instanceof MarkerLayer;
        }
    }
}

