/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.Extensions;
import org.openstreetmap.josm.data.gpx.GpxConstants;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.preferences.CachedProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.ImageMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerProducers;
import org.openstreetmap.josm.gui.layer.markerlayer.WebMarker;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.template_engine.ParseError;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;
import org.openstreetmap.josm.tools.template_engine.TemplateEntry;
import org.openstreetmap.josm.tools.template_engine.TemplateParser;

public class Marker
implements TemplateEngineDataProvider {
    public static final List<MarkerProducers> markerProducers = new LinkedList<MarkerProducers>();
    public static final String MARKER_OFFSET = "waypointOffset";
    public static final String MARKER_FORMATTED_OFFSET = "formattedWaypointOffset";
    public static final String LABEL_PATTERN_AUTO = "?{ '{name} - {desc}' | '{name}' | '{desc}' }";
    public static final String LABEL_PATTERN_NAME = "{name}";
    public static final String LABEL_PATTERN_DESC = "{desc}";
    private final DateFormat timeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private final TemplateEngineDataProvider dataProvider;
    private final String text;
    protected final ImageIcon symbol;
    private BufferedImage redSymbol = null;
    public final MarkerLayer parentLayer;
    public double time;
    public double offset;
    private String cachedText;
    private int textVersion = -1;
    private CachedLatLon coor;
    private boolean erroneous = false;

    public static Marker createMarker(WayPoint wpt, File relativePath, MarkerLayer parentLayer, double time, double offset) {
        for (MarkerProducers maker : markerProducers) {
            Marker marker = maker.createMarker(wpt, relativePath, parentLayer, time, offset);
            if (marker == null) continue;
            return marker;
        }
        return null;
    }

    public Marker(LatLon ll, TemplateEngineDataProvider dataProvider, String iconName, MarkerLayer parentLayer, double time, double offset) {
        this(ll, dataProvider, null, iconName, parentLayer, time, offset);
    }

    public Marker(LatLon ll, String text, String iconName, MarkerLayer parentLayer, double time, double offset) {
        this(ll, null, text, iconName, parentLayer, time, offset);
    }

    private Marker(LatLon ll, TemplateEngineDataProvider dataProvider, String text, String iconName, MarkerLayer parentLayer, double time, double offset) {
        this.timeFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.setCoor(ll);
        this.offset = offset;
        this.time = time;
        this.symbol = iconName != null ? ImageProvider.getIfAvailable("markers", iconName) : null;
        this.parentLayer = parentLayer;
        this.dataProvider = dataProvider;
        this.text = text;
    }

    public WayPoint convertToWayPoint() {
        WayPoint wpt = new WayPoint(this.getCoor());
        wpt.put("time", this.timeFormatter.format(new Date(Math.round(this.time * 1000.0))));
        if (this.text != null) {
            wpt.addExtension("text", this.text);
        } else if (this.dataProvider != null) {
            for (String key : this.dataProvider.getTemplateKeys()) {
                Object value = this.dataProvider.getTemplateValue(key, false);
                if (value == null || !GpxConstants.WPT_KEYS.contains(key)) continue;
                wpt.put(key, value);
            }
        }
        return wpt;
    }

    public final void setCoor(LatLon coor) {
        this.coor = new CachedLatLon(coor);
    }

    public final LatLon getCoor() {
        return this.coor;
    }

    public final void setEastNorth(EastNorth eastNorth) {
        this.coor = new CachedLatLon(eastNorth);
    }

    public final EastNorth getEastNorth() {
        return this.coor.getEastNorth();
    }

    public boolean containsPoint(Point p) {
        return false;
    }

    public void actionPerformed(ActionEvent ev) {
    }

    public void paint(Graphics g, MapView mv, boolean mousePressed, boolean showTextOrIcon) {
        Point screen = mv.getPoint(this.getEastNorth());
        if (this.symbol != null && showTextOrIcon) {
            this.paintIcon(mv, g, screen.x - this.symbol.getIconWidth() / 2, screen.y - this.symbol.getIconHeight() / 2);
        } else {
            g.drawLine(screen.x - 2, screen.y - 2, screen.x + 2, screen.y + 2);
            g.drawLine(screen.x + 2, screen.y - 2, screen.x - 2, screen.y + 2);
        }
        String labelText = this.getText();
        if (labelText != null && showTextOrIcon) {
            g.drawString(labelText, screen.x + 4, screen.y + 2);
        }
    }

    protected void paintIcon(MapView mv, Graphics g, int x, int y) {
        if (!this.erroneous) {
            this.symbol.paintIcon(mv, g, x, y);
        } else {
            if (this.redSymbol == null) {
                int width = this.symbol.getIconWidth();
                int height = this.symbol.getIconHeight();
                this.redSymbol = new BufferedImage(width, height, 2);
                Graphics2D gbi = this.redSymbol.createGraphics();
                gbi.drawImage(this.symbol.getImage(), 0, 0, null);
                gbi.setColor(Color.RED);
                gbi.setComposite(AlphaComposite.getInstance(10, 0.666f));
                gbi.fillRect(0, 0, width, height);
                gbi.dispose();
            }
            g.drawImage(this.redSymbol, x, y, mv);
        }
    }

    protected TemplateEntryProperty getTextTemplate() {
        return TemplateEntryProperty.forMarker(this.parentLayer.getName());
    }

    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        TemplateEntryProperty property = this.getTextTemplate();
        if (property.getUpdateCount() != this.textVersion) {
            TemplateEntry templateEntry = (TemplateEntry)property.get();
            StringBuilder sb = new StringBuilder();
            templateEntry.appendText(sb, this);
            this.cachedText = sb.toString();
            this.textVersion = property.getUpdateCount();
        }
        return this.cachedText;
    }

    @Override
    public Collection<String> getTemplateKeys() {
        Collection<String> result = this.dataProvider != null ? this.dataProvider.getTemplateKeys() : new ArrayList<String>();
        result.add(MARKER_FORMATTED_OFFSET);
        result.add(MARKER_OFFSET);
        return result;
    }

    private String formatOffset() {
        int wholeSeconds = (int)(this.offset + 0.5);
        if (wholeSeconds < 60) {
            return Integer.toString(wholeSeconds);
        }
        if (wholeSeconds < 3600) {
            return String.format("%d:%02d", wholeSeconds / 60, wholeSeconds % 60);
        }
        return String.format("%d:%02d:%02d", wholeSeconds / 3600, wholeSeconds % 3600 / 60, wholeSeconds % 60);
    }

    @Override
    public Object getTemplateValue(String name, boolean special) {
        if (MARKER_FORMATTED_OFFSET.equals(name)) {
            return this.formatOffset();
        }
        if (MARKER_OFFSET.equals(name)) {
            return this.offset;
        }
        if (this.dataProvider != null) {
            return this.dataProvider.getTemplateValue(name, special);
        }
        return null;
    }

    @Override
    public boolean evaluateCondition(SearchCompiler.Match condition) {
        throw new UnsupportedOperationException();
    }

    public final boolean isErroneous() {
        return this.erroneous;
    }

    public final void setErroneous(boolean erroneous) {
        this.erroneous = erroneous;
        if (!erroneous) {
            this.redSymbol = null;
        }
    }

    static {
        markerProducers.add(new MarkerProducers(){

            @Override
            public Marker createMarker(WayPoint wpt, File relativePath, MarkerLayer parentLayer, double time, double offset) {
                URL url;
                block11: {
                    Iterator i$;
                    String uri = null;
                    Collection links = wpt.getCollection("meta.links");
                    if (links != null && (i$ = links.iterator()).hasNext()) {
                        GpxLink oneLink = (GpxLink)i$.next();
                        uri = oneLink.uri;
                    }
                    url = null;
                    if (uri != null) {
                        try {
                            url = new URL(uri);
                        }
                        catch (MalformedURLException e) {
                            if (relativePath == null) break block11;
                            url = Utils.fileToURL(new File(relativePath.getParentFile(), uri));
                        }
                    }
                }
                if (url == null) {
                    String symbolName = wpt.getString("symbol");
                    if (symbolName == null) {
                        symbolName = wpt.getString("sym");
                    }
                    return new Marker(wpt.getCoor(), wpt, symbolName, parentLayer, time, offset);
                }
                if (url.toString().endsWith(".wav")) {
                    AudioMarker audioMarker = new AudioMarker(wpt.getCoor(), (TemplateEngineDataProvider)wpt, url, parentLayer, time, offset);
                    Extensions exts = (Extensions)wpt.get("meta.extensions");
                    if (exts != null && exts.containsKey("offset")) {
                        try {
                            double syncOffset;
                            audioMarker.syncOffset = syncOffset = Double.parseDouble((String)exts.get("sync-offset"));
                        }
                        catch (NumberFormatException nfe) {
                            Main.warn(nfe);
                        }
                    }
                    return audioMarker;
                }
                if (url.toString().endsWith(".png") || url.toString().endsWith(".jpg") || url.toString().endsWith(".jpeg") || url.toString().endsWith(".gif")) {
                    return new ImageMarker(wpt.getCoor(), url, parentLayer, time, offset);
                }
                return new WebMarker(wpt.getCoor(), url, parentLayer, time, offset);
            }
        });
    }

    public static final class TemplateEntryProperty
    extends CachedProperty<TemplateEntry> {
        private static final Map<String, TemplateEntryProperty> CACHE = new HashMap<String, TemplateEntryProperty>();
        private static final IntegerProperty PROP_LABEL = new IntegerProperty("draw.rawgps.layer.wpt", 0);
        private TemplateEntryProperty parent;

        private static String getDefaultLabelPattern() {
            switch (PROP_LABEL.get()) {
                case 1: {
                    return Marker.LABEL_PATTERN_NAME;
                }
                case 2: {
                    return Marker.LABEL_PATTERN_DESC;
                }
                case 0: 
                case 3: {
                    return Marker.LABEL_PATTERN_AUTO;
                }
            }
            return "";
        }

        public static TemplateEntryProperty forMarker(String layerName) {
            TemplateEntryProperty result;
            String key = "draw.rawgps.layer.wpt.pattern";
            if (layerName != null) {
                key = key + "." + layerName;
            }
            if ((result = CACHE.get(key)) == null) {
                String defaultValue = layerName == null ? TemplateEntryProperty.getDefaultLabelPattern() : "";
                TemplateEntryProperty parent = layerName == null ? null : TemplateEntryProperty.forMarker(null);
                result = new TemplateEntryProperty(key, defaultValue, parent);
                CACHE.put(key, result);
            }
            return result;
        }

        public static TemplateEntryProperty forAudioMarker(String layerName) {
            TemplateEntryProperty result;
            String key = "draw.rawgps.layer.audiowpt.pattern";
            if (layerName != null) {
                key = key + "." + layerName;
            }
            if ((result = CACHE.get(key)) == null) {
                String defaultValue = layerName == null ? "?{ '{name}' | '{desc}' | '{formattedWaypointOffset}' }" : "";
                TemplateEntryProperty parent = layerName == null ? null : TemplateEntryProperty.forAudioMarker(null);
                result = new TemplateEntryProperty(key, defaultValue, parent);
                CACHE.put(key, result);
            }
            return result;
        }

        private TemplateEntryProperty(String key, String defaultValue, TemplateEntryProperty parent) {
            super(key, defaultValue);
            this.parent = parent;
            this.updateValue();
        }

        @Override
        protected TemplateEntry fromString(String s) {
            try {
                return new TemplateParser(s).parse();
            }
            catch (ParseError e) {
                Main.warn("Unable to parse template engine pattern ''{0}'' for property {1}. Using default (''{2}'') instead", s, this.getKey(), super.getDefaultValueAsString());
                return (TemplateEntry)this.getDefaultValue();
            }
        }

        @Override
        public String getDefaultValueAsString() {
            if (this.parent == null) {
                return super.getDefaultValueAsString();
            }
            return this.parent.getAsString();
        }

        @Override
        public void preferenceChanged(Preferences.PreferenceChangeEvent e) {
            if (e.getKey().equals(this.key) || this.parent != null && e.getKey().equals(this.parent.getKey())) {
                this.updateValue();
            }
        }
    }
}

