/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MarkersFromNamedPointsAction
extends AbstractAction {
    private final GpxLayer layer;

    public MarkersFromNamedPointsAction(GpxLayer layer) {
        super(I18n.tr("Markers From Named Points", new Object[0]), ImageProvider.get("addmarkers"));
        this.layer = layer;
        this.putValue("help", HelpUtil.ht("/Action/MarkersFromNamedPoints"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GpxData namedTrackPoints = new GpxData();
        for (GpxTrack track : this.layer.data.tracks) {
            for (GpxTrackSegment seg : track.getSegments()) {
                for (WayPoint point : seg.getWayPoints()) {
                    if (!point.attr.containsKey("name") && !point.attr.containsKey("desc")) continue;
                    namedTrackPoints.waypoints.add(point);
                }
            }
        }
        MarkerLayer ml = new MarkerLayer(namedTrackPoints, I18n.tr("Named Trackpoints from {0}", this.layer.getName()), this.layer.getAssociatedFile(), this.layer);
        if (!ml.data.isEmpty()) {
            Main.main.addLayer(ml);
        }
    }
}

