/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.tools.AudioUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;

public class ImportAudioAction
extends AbstractAction {
    private final GpxLayer layer;

    public ImportAudioAction(GpxLayer layer) {
        super(I18n.tr("Import Audio", new Object[0]), ImageProvider.get("importaudio"));
        this.layer = layer;
        this.putValue("help", HelpUtil.ht("/Action/ImportAudio"));
    }

    private void warnCantImportIntoServerLayer(GpxLayer layer) {
        String msg = I18n.tr("<html>The data in the GPX layer ''{0}'' has been downloaded from the server.<br>Because its way points do not include a timestamp we cannot correlate them with audio data.</html>", layer.getName());
        HelpAwareOptionPane.showOptionDialog(Main.parent, msg, I18n.tr("Import not possible", new Object[0]), 2, HelpUtil.ht("/Action/ImportAudio#CantImportIntoGpxLayerFromServer"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.layer.data.fromServer) {
            this.warnCantImportIntoServerLayer(this.layer);
            return;
        }
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".wav");
            }

            @Override
            public String getDescription() {
                return I18n.tr("Wave Audio files (*.wav)", new Object[0]);
            }
        };
        AbstractFileChooser fc = DiskAccessAction.createAndOpenFileChooser(true, true, null, filter, 0, "markers.lastaudiodirectory");
        if (fc != null) {
            File[] sel = fc.getSelectedFiles();
            if (sel.length > 1) {
                Arrays.sort(sel, new Comparator<File>(){

                    @Override
                    public int compare(File a, File b) {
                        return a.lastModified() <= b.lastModified() ? -1 : 1;
                    }
                });
            }
            String names = null;
            for (File file : sel) {
                names = names == null ? " (" : names + ", ";
                names = names + file.getName();
            }
            names = names != null ? names + ")" : "";
            MarkerLayer ml = new MarkerLayer(new GpxData(), I18n.tr("Audio markers from {0}", this.layer.getName()) + names, this.layer.getAssociatedFile(), this.layer);
            double firstStartTime = (double)sel[0].lastModified() / 1000.0 - AudioUtil.getCalibratedDuration(sel[0]);
            Markers m = new Markers();
            for (File file : sel) {
                this.importAudio(file, ml, firstStartTime, m);
            }
            Main.main.addLayer(ml);
            Main.map.repaint();
        }
    }

    private void importAudio(File wavFile, MarkerLayer ml, double firstStartTime, Markers markers) {
        URL url = Utils.fileToURL(wavFile);
        boolean hasTracks = this.layer.data.tracks != null && !this.layer.data.tracks.isEmpty();
        boolean hasWaypoints = this.layer.data.waypoints != null && !this.layer.data.waypoints.isEmpty();
        ArrayList<WayPoint> waypoints = new ArrayList<WayPoint>();
        boolean timedMarkersOmitted = false;
        boolean untimedMarkersOmitted = false;
        double snapDistance = Main.pref.getDouble("marker.audiofromuntimedwaypoints.distance", 0.001);
        WayPoint wayPointFromTimeStamp = null;
        double firstTime = -1.0;
        if (hasTracks) {
            for (GpxTrack track : this.layer.data.tracks) {
                for (GpxTrackSegment seg : track.getSegments()) {
                    Iterator<WayPoint> i$ = seg.getWayPoints().iterator();
                    if (i$.hasNext()) {
                        WayPoint w = i$.next();
                        firstTime = w.time;
                    }
                    if (!(firstTime >= 0.0)) continue;
                    break;
                }
                if (!(firstTime >= 0.0)) continue;
                break;
            }
        }
        if (firstTime < 0.0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No GPX track available in layer to associate audio with.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
            return;
        }
        if (Main.pref.getBoolean("marker.audiofromexplicitwaypoints", true) && hasWaypoints) {
            for (WayPoint w : this.layer.data.waypoints) {
                if (w.time > firstTime) {
                    waypoints.add(w);
                    continue;
                }
                if (!(w.time > 0.0)) continue;
                timedMarkersOmitted = true;
            }
        }
        if (Main.pref.getBoolean("marker.audiofromuntimedwaypoints", true) && hasWaypoints) {
            for (WayPoint w : this.layer.data.waypoints) {
                if (waypoints.contains(w)) continue;
                WayPoint wNear = this.layer.data.nearestPointOnTrack(w.getEastNorth(), snapDistance);
                if (wNear != null) {
                    WayPoint wc = new WayPoint(w.getCoor());
                    wc.time = wNear.time;
                    if (w.attr.containsKey("name")) {
                        wc.put("name", w.getString("name"));
                    }
                    waypoints.add(wc);
                    continue;
                }
                untimedMarkersOmitted = true;
            }
        }
        if (Main.pref.getBoolean("marker.audiofromnamedtrackpoints", false) && this.layer.data.tracks != null && !this.layer.data.tracks.isEmpty()) {
            for (GpxTrack track : this.layer.data.tracks) {
                for (GpxTrackSegment seg : track.getSegments()) {
                    for (WayPoint w : seg.getWayPoints()) {
                        if (!w.attr.containsKey("name") && !w.attr.containsKey("desc")) continue;
                        waypoints.add(w);
                    }
                }
            }
        }
        if (Main.pref.getBoolean("marker.audiofromwavtimestamps", false) && hasTracks) {
            double lastModified = (double)wavFile.lastModified() / 1000.0;
            double duration = AudioUtil.getCalibratedDuration(wavFile);
            double startTime = lastModified - duration;
            startTime = firstStartTime + (startTime - firstStartTime) / Main.pref.getDouble("audio.calibration", 1.0);
            WayPoint w1 = null;
            WayPoint w2 = null;
            block7: for (GpxTrack track : this.layer.data.tracks) {
                for (GpxTrackSegment seg : track.getSegments()) {
                    for (WayPoint w : seg.getWayPoints()) {
                        if (startTime < w.time) {
                            w2 = w;
                            break;
                        }
                        w1 = w;
                    }
                    if (w2 == null) continue;
                    continue block7;
                }
            }
            if (w1 == null || w2 == null) {
                timedMarkersOmitted = true;
            } else {
                wayPointFromTimeStamp = new WayPoint(w1.getCoor().interpolate(w2.getCoor(), (startTime - w1.time) / (w2.time - w1.time)));
                wayPointFromTimeStamp.time = startTime;
                String name = wavFile.getName();
                int dot = name.lastIndexOf(46);
                if (dot > 0) {
                    name = name.substring(0, dot);
                }
                wayPointFromTimeStamp.put("name", name);
                waypoints.add(wayPointFromTimeStamp);
            }
        }
        if ((Main.pref.getBoolean("marker.audiofromstart") || waypoints.isEmpty()) && hasTracks) {
            boolean gotOne = false;
            for (GpxTrack track : this.layer.data.tracks) {
                for (GpxTrackSegment seg : track.getSegments()) {
                    Iterator<WayPoint> i$ = seg.getWayPoints().iterator();
                    if (i$.hasNext()) {
                        WayPoint w = i$.next();
                        WayPoint wStart = new WayPoint(w.getCoor());
                        wStart.put("name", "start");
                        wStart.time = w.time;
                        waypoints.add(wStart);
                        gotOne = true;
                    }
                    if (!gotOne) continue;
                    break;
                }
                if (!gotOne) continue;
                break;
            }
        }
        Collections.sort(waypoints, new Comparator<WayPoint>(){

            @Override
            public int compare(WayPoint a, WayPoint b) {
                return a.time <= b.time ? -1 : 1;
            }
        });
        firstTime = -1.0;
        for (WayPoint w : waypoints) {
            if (firstTime < 0.0) {
                firstTime = w.time;
            }
            double offset = w.time - firstTime;
            AudioMarker am = new AudioMarker(w.getCoor(), (TemplateEngineDataProvider)w, url, ml, w.time, offset);
            if (w == wayPointFromTimeStamp) {
                am.timeFromAudio = true;
            }
            ml.data.add(am);
        }
        if (timedMarkersOmitted && !markers.timedMarkersOmitted) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Some waypoints with timestamps from before the start of the track or after the end were omitted or moved to the start.", new Object[0]));
            markers.timedMarkersOmitted = timedMarkersOmitted;
        }
        if (untimedMarkersOmitted && !markers.untimedMarkersOmitted) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Some waypoints which were too far from the track to sensibly estimate their time were omitted.", new Object[0]));
            markers.untimedMarkersOmitted = untimedMarkersOmitted;
        }
    }

    private static class Markers {
        public boolean timedMarkersOmitted = false;
        public boolean untimedMarkersOmitted = false;

        private Markers() {
        }
    }
}

