/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.tools.ColorScale;
import org.openstreetmap.josm.tools.I18n;

public class GpxDrawHelper {
    private GpxData data;
    private boolean forceLines;
    private boolean direction;
    private int lineWidth;
    private int maxLineLength;
    private boolean lines;
    private boolean large;
    private int largesize;
    private boolean hdopCircle;
    private boolean alternateDirection;
    private int delta;
    private double minTrackDurationForTimeColoring;
    private int hdopfactor;
    private static final double PHI = Math.toRadians(15.0);
    private boolean computeCacheInSync = false;
    private int computeCacheMaxLineLengthUsed;
    private Color computeCacheColorUsed;
    private boolean computeCacheColorDynamic;
    private ColorMode computeCacheColored;
    private int computeCacheColorTracksTune;
    private ColorMode colored;
    private int colorTracksTune;
    private boolean colorModeDynamic;
    private Color neutralColor;
    private int largePointAlpha;
    ColorScale velocityScale;
    ColorScale hdopScale;
    ColorScale dateScale;
    ColorScale directionScale;
    private int hdopAlpha;
    private static final int[][] dir = new int[][]{{5, 9, 9, 5}, {-3, 9, 3, 9}, {-9, 5, -5, 9}, {-9, -3, -9, 3}, {-5, -9, -9, -5}, {3, -9, -3, -9}, {9, -5, 5, -9}, {9, 3, 9, -3}, {5, 9, 9, 5}, {-3, 9, 3, 9}, {-9, 5, -5, 9}, {-9, -3, -9, 3}};

    private void setupColors() {
        this.hdopAlpha = Main.pref.getInteger("hdop.color.alpha", -1);
        this.velocityScale = ColorScale.createHSBScale(256).addTitle(I18n.tr("Velocity, km/h", new Object[0]));
        this.hdopScale = ColorScale.createHSBScale(256).makeReversed().addTitle(I18n.tr("HDOP, m", new Object[0]));
        this.dateScale = ColorScale.createHSBScale(256).addTitle(I18n.tr("Time", new Object[0]));
        this.directionScale = ColorScale.createCyclicScale(256).setIntervalCount(4).addTitle(I18n.tr("Direction", new Object[0]));
    }

    public GpxDrawHelper(GpxData gpxData) {
        this.data = gpxData;
        this.setupColors();
    }

    private static String specName(String layerName) {
        return "layer " + layerName;
    }

    public Color getColor(String layerName, boolean ignoreCustom) {
        Color c = Main.pref.getColor(I18n.marktr("gps point"), GpxDrawHelper.specName(layerName), Color.gray);
        return ignoreCustom || this.getColorMode(layerName) == ColorMode.NONE ? c : null;
    }

    public ColorMode getColorMode(String layerName) {
        try {
            int i = Main.pref.getInteger("draw.rawgps.colors", GpxDrawHelper.specName(layerName), 0);
            return ColorMode.values()[i];
        }
        catch (Exception e) {
            Main.warn(e);
            return ColorMode.NONE;
        }
    }

    public static Color getGenericColor() {
        return Main.pref.getColor(I18n.marktr("gps point"), Color.gray);
    }

    public void readPreferences(String layerName) {
        String spec = GpxDrawHelper.specName(layerName);
        this.forceLines = Main.pref.getBoolean("draw.rawgps.lines.force", spec, false);
        this.direction = Main.pref.getBoolean("draw.rawgps.direction", spec, false);
        this.lineWidth = Main.pref.getInteger("draw.rawgps.linewidth", spec, 0);
        if (!this.data.fromServer) {
            this.maxLineLength = Main.pref.getInteger("draw.rawgps.max-line-length.local", spec, -1);
            this.lines = Main.pref.getBoolean("draw.rawgps.lines.local", spec, true);
        } else {
            this.maxLineLength = Main.pref.getInteger("draw.rawgps.max-line-length", spec, 200);
            this.lines = Main.pref.getBoolean("draw.rawgps.lines", spec, true);
        }
        this.large = Main.pref.getBoolean("draw.rawgps.large", spec, false);
        this.largesize = Main.pref.getInteger("draw.rawgps.large.size", spec, 3);
        this.hdopCircle = Main.pref.getBoolean("draw.rawgps.hdopcircle", spec, false);
        this.colored = this.getColorMode(layerName);
        this.alternateDirection = Main.pref.getBoolean("draw.rawgps.alternatedirection", spec, false);
        this.delta = Main.pref.getInteger("draw.rawgps.min-arrow-distance", spec, 40);
        this.colorTracksTune = Main.pref.getInteger("draw.rawgps.colorTracksTune", spec, 45);
        this.colorModeDynamic = Main.pref.getBoolean("draw.rawgps.colors.dynamic", spec, false);
        this.hdopfactor = Main.pref.getInteger("hdop.factor", 25);
        this.minTrackDurationForTimeColoring = Main.pref.getInteger("draw.rawgps.date-coloring-min-dt", 60);
        this.largePointAlpha = Main.pref.getInteger("draw.rawgps.large.alpha", -1) & 0xFF;
        this.neutralColor = this.getColor(layerName, true);
        this.velocityScale.setNoDataColor(this.neutralColor);
        this.dateScale.setNoDataColor(this.neutralColor);
        this.hdopScale.setNoDataColor(this.neutralColor);
        this.directionScale.setNoDataColor(this.neutralColor);
        this.largesize += this.lineWidth;
    }

    public void drawAll(Graphics2D g, MapView mv, List<WayPoint> visibleSegments) {
        this.checkCache();
        if (!this.computeCacheInSync) {
            this.calculateColors();
        }
        Stroke storedStroke = g.getStroke();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, Main.pref.getBoolean("mappaint.gpx.use-antialiasing", false) ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        if (this.lineWidth != 0) {
            g.setStroke(new BasicStroke(this.lineWidth, 1, 1));
        }
        this.fixColors(visibleSegments);
        this.drawLines(g, mv, visibleSegments);
        this.drawArrows(g, mv, visibleSegments);
        this.drawPoints(g, mv, visibleSegments);
        if (this.lineWidth != 0) {
            g.setStroke(storedStroke);
        }
    }

    public void calculateColors() {
        double minval = 1.0E10;
        double maxval = -1.0E10;
        WayPoint oldWp = null;
        if (this.colorModeDynamic) {
            if (this.colored == ColorMode.VELOCITY) {
                for (Collection<WayPoint> segment : this.data.getLinesIterable(null)) {
                    if (!this.forceLines) {
                        oldWp = null;
                    }
                    for (WayPoint wayPoint : segment) {
                        LatLon c = wayPoint.getCoor();
                        if (Double.isNaN(c.lat()) || Double.isNaN(c.lon())) continue;
                        if (oldWp != null && wayPoint.time > oldWp.time) {
                            double vel = c.greatCircleDistance(oldWp.getCoor()) / (wayPoint.time - oldWp.time);
                            if (vel > maxval) {
                                maxval = vel;
                            }
                            if (vel < minval) {
                                minval = vel;
                            }
                        }
                        oldWp = wayPoint;
                    }
                }
                if (minval >= maxval) {
                    this.velocityScale.setRange(0.0, 33.333333333333336);
                } else {
                    this.velocityScale.setRange(minval, maxval);
                }
            } else if (this.colored == ColorMode.HDOP) {
                for (Collection<WayPoint> segment : this.data.getLinesIterable(null)) {
                    for (WayPoint wayPoint : segment) {
                        Object val = wayPoint.get("hdop");
                        if (val == null) continue;
                        double hdop = ((Float)val).doubleValue();
                        if (hdop > maxval) {
                            maxval = hdop;
                        }
                        if (!(hdop < minval)) continue;
                        minval = hdop;
                    }
                }
                if (minval >= maxval) {
                    this.hdopScale.setRange(0.0, 100.0);
                } else {
                    this.hdopScale.setRange(minval, maxval);
                }
            }
            oldWp = null;
        } else {
            this.velocityScale.setRange(0.0, this.colorTracksTune);
            this.hdopScale.setRange(0.0, 1.0 / (double)this.hdopfactor);
        }
        double now = (double)System.currentTimeMillis() / 1000.0;
        if (this.colored == ColorMode.TIME) {
            Date[] bounds = this.data.getMinMaxTimeForAllTracks();
            if (bounds != null) {
                minval = (double)bounds[0].getTime() / 1000.0;
                maxval = (double)bounds[1].getTime() / 1000.0;
            } else {
                minval = 0.0;
                maxval = now;
            }
            this.dateScale.setRange(minval, maxval);
        }
        for (Collection collection : this.data.getLinesIterable(null)) {
            if (!this.forceLines) {
                oldWp = null;
            }
            for (WayPoint trkPnt : collection) {
                LatLon c = trkPnt.getCoor();
                trkPnt.customColoring = this.neutralColor;
                if (Double.isNaN(c.lat()) || Double.isNaN(c.lon())) continue;
                Color color = null;
                if (this.colored == ColorMode.HDOP) {
                    Float hdop = (Float)trkPnt.get("hdop");
                    color = this.hdopScale.getColor(hdop);
                }
                if (oldWp != null) {
                    double dist = c.greatCircleDistance(oldWp.getCoor());
                    boolean noDraw = false;
                    switch (this.colored) {
                        case VELOCITY: {
                            double dtime = trkPnt.time - oldWp.time;
                            if (dtime > 0.0) {
                                color = this.velocityScale.getColor(dist / dtime);
                                break;
                            }
                            color = this.velocityScale.getNoDataColor();
                            break;
                        }
                        case DIRECTION: {
                            double dirColor = oldWp.getCoor().heading(trkPnt.getCoor());
                            color = this.directionScale.getColor(dirColor);
                            break;
                        }
                        case TIME: {
                            double t = trkPnt.time;
                            color = t > 0.0 && t <= now && maxval - minval > this.minTrackDurationForTimeColoring ? this.dateScale.getColor(t) : this.dateScale.getNoDataColor();
                        }
                    }
                    if (!noDraw && (this.maxLineLength == -1 || dist <= (double)this.maxLineLength)) {
                        trkPnt.drawLine = true;
                        trkPnt.dir = (int)oldWp.getCoor().heading(trkPnt.getCoor());
                    } else {
                        trkPnt.drawLine = false;
                    }
                } else {
                    trkPnt.drawLine = false;
                    color = this.neutralColor;
                }
                if (color != null) {
                    trkPnt.customColoring = color;
                }
                oldWp = trkPnt;
            }
        }
        this.computeCacheInSync = true;
    }

    private void drawLines(Graphics2D g, MapView mv, List<WayPoint> visibleSegments) {
        if (this.lines) {
            Point old = null;
            for (WayPoint trkPnt : visibleSegments) {
                LatLon c = trkPnt.getCoor();
                if (Double.isNaN(c.lat()) || Double.isNaN(c.lon())) continue;
                Point screen = mv.getPoint(trkPnt.getEastNorth());
                if (trkPnt.drawLine && old != null && (old.x != screen.x || old.y != screen.y)) {
                    g.setColor(trkPnt.customColoring);
                    g.drawLine(old.x, old.y, screen.x, screen.y);
                }
                old = screen;
            }
        }
    }

    private void drawArrows(Graphics2D g, MapView mv, List<WayPoint> visibleSegments) {
        Point screen;
        LatLon c;
        Point oldA;
        Point old;
        if (this.lines && this.direction && !this.alternateDirection) {
            old = null;
            oldA = null;
            for (WayPoint trkPnt : visibleSegments) {
                c = trkPnt.getCoor();
                if (Double.isNaN(c.lat()) || Double.isNaN(c.lon()) || !trkPnt.drawLine) continue;
                screen = mv.getPoint(trkPnt.getEastNorth());
                if (old != null && (oldA == null || screen.x < oldA.x - this.delta || screen.x > oldA.x + this.delta || screen.y < oldA.y - this.delta || screen.y > oldA.y + this.delta)) {
                    g.setColor(trkPnt.customColoring);
                    double t = Math.atan2(screen.y - old.y, screen.x - old.x) + Math.PI;
                    g.drawLine(screen.x, screen.y, (int)((double)screen.x + 10.0 * Math.cos(t - PHI)), (int)((double)screen.y + 10.0 * Math.sin(t - PHI)));
                    g.drawLine(screen.x, screen.y, (int)((double)screen.x + 10.0 * Math.cos(t + PHI)), (int)((double)screen.y + 10.0 * Math.sin(t + PHI)));
                    oldA = screen;
                }
                old = screen;
            }
        }
        if (this.lines && this.direction && this.alternateDirection) {
            old = null;
            oldA = null;
            for (WayPoint trkPnt : visibleSegments) {
                c = trkPnt.getCoor();
                if (Double.isNaN(c.lat()) || Double.isNaN(c.lon()) || !trkPnt.drawLine) continue;
                screen = mv.getPoint(trkPnt.getEastNorth());
                if (old != null && (oldA == null || screen.x < oldA.x - this.delta || screen.x > oldA.x + this.delta || screen.y < oldA.y - this.delta || screen.y > oldA.y + this.delta)) {
                    g.setColor(trkPnt.customColoring);
                    g.drawLine(screen.x, screen.y, screen.x + dir[trkPnt.dir][0], screen.y + dir[trkPnt.dir][1]);
                    g.drawLine(screen.x, screen.y, screen.x + dir[trkPnt.dir][2], screen.y + dir[trkPnt.dir][3]);
                    oldA = screen;
                }
                old = screen;
            }
        }
    }

    private void drawPoints(Graphics2D g, MapView mv, List<WayPoint> visibleSegments) {
        Point screen;
        LatLon c;
        if (this.large || this.hdopCircle) {
            int halfSize = this.largesize / 2;
            for (WayPoint trkPnt : visibleSegments) {
                LatLon c2 = trkPnt.getCoor();
                if (Double.isNaN(c2.lat()) || Double.isNaN(c2.lon())) continue;
                Point screen2 = mv.getPoint(trkPnt.getEastNorth());
                if (this.hdopCircle && trkPnt.get("hdop") != null) {
                    float hdop = ((Float)trkPnt.get("hdop")).floatValue();
                    if (hdop < 0.0f) {
                        hdop = 0.0f;
                    }
                    Color customColoringTransparent = this.hdopAlpha < 0 ? trkPnt.customColoring : new Color(trkPnt.customColoring.getRGB() & 0xFFFFFF | this.hdopAlpha << 24, true);
                    g.setColor(customColoringTransparent);
                    int hdopp = mv.getPoint((LatLon)new LatLon((double)trkPnt.getCoor().lat(), (double)(trkPnt.getCoor().lon() + (double)(12.0f * hdop * 360.0f / 4.0E7f)))).x - screen2.x;
                    g.drawArc(screen2.x - hdopp / 2, screen2.y - hdopp / 2, hdopp, hdopp, 0, 360);
                }
                if (!this.large) continue;
                if (trkPnt.customColoring != null) {
                    Color customColoringTransparent = this.largePointAlpha < 0 ? trkPnt.customColoring : new Color(trkPnt.customColoring.getRGB() & 0xFFFFFF | this.largePointAlpha << 24, true);
                    g.setColor(customColoringTransparent);
                }
                g.fillRect(screen2.x - halfSize, screen2.y - halfSize, this.largesize, this.largesize);
            }
        }
        if (!this.large && this.lines) {
            g.setColor(this.neutralColor);
            for (WayPoint trkPnt : visibleSegments) {
                c = trkPnt.getCoor();
                if (Double.isNaN(c.lat()) || Double.isNaN(c.lon()) || trkPnt.drawLine) continue;
                screen = mv.getPoint(trkPnt.getEastNorth());
                g.drawRect(screen.x, screen.y, 0, 0);
            }
        }
        if (!this.large && !this.lines) {
            g.setColor(this.neutralColor);
            for (WayPoint trkPnt : visibleSegments) {
                c = trkPnt.getCoor();
                if (Double.isNaN(c.lat()) || Double.isNaN(c.lon())) continue;
                screen = mv.getPoint(trkPnt.getEastNorth());
                g.setColor(trkPnt.customColoring);
                g.drawRect(screen.x, screen.y, 0, 0);
            }
        }
    }

    private void fixColors(List<WayPoint> visibleSegments) {
        for (WayPoint trkPnt : visibleSegments) {
            if (trkPnt.customColoring != null) continue;
            trkPnt.customColoring = this.neutralColor;
        }
    }

    private void checkCache() {
        if (this.computeCacheMaxLineLengthUsed != this.maxLineLength || !this.neutralColor.equals(this.computeCacheColorUsed) || this.computeCacheColored != this.colored || this.computeCacheColorTracksTune != this.colorTracksTune || this.computeCacheColorDynamic != this.colorModeDynamic) {
            this.computeCacheMaxLineLengthUsed = this.maxLineLength;
            this.computeCacheInSync = false;
            this.computeCacheColorUsed = this.neutralColor;
            this.computeCacheColored = this.colored;
            this.computeCacheColorTracksTune = this.colorTracksTune;
            this.computeCacheColorDynamic = this.colorModeDynamic;
        }
    }

    public void dataChanged() {
        this.computeCacheInSync = false;
    }

    public void drawColorBar(Graphics2D g, MapView mv) {
        int w = mv.getWidth();
        if (this.colored == ColorMode.HDOP) {
            this.hdopScale.drawColorBar(g, w - 30, 50, 20, 100, 1.0);
        } else if (this.colored == ColorMode.VELOCITY) {
            this.velocityScale.drawColorBar(g, w - 30, 50, 20, 100, 3.6);
        } else if (this.colored == ColorMode.DIRECTION) {
            this.directionScale.drawColorBar(g, w - 30, 50, 20, 100, 57.29577951308232);
        }
    }

    public static enum ColorMode {
        NONE,
        VELOCITY,
        HDOP,
        DIRECTION,
        TIME;

    }
}

