/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AbstractMergeAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;
import org.openstreetmap.josm.gui.progress.ProgressTaskIds;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.xml.sax.SAXException;

public class DownloadWmsAlongTrackAction
extends AbstractAction {
    private final GpxData data;

    public DownloadWmsAlongTrackAction(GpxData data) {
        super(I18n.tr("Precache imagery tiles along this track", new Object[0]), ImageProvider.get("downloadalongtrack"));
        this.data = data;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final ArrayList<LatLon> points = new ArrayList<LatLon>();
        for (GpxTrack trk : this.data.tracks) {
            for (GpxTrackSegment segment : trk.getSegments()) {
                for (WayPoint p : segment.getWayPoints()) {
                    points.add(p.getCoor());
                }
            }
        }
        for (WayPoint p : this.data.waypoints) {
            points.add(p.getCoor());
        }
        final WMSLayer layer = this.askWMSLayer();
        if (layer != null) {
            PleaseWaitRunnable task = new PleaseWaitRunnable(I18n.tr("Precaching WMS", new Object[0])){
                private WMSLayer.PrecacheTask precacheTask;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void realRun() throws SAXException, IOException, OsmTransferException {
                    this.precacheTask = new WMSLayer.PrecacheTask(this.progressMonitor);
                    layer.downloadAreaToCache(this.precacheTask, points, 0.0, 0.0);
                    while (!this.precacheTask.isFinished() && !this.progressMonitor.isCanceled()) {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            try {
                                this.wait(200L);
                            }
                            catch (InterruptedException ex) {
                                Main.warn("InterruptedException in " + this.getClass().getSimpleName() + " while precaching WMS");
                            }
                        }
                    }
                }

                @Override
                protected void finish() {
                }

                @Override
                protected void cancel() {
                    this.precacheTask.cancel();
                }

                @Override
                public ProgressTaskId canRunInBackground() {
                    return ProgressTaskIds.PRECACHE_WMS;
                }
            };
            Main.worker.execute(task);
        }
    }

    protected WMSLayer askWMSLayer() {
        List<WMSLayer> targetLayers = Main.map.mapView.getLayersOfType(WMSLayer.class);
        if (targetLayers.isEmpty()) {
            this.warnNoImageryLayers();
            return null;
        }
        JosmComboBox<WMSLayer> layerList = new JosmComboBox<WMSLayer>(targetLayers.toArray(new WMSLayer[0]));
        layerList.setRenderer(new AbstractMergeAction.LayerListCellRenderer());
        layerList.setSelectedIndex(0);
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.add((Component)new JLabel(I18n.tr("Please select the imagery layer.", new Object[0])), GBC.eol());
        pnl.add(layerList, GBC.eol());
        ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Select imagery layer", new Object[0]), new String[]{I18n.tr("Download", new Object[0]), I18n.tr("Cancel", new Object[0])});
        ed.setButtonIcons(new String[]{"dialogs/down", "cancel"});
        ed.setContent(pnl);
        ed.showDialog();
        if (ed.getValue() != 1) {
            return null;
        }
        return (WMSLayer)layerList.getSelectedItem();
    }

    protected void warnNoImageryLayers() {
        JOptionPane.showMessageDialog(Main.parent, I18n.tr("There are no imagery layers.", new Object[0]), I18n.tr("No imagery layers", new Object[0]), 2);
    }
}

