/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DownloadAlongAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.gpx.DownloadAlongPanel;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

public class DownloadAlongTrackAction
extends DownloadAlongAction {
    private final GpxData data;

    public DownloadAlongTrackAction(GpxData data) {
        super(I18n.tr("Download from OSM along this track", new Object[0]), "downloadalongtrack", null, null, false);
        this.data = data;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final DownloadAlongPanel panel = new DownloadAlongPanel("downloadAlongTrack.download.osm", "downloadAlongTrack.download.gps", "downloadAlongTrack.distance", "downloadAlongTrack.area", "downloadAlongTrack.near");
        if (0 != panel.showInDownloadDialog(I18n.tr("Download from OSM along this track", new Object[0]), HelpUtil.ht("/Action/DownloadAlongTrack"))) {
            return;
        }
        final int near = panel.getNear();
        double latsum = 0.0;
        int latcnt = 0;
        if (near == 0 || near == 2) {
            for (GpxTrack trk : this.data.tracks) {
                for (GpxTrackSegment segment : trk.getSegments()) {
                    for (WayPoint p : segment.getWayPoints()) {
                        latsum += p.getCoor().lat();
                        ++latcnt;
                    }
                }
            }
        }
        if (near == 1 || near == 2) {
            for (WayPoint p : this.data.waypoints) {
                latsum += p.getCoor().lat();
                ++latcnt;
            }
        }
        double avglat = latsum / (double)latcnt;
        double scale = Math.cos(Math.toRadians(avglat));
        final double buffer_dist = panel.getDistance();
        final double max_area = panel.getArea() / 10000.0 / scale;
        final double buffer_y = buffer_dist / 100000.0;
        final double buffer_x = buffer_y / scale;
        final int totalTicks = latcnt;
        final boolean displayProgress = totalTicks > 2000 && buffer_y < 0.01;
        class CalculateDownloadArea
        extends PleaseWaitRunnable {
            private Area a;
            private boolean cancel;
            private int ticks;
            private Rectangle2D r;

            public CalculateDownloadArea() {
                super(I18n.tr("Calculating Download Area", new Object[0]), bl ? null : NullProgressMonitor.INSTANCE, false);
                this.a = new Area();
                this.cancel = false;
                this.ticks = 0;
                this.r = new Rectangle2D.Double();
            }

            @Override
            protected void cancel() {
                this.cancel = true;
            }

            @Override
            protected void finish() {
            }

            @Override
            protected void afterFinish() {
                if (this.cancel) {
                    return;
                }
                DownloadAlongTrackAction.confirmAndDownloadAreas(this.a, max_area, panel.isDownloadOsmData(), panel.isDownloadGpxData(), I18n.tr("Download from OSM along this track", new Object[0]), this.progressMonitor);
            }

            private void tick() {
                ++this.ticks;
                if (this.ticks % 100 == 0) {
                    this.progressMonitor.worked(100);
                }
            }

            private LatLon calcAreaForWayPoint(WayPoint p, LatLon previous) {
                this.tick();
                LatLon c = p.getCoor();
                if (previous == null || c.greatCircleDistance(previous) > buffer_dist) {
                    this.r.setRect(c.lon() - buffer_x, c.lat() - buffer_y, 2.0 * buffer_x, 2.0 * buffer_y);
                    this.a.add(new Area(this.r));
                    return c;
                }
                return previous;
            }

            @Override
            protected void realRun() {
                this.progressMonitor.setTicksCount(totalTicks);
                LatLon previous = null;
                if (near == 0 || near == 2) {
                    for (GpxTrack trk : ((DownloadAlongTrackAction)DownloadAlongTrackAction.this).data.tracks) {
                        for (GpxTrackSegment segment : trk.getSegments()) {
                            for (WayPoint p : segment.getWayPoints()) {
                                if (this.cancel) {
                                    return;
                                }
                                previous = this.calcAreaForWayPoint(p, previous);
                            }
                        }
                    }
                }
                if (near == 1 || near == 2) {
                    for (WayPoint p : ((DownloadAlongTrackAction)DownloadAlongTrackAction.this).data.waypoints) {
                        if (this.cancel) {
                            return;
                        }
                        previous = this.calcAreaForWayPoint(p, previous);
                    }
                }
            }
        }
        Main.worker.submit(new CalculateDownloadArea());
    }
}

