/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.widgets.DateEditorWithSlider;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class DateFilterPanel
extends JPanel {
    DateEditorWithSlider dateFrom = new DateEditorWithSlider(I18n.tr("From", new Object[0]));
    DateEditorWithSlider dateTo = new DateEditorWithSlider(I18n.tr("To", new Object[0]));
    JCheckBox noTimestampCb = new JCheckBox(I18n.tr("No timestamp", new Object[0]));
    GpxLayer layer;
    ActionListener filterAppliedListener;
    final String PREF_DATE_0;
    final String PREF_DATE_MIN;
    final String PREF_DATE_MAX;
    private ChangeListener changeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            if (DateFilterPanel.this.isEnabled()) {
                DateFilterPanel.this.applyFilterWithDelay();
            }
        }
    };
    private Timer t = new Timer(200, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DateFilterPanel.this.applyFilter();
        }
    });

    public DateFilterPanel(GpxLayer layer, String preferencePrefix, boolean enabled) {
        super(new GridBagLayout());
        this.PREF_DATE_0 = preferencePrefix + ".showzerotimestamp";
        this.PREF_DATE_MIN = preferencePrefix + ".mintime";
        this.PREF_DATE_MAX = preferencePrefix + ".maxtime";
        this.layer = layer;
        Date[] bounds = layer.data.getMinMaxTimeForAllTracks();
        Date startTime = bounds == null ? new GregorianCalendar(2000, 1, 1).getTime() : bounds[0];
        Date endTime = bounds == null ? new Date() : bounds[1];
        this.dateFrom.setDate(startTime);
        this.dateTo.setDate(endTime);
        this.dateFrom.setRange(startTime, endTime);
        this.dateTo.setRange(startTime, endTime);
        this.add((Component)this.noTimestampCb, GBC.std().grid(1, 1).insets(0, 0, 5, 0));
        this.add((Component)this.dateFrom, GBC.std().grid(2, 1).fill(2));
        this.add((Component)this.dateTo, GBC.eol().grid(3, 1).fill(2));
        this.setEnabled(enabled);
        this.dateFrom.addDateListener(this.changeListener);
        this.dateTo.addDateListener(this.changeListener);
        this.noTimestampCb.addChangeListener(this.changeListener);
    }

    public void applyFilterWithDelay() {
        if (this.t.isRunning()) {
            this.t.restart();
        } else {
            this.t.start();
        }
    }

    public void applyFilter() {
        this.t.stop();
        this.filterTracksByDate();
        if (this.filterAppliedListener != null) {
            this.filterAppliedListener.actionPerformed(null);
        }
    }

    public void saveInPrefs() {
        Main.pref.putLong(this.PREF_DATE_MIN, this.dateFrom.getDate().getTime());
        Main.pref.putLong(this.PREF_DATE_MAX, this.dateTo.getDate().getTime());
        Main.pref.put(this.PREF_DATE_0, this.noTimestampCb.isSelected());
    }

    public void loadFromPrefs() {
        long t2;
        long t1 = Main.pref.getLong(this.PREF_DATE_MIN, 0L);
        if (t1 != 0L) {
            this.dateFrom.setDate(new Date(t1));
        }
        if ((t2 = Main.pref.getLong(this.PREF_DATE_MAX, 0L)) != 0L) {
            this.dateTo.setDate(new Date(t2));
        }
        this.noTimestampCb.setSelected(Main.pref.getBoolean(this.PREF_DATE_0, false));
    }

    public void setFilterAppliedListener(ActionListener filterAppliedListener) {
        this.filterAppliedListener = filterAppliedListener;
    }

    private void filterTracksByDate() {
        Date from = this.dateFrom.getDate();
        Date to = this.dateTo.getDate();
        this.layer.filterTracksByDate(from, to, this.noTimestampCb.isSelected());
    }

    @Override
    public final void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Component c : this.getComponents()) {
            c.setEnabled(enabled);
        }
    }
}

