/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.date.DateUtils;

public class ConvertToDataLayerAction
extends AbstractAction {
    private final GpxLayer layer;

    public ConvertToDataLayerAction(GpxLayer layer) {
        super(I18n.tr("Convert to data layer", new Object[0]), ImageProvider.get("converttoosm"));
        this.layer = layer;
        this.putValue("help", HelpUtil.ht("/Action/ConvertToDataLayer"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JPanel msg = new JPanel(new GridBagLayout());
        msg.add((Component)new JLabel(I18n.tr("<html>Upload of unprocessed GPS data as map data is considered harmful.<br>If you want to upload traces, look here:</html>", new Object[0])), GBC.eol());
        msg.add((Component)new UrlLabel(Main.getOSMWebsite() + "/traces", 2), GBC.eop());
        if (!ConditionalOptionPaneUtil.showConfirmationDialog("convert_to_data", Main.parent, msg, I18n.tr("Warning", new Object[0]), 2, 2, 0)) {
            return;
        }
        DataSet ds = new DataSet();
        for (GpxTrack trk : this.layer.data.tracks) {
            for (GpxTrackSegment segment : trk.getSegments()) {
                ArrayList<Node> nodes = new ArrayList<Node>();
                for (WayPoint p : segment.getWayPoints()) {
                    Node n = new Node(p.getCoor());
                    String timestr = p.getString("time");
                    if (timestr != null) {
                        n.setTimestamp(DateUtils.fromString(timestr));
                    }
                    ds.addPrimitive(n);
                    nodes.add(n);
                }
                Way w = new Way();
                w.setNodes(nodes);
                ds.addPrimitive(w);
            }
        }
        Main.main.addLayer(new OsmDataLayer(ds, I18n.tr("Converted from: {0}", this.layer.getName()), this.layer.getAssociatedFile()));
        Main.main.removeLayer(this.layer);
    }
}

