/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.gpx.DateFilterPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.WindowGeometry;

public class ChooseTrackVisibilityAction
extends AbstractAction {
    private final GpxLayer layer;
    DateFilterPanel dateFilter;
    JTable table;
    boolean noUpdates = false;

    public ChooseTrackVisibilityAction(GpxLayer layer) {
        super(I18n.tr("Choose visible tracks", new Object[0]), ImageProvider.get("dialogs/filter"));
        this.layer = layer;
        this.putValue("help", HelpUtil.ht("/Action/ChooseTrackVisibility"));
    }

    private Object[][] buildTableContents() {
        Object[][] tracks = new Object[this.layer.data.tracks.size()][5];
        int i = 0;
        for (GpxTrack trk : this.layer.data.tracks) {
            Map<String, Object> attr = trk.getAttributes();
            String name = attr.containsKey("name") ? attr.get("name") : "";
            String desc = attr.containsKey("desc") ? attr.get("desc") : "";
            String time = GpxLayer.getTimespanForTrack(trk);
            TrackLength length = new TrackLength(trk.length());
            String url = attr.containsKey("url") ? attr.get("url") : "";
            tracks[i] = new Object[]{name, desc, time, length, url};
            ++i;
        }
        return tracks;
    }

    private JTable buildTable(Object[][] content) {
        Object[] headers = new String[]{I18n.tr("Name", new Object[0]), I18n.tr("Description", new Object[0]), I18n.tr("Timespan", new Object[0]), I18n.tr("Length", new Object[0]), I18n.tr("URL", new Object[0])};
        DefaultTableModel model = new DefaultTableModel(content, headers);
        JTable t = new JTable(model){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                Component c = super.prepareRenderer(renderer, row, col);
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    jc.setToolTipText(this.getValueAt(row, col).toString());
                }
                return c;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int colIndex) {
                return false;
            }
        };
        TableRowSorter<DefaultTableModel> rowSorter = new TableRowSorter<DefaultTableModel>();
        t.setRowSorter(rowSorter);
        rowSorter.setModel(model);
        rowSorter.setComparator(3, new LengthContentComparator());
        t.getColumnModel().getColumn(0).setPreferredWidth(220);
        t.getColumnModel().getColumn(1).setPreferredWidth(300);
        t.getColumnModel().getColumn(2).setPreferredWidth(200);
        t.getColumnModel().getColumn(3).setPreferredWidth(50);
        t.getColumnModel().getColumn(4).setPreferredWidth(100);
        MouseAdapter urlOpener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                JTable t = (JTable)e.getSource();
                int col = t.convertColumnIndexToModel(t.columnAtPoint(e.getPoint()));
                if (col != 4) {
                    return;
                }
                int row = t.rowAtPoint(e.getPoint());
                String url = (String)t.getValueAt(row, col);
                if (url == null || url.isEmpty()) {
                    return;
                }
                OpenBrowser.displayUrl(url);
            }
        };
        t.addMouseListener(urlOpener);
        t.setFillsViewportHeight(true);
        return t;
    }

    private void selectVisibleTracksInTable() {
        if (!this.layer.isVisible()) {
            return;
        }
        ListSelectionModel s = this.table.getSelectionModel();
        s.clearSelection();
        for (int i = 0; i < this.layer.trackVisibility.length; ++i) {
            if (!this.layer.trackVisibility[i]) continue;
            s.addSelectionInterval(i, i);
        }
    }

    private void listenToSelectionChanges() {
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ChooseTrackVisibilityAction.this.noUpdates || !(e.getSource() instanceof ListSelectionModel)) {
                    return;
                }
                ChooseTrackVisibilityAction.this.updateVisibilityFromTable();
            }
        });
    }

    private void updateVisibilityFromTable() {
        ListSelectionModel s = this.table.getSelectionModel();
        for (int i = 0; i < this.layer.trackVisibility.length; ++i) {
            this.layer.trackVisibility[this.table.convertRowIndexToModel((int)i)] = s.isSelectedIndex(i);
        }
        Main.map.mapView.preferenceChanged(null);
        Main.map.repaint(100L);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        JPanel msg = new JPanel(new GridBagLayout());
        this.dateFilter = new DateFilterPanel(this.layer, "gpx.traces", false);
        this.dateFilter.setFilterAppliedListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseTrackVisibilityAction.this.noUpdates = true;
                ChooseTrackVisibilityAction.this.selectVisibleTracksInTable();
                ChooseTrackVisibilityAction.this.noUpdates = false;
                Main.map.mapView.preferenceChanged(null);
                Main.map.repaint(100L);
            }
        });
        this.dateFilter.loadFromPrefs();
        JToggleButton b = new JToggleButton(new AbstractAction(I18n.tr("Select by date", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JToggleButton)e.getSource()).isSelected()) {
                    ChooseTrackVisibilityAction.this.dateFilter.setEnabled(true);
                    ChooseTrackVisibilityAction.this.dateFilter.applyFilter();
                } else {
                    ChooseTrackVisibilityAction.this.dateFilter.setEnabled(false);
                }
            }
        });
        this.dateFilter.setEnabled(false);
        msg.add((Component)b, GBC.std().insets(0, 0, 5, 0));
        msg.add((Component)this.dateFilter, GBC.eol().insets(0, 0, 10, 0).fill(2));
        msg.add((Component)new JLabel(I18n.tr("<html>Select all tracks that you want to be displayed. You can drag select a range of tracks or use CTRL+Click to select specific ones. The map is updated live in the background. Open the URLs by double clicking them.</html>", new Object[0])), GBC.eop().fill(2));
        boolean[] trackVisibilityBackup = (boolean[])this.layer.trackVisibility.clone();
        this.table = this.buildTable(this.buildTableContents());
        this.selectVisibleTracksInTable();
        this.listenToSelectionChanges();
        JScrollPane scrollPane = new JScrollPane(this.table);
        msg.add((Component)scrollPane, GBC.eol().fill(1));
        ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Set track visibility for {0}", this.layer.getName()), new String[]{I18n.tr("Show all", new Object[0]), I18n.tr("Show selected only", new Object[0]), I18n.tr("Cancel", new Object[0])});
        ed.setButtonIcons(new String[]{"eye", "dialogs/filter", "cancel"});
        ed.setContent(msg, false);
        ed.setDefaultButton(2);
        ed.setCancelButton(3);
        ed.configureContextsensitiveHelp("/Action/ChooseTrackVisibility", true);
        ed.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(1000, 500)));
        ed.showDialog();
        this.dateFilter.saveInPrefs();
        int v = ed.getValue();
        if (v != 1 && v != 2) {
            this.layer.trackVisibility = Arrays.copyOf(trackVisibilityBackup, this.layer.trackVisibility.length);
            Main.map.repaint();
            return;
        }
        ListSelectionModel s = this.table.getSelectionModel();
        boolean all = v == 1 || s.isSelectionEmpty();
        for (int i = 0; i < this.layer.trackVisibility.length; ++i) {
            this.layer.trackVisibility[this.table.convertRowIndexToModel((int)i)] = all || s.isSelectedIndex(i);
        }
        this.layer.setVisible(v == 1 || !s.isSelectionEmpty());
        Main.map.mapView.preferenceChanged(null);
        Main.map.repaint();
    }

    private static final class LengthContentComparator
    implements Comparator<TrackLength> {
        private LengthContentComparator() {
        }

        @Override
        public int compare(TrackLength l0, TrackLength l1) {
            if (l0.value < l1.value) {
                return -1;
            }
            if (l0.value > l1.value) {
                return 1;
            }
            return 0;
        }
    }

    private static final class TrackLength {
        private double value;

        TrackLength(double value) {
            this.value = value;
        }

        public String toString() {
            return NavigatableComponent.getSystemOfMeasurement().getDistText(this.value);
        }
    }
}

