/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageDisplay;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.io.CacheFiles;
import org.openstreetmap.josm.tools.ExifReader;

public class ThumbsLoader
implements Runnable {
    public static final int maxSize = 120;
    public static final int minSize = 22;
    public volatile boolean stop = false;
    List<ImageEntry> data;
    GeoImageLayer layer;
    MediaTracker tracker;
    CacheFiles cache;
    boolean cacheOff = Main.pref.getBoolean("geoimage.noThumbnailCache", false);

    public ThumbsLoader(GeoImageLayer layer) {
        this.layer = layer;
        this.data = new ArrayList<ImageEntry>(layer.data);
        if (!this.cacheOff) {
            this.cache = new CacheFiles("geoimage-thumbnails", false);
            this.cache.setExpire(-1, false);
            this.cache.setMaxSize(120, false);
        }
    }

    @Override
    public void run() {
        Main.debug("Load Thumbnails");
        this.tracker = new MediaTracker(Main.map.mapView);
        for (int i = 0; i < this.data.size(); ++i) {
            if (this.stop) {
                return;
            }
            if (this.data.get((int)i).thumbnail != null) continue;
            this.data.get((int)i).thumbnail = this.loadThumb(this.data.get(i));
            if (!Main.isDisplayingMapView()) continue;
            this.layer.updateOffscreenBuffer = true;
            Main.map.mapView.repaint();
        }
        this.layer.thumbsLoaded();
        this.layer.updateOffscreenBuffer = true;
        Main.map.mapView.repaint();
    }

    private BufferedImage loadThumb(ImageEntry entry) {
        int hh;
        int ww;
        BufferedImage cached;
        String cacheIdent = entry.getFile().toString() + ":" + 120;
        if (!this.cacheOff && (cached = this.cache.getImg(cacheIdent)) != null) {
            Main.debug(" from cache");
            return cached;
        }
        Image img = Toolkit.getDefaultToolkit().createImage(entry.getFile().getPath());
        this.tracker.addImage(img, 0);
        try {
            this.tracker.waitForID(0);
        }
        catch (InterruptedException e) {
            Main.error(" InterruptedException while loading thumb");
            return null;
        }
        if (this.tracker.isErrorID(1) || img.getWidth(null) <= 0 || img.getHeight(null) <= 0) {
            Main.error(" Invalid image");
            return null;
        }
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        if (ExifReader.orientationSwitchesDimensions(entry.getExifOrientation())) {
            ww = h;
            hh = w;
        } else {
            ww = w;
            hh = h;
        }
        Rectangle targetSize = ImageDisplay.calculateDrawImageRectangle(new Rectangle(0, 0, ww, hh), new Rectangle(0, 0, 120, 120));
        BufferedImage scaledBI = new BufferedImage(targetSize.width, targetSize.height, 1);
        Graphics2D g = scaledBI.createGraphics();
        AffineTransform restoreOrientation = ExifReader.getRestoreOrientationTransform(entry.getExifOrientation(), w, h);
        AffineTransform scale = AffineTransform.getScaleInstance((double)targetSize.width / (double)ww, (double)targetSize.height / (double)hh);
        scale.concatenate(restoreOrientation);
        while (!g.drawImage(img, scale, null)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ie) {
                Main.warn("InterruptedException while drawing thumb");
            }
        }
        g.dispose();
        this.tracker.removeImage(img);
        if (scaledBI.getWidth() <= 0 || scaledBI.getHeight() <= 0) {
            Main.error(" Invalid image");
            return null;
        }
        if (!this.cacheOff) {
            this.cache.saveImg(cacheIdent, scaledBI);
        }
        return scaledBI;
    }
}

