/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.DialogsPanel;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageDisplay;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.date.DateUtils;

public final class ImageViewerDialog
extends ToggleDialog
implements MapView.LayerChangeListener {
    private ImageDisplay imgDisplay = new ImageDisplay();
    private boolean centerView = false;
    private static volatile ImageViewerDialog dialog;
    private boolean collapseButtonClicked = false;
    private JButton btnNext;
    private JButton btnPrevious;
    private JButton btnCollapse;
    private GeoImageLayer currentLayer = null;
    private ImageEntry currentEntry = null;

    static void newInstance() {
        dialog = new ImageViewerDialog();
    }

    public static ImageViewerDialog getInstance() {
        if (dialog == null) {
            throw new AssertionError((Object)"a new instance needs to be created first");
        }
        return dialog;
    }

    private ImageViewerDialog() {
        super(I18n.tr("Geotagged Images", new Object[0]), "geoimage", I18n.tr("Display geotagged images", new Object[0]), Shortcut.registerShortcut("tools:geotagged", I18n.tr("Tool: {0}", I18n.tr("Display geotagged images", new Object[0])), 89, 5003), 200);
        this.build();
        MapView.addLayerChangeListener(this);
    }

    protected void build() {
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        content.add((Component)this.imgDisplay, "Center");
        Dimension buttonDim = new Dimension(26, 26);
        ImageAction prevAction = new ImageAction("previous", ImageProvider.get("dialogs", "previous"), I18n.tr("Previous", new Object[0]));
        this.btnPrevious = new JButton(prevAction);
        this.btnPrevious.setPreferredSize(buttonDim);
        Shortcut scPrev = Shortcut.registerShortcut("geoimage:previous", I18n.tr("Geoimage: {0}", I18n.tr("Show previous Image", new Object[0])), 33, 5003);
        String APREVIOUS = "Previous Image";
        Main.registerActionShortcut(prevAction, scPrev);
        this.btnPrevious.getInputMap(2).put(scPrev.getKeyStroke(), "Previous Image");
        this.btnPrevious.getActionMap().put("Previous Image", prevAction);
        this.btnPrevious.setEnabled(false);
        String DELETE_TEXT = I18n.tr("Remove photo from layer", new Object[0]);
        ImageAction delAction = new ImageAction("remove", ImageProvider.get("dialogs", "delete"), DELETE_TEXT);
        JButton btnDelete = new JButton(delAction);
        btnDelete.setPreferredSize(buttonDim);
        Shortcut scDelete = Shortcut.registerShortcut("geoimage:deleteimagefromlayer", I18n.tr("Geoimage: {0}", I18n.tr("Remove photo from layer", new Object[0])), 127, 5005);
        Main.registerActionShortcut(delAction, scDelete);
        btnDelete.getInputMap(2).put(scDelete.getKeyStroke(), DELETE_TEXT);
        btnDelete.getActionMap().put(DELETE_TEXT, delAction);
        ImageAction delFromDiskAction = new ImageAction("removefromdisk", ImageProvider.get("dialogs", "geoimage/deletefromdisk"), I18n.tr("Delete image file from disk", new Object[0]));
        JButton btnDeleteFromDisk = new JButton(delFromDiskAction);
        btnDeleteFromDisk.setPreferredSize(buttonDim);
        Shortcut scDeleteFromDisk = Shortcut.registerShortcut("geoimage:deletefilefromdisk", I18n.tr("Geoimage: {0}", I18n.tr("Delete File from disk", new Object[0])), 127, 5009);
        String ADELFROMDISK = "Delete image file from disk";
        Main.registerActionShortcut(delFromDiskAction, scDeleteFromDisk);
        btnDeleteFromDisk.getInputMap(2).put(scDeleteFromDisk.getKeyStroke(), "Delete image file from disk");
        btnDeleteFromDisk.getActionMap().put("Delete image file from disk", delFromDiskAction);
        ImageAction copyPathAction = new ImageAction("copypath", ImageProvider.get("copy"), I18n.tr("Copy image path", new Object[0]));
        JButton btnCopyPath = new JButton(copyPathAction);
        btnCopyPath.setPreferredSize(buttonDim);
        Shortcut scCopyPath = Shortcut.registerShortcut("geoimage:copypath", I18n.tr("Geoimage: {0}", I18n.tr("Copy image path", new Object[0])), 67, 5010);
        String ACOPYPATH = "Copy image path";
        Main.registerActionShortcut(copyPathAction, scCopyPath);
        btnCopyPath.getInputMap(2).put(scCopyPath.getKeyStroke(), "Copy image path");
        btnCopyPath.getActionMap().put("Copy image path", copyPathAction);
        ImageAction nextAction = new ImageAction("next", ImageProvider.get("dialogs", "next"), I18n.tr("Next", new Object[0]));
        this.btnNext = new JButton(nextAction);
        this.btnNext.setPreferredSize(buttonDim);
        Shortcut scNext = Shortcut.registerShortcut("geoimage:next", I18n.tr("Geoimage: {0}", I18n.tr("Show next Image", new Object[0])), 34, 5003);
        String ANEXT = "Next Image";
        Main.registerActionShortcut(nextAction, scNext);
        this.btnNext.getInputMap(2).put(scNext.getKeyStroke(), "Next Image");
        this.btnNext.getActionMap().put("Next Image", nextAction);
        this.btnNext.setEnabled(false);
        Main.registerActionShortcut(new ImageAction("first", null, null), Shortcut.registerShortcut("geoimage:first", I18n.tr("Geoimage: {0}", I18n.tr("Show first Image", new Object[0])), 36, 5003));
        Main.registerActionShortcut(new ImageAction("last", null, null), Shortcut.registerShortcut("geoimage:last", I18n.tr("Geoimage: {0}", I18n.tr("Show last Image", new Object[0])), 35, 5003));
        JToggleButton tbCentre = new JToggleButton(new ImageAction("centre", ImageProvider.get("dialogs", "centreview"), I18n.tr("Center view", new Object[0])));
        tbCentre.setPreferredSize(buttonDim);
        JButton btnZoomBestFit = new JButton(new ImageAction("zoom", ImageProvider.get("dialogs", "zoom-best-fit"), I18n.tr("Zoom best fit and 1:1", new Object[0])));
        btnZoomBestFit.setPreferredSize(buttonDim);
        this.btnCollapse = new JButton(new ImageAction("collapse", ImageProvider.get("dialogs", "collapse"), I18n.tr("Move dialog to the side pane", new Object[0])));
        this.btnCollapse.setPreferredSize(new Dimension(20, 20));
        this.btnCollapse.setAlignmentY(0.0f);
        JPanel buttons = new JPanel();
        buttons.add(this.btnPrevious);
        buttons.add(this.btnNext);
        buttons.add(Box.createRigidArea(new Dimension(7, 0)));
        buttons.add(tbCentre);
        buttons.add(btnZoomBestFit);
        buttons.add(Box.createRigidArea(new Dimension(7, 0)));
        buttons.add(btnDelete);
        buttons.add(btnDeleteFromDisk);
        buttons.add(Box.createRigidArea(new Dimension(7, 0)));
        buttons.add(btnCopyPath);
        JPanel bottomPane = new JPanel();
        bottomPane.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 10;
        gc.weightx = 1.0;
        bottomPane.add((Component)buttons, gc);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.anchor = 20;
        gc.weightx = 0.0;
        bottomPane.add((Component)this.btnCollapse, gc);
        content.add((Component)bottomPane, "South");
        this.createLayout(content, false, null);
    }

    @Override
    public void destroy() {
        MapView.removeLayerChangeListener(this);
        super.destroy();
    }

    public static void showImage(GeoImageLayer layer, ImageEntry entry) {
        ImageViewerDialog.getInstance().displayImage(layer, entry);
        if (layer != null) {
            layer.checkPreviousNextButtons();
        } else {
            ImageViewerDialog.setPreviousEnabled(false);
            ImageViewerDialog.setNextEnabled(false);
        }
    }

    public static void setPreviousEnabled(boolean value) {
        ImageViewerDialog.getInstance().btnPrevious.setEnabled(value);
    }

    public static void setNextEnabled(boolean value) {
        ImageViewerDialog.getInstance().btnNext.setEnabled(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayImage(GeoImageLayer layer, ImageEntry entry) {
        StringBuilder osd;
        boolean imageChanged;
        ImageViewerDialog imageViewerDialog = this;
        synchronized (imageViewerDialog) {
            boolean bl = imageChanged = this.currentEntry != entry;
            if (this.centerView && Main.isDisplayingMapView() && entry != null && entry.getPos() != null) {
                Main.map.mapView.zoomTo(entry.getPos());
            }
            this.currentLayer = layer;
            this.currentEntry = entry;
        }
        if (entry != null) {
            if (imageChanged) {
                this.imgDisplay.setImage(entry.getFile(), entry.getExifOrientation());
            }
            this.setTitle(I18n.tr("Geotagged Images", new Object[0]) + (entry.getFile() != null ? " - " + entry.getFile().getName() : ""));
            osd = new StringBuilder(entry.getFile() != null ? entry.getFile().getName() : "");
            if (entry.getElevation() != null) {
                osd.append(I18n.tr("\nAltitude: {0} m", entry.getElevation().longValue()));
            }
            if (entry.getSpeed() != null) {
                osd.append(I18n.tr("\nSpeed: {0} km/h", Math.round(entry.getSpeed())));
            }
            if (entry.getExifImgDir() != null) {
                osd.append(I18n.tr("\nDirection {0}\u00b0", Math.round(entry.getExifImgDir())));
            }
            DateFormat dtf = DateUtils.getDateTimeFormat(3, 2);
            if (entry.hasExifTime()) {
                osd.append(I18n.tr("\nEXIF time: {0}", dtf.format(entry.getExifTime())));
            }
            if (entry.hasGpsTime()) {
                osd.append(I18n.tr("\nGPS time: {0}", dtf.format(entry.getGpsTime())));
            }
        } else {
            this.setTitle(I18n.tr("Geotagged Images", new Object[0]));
            this.imgDisplay.setImage(null, null);
            this.imgDisplay.setOsdText("");
            return;
        }
        this.imgDisplay.setOsdText(osd.toString());
        if (!this.isDialogShowing()) {
            this.setIsDocked(false);
            this.showDialog();
        } else if (this.isDocked && this.isCollapsed) {
            this.expand();
            this.dialogsPanel.reconstruct(DialogsPanel.Action.COLLAPSED_TO_DEFAULT, this);
        }
    }

    @Override
    protected boolean dockWhenClosingDetachedDlg() {
        if (this.collapseButtonClicked) {
            this.collapseButtonClicked = false;
            return true;
        }
        return false;
    }

    @Override
    protected void stateChanged() {
        super.stateChanged();
        if (this.btnCollapse != null) {
            this.btnCollapse.setVisible(!this.isDocked);
        }
    }

    public boolean hasImage() {
        return this.currentEntry != null;
    }

    public static ImageEntry getCurrentImage() {
        return ImageViewerDialog.getInstance().currentEntry;
    }

    public static GeoImageLayer getCurrentLayer() {
        return ImageViewerDialog.getInstance().currentLayer;
    }

    @Override
    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        if (this.currentLayer == null && newLayer instanceof GeoImageLayer) {
            ((GeoImageLayer)newLayer).showFirstPhoto();
        }
    }

    @Override
    public void layerAdded(Layer newLayer) {
        if (this.currentLayer == null && newLayer instanceof GeoImageLayer) {
            ((GeoImageLayer)newLayer).showFirstPhoto();
        }
    }

    @Override
    public void layerRemoved(Layer oldLayer) {
        if (this.currentLayer != null && this.currentLayer.equals(oldLayer)) {
            ImageViewerDialog.showImage(null, null);
        }
        if (this.currentLayer != null && oldLayer instanceof GeoImageLayer) {
            this.currentLayer.checkPreviousNextButtons();
        }
    }

    class ImageAction
    extends AbstractAction {
        private final String action;

        public ImageAction(String action, ImageIcon icon, String toolTipText) {
            this.action = action;
            this.putValue("ShortDescription", toolTipText);
            this.putValue("SmallIcon", icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if ("next".equals(this.action)) {
                if (ImageViewerDialog.this.currentLayer != null) {
                    ImageViewerDialog.this.currentLayer.showNextPhoto();
                }
            } else if ("previous".equals(this.action)) {
                if (ImageViewerDialog.this.currentLayer != null) {
                    ImageViewerDialog.this.currentLayer.showPreviousPhoto();
                }
            } else if ("first".equals(this.action) && ImageViewerDialog.this.currentLayer != null) {
                ImageViewerDialog.this.currentLayer.showFirstPhoto();
            } else if ("last".equals(this.action) && ImageViewerDialog.this.currentLayer != null) {
                ImageViewerDialog.this.currentLayer.showLastPhoto();
            } else if ("centre".equals(this.action)) {
                ImageViewerDialog.this.centerView = ((JToggleButton)e.getSource()).isSelected();
                if (ImageViewerDialog.this.centerView && ImageViewerDialog.this.currentEntry != null && ImageViewerDialog.this.currentEntry.getPos() != null) {
                    Main.map.mapView.zoomTo(ImageViewerDialog.this.currentEntry.getPos());
                }
            } else if ("zoom".equals(this.action)) {
                ImageViewerDialog.this.imgDisplay.zoomBestFitOrOne();
            } else if ("remove".equals(this.action)) {
                if (ImageViewerDialog.this.currentLayer != null) {
                    ImageViewerDialog.this.currentLayer.removeCurrentPhoto();
                }
            } else if ("removefromdisk".equals(this.action)) {
                if (ImageViewerDialog.this.currentLayer != null) {
                    ImageViewerDialog.this.currentLayer.removeCurrentPhotoFromDisk();
                }
            } else if ("copypath".equals(this.action)) {
                if (ImageViewerDialog.this.currentLayer != null) {
                    ImageViewerDialog.this.currentLayer.copyCurrentPhotoPath();
                }
            } else if ("collapse".equals(this.action)) {
                ImageViewerDialog.this.collapseButtonClicked = true;
                ImageViewerDialog.this.detachedDialog.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(ImageViewerDialog.this.detachedDialog, 201));
            }
        }
    }
}

