/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.lang.CompoundException;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.GpsDirectory;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.LassoModeAction;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.mapmode.SelectAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.JumpToMarkerActions;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.geoimage.CorrelateGpxWithImages;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.gui.layer.geoimage.ImageViewerDialog;
import org.openstreetmap.josm.gui.layer.geoimage.JpegFileFilter;
import org.openstreetmap.josm.gui.layer.geoimage.ShowThumbnailAction;
import org.openstreetmap.josm.gui.layer.geoimage.ThumbsLoader;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.ExifReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class GeoImageLayer
extends Layer
implements PropertyChangeListener,
JumpToMarkerActions.JumpToMarkerLayer {
    List<ImageEntry> data;
    GpxLayer gpxLayer;
    private Icon icon = ImageProvider.get("dialogs/geoimage/photo-marker");
    private Icon selectedIcon = ImageProvider.get("dialogs/geoimage/photo-marker-selected");
    private int currentPhoto = -1;
    boolean useThumbs = false;
    ExecutorService thumbsLoaderExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setPriority(1);
            return t;
        }
    });
    ThumbsLoader thumbsloader;
    boolean thumbsLoaderRunning = false;
    volatile boolean thumbsLoaded = false;
    private BufferedImage offscreenBuffer;
    boolean updateOffscreenBuffer = true;
    private static List<Action> menuAdditions = new LinkedList<Action>();
    private static volatile List<MapMode> supportedMapModes = null;
    private MouseAdapter mouseAdapter = null;
    private MapFrame.MapModeChangeListener mapModeListener = null;

    public static void create(Collection<File> files, GpxLayer gpxLayer) {
        Loader loader = new Loader(files, gpxLayer);
        Main.worker.execute(loader);
    }

    public GeoImageLayer(List<ImageEntry> data, GpxLayer gpxLayer) {
        this(data, gpxLayer, null, false);
    }

    public GeoImageLayer(List<ImageEntry> data, GpxLayer gpxLayer, String name) {
        this(data, gpxLayer, name, false);
    }

    public GeoImageLayer(List<ImageEntry> data, GpxLayer gpxLayer, boolean useThumbs) {
        this(data, gpxLayer, null, useThumbs);
    }

    public GeoImageLayer(List<ImageEntry> data, GpxLayer gpxLayer, String name, boolean useThumbs) {
        super(name != null ? name : I18n.tr("Geotagged Images", new Object[0]));
        Collections.sort(data);
        this.data = data;
        this.gpxLayer = gpxLayer;
        this.useThumbs = useThumbs;
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("dialogs/geoimage");
    }

    public static void registerMenuAddition(Action addition) {
        menuAdditions.add(addition);
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<Action> entries = new ArrayList<Action>();
        entries.add(LayerListDialog.getInstance().createShowHideLayerAction());
        entries.add(LayerListDialog.getInstance().createDeleteLayerAction());
        entries.add(new RenameLayerAction(null, this));
        entries.add(Layer.SeparatorLayerAction.INSTANCE);
        entries.add(new CorrelateGpxWithImages(this));
        entries.add(new ShowThumbnailAction(this));
        if (!menuAdditions.isEmpty()) {
            entries.add(Layer.SeparatorLayerAction.INSTANCE);
            entries.addAll(menuAdditions);
        }
        entries.add(Layer.SeparatorLayerAction.INSTANCE);
        entries.add(new JumpToMarkerActions.JumpToNextMarker(this));
        entries.add(new JumpToMarkerActions.JumpToPreviousMarker(this));
        entries.add(Layer.SeparatorLayerAction.INSTANCE);
        entries.add(new LayerListPopup.InfoAction(this));
        return entries.toArray(new Action[entries.size()]);
    }

    private String infoText() {
        int tagged = 0;
        int newdata = 0;
        for (ImageEntry e : this.data) {
            if (e.getPos() != null) {
                ++tagged;
            }
            if (!e.hasNewGpsData()) continue;
            ++newdata;
        }
        return "<html>" + I18n.trn("{0} image loaded.", "{0} images loaded.", this.data.size(), this.data.size()) + " " + I18n.trn("{0} was found to be GPS tagged.", "{0} were found to be GPS tagged.", tagged, tagged) + (newdata > 0 ? "<br>" + I18n.trn("{0} has updated GPS data.", "{0} have updated GPS data.", newdata, newdata) : "") + "</html>";
    }

    @Override
    public Object getInfoComponent() {
        return this.infoText();
    }

    @Override
    public String getToolTipText() {
        return this.infoText();
    }

    @Override
    public boolean isMergable(Layer other) {
        return other instanceof GeoImageLayer;
    }

    @Override
    public void mergeFrom(Layer from) {
        GeoImageLayer l = (GeoImageLayer)from;
        this.stopLoadThumbs();
        l.stopLoadThumbs();
        final ImageEntry selected = l.currentPhoto >= 0 ? l.data.get(l.currentPhoto) : null;
        this.data.addAll(l.data);
        Collections.sort(this.data);
        if (this.data.size() > 1) {
            ImageEntry prev = this.data.get(this.data.size() - 1);
            for (int i = this.data.size() - 2; i >= 0; --i) {
                ImageEntry cur = this.data.get(i);
                if (cur.getFile().equals(prev.getFile())) {
                    this.data.remove(i);
                    continue;
                }
                prev = cur;
            }
        }
        if (selected != null && !this.data.isEmpty()) {
            GuiHelper.runInEDTAndWait(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < GeoImageLayer.this.data.size(); ++i) {
                        if (!selected.equals(GeoImageLayer.this.data.get(i))) continue;
                        GeoImageLayer.this.currentPhoto = i;
                        ImageViewerDialog.showImage(GeoImageLayer.this, GeoImageLayer.this.data.get(i));
                        break;
                    }
                }
            });
        }
        this.setName(l.getName());
        this.thumbsLoaded &= l.thumbsLoaded;
    }

    private Dimension scaledDimension(Image thumb) {
        double d = Main.map.mapView.getDist100Pixel();
        double size = 10.0;
        double s = 1000.0 / d;
        double sMin = 22.0;
        double sMax = 120.0;
        if (s < 22.0) {
            s = 22.0;
        }
        if (s > 120.0) {
            s = 120.0;
        }
        double f = s / 120.0;
        if (thumb == null) {
            return null;
        }
        return new Dimension((int)Math.round(f * (double)thumb.getWidth(null)), (int)Math.round(f * (double)thumb.getHeight(null)));
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        ImageEntry e;
        int width = mv.getWidth();
        int height = mv.getHeight();
        Rectangle clip = g.getClipBounds();
        if (this.useThumbs) {
            if (!this.thumbsLoaded) {
                this.startLoadThumbs();
            }
            if (null == this.offscreenBuffer || this.offscreenBuffer.getWidth() != width || this.offscreenBuffer.getHeight() != height) {
                this.offscreenBuffer = new BufferedImage(width, height, 2);
                this.updateOffscreenBuffer = true;
            }
            if (this.updateOffscreenBuffer) {
                Graphics2D tempG = this.offscreenBuffer.createGraphics();
                tempG.setColor(new Color(0, 0, 0, 0));
                Composite saveComp = tempG.getComposite();
                tempG.setComposite(AlphaComposite.Clear);
                tempG.fillRect(0, 0, width, height);
                tempG.setComposite(saveComp);
                for (ImageEntry e2 : this.data) {
                    if (e2.getPos() == null) continue;
                    Point p = mv.getPoint(e2.getPos());
                    if (e2.thumbnail != null) {
                        Dimension d = this.scaledDimension(e2.thumbnail);
                        Rectangle target = new Rectangle(p.x - d.width / 2, p.y - d.height / 2, d.width, d.height);
                        if (!clip.intersects(target)) continue;
                        tempG.drawImage(e2.thumbnail, target.x, target.y, target.width, target.height, null);
                        continue;
                    }
                    this.icon.paintIcon(mv, tempG, p.x - this.icon.getIconWidth() / 2, p.y - this.icon.getIconHeight() / 2);
                }
                this.updateOffscreenBuffer = false;
            }
            g.drawImage((Image)this.offscreenBuffer, 0, 0, null);
        } else {
            for (ImageEntry e3 : this.data) {
                if (e3.getPos() == null) continue;
                Point p = mv.getPoint(e3.getPos());
                this.icon.paintIcon(mv, g, p.x - this.icon.getIconWidth() / 2, p.y - this.icon.getIconHeight() / 2);
            }
        }
        if (this.currentPhoto >= 0 && this.currentPhoto < this.data.size() && (e = this.data.get(this.currentPhoto)).getPos() != null) {
            Point p = mv.getPoint(e.getPos());
            int imgWidth = 100;
            int imgHeight = 100;
            if (this.useThumbs && e.thumbnail != null) {
                Dimension d = this.scaledDimension(e.thumbnail);
                imgWidth = d.width;
                imgHeight = d.height;
            } else {
                imgWidth = this.selectedIcon.getIconWidth();
                imgHeight = this.selectedIcon.getIconHeight();
            }
            if (e.getExifImgDir() != null) {
                double arrowlength = Math.max(25.0, (double)Math.max(imgWidth, imgHeight) * 0.85);
                double arrowwidth = arrowlength / 1.4;
                double dir = e.getExifImgDir();
                double headdir = dir < 90.0 ? dir + 270.0 : dir - 90.0;
                double leftdir = headdir < 90.0 ? headdir + 270.0 : headdir - 90.0;
                double rightdir = headdir > 270.0 ? headdir - 270.0 : headdir + 90.0;
                double ptx = (double)p.x + Math.cos(Math.toRadians(headdir)) * arrowlength;
                double pty = (double)p.y + Math.sin(Math.toRadians(headdir)) * arrowlength;
                double ltx = (double)p.x + Math.cos(Math.toRadians(leftdir)) * arrowwidth / 2.0;
                double lty = (double)p.y + Math.sin(Math.toRadians(leftdir)) * arrowwidth / 2.0;
                double rtx = (double)p.x + Math.cos(Math.toRadians(rightdir)) * arrowwidth / 2.0;
                double rty = (double)p.y + Math.sin(Math.toRadians(rightdir)) * arrowwidth / 2.0;
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(new Color(255, 255, 255, 192));
                int[] xar = new int[]{(int)ltx, (int)ptx, (int)rtx, (int)ltx};
                int[] yar = new int[]{(int)lty, (int)pty, (int)rty, (int)lty};
                g.fillPolygon(xar, yar, 4);
                g.setColor(Color.black);
                g.setStroke(new BasicStroke(1.2f));
                g.drawPolyline(xar, yar, 3);
            }
            if (this.useThumbs && e.thumbnail != null) {
                g.setColor(new Color(128, 0, 0, 122));
                g.fillRect(p.x - imgWidth / 2, p.y - imgHeight / 2, imgWidth, imgHeight);
            } else {
                this.selectedIcon.paintIcon(mv, g, p.x - imgWidth / 2, p.y - imgHeight / 2);
            }
        }
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor v) {
        for (ImageEntry e : this.data) {
            v.visit(e.getPos());
        }
    }

    private static void extractExif(ImageEntry e) {
        GpsDirectory dirGps;
        ExifIFD0Directory dirExif;
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(e.getFile());
            dirExif = metadata.getDirectory(ExifIFD0Directory.class);
            dirGps = metadata.getDirectory(GpsDirectory.class);
        }
        catch (CompoundException | IOException p) {
            e.setExifCoor(null);
            e.setPos(null);
            return;
        }
        try {
            if (dirExif != null) {
                int orientation = dirExif.getInt(274);
                e.setExifOrientation(orientation);
            }
        }
        catch (MetadataException ex) {
            Main.debug(ex.getMessage());
        }
        if (dirGps == null) {
            e.setExifCoor(null);
            e.setPos(null);
            return;
        }
        try {
            double speed = dirGps.getDouble(13);
            String speedRef = dirGps.getString(12);
            if (speedRef != null) {
                if (speedRef.equalsIgnoreCase("M")) {
                    speed *= 1.609344;
                } else if (speedRef.equalsIgnoreCase("N")) {
                    speed *= 1.852;
                }
            }
            e.setSpeed(speed);
        }
        catch (Exception ex) {
            Main.debug(ex.getMessage());
        }
        try {
            double ele = dirGps.getDouble(6);
            int d = dirGps.getInt(5);
            if (d == 1) {
                ele *= -1.0;
            }
            e.setElevation(ele);
        }
        catch (MetadataException ex) {
            Main.debug(ex.getMessage());
        }
        try {
            LatLon latlon = ExifReader.readLatLon(dirGps);
            e.setExifCoor(latlon);
            e.setPos(e.getExifCoor());
        }
        catch (Exception ex) {
            Main.error("Error reading EXIF from file: " + ex);
            e.setExifCoor(null);
            e.setPos(null);
        }
        try {
            Double direction = ExifReader.readDirection(dirGps);
            if (direction != null) {
                e.setExifImgDir(direction);
            }
        }
        catch (Exception ex) {
            Main.debug(ex.getMessage());
        }
        int[] timeStampComps = dirGps.getIntArray(7);
        if (timeStampComps != null) {
            int gpsHour = timeStampComps[0];
            int gpsMin = timeStampComps[1];
            int gpsSec = timeStampComps[2];
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            String dateStampStr = dirGps.getString(29);
            if (dateStampStr != null && dateStampStr.matches("^\\d+:\\d+:\\d+$")) {
                String[] dateStampComps = dateStampStr.split(":");
                cal.set(1, Integer.parseInt(dateStampComps[0]));
                cal.set(2, Integer.parseInt(dateStampComps[1]) - 1);
                cal.set(5, Integer.parseInt(dateStampComps[2]));
            } else if (e.hasExifTime()) {
                cal.setTime(e.getExifTime());
            }
            cal.set(11, gpsHour);
            cal.set(12, gpsMin);
            cal.set(13, gpsSec);
            e.setExifGpsTime(cal.getTime());
        }
    }

    public void showNextPhoto() {
        if (this.data != null && this.data.size() > 0) {
            ++this.currentPhoto;
            if (this.currentPhoto >= this.data.size()) {
                this.currentPhoto = this.data.size() - 1;
            }
            ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
        } else {
            this.currentPhoto = -1;
        }
        Main.map.repaint();
    }

    public void showPreviousPhoto() {
        if (this.data != null && !this.data.isEmpty()) {
            --this.currentPhoto;
            if (this.currentPhoto < 0) {
                this.currentPhoto = 0;
            }
            ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
        } else {
            this.currentPhoto = -1;
        }
        Main.map.repaint();
    }

    public void showFirstPhoto() {
        if (this.data != null && this.data.size() > 0) {
            this.currentPhoto = 0;
            ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
        } else {
            this.currentPhoto = -1;
        }
        Main.map.repaint();
    }

    public void showLastPhoto() {
        if (this.data != null && this.data.size() > 0) {
            this.currentPhoto = this.data.size() - 1;
            ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
        } else {
            this.currentPhoto = -1;
        }
        Main.map.repaint();
    }

    public void checkPreviousNextButtons() {
        ImageViewerDialog.setNextEnabled(this.currentPhoto < this.data.size() - 1);
        ImageViewerDialog.setPreviousEnabled(this.currentPhoto > 0);
    }

    public void removeCurrentPhoto() {
        if (this.data != null && this.data.size() > 0 && this.currentPhoto >= 0 && this.currentPhoto < this.data.size()) {
            this.data.remove(this.currentPhoto);
            if (this.currentPhoto >= this.data.size()) {
                this.currentPhoto = this.data.size() - 1;
            }
            if (this.currentPhoto >= 0) {
                ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
            } else {
                ImageViewerDialog.showImage(this, null);
            }
            this.updateOffscreenBuffer = true;
            Main.map.repaint();
        }
    }

    public void removeCurrentPhotoFromDisk() {
        ImageEntry toDelete = null;
        if (this.data != null && this.data.size() > 0 && this.currentPhoto >= 0 && this.currentPhoto < this.data.size()) {
            toDelete = this.data.get(this.currentPhoto);
            int result = new ExtendedDialog(Main.parent, I18n.tr("Delete image file from disk", new Object[0]), new String[]{I18n.tr("Cancel", new Object[0]), I18n.tr("Delete", new Object[0])}).setButtonIcons(new String[]{"cancel", "dialogs/delete"}).setContent(new JLabel(I18n.tr("<html><h3>Delete the file {0} from disk?<p>The image file will be permanently lost!</h3></html>", toDelete.getFile().getName()), ImageProvider.get("dialogs/geoimage/deletefromdisk"), 2)).toggleEnable("geoimage.deleteimagefromdisk").setCancelButton(1).setDefaultButton(2).showDialog().getValue();
            if (result == 2) {
                this.data.remove(this.currentPhoto);
                if (this.currentPhoto >= this.data.size()) {
                    this.currentPhoto = this.data.size() - 1;
                }
                if (this.currentPhoto >= 0) {
                    ImageViewerDialog.showImage(this, this.data.get(this.currentPhoto));
                } else {
                    ImageViewerDialog.showImage(this, null);
                }
                if (toDelete.getFile().delete()) {
                    Main.info("File " + toDelete.getFile().toString() + " deleted. ");
                } else {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Image file could not be deleted.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
                }
                this.updateOffscreenBuffer = true;
                Main.map.repaint();
            }
        }
    }

    public void copyCurrentPhotoPath() {
        ImageEntry toCopy = null;
        if (this.data != null && this.data.size() > 0 && this.currentPhoto >= 0 && this.currentPhoto < this.data.size()) {
            toCopy = this.data.get(this.currentPhoto);
            String copyString = toCopy.getFile().toString();
            Utils.copyToClipboard(copyString);
        }
    }

    public void removePhotoByIdx(int idx) {
        if (idx >= 0 && this.data != null && idx < this.data.size()) {
            this.data.remove(idx);
        }
    }

    public ImageEntry getPhotoUnderMouse(MouseEvent evt) {
        if (this.data != null) {
            for (int idx = this.data.size() - 1; idx >= 0; --idx) {
                Rectangle r;
                ImageEntry img = this.data.get(idx);
                if (img.getPos() == null) continue;
                Point p = Main.map.mapView.getPoint(img.getPos());
                if (this.useThumbs && img.thumbnail != null) {
                    Dimension d = this.scaledDimension(img.thumbnail);
                    r = new Rectangle(p.x - d.width / 2, p.y - d.height / 2, d.width, d.height);
                } else {
                    r = new Rectangle(p.x - this.icon.getIconWidth() / 2, p.y - this.icon.getIconHeight() / 2, this.icon.getIconWidth(), this.icon.getIconHeight());
                }
                if (!r.contains(evt.getPoint())) continue;
                return img;
            }
        }
        return null;
    }

    public void clearCurrentPhoto(boolean repaint) {
        this.currentPhoto = -1;
        if (repaint) {
            this.updateBufferAndRepaint();
        }
    }

    private void clearOtherCurrentPhotos() {
        for (GeoImageLayer layer : Main.map.mapView.getLayersOfType(GeoImageLayer.class)) {
            if (layer == this) continue;
            layer.clearCurrentPhoto(false);
        }
    }

    public static void registerSupportedMapMode(MapMode mapMode) {
        if (supportedMapModes == null) {
            supportedMapModes = new ArrayList<MapMode>();
        }
        supportedMapModes.add(mapMode);
    }

    private static final boolean isSupportedMapMode(MapMode mapMode) {
        if (mapMode instanceof SelectAction || mapMode instanceof LassoModeAction) {
            return true;
        }
        if (supportedMapModes != null) {
            for (MapMode supmmode : supportedMapModes) {
                if (mapMode != supmmode) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void hookUpMapView() {
        this.mouseAdapter = new MouseAdapter(){

            private final boolean isMapModeOk() {
                return Main.map.mapMode == null || GeoImageLayer.isSupportedMapMode(Main.map.mapMode);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                if (GeoImageLayer.this.isVisible() && this.isMapModeOk()) {
                    Main.map.mapView.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent ev) {
                if (ev.getButton() != 1) {
                    return;
                }
                if (GeoImageLayer.this.data == null || !GeoImageLayer.this.isVisible() || !this.isMapModeOk()) {
                    return;
                }
                for (int i = GeoImageLayer.this.data.size() - 1; i >= 0; --i) {
                    Rectangle r;
                    ImageEntry e = GeoImageLayer.this.data.get(i);
                    if (e.getPos() == null) continue;
                    Point p = Main.map.mapView.getPoint(e.getPos());
                    if (GeoImageLayer.this.useThumbs && e.thumbnail != null) {
                        Dimension d = GeoImageLayer.this.scaledDimension(e.thumbnail);
                        r = new Rectangle(p.x - d.width / 2, p.y - d.height / 2, d.width, d.height);
                    } else {
                        r = new Rectangle(p.x - GeoImageLayer.this.icon.getIconWidth() / 2, p.y - GeoImageLayer.this.icon.getIconHeight() / 2, GeoImageLayer.this.icon.getIconWidth(), GeoImageLayer.this.icon.getIconHeight());
                    }
                    if (!r.contains(ev.getPoint())) continue;
                    GeoImageLayer.this.clearOtherCurrentPhotos();
                    GeoImageLayer.this.currentPhoto = i;
                    ImageViewerDialog.showImage(GeoImageLayer.this, e);
                    Main.map.repaint();
                    break;
                }
            }
        };
        this.mapModeListener = new MapFrame.MapModeChangeListener(){

            @Override
            public void mapModeChange(MapMode oldMapMode, MapMode newMapMode) {
                if (newMapMode == null || GeoImageLayer.isSupportedMapMode(newMapMode)) {
                    Main.map.mapView.addMouseListener(GeoImageLayer.this.mouseAdapter);
                } else {
                    Main.map.mapView.removeMouseListener(GeoImageLayer.this.mouseAdapter);
                }
            }
        };
        MapFrame.addMapModeChangeListener(this.mapModeListener);
        this.mapModeListener.mapModeChange(null, Main.map.mapMode);
        MapView.addLayerChangeListener(new MapView.LayerChangeListener(){

            @Override
            public void activeLayerChange(Layer oldLayer, Layer newLayer) {
                if (newLayer == GeoImageLayer.this) {
                    Main.map.selectSelectTool(false);
                }
            }

            @Override
            public void layerAdded(Layer newLayer) {
            }

            @Override
            public void layerRemoved(Layer oldLayer) {
                if (oldLayer == GeoImageLayer.this) {
                    GeoImageLayer.this.stopLoadThumbs();
                    Main.map.mapView.removeMouseListener(GeoImageLayer.this.mouseAdapter);
                    MapFrame.removeMapModeChangeListener(GeoImageLayer.this.mapModeListener);
                    GeoImageLayer.this.currentPhoto = -1;
                    GeoImageLayer.this.data.clear();
                    GeoImageLayer.this.data = null;
                    MapView.removeLayerChangeListener(this);
                }
            }
        });
        Main.map.mapView.addPropertyChangeListener(this);
        if (Main.map.getToggleDialog(ImageViewerDialog.class) == null) {
            ImageViewerDialog.newInstance();
            Main.map.addToggleDialog(ImageViewerDialog.getInstance());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("center".equals(evt.getPropertyName()) || "scale".equals(evt.getPropertyName())) {
            this.updateOffscreenBuffer = true;
        }
    }

    public synchronized void startLoadThumbs() {
        if (this.useThumbs && !this.thumbsLoaded && !this.thumbsLoaderRunning) {
            this.stopLoadThumbs();
            this.thumbsloader = new ThumbsLoader(this);
            this.thumbsLoaderExecutor.submit(this.thumbsloader);
            this.thumbsLoaderRunning = true;
        }
    }

    public synchronized void stopLoadThumbs() {
        if (this.thumbsloader != null) {
            this.thumbsloader.stop = true;
        }
        this.thumbsLoaderRunning = false;
    }

    public void thumbsLoaded() {
        this.thumbsLoaded = true;
    }

    public void updateBufferAndRepaint() {
        this.updateOffscreenBuffer = true;
        Main.map.mapView.repaint();
    }

    public List<ImageEntry> getImages() {
        ArrayList<ImageEntry> copy = new ArrayList<ImageEntry>(this.data.size());
        for (ImageEntry ie : this.data) {
            copy.add(ie);
        }
        return copy;
    }

    public GpxLayer getGpxLayer() {
        return this.gpxLayer;
    }

    @Override
    public void jumpToNextMarker() {
        this.showNextPhoto();
    }

    @Override
    public void jumpToPreviousMarker() {
        this.showPreviousPhoto();
    }

    public boolean isUseThumbs() {
        return this.useThumbs;
    }

    public void setUseThumbs(boolean useThumbs) {
        this.useThumbs = useThumbs;
        if (useThumbs && !this.thumbsLoaded) {
            this.startLoadThumbs();
        } else if (!useThumbs) {
            this.stopLoadThumbs();
        }
    }

    private static final class Loader
    extends PleaseWaitRunnable {
        private boolean canceled = false;
        private GeoImageLayer layer;
        private Collection<File> selection;
        private Set<String> loadedDirectories = new HashSet<String>();
        private Set<String> errorMessages;
        private GpxLayer gpxLayer;

        protected void rememberError(String message) {
            this.errorMessages.add(message);
        }

        public Loader(Collection<File> selection, GpxLayer gpxLayer) {
            super(I18n.tr("Extracting GPS locations from EXIF", new Object[0]));
            this.selection = selection;
            this.gpxLayer = gpxLayer;
            this.errorMessages = new LinkedHashSet<String>();
        }

        @Override
        protected void realRun() throws IOException {
            this.progressMonitor.subTask(I18n.tr("Starting directory scan", new Object[0]));
            ArrayList<File> files = new ArrayList<File>();
            try {
                this.addRecursiveFiles(files, this.selection);
            }
            catch (IllegalStateException e) {
                this.rememberError(e.getMessage());
            }
            if (this.canceled) {
                return;
            }
            this.progressMonitor.subTask(I18n.tr("Read photos...", new Object[0]));
            this.progressMonitor.setTicksCount(files.size());
            this.progressMonitor.subTask(I18n.tr("Read photos...", new Object[0]));
            this.progressMonitor.setTicksCount(files.size());
            ArrayList<ImageEntry> data = new ArrayList<ImageEntry>(files.size());
            for (File f : files) {
                if (this.canceled) break;
                this.progressMonitor.subTask(I18n.tr("Reading {0}...", f.getName()));
                this.progressMonitor.worked(1);
                ImageEntry e = new ImageEntry();
                try {
                    e.setExifTime(ExifReader.readTime(f));
                }
                catch (ParseException ex) {
                    e.setExifTime(null);
                }
                e.setFile(f);
                GeoImageLayer.extractExif(e);
                data.add(e);
            }
            this.layer = new GeoImageLayer(data, this.gpxLayer);
            files.clear();
        }

        private void addRecursiveFiles(Collection<File> files, Collection<File> sel) {
            boolean nullFile = false;
            for (File f : sel) {
                if (this.canceled) break;
                if (f == null) {
                    nullFile = true;
                    continue;
                }
                if (f.isDirectory()) {
                    String canonical = null;
                    try {
                        canonical = f.getCanonicalPath();
                    }
                    catch (IOException e) {
                        Main.error(e);
                        this.rememberError(I18n.tr("Unable to get canonical path for directory {0}\n", f.getAbsolutePath()));
                    }
                    if (canonical == null || this.loadedDirectories.contains(canonical)) continue;
                    this.loadedDirectories.add(canonical);
                    File[] children = f.listFiles(JpegFileFilter.getInstance());
                    if (children != null) {
                        this.progressMonitor.subTask(I18n.tr("Scanning directory {0}", f.getPath()));
                        this.addRecursiveFiles(files, Arrays.asList(children));
                        continue;
                    }
                    this.rememberError(I18n.tr("Error while getting files from directory {0}\n", f.getPath()));
                    continue;
                }
                files.add(f);
            }
            if (nullFile) {
                throw new IllegalStateException(I18n.tr("One of the selected files was null", new Object[0]));
            }
        }

        protected String formatErrorMessages() {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            if (this.errorMessages.size() == 1) {
                sb.append(this.errorMessages.iterator().next());
            } else {
                sb.append(Utils.joinAsHtmlUnorderedList(this.errorMessages));
            }
            sb.append("</html>");
            return sb.toString();
        }

        @Override
        protected void finish() {
            if (!this.errorMessages.isEmpty()) {
                JOptionPane.showMessageDialog(Main.parent, this.formatErrorMessages(), I18n.tr("Error", new Object[0]), 0);
            }
            if (this.layer != null) {
                Main.main.addLayer(this.layer);
                if (!this.canceled && !this.layer.data.isEmpty()) {
                    boolean noGeotagFound = true;
                    for (ImageEntry e : this.layer.data) {
                        if (e.getPos() == null) continue;
                        noGeotagFound = false;
                    }
                    if (noGeotagFound) {
                        new CorrelateGpxWithImages(this.layer).actionPerformed(null);
                    }
                }
            }
        }

        @Override
        protected void cancel() {
            this.canceled = true;
        }
    }
}

