/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageDisplay;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.gui.layer.geoimage.JpegFileFilter;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.tools.ExifReader;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.date.DateUtils;
import org.openstreetmap.josm.tools.date.PrimaryDateParser;
import org.xml.sax.SAXException;

public class CorrelateGpxWithImages
extends AbstractAction {
    private static List<GpxData> loadedGpxData = new ArrayList<GpxData>();
    GeoImageLayer yLayer = null;
    double timezone;
    long delta;
    ExtendedDialog syncDialog;
    List<GpxDataWrapper> gpxLst = new ArrayList<GpxDataWrapper>();
    JPanel outerPanel;
    JosmComboBox<GpxDataWrapper> cbGpx;
    JosmTextField tfTimezone;
    JosmTextField tfOffset;
    JCheckBox cbExifImg;
    JCheckBox cbTaggedImg;
    JCheckBox cbShowThumbs;
    JLabel statusBarText;
    int lastNumMatched = 0;
    StatusBarUpdater statusBarUpdater = new StatusBarUpdater(false);
    StatusBarUpdater statusBarUpdaterWithRepaint = new StatusBarUpdater(true);
    RepaintTheMapListener repaintTheMap = new RepaintTheMapListener();

    public CorrelateGpxWithImages(GeoImageLayer layer) {
        super(I18n.tr("Correlate to GPX", new Object[0]), ImageProvider.get("dialogs/geoimage/gpx2img"));
        this.yLayer = layer;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Collection<Layer> layerLst = Main.map.mapView.getAllLayers();
        GpxDataWrapper defaultItem = null;
        for (Layer cur : layerLst) {
            if (!(cur instanceof GpxLayer)) continue;
            GpxLayer curGpx = (GpxLayer)cur;
            GpxDataWrapper gdw = new GpxDataWrapper(curGpx.getName(), curGpx.data, curGpx.data.storageFile);
            this.gpxLst.add(gdw);
            if (cur != this.yLayer.gpxLayer) continue;
            defaultItem = gdw;
        }
        for (GpxData data : loadedGpxData) {
            this.gpxLst.add(new GpxDataWrapper(data.storageFile.getName(), data, data.storageFile));
        }
        if (this.gpxLst.isEmpty()) {
            this.gpxLst.add(new GpxDataWrapper(I18n.tr("<No GPX track loaded yet>", new Object[0]), null, null));
        }
        JPanel panelCb = new JPanel();
        panelCb.add(new JLabel(I18n.tr("GPX track: ", new Object[0])));
        this.cbGpx = new JosmComboBox<GpxDataWrapper>(this.gpxLst.toArray(new GpxDataWrapper[0]));
        if (defaultItem != null) {
            this.cbGpx.setSelectedItem(defaultItem);
        }
        this.cbGpx.addActionListener(this.statusBarUpdaterWithRepaint);
        panelCb.add(this.cbGpx);
        JButton buttonOpen = new JButton(I18n.tr("Open another GPX trace", new Object[0]));
        buttonOpen.addActionListener(new LoadGpxDataActionListener());
        panelCb.add(buttonOpen);
        JPanel panelTf = new JPanel();
        panelTf.setLayout(new GridBagLayout());
        String prefTimezone = Main.pref.get("geoimage.timezone", "0:00");
        if (prefTimezone == null) {
            prefTimezone = "0:00";
        }
        try {
            this.timezone = this.parseTimezone(prefTimezone);
        }
        catch (ParseException e) {
            this.timezone = 0.0;
        }
        this.tfTimezone = new JosmTextField(10);
        this.tfTimezone.setText(this.formatTimezone(this.timezone));
        try {
            this.delta = this.parseOffset(Main.pref.get("geoimage.delta", "0"));
        }
        catch (ParseException e) {
            this.delta = 0L;
        }
        this.delta /= 1000L;
        this.tfOffset = new JosmTextField(10);
        this.tfOffset.setText(Long.toString(this.delta));
        JButton buttonViewGpsPhoto = new JButton(I18n.tr("<html>Use photo of an accurate clock,<br>e.g. GPS receiver display</html>", new Object[0]));
        buttonViewGpsPhoto.setIcon(ImageProvider.get("clock"));
        buttonViewGpsPhoto.addActionListener(new SetOffsetActionListener());
        JButton buttonAutoGuess = new JButton(I18n.tr("Auto-Guess", new Object[0]));
        buttonAutoGuess.setToolTipText(I18n.tr("Matches first photo with first gpx point", new Object[0]));
        buttonAutoGuess.addActionListener(new AutoGuessActionListener());
        JButton buttonAdjust = new JButton(I18n.tr("Manual adjust", new Object[0]));
        buttonAdjust.addActionListener(new AdjustActionListener());
        JLabel labelPosition = new JLabel(I18n.tr("Override position for: ", new Object[0]));
        int numAll = this.getSortedImgList(true, true).size();
        int numExif = numAll - this.getSortedImgList(false, true).size();
        int numTagged = numAll - this.getSortedImgList(true, false).size();
        this.cbExifImg = new JCheckBox(I18n.tr("Images with geo location in exif data ({0}/{1})", numExif, numAll));
        this.cbExifImg.setEnabled(numExif != 0);
        this.cbTaggedImg = new JCheckBox(I18n.tr("Images that are already tagged ({0}/{1})", numTagged, numAll), true);
        this.cbTaggedImg.setEnabled(numTagged != 0);
        labelPosition.setEnabled(this.cbExifImg.isEnabled() || this.cbTaggedImg.isEnabled());
        boolean ticked = this.yLayer.thumbsLoaded || Main.pref.getBoolean("geoimage.showThumbs", false);
        this.cbShowThumbs = new JCheckBox(I18n.tr("Show Thumbnail images on the map", new Object[0]), ticked);
        this.cbShowThumbs.setEnabled(!this.yLayer.thumbsLoaded);
        int y = 0;
        GBC gbc = GBC.eol();
        gbc.gridx = 0;
        gbc.gridy = y++;
        panelTf.add((Component)panelCb, gbc);
        gbc = GBC.eol().fill(2).insets(0, 0, 0, 12);
        gbc.gridx = 0;
        gbc.gridy = y++;
        panelTf.add((Component)new JSeparator(0), gbc);
        gbc = GBC.std();
        gbc.gridx = 0;
        gbc.gridy = y;
        panelTf.add((Component)new JLabel(I18n.tr("Timezone: ", new Object[0])), gbc);
        gbc = GBC.std().fill(2);
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.weightx = 1.0;
        panelTf.add((Component)this.tfTimezone, gbc);
        gbc = GBC.std();
        gbc.gridx = 0;
        gbc.gridy = y;
        panelTf.add((Component)new JLabel(I18n.tr("Offset:", new Object[0])), gbc);
        gbc = GBC.std().fill(2);
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.weightx = 1.0;
        panelTf.add((Component)this.tfOffset, gbc);
        gbc = GBC.std().insets(5, 5, 5, 5);
        gbc.gridx = 2;
        gbc.gridy = y - 2;
        gbc.gridheight = 2;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.weightx = 0.5;
        panelTf.add((Component)buttonViewGpsPhoto, gbc);
        gbc = GBC.std().fill(1).insets(5, 5, 5, 5);
        gbc.gridx = 2;
        gbc.gridy = y++;
        gbc.weightx = 0.5;
        panelTf.add((Component)buttonAutoGuess, gbc);
        gbc.gridx = 3;
        panelTf.add((Component)buttonAdjust, gbc);
        gbc = GBC.eol().fill(2).insets(0, 12, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = y++;
        panelTf.add((Component)new JSeparator(0), gbc);
        gbc = GBC.eol();
        gbc.gridx = 0;
        gbc.gridy = y++;
        panelTf.add((Component)labelPosition, gbc);
        gbc = GBC.eol();
        gbc.gridx = 1;
        gbc.gridy = y++;
        panelTf.add((Component)this.cbExifImg, gbc);
        gbc = GBC.eol();
        gbc.gridx = 1;
        gbc.gridy = y++;
        panelTf.add((Component)this.cbTaggedImg, gbc);
        gbc = GBC.eol();
        gbc.gridx = 0;
        gbc.gridy = y++;
        panelTf.add((Component)this.cbShowThumbs, gbc);
        JPanel statusBar = new JPanel();
        statusBar.setLayout(new FlowLayout(0, 0, 0));
        statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusBarText = new JLabel(" ");
        this.statusBarText.setFont(this.statusBarText.getFont().deriveFont(8));
        statusBar.add(this.statusBarText);
        this.tfTimezone.addFocusListener(this.repaintTheMap);
        this.tfOffset.addFocusListener(this.repaintTheMap);
        this.tfTimezone.getDocument().addDocumentListener(this.statusBarUpdater);
        this.tfOffset.getDocument().addDocumentListener(this.statusBarUpdater);
        this.cbExifImg.addItemListener(this.statusBarUpdaterWithRepaint);
        this.cbTaggedImg.addItemListener(this.statusBarUpdaterWithRepaint);
        this.statusBarUpdater.updateStatusBar();
        this.outerPanel = new JPanel();
        this.outerPanel.setLayout(new BorderLayout());
        this.outerPanel.add((Component)statusBar, "Last");
        this.syncDialog = new ExtendedDialog(Main.parent, I18n.tr("Correlate images with GPX track", new Object[0]), new String[]{I18n.tr("Correlate", new Object[0]), I18n.tr("Cancel", new Object[0])}, false);
        this.syncDialog.setContent(panelTf, false);
        this.syncDialog.setButtonIcons(new String[]{"ok", "cancel"});
        this.syncDialog.setupDialog();
        this.outerPanel.add((Component)this.syncDialog.getContentPane(), "First");
        this.syncDialog.setContentPane(this.outerPanel);
        this.syncDialog.pack();
        this.syncDialog.addWindowListener(new WindowAdapter(){

            private int checkAndSave() {
                if (CorrelateGpxWithImages.this.syncDialog.isVisible()) {
                    return 2;
                }
                int answer = CorrelateGpxWithImages.this.syncDialog.getValue();
                if (answer != 1) {
                    return -1;
                }
                try {
                    CorrelateGpxWithImages.this.timezone = CorrelateGpxWithImages.this.parseTimezone(CorrelateGpxWithImages.this.tfTimezone.getText().trim());
                }
                catch (ParseException e) {
                    JOptionPane.showMessageDialog(Main.parent, e.getMessage(), I18n.tr("Invalid timezone", new Object[0]), 0);
                    return 1;
                }
                try {
                    CorrelateGpxWithImages.this.delta = CorrelateGpxWithImages.this.parseOffset(CorrelateGpxWithImages.this.tfOffset.getText().trim());
                }
                catch (ParseException e) {
                    JOptionPane.showMessageDialog(Main.parent, e.getMessage(), I18n.tr("Invalid offset", new Object[0]), 0);
                    return 1;
                }
                if (CorrelateGpxWithImages.this.lastNumMatched == 0 && new ExtendedDialog(Main.parent, I18n.tr("Correlate images with GPX track", new Object[0]), new String[]{I18n.tr("OK", new Object[0]), I18n.tr("Try Again", new Object[0])}).setContent(I18n.tr("No images could be matched!", new Object[0])).setButtonIcons(new String[]{"ok", "dialogs/refresh"}).showDialog().getValue() == 2) {
                    return 1;
                }
                return 0;
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                int result = this.checkAndSave();
                switch (result) {
                    case 2: {
                        break;
                    }
                    case -1: {
                        if (CorrelateGpxWithImages.this.yLayer == null) break;
                        for (ImageEntry ie : CorrelateGpxWithImages.this.yLayer.data) {
                            ie.tmp = null;
                        }
                        CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
                        break;
                    }
                    case 1: {
                        CorrelateGpxWithImages.this.actionPerformed(null);
                        break;
                    }
                    case 0: {
                        Main.pref.put("geoimage.timezone", CorrelateGpxWithImages.this.formatTimezone(CorrelateGpxWithImages.this.timezone));
                        Main.pref.put("geoimage.delta", Long.toString(CorrelateGpxWithImages.this.delta * 1000L));
                        Main.pref.put("geoimage.showThumbs", CorrelateGpxWithImages.this.yLayer.useThumbs);
                        CorrelateGpxWithImages.this.yLayer.useThumbs = CorrelateGpxWithImages.this.cbShowThumbs.isSelected();
                        CorrelateGpxWithImages.this.yLayer.startLoadThumbs();
                        boolean boundingBoxedLayerFound = false;
                        for (Layer l : Main.map.mapView.getAllLayers()) {
                            if (l == CorrelateGpxWithImages.this.yLayer) continue;
                            BoundingXYVisitor bbox = new BoundingXYVisitor();
                            l.visitBoundingBox(bbox);
                            if (bbox.getBounds() == null) continue;
                            boundingBoxedLayerFound = true;
                            break;
                        }
                        if (!boundingBoxedLayerFound) {
                            BoundingXYVisitor bbox = new BoundingXYVisitor();
                            CorrelateGpxWithImages.this.yLayer.visitBoundingBox(bbox);
                            Main.map.mapView.zoomTo(bbox);
                        }
                        for (ImageEntry ie : CorrelateGpxWithImages.this.yLayer.data) {
                            ie.applyTmp();
                        }
                        CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        });
        this.syncDialog.showDialog();
    }

    private List<ImageEntry> getSortedImgList() {
        return this.getSortedImgList(this.cbExifImg.isSelected(), this.cbTaggedImg.isSelected());
    }

    private List<ImageEntry> getSortedImgList(boolean exif, boolean tagged) {
        ArrayList<ImageEntry> dateImgLst = new ArrayList<ImageEntry>(this.yLayer.data.size());
        for (ImageEntry e : this.yLayer.data) {
            if (!e.hasExifTime() || e.getExifCoor() != null && !exif || e.isTagged() && e.getExifCoor() == null && !tagged) continue;
            dateImgLst.add(e);
        }
        Collections.sort(dateImgLst, new Comparator<ImageEntry>(){

            @Override
            public int compare(ImageEntry arg0, ImageEntry arg1) {
                return arg0.getExifTime().compareTo(arg1.getExifTime());
            }
        });
        return dateImgLst;
    }

    private GpxDataWrapper selectedGPX(boolean complain) {
        Object item = this.cbGpx.getSelectedItem();
        if (item == null || ((GpxDataWrapper)item).file == null) {
            if (complain) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("You should select a GPX track", new Object[0]), I18n.tr("No selected GPX track", new Object[0]), 0);
            }
            return null;
        }
        return (GpxDataWrapper)item;
    }

    private int matchGpxTrack(List<ImageEntry> images, GpxData selectedGpx, long offset) {
        int ret = 0;
        PrimaryDateParser dateParser = new PrimaryDateParser();
        for (GpxTrack trk : selectedGpx.tracks) {
            for (GpxTrackSegment segment : trk.getSegments()) {
                long prevWpTime = 0L;
                WayPoint prevWp = null;
                for (WayPoint curWp : segment.getWayPoints()) {
                    String curWpTimeStr = curWp.getString("time");
                    if (curWpTimeStr != null) {
                        try {
                            long curWpTime = dateParser.parse(curWpTimeStr).getTime() + offset;
                            ret += this.matchPoints(images, prevWp, prevWpTime, curWp, curWpTime, offset);
                            prevWp = curWp;
                            prevWpTime = curWpTime;
                        }
                        catch (ParseException e) {
                            Main.error("Error while parsing date \"" + curWpTimeStr + '\"');
                            Main.error(e);
                            prevWp = null;
                            prevWpTime = 0L;
                        }
                        continue;
                    }
                    prevWp = null;
                    prevWpTime = 0L;
                }
            }
        }
        return ret;
    }

    private static Double getElevation(WayPoint wp) {
        String value = wp.getString("ele");
        if (value != null) {
            try {
                return new Double(value);
            }
            catch (NumberFormatException e) {
                Main.warn(e);
            }
        }
        return null;
    }

    private int matchPoints(List<ImageEntry> images, WayPoint prevWp, long prevWpTime, WayPoint curWp, long curWpTime, long offset) {
        ImageEntry curImg;
        long imgTime;
        long interval = prevWpTime > 0L ? Math.abs(curWpTime - prevWpTime) : 5000L;
        int ret = 0;
        int i = this.getLastIndexOfListBefore(images, curWpTime);
        if (i < 0) {
            return 0;
        }
        Double speed = null;
        Double prevElevation = null;
        if (prevWp != null) {
            double distance = prevWp.getCoor().greatCircleDistance(curWp.getCoor());
            if (curWpTime > prevWpTime) {
                speed = 3600.0 * distance / (double)(curWpTime - prevWpTime);
            }
            prevElevation = CorrelateGpxWithImages.getElevation(prevWp);
        }
        Double curElevation = CorrelateGpxWithImages.getElevation(curWp);
        if (prevWpTime == 0L || curWpTime <= prevWpTime) {
            ImageEntry curImg2;
            long time;
            while (i >= 0 && (time = (curImg2 = images.get(i)).getExifTime().getTime()) <= curWpTime && time >= curWpTime - interval) {
                if (curImg2.tmp.getPos() == null) {
                    curImg2.tmp.setPos(curWp.getCoor());
                    curImg2.tmp.setSpeed(speed);
                    curImg2.tmp.setElevation(curElevation);
                    curImg2.tmp.setGpsTime(new Date(curImg2.getExifTime().getTime() - offset));
                    curImg2.flagNewGpsData();
                    ++ret;
                }
                --i;
            }
            return ret;
        }
        while (i >= 0 && (imgTime = (curImg = images.get(i)).getExifTime().getTime()) >= prevWpTime) {
            if (curImg.tmp.getPos() == null && prevWp != null) {
                double timeDiff = (double)(imgTime - prevWpTime) / (double)interval;
                curImg.tmp.setPos(prevWp.getCoor().interpolate(curWp.getCoor(), timeDiff));
                curImg.tmp.setSpeed(speed);
                if (curElevation != null && prevElevation != null) {
                    curImg.tmp.setElevation(prevElevation + (curElevation - prevElevation) * timeDiff);
                }
                curImg.tmp.setGpsTime(new Date(curImg.getExifTime().getTime() - offset));
                curImg.flagNewGpsData();
                ++ret;
            }
            --i;
        }
        return ret;
    }

    private int getLastIndexOfListBefore(List<ImageEntry> images, long searchedTime) {
        int lstSize = images.size();
        if (lstSize == 0 || searchedTime < images.get(0).getExifTime().getTime()) {
            return -1;
        }
        if (searchedTime > images.get(lstSize - 1).getExifTime().getTime()) {
            return lstSize - 1;
        }
        int curIndex = 0;
        int startIndex = 0;
        int endIndex = lstSize - 1;
        while (endIndex - startIndex > 1) {
            curIndex = (endIndex + startIndex) / 2;
            if (searchedTime > images.get(curIndex).getExifTime().getTime()) {
                startIndex = curIndex;
                continue;
            }
            endIndex = curIndex;
        }
        if (searchedTime < images.get(endIndex).getExifTime().getTime()) {
            return startIndex;
        }
        while (endIndex < lstSize - 1 && images.get(endIndex).getExifTime().getTime() == images.get(endIndex + 1).getExifTime().getTime()) {
            ++endIndex;
        }
        return endIndex;
    }

    private String formatTimezone(double timezone) {
        StringBuilder ret = new StringBuilder();
        if (timezone < 0.0) {
            ret.append('-');
            timezone = -timezone;
        } else {
            ret.append('+');
        }
        ret.append((long)timezone).append(':');
        int minutes = (int)(timezone % 1.0 * 60.0);
        if (minutes < 10) {
            ret.append('0');
        }
        ret.append(minutes);
        return ret.toString();
    }

    private double parseTimezone(String timezone) throws ParseException {
        String error = I18n.tr("Error while parsing timezone.\nExpected format: {0}", "+H:MM");
        if (timezone.length() == 0) {
            return 0.0;
        }
        int sgnTimezone = 43;
        StringBuilder hTimezone = new StringBuilder();
        StringBuilder mTimezone = new StringBuilder();
        int state = 1;
        block12: for (int i = 0; i < timezone.length(); ++i) {
            char c = timezone.charAt(i);
            switch (c) {
                case ' ': {
                    if (state == 2 && hTimezone.length() == 0) continue block12;
                    throw new ParseException(error, 0);
                }
                case '+': 
                case '-': {
                    if (state == 1) {
                        sgnTimezone = c;
                        state = 2;
                        continue block12;
                    }
                    throw new ParseException(error, 0);
                }
                case '.': 
                case ':': {
                    if (state == 2) {
                        state = 3;
                        continue block12;
                    }
                    throw new ParseException(error, 0);
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    switch (state) {
                        case 1: 
                        case 2: {
                            state = 2;
                            hTimezone.append(c);
                            continue block12;
                        }
                        case 3: {
                            mTimezone.append(c);
                            continue block12;
                        }
                    }
                    throw new ParseException(error, 0);
                }
                default: {
                    throw new ParseException(error, 0);
                }
            }
        }
        int h = 0;
        int m = 0;
        try {
            h = Integer.parseInt(hTimezone.toString());
            if (mTimezone.length() > 0) {
                m = Integer.parseInt(mTimezone.toString());
            }
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(error, 0);
        }
        if (h > 12 || m > 59) {
            throw new ParseException(error, 0);
        }
        return ((double)h + (double)m / 60.0) * (double)(sgnTimezone == 45 ? -1 : 1);
    }

    private long parseOffset(String offset) throws ParseException {
        String error = I18n.tr("Error while parsing offset.\nExpected format: {0}", "number");
        if (offset.length() > 0) {
            try {
                if (offset.startsWith("+")) {
                    offset = offset.substring(1);
                }
                return Long.parseLong(offset);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException(error, 0);
            }
        }
        return 0L;
    }

    private class AutoGuessActionListener
    implements ActionListener {
        private AutoGuessActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GpxDataWrapper gpxW = CorrelateGpxWithImages.this.selectedGPX(true);
            if (gpxW == null) {
                return;
            }
            GpxData gpx = gpxW.data;
            List imgs = CorrelateGpxWithImages.this.getSortedImgList();
            PrimaryDateParser dateParser = new PrimaryDateParser();
            if (imgs.size() <= 0) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("The selected photos do not contain time information.", new Object[0]), I18n.tr("Photos do not contain time information", new Object[0]), 2);
                return;
            }
            long firstExifDate = ((ImageEntry)imgs.get(0)).getExifTime().getTime() / 1000L;
            long firstGPXDate = -1L;
            block2: for (GpxTrack trk : gpx.tracks) {
                for (GpxTrackSegment segment : trk.getSegments()) {
                    for (WayPoint curWp : segment.getWayPoints()) {
                        String curDateWpStr = curWp.getString("time");
                        if (curDateWpStr == null) continue;
                        try {
                            firstGPXDate = dateParser.parse(curDateWpStr).getTime() / 1000L;
                            break block2;
                        }
                        catch (Exception e) {
                            Main.warn(e);
                        }
                    }
                }
            }
            if (firstGPXDate < 0L) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("The selected GPX track does not contain timestamps. Please select another one.", new Object[0]), I18n.tr("GPX Track has no time information", new Object[0]), 2);
                return;
            }
            long diff = firstExifDate - firstGPXDate;
            double diffInH = (double)diff / 3600.0;
            int dayOffset = (int)Math.round(diffInH / 24.0);
            double tz = diff - (long)(dayOffset * 24 * 60) * 60L;
            tz = (double)Math.round(tz * 100.0 / 3600.0) / 100.0;
            CorrelateGpxWithImages.this.timezone = (double)Math.round(tz * 2.0) / 2.0;
            CorrelateGpxWithImages.this.delta = Math.round((double)diff - CorrelateGpxWithImages.this.timezone * 60.0 * 60.0);
            CorrelateGpxWithImages.this.tfTimezone.getDocument().removeDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
            CorrelateGpxWithImages.this.tfOffset.getDocument().removeDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
            CorrelateGpxWithImages.this.tfTimezone.setText(CorrelateGpxWithImages.this.formatTimezone(CorrelateGpxWithImages.this.timezone));
            CorrelateGpxWithImages.this.tfOffset.setText(Long.toString(CorrelateGpxWithImages.this.delta));
            CorrelateGpxWithImages.this.tfOffset.requestFocus();
            CorrelateGpxWithImages.this.tfTimezone.getDocument().addDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
            CorrelateGpxWithImages.this.tfOffset.getDocument().addDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
            CorrelateGpxWithImages.this.statusBarUpdater.updateStatusBar();
            CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
        }
    }

    private class AdjustActionListener
    implements ActionListener {
        private AdjustActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            long diff = CorrelateGpxWithImages.this.delta + Math.round(CorrelateGpxWithImages.this.timezone * 60.0 * 60.0);
            double diffInH = (double)diff / 3600.0;
            final int dayOffset = (int)Math.round(diffInH / 24.0);
            double tmz = diff - (long)(dayOffset * 24 * 60) * 60L;
            tmz = (double)Math.round(tmz * 100.0 / 3600.0) / 100.0;
            double fixTimezone = (double)Math.round(tmz * 2.0) / 2.0;
            int offset = (int)Math.round((double)diff - fixTimezone * 60.0 * 60.0) - dayOffset * 24 * 60 * 60;
            final JLabel lblMatches = new JLabel();
            final JLabel lblTimezone = new JLabel();
            final JSlider sldTimezone = new JSlider(-24, 24, 0);
            sldTimezone.setPaintLabels(true);
            Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
            ((Dictionary)labelTable).put(-24, new JLabel("-12:00"));
            ((Dictionary)labelTable).put(-12, new JLabel("-6:00"));
            ((Dictionary)labelTable).put(0, new JLabel("0:00"));
            ((Dictionary)labelTable).put(12, new JLabel("6:00"));
            ((Dictionary)labelTable).put(24, new JLabel("12:00"));
            sldTimezone.setLabelTable(labelTable);
            final JLabel lblMinutes = new JLabel();
            final JSlider sldMinutes = new JSlider(-15, 15, 0);
            sldMinutes.setPaintLabels(true);
            sldMinutes.setMajorTickSpacing(5);
            final JLabel lblSeconds = new JLabel();
            final JSlider sldSeconds = new JSlider(-60, 60, 0);
            sldSeconds.setPaintLabels(true);
            sldSeconds.setMajorTickSpacing(30);
            JPanel p = new JPanel(new GridBagLayout());
            p.setPreferredSize(new Dimension(400, 230));
            p.add((Component)lblMatches, GBC.eol().fill());
            p.add((Component)lblTimezone, GBC.eol().fill());
            p.add((Component)sldTimezone, GBC.eol().fill().insets(0, 0, 0, 10));
            p.add((Component)lblMinutes, GBC.eol().fill());
            p.add((Component)sldMinutes, GBC.eol().fill().insets(0, 0, 0, 10));
            p.add((Component)lblSeconds, GBC.eol().fill());
            p.add((Component)sldSeconds, GBC.eol().fill());
            try {
                sldTimezone.setValue((int)(fixTimezone * 2.0));
                sldMinutes.setValue(offset / 60);
                sldSeconds.setValue(offset % 60);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("An error occurred while trying to match the photos to the GPX track. You can adjust the sliders to manually match the photos.", new Object[0]), I18n.tr("Matching photos to track failed", new Object[0]), 2);
            }
            class SliderListener
            implements ChangeListener {
                SliderListener() {
                }

                @Override
                public void stateChanged(ChangeEvent e) {
                    String zone;
                    double tz = Math.abs(sldTimezone.getValue());
                    String string = zone = tz % 2.0 == 0.0 ? (int)Math.floor(tz / 2.0) + ":00" : (int)Math.floor(tz / 2.0) + ":30";
                    if (sldTimezone.getValue() < 0) {
                        zone = "-" + zone;
                    }
                    lblTimezone.setText(I18n.tr("Timezone: {0}", zone));
                    lblMinutes.setText(I18n.tr("Minutes: {0}", sldMinutes.getValue()));
                    lblSeconds.setText(I18n.tr("Seconds: {0}", sldSeconds.getValue()));
                    try {
                        CorrelateGpxWithImages.this.timezone = CorrelateGpxWithImages.this.parseTimezone(zone);
                    }
                    catch (ParseException pe) {
                        throw new RuntimeException(pe);
                    }
                    CorrelateGpxWithImages.this.delta = sldMinutes.getValue() * 60 + sldSeconds.getValue();
                    CorrelateGpxWithImages.this.tfTimezone.getDocument().removeDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
                    CorrelateGpxWithImages.this.tfOffset.getDocument().removeDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
                    CorrelateGpxWithImages.this.tfTimezone.setText(CorrelateGpxWithImages.this.formatTimezone(CorrelateGpxWithImages.this.timezone));
                    CorrelateGpxWithImages.this.tfOffset.setText(Long.toString(CorrelateGpxWithImages.this.delta + 86400L * (long)dayOffset));
                    CorrelateGpxWithImages.this.tfTimezone.getDocument().addDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
                    CorrelateGpxWithImages.this.tfOffset.getDocument().addDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
                    lblMatches.setText(CorrelateGpxWithImages.this.statusBarText.getText() + "<br>" + I18n.trn("(Time difference of {0} day)", "Time difference of {0} days", Math.abs(dayOffset), Math.abs(dayOffset)));
                    CorrelateGpxWithImages.this.statusBarUpdater.updateStatusBar();
                    CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
                }
            }
            new SliderListener().stateChanged(null);
            sldTimezone.addChangeListener(new SliderListener());
            sldMinutes.addChangeListener(new SliderListener());
            sldSeconds.addChangeListener(new SliderListener());
            new ExtendedDialog(Main.parent, I18n.tr("Adjust timezone and offset", new Object[0]), new String[]{I18n.tr("Close", new Object[0])}).setContent(p).setButtonIcons(new String[]{"ok"}).showDialog();
        }
    }

    private class RepaintTheMapListener
    implements FocusListener {
        private RepaintTheMapListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
        }
    }

    private class StatusBarUpdater
    implements ActionListener,
    ItemListener,
    DocumentListener {
        private boolean doRepaint;

        public StatusBarUpdater(boolean doRepaint) {
            this.doRepaint = doRepaint;
        }

        @Override
        public void insertUpdate(DocumentEvent ev) {
            this.updateStatusBar();
        }

        @Override
        public void removeUpdate(DocumentEvent ev) {
            this.updateStatusBar();
        }

        @Override
        public void changedUpdate(DocumentEvent ev) {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.updateStatusBar();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.updateStatusBar();
        }

        public void updateStatusBar() {
            CorrelateGpxWithImages.this.statusBarText.setText(this.statusText());
            if (this.doRepaint) {
                CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
            }
        }

        private String statusText() {
            try {
                CorrelateGpxWithImages.this.timezone = CorrelateGpxWithImages.this.parseTimezone(CorrelateGpxWithImages.this.tfTimezone.getText().trim());
                CorrelateGpxWithImages.this.delta = CorrelateGpxWithImages.this.parseOffset(CorrelateGpxWithImages.this.tfOffset.getText().trim());
            }
            catch (ParseException e) {
                return e.getMessage();
            }
            for (ImageEntry ie : CorrelateGpxWithImages.this.yLayer.data) {
                ie.tmp = null;
            }
            List dateImgLst = CorrelateGpxWithImages.this.getSortedImgList();
            for (ImageEntry ie : dateImgLst) {
                ie.cleanTmp();
            }
            GpxDataWrapper selGpx = CorrelateGpxWithImages.this.selectedGPX(false);
            if (selGpx == null) {
                return I18n.tr("No gpx selected", new Object[0]);
            }
            long offset_ms = ((long)(CorrelateGpxWithImages.this.timezone * 3600.0) + CorrelateGpxWithImages.this.delta) * 1000L;
            CorrelateGpxWithImages.this.lastNumMatched = CorrelateGpxWithImages.this.matchGpxTrack(dateImgLst, selGpx.data, offset_ms);
            return I18n.trn("<html>Matched <b>{0}</b> of <b>{1}</b> photo to GPX track.</html>", "<html>Matched <b>{0}</b> of <b>{1}</b> photos to GPX track.</html>", dateImgLst.size(), CorrelateGpxWithImages.this.lastNumMatched, dateImgLst.size());
        }
    }

    private class SetOffsetActionListener
    implements ActionListener {
        JPanel panel;
        JLabel lbExifTime;
        JosmTextField tfGpsTime;
        JosmComboBox<String> cbTimezones;
        ImageDisplay imgDisp;
        JList<String> imgList;

        private SetOffsetActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            SimpleDateFormat dateFormat = (SimpleDateFormat)DateUtils.getDateTimeFormat(3, 2);
            this.panel = new JPanel();
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)new JLabel(I18n.tr("<html>Take a photo of your GPS receiver while it displays the time.<br>Display that photo here.<br>And then, simply capture the time you read on the photo and select a timezone<hr></html>", new Object[0])), "North");
            this.imgDisp = new ImageDisplay();
            this.imgDisp.setPreferredSize(new Dimension(300, 225));
            this.panel.add((Component)this.imgDisp, "Center");
            JPanel panelTf = new JPanel();
            panelTf.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridy = 0;
            gc.gridx = 0;
            gc.gridheight = 1;
            gc.gridwidth = 1;
            gc.weighty = 0.0;
            gc.weightx = 0.0;
            gc.fill = 0;
            gc.anchor = 17;
            panelTf.add((Component)new JLabel(I18n.tr("Photo time (from exif):", new Object[0])), gc);
            this.lbExifTime = new JLabel();
            gc.gridx = 1;
            gc.weightx = 1.0;
            gc.fill = 2;
            gc.gridwidth = 2;
            panelTf.add((Component)this.lbExifTime, gc);
            gc.gridx = 0;
            gc.gridy = 1;
            gc.gridheight = 1;
            gc.gridwidth = 1;
            gc.weighty = 0.0;
            gc.weightx = 0.0;
            gc.fill = 0;
            gc.anchor = 17;
            panelTf.add((Component)new JLabel(I18n.tr("Gps time (read from the above photo): ", new Object[0])), gc);
            this.tfGpsTime = new JosmTextField(12);
            this.tfGpsTime.setEnabled(false);
            this.tfGpsTime.setMinimumSize(new Dimension(155, this.tfGpsTime.getMinimumSize().height));
            gc.gridx = 1;
            gc.weightx = 1.0;
            gc.fill = 2;
            panelTf.add((Component)this.tfGpsTime, gc);
            gc.gridx = 2;
            gc.weightx = 0.2;
            panelTf.add((Component)new JLabel(" [" + dateFormat.toLocalizedPattern() + "]"), gc);
            gc.gridx = 0;
            gc.gridy = 2;
            gc.gridheight = 1;
            gc.gridwidth = 1;
            gc.weighty = 0.0;
            gc.weightx = 0.0;
            gc.fill = 0;
            gc.anchor = 17;
            panelTf.add((Component)new JLabel(I18n.tr("I am in the timezone of: ", new Object[0])), gc);
            String[] tmp = TimeZone.getAvailableIDs();
            ArrayList<String> vtTimezones = new ArrayList<String>(tmp.length);
            for (String tzStr : tmp) {
                TimeZone tz = TimeZone.getTimeZone(tzStr);
                String tzDesc = tzStr + " (" + CorrelateGpxWithImages.this.formatTimezone((double)tz.getRawOffset() / 3600000.0) + ')';
                vtTimezones.add(tzDesc);
            }
            Collections.sort(vtTimezones);
            this.cbTimezones = new JosmComboBox<String>(vtTimezones.toArray(new String[0]));
            String tzId = Main.pref.get("geoimage.timezoneid", "");
            TimeZone defaultTz = tzId.length() == 0 ? TimeZone.getDefault() : TimeZone.getTimeZone(tzId);
            this.cbTimezones.setSelectedItem(defaultTz.getID() + " (" + CorrelateGpxWithImages.this.formatTimezone((double)defaultTz.getRawOffset() / 3600000.0) + ')');
            gc.gridx = 1;
            gc.weightx = 1.0;
            gc.gridwidth = 2;
            gc.fill = 2;
            panelTf.add(this.cbTimezones, gc);
            this.panel.add((Component)panelTf, "South");
            JPanel panelLst = new JPanel();
            panelLst.setLayout(new BorderLayout());
            this.imgList = new JList<String>(new AbstractListModel<String>(){

                @Override
                public String getElementAt(int i) {
                    return CorrelateGpxWithImages.this.yLayer.data.get(i).getFile().getName();
                }

                @Override
                public int getSize() {
                    return CorrelateGpxWithImages.this.yLayer.data.size();
                }
            });
            this.imgList.getSelectionModel().setSelectionMode(0);
            this.imgList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent arg0) {
                    int index = SetOffsetActionListener.this.imgList.getSelectedIndex();
                    Integer orientation = null;
                    try {
                        orientation = ExifReader.readOrientation(CorrelateGpxWithImages.this.yLayer.data.get(index).getFile());
                    }
                    catch (Exception e) {
                        Main.warn(e);
                    }
                    SetOffsetActionListener.this.imgDisp.setImage(CorrelateGpxWithImages.this.yLayer.data.get(index).getFile(), orientation);
                    Date date = CorrelateGpxWithImages.this.yLayer.data.get(index).getExifTime();
                    if (date != null) {
                        DateFormat df = DateUtils.getDateTimeFormat(3, 2);
                        SetOffsetActionListener.this.lbExifTime.setText(df.format(date));
                        SetOffsetActionListener.this.tfGpsTime.setText(df.format(date));
                        SetOffsetActionListener.this.tfGpsTime.setCaretPosition(SetOffsetActionListener.this.tfGpsTime.getText().length());
                        SetOffsetActionListener.this.tfGpsTime.setEnabled(true);
                        SetOffsetActionListener.this.tfGpsTime.requestFocus();
                    } else {
                        SetOffsetActionListener.this.lbExifTime.setText(I18n.tr("No date", new Object[0]));
                        SetOffsetActionListener.this.tfGpsTime.setText("");
                        SetOffsetActionListener.this.tfGpsTime.setEnabled(false);
                    }
                }
            });
            panelLst.add((Component)new JScrollPane(this.imgList), "Center");
            JButton openButton = new JButton(I18n.tr("Open another photo", new Object[0]));
            openButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    AbstractFileChooser fc = DiskAccessAction.createAndOpenFileChooser(true, false, null, JpegFileFilter.getInstance(), 0, "geoimage.lastdirectory");
                    if (fc == null) {
                        return;
                    }
                    File sel = fc.getSelectedFile();
                    Integer orientation = null;
                    try {
                        orientation = ExifReader.readOrientation(sel);
                    }
                    catch (Exception e) {
                        Main.warn(e);
                    }
                    SetOffsetActionListener.this.imgDisp.setImage(sel, orientation);
                    Date date = null;
                    try {
                        date = ExifReader.readTime(sel);
                    }
                    catch (Exception e) {
                        Main.warn(e);
                    }
                    if (date != null) {
                        SetOffsetActionListener.this.lbExifTime.setText(DateUtils.getDateTimeFormat(3, 2).format(date));
                        SetOffsetActionListener.this.tfGpsTime.setText(DateUtils.getDateFormat(3).format(date) + " ");
                        SetOffsetActionListener.this.tfGpsTime.setEnabled(true);
                    } else {
                        SetOffsetActionListener.this.lbExifTime.setText(I18n.tr("No date", new Object[0]));
                        SetOffsetActionListener.this.tfGpsTime.setText("");
                        SetOffsetActionListener.this.tfGpsTime.setEnabled(false);
                    }
                }
            });
            panelLst.add((Component)openButton, "Last");
            this.panel.add((Component)panelLst, "Before");
            boolean isOk = false;
            while (!isOk) {
                long delta;
                int answer = JOptionPane.showConfirmDialog(Main.parent, this.panel, I18n.tr("Synchronize time from a photo of the GPS receiver", new Object[0]), 2, 3);
                if (answer == 2) {
                    return;
                }
                try {
                    delta = dateFormat.parse(this.lbExifTime.getText()).getTime() - dateFormat.parse(this.tfGpsTime.getText()).getTime();
                }
                catch (ParseException e) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error while parsing the date.\nPlease use the requested format", new Object[0]), I18n.tr("Invalid date", new Object[0]), 0);
                    continue;
                }
                String selectedTz = (String)this.cbTimezones.getSelectedItem();
                int pos = selectedTz.lastIndexOf(40);
                tzId = selectedTz.substring(0, pos - 1);
                String tzValue = selectedTz.substring(pos + 1, selectedTz.length() - 1);
                Main.pref.put("geoimage.timezoneid", tzId);
                CorrelateGpxWithImages.this.tfOffset.setText(Long.toString(delta / 1000L));
                CorrelateGpxWithImages.this.tfTimezone.setText(tzValue);
                isOk = true;
            }
            CorrelateGpxWithImages.this.statusBarUpdater.updateStatusBar();
            CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
        }
    }

    private class LoadGpxDataActionListener
    implements ActionListener {
        private LoadGpxDataActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void actionPerformed(ActionEvent arg0) {
            block26: {
                FileFilter filter = new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase().endsWith(".gpx") || f.getName().toLowerCase().endsWith(".gpx.gz");
                    }

                    @Override
                    public String getDescription() {
                        return I18n.tr("GPX Files (*.gpx *.gpx.gz)", new Object[0]);
                    }
                };
                AbstractFileChooser fc = DiskAccessAction.createAndOpenFileChooser(true, false, null, filter, 0, null);
                if (fc == null) {
                    return;
                }
                File sel = fc.getSelectedFile();
                try {
                    CorrelateGpxWithImages.this.outerPanel.setCursor(Cursor.getPredefinedCursor(3));
                    for (int i = CorrelateGpxWithImages.this.gpxLst.size() - 1; i >= 0; --i) {
                        GpxDataWrapper wrapper = CorrelateGpxWithImages.this.gpxLst.get(i);
                        if (wrapper.file == null || !sel.equals(wrapper.file)) continue;
                        CorrelateGpxWithImages.this.cbGpx.setSelectedIndex(i);
                        if (!sel.getName().equals(wrapper.name)) {
                            JOptionPane.showMessageDialog(Main.parent, I18n.tr("File {0} is loaded yet under the name \"{1}\"", sel.getName(), wrapper.name), I18n.tr("Error", new Object[0]), 0);
                        }
                        return;
                    }
                    GpxData data = null;
                    try (InputStream iStream = this.createInputStream(sel);){
                        GpxReader reader = new GpxReader(iStream);
                        reader.parse(false);
                        data = reader.getGpxData();
                        data.storageFile = sel;
                    }
                    catch (SAXException x) {
                        Main.error(x);
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error while parsing {0}", sel.getName()) + ": " + x.getMessage(), I18n.tr("Error", new Object[0]), 0);
                        CorrelateGpxWithImages.this.outerPanel.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    catch (IOException x) {
                        Main.error(x);
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not read \"{0}\"", sel.getName()) + "\n" + x.getMessage(), I18n.tr("Error", new Object[0]), 0);
                        CorrelateGpxWithImages.this.outerPanel.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    loadedGpxData.add(data);
                    if (CorrelateGpxWithImages.this.gpxLst.get((int)0).file == null) {
                        CorrelateGpxWithImages.this.gpxLst.remove(0);
                    }
                    CorrelateGpxWithImages.this.gpxLst.add(new GpxDataWrapper(sel.getName(), data, sel));
                    CorrelateGpxWithImages.this.cbGpx.setSelectedIndex(CorrelateGpxWithImages.this.cbGpx.getItemCount() - 1);
                    break block26;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    CorrelateGpxWithImages.this.outerPanel.setCursor(Cursor.getDefaultCursor());
                }
            }
        }

        private InputStream createInputStream(File sel) throws IOException, FileNotFoundException {
            if (sel.getName().toLowerCase().endsWith(".gpx.gz")) {
                return new GZIPInputStream(new FileInputStream(sel));
            }
            return new FileInputStream(sel);
        }
    }

    private static class GpxDataWrapper {
        String name;
        GpxData data;
        File file;

        public GpxDataWrapper(String name, GpxData data, File file) {
            this.name = name;
            this.data = data;
            this.file = file;
        }

        public String toString() {
            return this.name;
        }
    }
}

