/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openstreetmap.gui.jmapviewer.AttributionSupport;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TemplatedWMSTileSource;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.imagery.TMSCachedTileLoader;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

public class WMSLayer
extends TMSLayer {
    private static final Double[] snapLevels = new Double[]{156412.0, 78206.0, 39103.0, 19551.0, 9776.0, 4888.0, 2444.0, 1222.0, 610.984, 305.492, 152.746, 76.373, 38.187, 19.093, 9.547, 4.773, 2.387, 1.193, 0.596};
    public static final BooleanProperty PROP_ALPHA_CHANNEL = new BooleanProperty("imagery.wms.alpha_channel", true);
    public static final IntegerProperty PROP_SIMULTANEOUS_CONNECTIONS = new IntegerProperty("imagery.wms.simultaneousConnections", 3);
    public static final BooleanProperty PROP_OVERLAP = new BooleanProperty("imagery.wms.overlap", false);
    public static final IntegerProperty PROP_OVERLAP_EAST = new IntegerProperty("imagery.wms.overlapEast", 14);
    public static final IntegerProperty PROP_OVERLAP_NORTH = new IntegerProperty("imagery.wms.overlapNorth", 4);
    public static final IntegerProperty PROP_IMAGE_SIZE = new IntegerProperty("imagery.wms.imageSize", 500);
    public static final BooleanProperty PROP_DEFAULT_AUTOZOOM = new BooleanProperty("imagery.wms.default_autozoom", true);
    protected double resolution;
    protected String resolutionText;
    protected int dax = 10;
    protected int day = 10;
    protected int daStep = 5;
    protected int minZoom = 3;
    protected static final int serializeFormatVersion = 5;
    protected boolean autoDownloadEnabled = true;
    protected boolean autoResolutionEnabled = PROP_DEFAULT_AUTOZOOM.get();
    protected boolean settingsChanged;
    private AttributionSupport attribution = new AttributionSupport();

    public WMSLayer() {
        this(new ImageryInfo(I18n.tr("Blank Layer", new Object[0])));
    }

    public WMSLayer(ImageryInfo info) {
        super(info);
        this.setBackgroundLayer(true);
        this.attribution.initialize(this.info);
    }

    public void doSetName(String name) {
        this.setName(name);
        this.info.setName(name);
    }

    public boolean hasAutoDownload() {
        return this.autoDownloadEnabled;
    }

    public void setAutoDownload(boolean val) {
        this.autoDownloadEnabled = val;
    }

    public boolean isAutoResolution() {
        return this.autoResolutionEnabled;
    }

    public void setAutoResolution(boolean val) {
        this.autoResolutionEnabled = val;
    }

    public void downloadAreaToCache(PrecacheTask precacheTask, List<LatLon> points, double bufferX, double bufferY) {
        final HashSet<Tile> requestedTiles = new HashSet<Tile>();
        for (LatLon point : points) {
            int minY = (int)Math.round(this.tileSource.latToTileY(point.lat() - bufferY, this.currentZoomLevel));
            int maxY = (int)Math.round(this.tileSource.latToTileY(point.lat() + bufferY, this.currentZoomLevel));
            int minX = (int)Math.round(this.tileSource.lonToTileX(point.lon() - bufferX, this.currentZoomLevel));
            int maxX = (int)Math.round(this.tileSource.lonToTileX(point.lon() + bufferX, this.currentZoomLevel));
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    requestedTiles.add(new Tile(this.tileSource, x, y, this.currentZoomLevel));
                }
            }
        }
        precacheTask.progressMonitor.setTicksCount(requestedTiles.size());
        precacheTask.progressMonitor.setCustomText(I18n.tr("Downloaded {0}/{1} tiles", 0, precacheTask.totalCount));
        new Thread(new Runnable(){

            @Override
            public void run() {
                for (Tile t : requestedTiles) {
                    ((TMSCachedTileLoader)WMSLayer.this.tileLoader).createTileLoaderJob(t).submit();
                }
            }
        }).setName("Download WMS imagery task for layer " + this.tileSource.getName());
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public ImageryInfo getInfo() {
        return this.info;
    }

    @Override
    public String getToolTipText() {
        if (this.autoDownloadEnabled) {
            return I18n.tr("WMS layer ({0}), automatically downloading in zoom {1}", this.getName(), this.resolutionText);
        }
        return I18n.tr("WMS layer ({0}), downloading in zoom {1}", this.getName(), this.resolutionText);
    }

    @Override
    public void setOffset(double dx, double dy) {
        super.setOffset(dx, dy);
        this.settingsChanged = true;
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<Action> ret = new ArrayList<Action>();
        ret.addAll(Arrays.asList(super.getMenuEntries()));
        ret.add(Layer.SeparatorLayerAction.INSTANCE);
        ret.add(new Layer.LayerSaveAction(this));
        ret.add(new Layer.LayerSaveAsAction(this));
        ret.add(new BookmarkWmsAction());
        return ret.toArray(new Action[0]);
    }

    @Override
    public TileSource getTileSource(ImageryInfo info) throws IllegalArgumentException {
        if (info.getImageryType() == ImageryInfo.ImageryType.WMS && info.getUrl() != null) {
            TemplatedWMSTileSource.checkUrl(info.getUrl());
            TemplatedWMSTileSource tileSource = new TemplatedWMSTileSource(info);
            info.setAttribution(tileSource);
            return tileSource;
        }
        return null;
    }

    public void checkGrabberType() {
        ImageryInfo.ImageryType it = this.getInfo().getImageryType();
        if (!ImageryInfo.ImageryType.HTML.equals((Object)it) && !ImageryInfo.ImageryType.WMS.equals((Object)it)) {
            throw new IllegalStateException("getGrabber() called for non-WMS layer type");
        }
    }

    public class BookmarkWmsAction
    extends AbstractAction {
        public BookmarkWmsAction() {
            super(I18n.tr("Set WMS Bookmark", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            ImageryLayerInfo.addLayer(new ImageryInfo(WMSLayer.this.info));
        }
    }

    public static class PrecacheTask {
        private final ProgressMonitor progressMonitor;
        private volatile int totalCount;
        private volatile int processedCount;
        private volatile boolean isCancelled;

        public PrecacheTask(ProgressMonitor progressMonitor) {
            this.progressMonitor = progressMonitor;
        }

        public boolean isFinished() {
            return this.totalCount == this.processedCount;
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public void cancel() {
            this.isCancelled = true;
        }
    }
}

