/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Graphics2D;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.PaintVisitor;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.MultiMap;

public class ValidatorLayer
extends Layer
implements MapView.LayerChangeListener {
    private int updateCount = -1;

    public ValidatorLayer() {
        super(I18n.tr("Validation errors", new Object[0]));
        MapView.addLayerChangeListener(this);
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "validator_small");
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        this.updateCount = Main.map.validatorDialog.tree.getUpdateCount();
        DefaultMutableTreeNode root = Main.map.validatorDialog.tree.getRoot();
        if (root == null || root.getChildCount() == 0) {
            return;
        }
        PaintVisitor paintVisitor = new PaintVisitor(g, mv);
        for (DefaultMutableTreeNode severity = (DefaultMutableTreeNode)root.getLastChild(); severity != null; severity = severity.getPreviousSibling()) {
            Enumeration<TreeNode> errorMessages = severity.breadthFirstEnumeration();
            while (errorMessages.hasMoreElements()) {
                Object tn = ((DefaultMutableTreeNode)errorMessages.nextElement()).getUserObject();
                if (!(tn instanceof TestError)) continue;
                paintVisitor.visit((TestError)tn);
            }
        }
        paintVisitor.clearPaintedObjects();
    }

    @Override
    public String getToolTipText() {
        MultiMap<Severity, TestError> errorTree = new MultiMap<Severity, TestError>();
        List<TestError> errors = Main.map.validatorDialog.tree.getErrors();
        for (TestError e : errors) {
            errorTree.put(e.getSeverity(), e);
        }
        StringBuilder b = new StringBuilder();
        for (Severity s : Severity.values()) {
            if (!errorTree.containsKey(s)) continue;
            b.append(I18n.tr(s.toString(), new Object[0])).append(": ").append(errorTree.get(s).size()).append("<br>");
        }
        if (b.length() == 0) {
            return "<html>" + I18n.tr("No validation errors", new Object[0]) + "</html>";
        }
        return "<html>" + I18n.tr("Validation errors", new Object[0]) + ":<br>" + b + "</html>";
    }

    @Override
    public void mergeFrom(Layer from) {
    }

    @Override
    public boolean isMergable(Layer other) {
        return false;
    }

    @Override
    public boolean isChanged() {
        return this.updateCount != Main.map.validatorDialog.tree.getUpdateCount();
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    @Override
    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    @Override
    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(null, this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction(this)};
    }

    @Override
    public void destroy() {
    }

    @Override
    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    @Override
    public void layerAdded(Layer newLayer) {
    }

    @Override
    public void layerRemoved(Layer oldLayer) {
        if (oldLayer instanceof OsmDataLayer && Main.isDisplayingMapView() && !Main.main.hasEditLayer()) {
            Main.main.removeLayer(this);
        } else if (oldLayer == this) {
            MapView.removeLayerChangeListener(this);
            OsmValidator.errorLayer = null;
        }
    }
}

