/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.openstreetmap.gui.jmapviewer.AttributionSupport;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.CachedTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TemplatedTileSource;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.TMSCachedTileLoader;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class TMSLayer
extends ImageryLayer
implements ImageObserver,
TileLoaderListener {
    public static final String PREFERENCE_PREFIX = "imagery.tms";
    public static final int MAX_ZOOM = 30;
    public static final int MIN_ZOOM = 2;
    public static final int DEFAULT_MAX_ZOOM = 20;
    public static final int DEFAULT_MIN_ZOOM = 2;
    public static final BooleanProperty PROP_DEFAULT_AUTOZOOM = new BooleanProperty("imagery.tms.default_autozoom", true);
    public static final BooleanProperty PROP_DEFAULT_AUTOLOAD = new BooleanProperty("imagery.tms.default_autoload", true);
    public static final BooleanProperty PROP_DEFAULT_SHOWERRORS = new BooleanProperty("imagery.tms.default_showerrors", true);
    public static final IntegerProperty PROP_MIN_ZOOM_LVL = new IntegerProperty("imagery.tms.min_zoom_lvl", 2);
    public static final IntegerProperty PROP_MAX_ZOOM_LVL = new IntegerProperty("imagery.tms.max_zoom_lvl", 20);
    public static final BooleanProperty PROP_ADD_TO_SLIPPYMAP_CHOOSER = new BooleanProperty("imagery.tms.add_to_slippymap_chooser", true);
    public static final StringProperty PROP_TILECACHE_DIR;
    protected TileCache tileCache;
    protected TileSource tileSource;
    protected TileLoader tileLoader;
    public static TileLoaderFactory loaderFactory;
    public int currentZoomLevel;
    private Tile clickedTile;
    private boolean needRedraw;
    private JPopupMenu tileOptionMenu;
    JCheckBoxMenuItem autoZoomPopup;
    JCheckBoxMenuItem autoLoadPopup;
    JCheckBoxMenuItem showErrorsPopup;
    Tile showMetadataTile;
    private AttributionSupport attribution = new AttributionSupport();
    private static final Font InfoFont;
    protected boolean autoZoom;
    protected boolean autoLoad;
    protected boolean showErrors;
    Image lastScaledImage = null;
    private final TileSet nullTileSet = new TileSet((LatLon)null, (LatLon)null, 0);

    public static void setCustomTileLoaderFactory(TileLoaderFactory loaderFactory) {
        TMSLayer.loaderFactory = loaderFactory;
    }

    @Override
    public synchronized void tileLoadingFinished(Tile tile, boolean success) {
        if (tile.hasError()) {
            success = false;
            tile.setImage(null);
        }
        if (this.sharpenLevel != 0 && success) {
            tile.setImage(this.sharpenImage(tile.getImage()));
        }
        tile.setLoaded(success);
        this.needRedraw = true;
        if (Main.map != null) {
            Main.map.repaint(100L);
        }
        if (Main.isDebugEnabled()) {
            Main.debug("tileLoadingFinished() tile: " + tile + " success: " + success);
        }
    }

    void clearTileCache(ProgressMonitor monitor) {
        this.tileCache.clear();
        if (this.tileLoader instanceof CachedTileLoader) {
            ((CachedTileLoader)((Object)this.tileLoader)).clearCache();
        }
    }

    void redraw() {
        this.needRedraw = true;
        Main.map.repaint();
    }

    static int checkMaxZoomLvl(int maxZoomLvl, TileSource ts) {
        if (maxZoomLvl > 30) {
            maxZoomLvl = 30;
        }
        if (maxZoomLvl < PROP_MIN_ZOOM_LVL.get()) {
            maxZoomLvl = PROP_MIN_ZOOM_LVL.get();
        }
        if (ts != null && ts.getMaxZoom() != 0 && ts.getMaxZoom() < maxZoomLvl) {
            maxZoomLvl = ts.getMaxZoom();
        }
        return maxZoomLvl;
    }

    public static int getMaxZoomLvl(TileSource ts) {
        return TMSLayer.checkMaxZoomLvl(PROP_MAX_ZOOM_LVL.get(), ts);
    }

    public static void setMaxZoomLvl(int maxZoomLvl) {
        maxZoomLvl = TMSLayer.checkMaxZoomLvl(maxZoomLvl, null);
        PROP_MAX_ZOOM_LVL.put(maxZoomLvl);
    }

    static int checkMinZoomLvl(int minZoomLvl, TileSource ts) {
        if (minZoomLvl < 2) {
            minZoomLvl = 2;
        }
        if (minZoomLvl > PROP_MAX_ZOOM_LVL.get()) {
            minZoomLvl = TMSLayer.getMaxZoomLvl(ts);
        }
        if (ts != null && ts.getMinZoom() > minZoomLvl) {
            minZoomLvl = ts.getMinZoom();
        }
        return minZoomLvl;
    }

    public static int getMinZoomLvl(TileSource ts) {
        return TMSLayer.checkMinZoomLvl(PROP_MIN_ZOOM_LVL.get(), ts);
    }

    public static void setMinZoomLvl(int minZoomLvl) {
        minZoomLvl = TMSLayer.checkMinZoomLvl(minZoomLvl, null);
        PROP_MIN_ZOOM_LVL.put(minZoomLvl);
    }

    protected TileSource getTileSource(ImageryInfo info) throws IllegalArgumentException {
        return AbstractTMSTileSource.getTileSource(info);
    }

    private void initTileSource(TileSource tileSource) {
        this.tileSource = tileSource;
        this.attribution.initialize(tileSource);
        this.currentZoomLevel = this.getBestZoom();
        Map<String, String> headers = null;
        if (tileSource instanceof TemplatedTileSource) {
            headers = ((TemplatedTileSource)tileSource).getHeaders();
        }
        this.tileLoader = loaderFactory.makeTileLoader(this, headers);
        this.tileCache = this.tileLoader instanceof TMSCachedTileLoader ? (TileCache)((Object)this.tileLoader) : new MemoryTileCache();
        if (this.tileLoader == null) {
            this.tileLoader = new OsmTileLoader(this);
        }
    }

    private double getScaleFactor(int zoom) {
        if (!Main.isDisplayingMapView()) {
            return 1.0;
        }
        MapView mv = Main.map.mapView;
        LatLon topLeft = mv.getLatLon(0, 0);
        LatLon botRight = mv.getLatLon(mv.getWidth(), mv.getHeight());
        double x1 = this.tileSource.lonToTileX(topLeft.lon(), zoom);
        double y1 = this.tileSource.latToTileY(topLeft.lat(), zoom);
        double x2 = this.tileSource.lonToTileX(botRight.lon(), zoom);
        double y2 = this.tileSource.latToTileY(botRight.lat(), zoom);
        int screenPixels = mv.getWidth() * mv.getHeight();
        double tilePixels = Math.abs((y2 - y1) * (x2 - x1) * (double)this.tileSource.getTileSize() * (double)this.tileSource.getTileSize());
        if (screenPixels == 0 || tilePixels == 0.0) {
            return 1.0;
        }
        return (double)screenPixels / tilePixels;
    }

    private final int getBestZoom() {
        double factor = this.getScaleFactor(1);
        double result = Math.log(factor) / Math.log(2.0) / 2.0 + 1.0;
        int intResult = (int)Math.floor(result);
        if (intResult > this.getMaxZoomLvl()) {
            return this.getMaxZoomLvl();
        }
        if (intResult < this.getMinZoomLvl()) {
            return this.getMinZoomLvl();
        }
        return intResult;
    }

    public TMSLayer(ImageryInfo info) {
        super(info);
        if (!this.isProjectionSupported(Main.getProjection())) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("TMS layers do not support the projection {0}.\n{1}\nChange the projection or remove the layer.", Main.getProjection().toCode(), this.nameSupportedProjections()), I18n.tr("Warning", new Object[0]), 2);
        }
        this.setBackgroundLayer(true);
        this.setVisible(true);
        TileSource source = this.getTileSource(info);
        if (source == null) {
            throw new IllegalStateException("Cannot create TMSLayer with non-TMS ImageryInfo");
        }
        this.initTileSource(source);
    }

    private static final boolean actionSupportLayers(List<Layer> layers) {
        return layers.size() == 1 && layers.get(0) instanceof TMSLayer;
    }

    @Override
    public void hookUpMapView() {
        this.tileOptionMenu = new JPopupMenu();
        this.autoZoom = PROP_DEFAULT_AUTOZOOM.get();
        this.autoZoomPopup = new JCheckBoxMenuItem();
        this.autoZoomPopup.setAction(new AutoZoomAction());
        this.autoZoomPopup.setSelected(this.autoZoom);
        this.tileOptionMenu.add(this.autoZoomPopup);
        this.autoLoad = PROP_DEFAULT_AUTOLOAD.get();
        this.autoLoadPopup = new JCheckBoxMenuItem();
        this.autoLoadPopup.setAction(new AutoLoadTilesAction());
        this.autoLoadPopup.setSelected(this.autoLoad);
        this.tileOptionMenu.add(this.autoLoadPopup);
        this.showErrors = PROP_DEFAULT_SHOWERRORS.get();
        this.showErrorsPopup = new JCheckBoxMenuItem();
        this.showErrorsPopup.setAction(new AbstractAction(I18n.tr("Show Errors", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TMSLayer.this.showErrors = !TMSLayer.this.showErrors;
            }
        });
        this.showErrorsPopup.setSelected(this.showErrors);
        this.tileOptionMenu.add(this.showErrorsPopup);
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Load Tile", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (TMSLayer.this.clickedTile != null) {
                    TMSLayer.this.loadTile(TMSLayer.this.clickedTile, true);
                    TMSLayer.this.redraw();
                }
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Show Tile Info", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (TMSLayer.this.clickedTile != null) {
                    TMSLayer.this.showMetadataTile = TMSLayer.this.clickedTile;
                    TMSLayer.this.redraw();
                }
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new LoadAllTilesAction()));
        this.tileOptionMenu.add(new JMenuItem(new LoadErroneusTilesAction()));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Increase zoom", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TMSLayer.this.increaseZoomLevel();
                TMSLayer.this.redraw();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Decrease zoom", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TMSLayer.this.decreaseZoomLevel();
                TMSLayer.this.redraw();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Snap to tile size", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent ae) {
                double new_factor = Math.sqrt(TMSLayer.this.getScaleFactor(TMSLayer.this.currentZoomLevel));
                Main.map.mapView.zoomToFactor(new_factor);
                TMSLayer.this.redraw();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Flush Tile Cache", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent ae) {
                new PleaseWaitRunnable(I18n.tr("Flush Tile Cache", new Object[0])){

                    @Override
                    protected void realRun() throws SAXException, IOException, OsmTransferException {
                        TMSLayer.this.clearTileCache(this.getProgressMonitor());
                    }

                    @Override
                    protected void finish() {
                    }

                    @Override
                    protected void cancel() {
                    }
                }.run();
            }
        }));
        final MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!TMSLayer.this.isVisible()) {
                    return;
                }
                if (e.getButton() == 3) {
                    TMSLayer.this.clickedTile = TMSLayer.this.getTileForPixelpos(e.getX(), e.getY());
                    TMSLayer.this.tileOptionMenu.show(e.getComponent(), e.getX(), e.getY());
                } else if (e.getButton() == 1) {
                    TMSLayer.this.attribution.handleAttribution(e.getPoint(), true);
                }
            }
        };
        Main.map.mapView.addMouseListener(adapter);
        MapView.addLayerChangeListener(new MapView.LayerChangeListener(){

            @Override
            public void activeLayerChange(Layer oldLayer, Layer newLayer) {
            }

            @Override
            public void layerAdded(Layer newLayer) {
            }

            @Override
            public void layerRemoved(Layer oldLayer) {
                if (oldLayer == TMSLayer.this) {
                    Main.map.mapView.removeMouseListener(adapter);
                    MapView.removeLayerChangeListener(this);
                }
            }
        });
    }

    void zoomChanged() {
        if (Main.isDebugEnabled()) {
            Main.debug("zoomChanged(): " + this.currentZoomLevel);
        }
        this.needRedraw = true;
    }

    int getMaxZoomLvl() {
        if (this.info.getMaxZoom() != 0) {
            return TMSLayer.checkMaxZoomLvl(this.info.getMaxZoom(), this.tileSource);
        }
        return TMSLayer.getMaxZoomLvl(this.tileSource);
    }

    int getMinZoomLvl() {
        return TMSLayer.getMinZoomLvl(this.tileSource);
    }

    public boolean zoomIncreaseAllowed() {
        boolean zia;
        boolean bl = zia = this.currentZoomLevel < this.getMaxZoomLvl();
        if (Main.isDebugEnabled()) {
            Main.debug("zoomIncreaseAllowed(): " + zia + " " + this.currentZoomLevel + " vs. " + this.getMaxZoomLvl());
        }
        return zia;
    }

    public boolean increaseZoomLevel() {
        if (this.zoomIncreaseAllowed()) {
            ++this.currentZoomLevel;
            if (Main.isDebugEnabled()) {
                Main.debug("increasing zoom level to: " + this.currentZoomLevel);
            }
        } else {
            Main.warn("Current zoom level (" + this.currentZoomLevel + ") could not be increased. " + "Max.zZoom Level " + this.getMaxZoomLvl() + " reached.");
            return false;
        }
        this.zoomChanged();
        return true;
    }

    public boolean setZoomLevel(int zoom) {
        if (zoom == this.currentZoomLevel) {
            return true;
        }
        if (zoom > this.getMaxZoomLvl()) {
            return false;
        }
        if (zoom < this.getMinZoomLvl()) {
            return false;
        }
        this.currentZoomLevel = zoom;
        this.zoomChanged();
        return true;
    }

    public boolean zoomDecreaseAllowed() {
        return this.currentZoomLevel > this.getMinZoomLvl();
    }

    public boolean decreaseZoomLevel() {
        if (this.zoomDecreaseAllowed()) {
            if (Main.isDebugEnabled()) {
                Main.debug("decreasing zoom level to: " + this.currentZoomLevel);
            }
            --this.currentZoomLevel;
        } else {
            return false;
        }
        this.zoomChanged();
        return true;
    }

    Tile tempCornerTile(Tile t) {
        int zoom;
        int y;
        int x = t.getXtile() + 1;
        Tile tile = this.getTile(x, y = t.getYtile() + 1, zoom = t.getZoom());
        if (tile != null) {
            return tile;
        }
        return new Tile(this.tileSource, x, y, zoom);
    }

    Tile getOrCreateTile(int x, int y, int zoom) {
        Tile tile = this.getTile(x, y, zoom);
        if (tile == null) {
            tile = new Tile(this.tileSource, x, y, zoom);
            this.tileCache.addTile(tile);
            tile.loadPlaceholderFromCache(this.tileCache);
        }
        return tile;
    }

    Tile getTile(int x, int y, int zoom) {
        int max = 1 << zoom;
        if (x < 0 || x >= max || y < 0 || y >= max) {
            return null;
        }
        return this.tileCache.getTile(this.tileSource, x, y, zoom);
    }

    boolean loadTile(Tile tile, boolean force) {
        if (tile == null) {
            return false;
        }
        if (!force && (tile.isLoaded() || tile.hasError())) {
            return false;
        }
        if (tile.isLoading()) {
            return false;
        }
        this.tileLoader.createTileLoaderJob(tile).submit();
        return true;
    }

    protected List<Tile> getAllVisibleTiles() {
        return this.getVisibleTileSet().allTilesCreate();
    }

    private TileSet getVisibleTileSet() {
        MapView mv = Main.map.mapView;
        EastNorth topLeft = mv.getEastNorth(0, 0);
        EastNorth botRight = mv.getEastNorth(mv.getWidth(), mv.getHeight());
        return new TileSet(topLeft, botRight, this.currentZoomLevel);
    }

    void loadAllTiles(boolean force) {
        TileSet ts = this.getVisibleTileSet();
        if (ts.tooLarge()) {
            Main.warn("Not downloading all tiles because there is more than 18 tiles on an axis!");
            return;
        }
        ts.loadAllTiles(force);
    }

    void loadAllErrorTiles(boolean force) {
        TileSet ts = this.getVisibleTileSet();
        ts.loadAllErrorTiles(force);
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        boolean done = (infoflags & 0x70) != 0;
        this.needRedraw = true;
        if (Main.isDebugEnabled()) {
            Main.debug("imageUpdate() done: " + done + " calling repaint");
        }
        Main.map.repaint(done ? 0L : 100L);
        return !done;
    }

    boolean imageLoaded(Image i) {
        if (i == null) {
            return false;
        }
        int status = Toolkit.getDefaultToolkit().checkImage(i, -1, -1, this);
        return (status & 0x20) != 0;
    }

    Image getLoadedTileImage(Tile tile) {
        if (!tile.isLoaded()) {
            return null;
        }
        BufferedImage img = tile.getImage();
        if (!this.imageLoaded(img)) {
            return null;
        }
        return img;
    }

    LatLon tileLatLon(Tile t) {
        int zoom = t.getZoom();
        return new LatLon(this.tileSource.tileYToLat(t.getYtile(), zoom), this.tileSource.tileXToLon(t.getXtile(), zoom));
    }

    Rectangle tileToRect(Tile t1) {
        Tile t2 = this.tempCornerTile(t1);
        Rectangle rect = new Rectangle(this.pixelPos(t1));
        rect.add(this.pixelPos(t2));
        return rect;
    }

    void drawImageInside(Graphics g, Image sourceImg, Rectangle source, Rectangle border) {
        Rectangle target = source;
        if (border != null) {
            target = source.intersection(border);
            if (Main.isDebugEnabled()) {
                Main.debug("source: " + source + "\nborder: " + border + "\nintersection: " + target);
            }
        }
        double imageYScaling = (double)sourceImg.getHeight(this) / source.getHeight();
        double imageXScaling = (double)sourceImg.getWidth(this) / source.getWidth();
        int screen_x_offset = target.x - source.x;
        int screen_y_offset = target.y - source.y;
        int img_x_offset = (int)((double)screen_x_offset * imageXScaling + 0.5);
        int img_y_offset = (int)((double)screen_y_offset * imageYScaling + 0.5);
        int img_x_end = img_x_offset + (int)(target.getWidth() * imageXScaling + 0.5);
        int img_y_end = img_y_offset + (int)(target.getHeight() * imageYScaling + 0.5);
        if (Main.isDebugEnabled()) {
            Main.debug("drawing image into target rect: " + target);
        }
        g.drawImage(sourceImg, target.x, target.y, target.x + target.width, target.y + target.height, img_x_offset, img_y_offset, img_x_end, img_y_end, this);
        if (PROP_FADE_AMOUNT.get() != 0) {
            g.setColor(TMSLayer.getFadeColorWithAlpha());
            g.fillRect(target.x, target.y, target.width, target.height);
        }
    }

    List<Tile> paintTileImages(Graphics g, TileSet ts, int zoom, Tile border) {
        if (zoom <= 0) {
            return Collections.emptyList();
        }
        Rectangle borderRect = null;
        if (border != null) {
            borderRect = this.tileToRect(border);
        }
        LinkedList<Tile> missedTiles = new LinkedList<Tile>();
        for (Tile tile : ts.allTilesCreate()) {
            Image img = this.getLoadedTileImage(tile);
            if (img == null || tile.hasError()) {
                if (Main.isDebugEnabled()) {
                    Main.debug("missed tile: " + tile);
                }
                missedTiles.add(tile);
                continue;
            }
            Rectangle sourceRect = this.tileToRect(tile);
            if (borderRect != null && !sourceRect.intersects(borderRect)) continue;
            this.drawImageInside(g, img, sourceRect, borderRect);
        }
        return missedTiles;
    }

    void myDrawString(Graphics g, String text, int x, int y) {
        Color oldColor = g.getColor();
        g.setColor(Color.black);
        g.drawString(text, x + 1, y + 1);
        g.setColor(oldColor);
        g.drawString(text, x, y);
    }

    void paintTileText(TileSet ts, Tile tile, Graphics g, MapView mv, int zoom, Tile t) {
        int fontHeight = g.getFontMetrics().getHeight();
        if (tile == null) {
            return;
        }
        Point p = this.pixelPos(t);
        int texty = p.y + 2 + fontHeight;
        if (tile == this.showMetadataTile) {
            Map<String, String> meta;
            String md = tile.toString();
            if (md != null) {
                this.myDrawString(g, md, p.x + 2, texty);
                texty += 1 + fontHeight;
            }
            if ((meta = tile.getMetadata()) != null) {
                for (Map.Entry<String, String> entry : meta.entrySet()) {
                    this.myDrawString(g, entry.getKey() + ": " + entry.getValue(), p.x + 2, texty);
                    texty += 1 + fontHeight;
                }
            }
        }
        if (tile.hasError() && this.showErrors) {
            this.myDrawString(g, I18n.tr("Error", new Object[0]) + ": " + I18n.tr(tile.getErrorMessage(), new Object[0]), p.x + 2, texty);
            texty += 1 + fontHeight;
        }
    }

    private Point pixelPos(LatLon ll) {
        return Main.map.mapView.getPoint(Main.getProjection().latlon2eastNorth(ll).add(this.getDx(), this.getDy()));
    }

    private Point pixelPos(Tile t) {
        double lon = this.tileSource.tileXToLon(t.getXtile(), t.getZoom());
        LatLon tmpLL = new LatLon(this.tileSource.tileYToLat(t.getYtile(), t.getZoom()), lon);
        return this.pixelPos(tmpLL);
    }

    private LatLon getShiftedLatLon(EastNorth en) {
        return Main.getProjection().eastNorth2latlon(en.add(-this.getDx(), -this.getDy()));
    }

    private Coordinate getShiftedCoord(EastNorth en) {
        LatLon ll = this.getShiftedLatLon(en);
        return new Coordinate(ll.lat(), ll.lon());
    }

    private static TileSetInfo getTileSetInfo(TileSet ts) {
        List<Tile> allTiles = ts.allExistingTiles();
        TileSetInfo result = new TileSetInfo();
        result.hasLoadingTiles = allTiles.size() < ts.size();
        for (Tile t : allTiles) {
            if (t.isLoaded()) {
                if (!t.hasError()) {
                    result.hasVisibleTiles = true;
                }
                if (!"no-tile".equals(t.getValue("tile-info"))) continue;
                result.hasOverzoomedTiles = true;
                continue;
            }
            result.hasLoadingTiles = true;
        }
        return result;
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        int[] otherZooms;
        double pixelScaling;
        EastNorth topLeft = mv.getEastNorth(0, 0);
        EastNorth botRight = mv.getEastNorth(mv.getWidth(), mv.getHeight());
        if (botRight.east() == 0.0 || botRight.north() == 0.0) {
            return;
        }
        this.needRedraw = false;
        int zoom = this.currentZoomLevel;
        if (this.autoZoom && ((pixelScaling = this.getScaleFactor(zoom)) > 3.0 || pixelScaling < 0.7)) {
            zoom = this.getBestZoom();
        }
        DeepTileSet dts = new DeepTileSet(topLeft, botRight, this.getMinZoomLvl(), zoom);
        TileSet ts = dts.getTileSet(zoom);
        int displayZoomLevel = zoom;
        boolean noTilesAtZoom = false;
        if (this.autoZoom && this.autoLoad) {
            TileSetInfo tsi = dts.getTileSetInfo(zoom);
            if (!(tsi.hasVisibleTiles || tsi.hasLoadingTiles && !tsi.hasOverzoomedTiles)) {
                noTilesAtZoom = true;
            }
            for (int tmpZoom = zoom; tmpZoom > dts.minZoom; --tmpZoom) {
                if (!dts.getTileSetInfo((int)tmpZoom).hasVisibleTiles) continue;
                displayZoomLevel = tmpZoom;
                break;
            }
            while (zoom > displayZoomLevel && !tsi.hasVisibleTiles && tsi.hasOverzoomedTiles) {
                zoom = (zoom + displayZoomLevel) / 2;
                tsi = dts.getTileSetInfo(zoom);
            }
            this.setZoomLevel(zoom);
            if (zoom == displayZoomLevel && !tsi.hasLoadingTiles && zoom < dts.maxZoom) {
                tsi = dts.getTileSetInfo(++zoom);
            }
            while (zoom > dts.minZoom && tsi.hasOverzoomedTiles && !tsi.hasLoadingTiles) {
                tsi = dts.getTileSetInfo(--zoom);
            }
            ts = dts.getTileSet(zoom);
        } else if (this.autoZoom) {
            this.setZoomLevel(zoom);
        }
        if (!ts.tooLarge()) {
            ts.loadAllTiles(false);
        }
        if (displayZoomLevel != zoom) {
            ts = dts.getTileSet(displayZoomLevel);
        }
        g.setColor(Color.DARK_GRAY);
        List<Tile> missedTiles = this.paintTileImages(g, ts, displayZoomLevel, null);
        for (int zoomOffset : otherZooms = new int[]{-1, 1, -2, 2, -3, -4, -5}) {
            if (!this.autoZoom) break;
            int newzoom = displayZoomLevel + zoomOffset;
            if (newzoom < 2) continue;
            if (missedTiles.size() <= 0) break;
            LinkedList<Tile> newlyMissedTiles = new LinkedList<Tile>();
            for (Tile missed : missedTiles) {
                LatLon botRight2;
                if ("no-tile".equals(missed.getValue("tile-info")) && zoomOffset > 0) {
                    newlyMissedTiles.add(missed);
                    continue;
                }
                Tile t2 = this.tempCornerTile(missed);
                LatLon topLeft2 = this.tileLatLon(missed);
                TileSet ts2 = new TileSet(topLeft2, botRight2 = this.tileLatLon(t2), newzoom);
                if (ts2.allLoadedTiles().isEmpty()) {
                    newlyMissedTiles.add(missed);
                    continue;
                }
                if (ts2.tooLarge()) continue;
                newlyMissedTiles.addAll(this.paintTileImages(g, ts2, newzoom, missed));
            }
            missedTiles = newlyMissedTiles;
        }
        if (Main.isDebugEnabled() && missedTiles.size() > 0) {
            Main.debug("still missed " + missedTiles.size() + " in the end");
        }
        g.setColor(Color.red);
        g.setFont(InfoFont);
        for (Tile t : ts.allExistingTiles()) {
            this.paintTileText(ts, t, g, mv, displayZoomLevel, t);
        }
        this.attribution.paintAttribution(g, mv.getWidth(), mv.getHeight(), this.getShiftedCoord(topLeft), this.getShiftedCoord(botRight), displayZoomLevel, this);
        g.setColor(Color.lightGray);
        if (!this.autoZoom) {
            if (ts.insane()) {
                this.myDrawString(g, I18n.tr("zoom in to load any tiles", new Object[0]), 120, 120);
            } else if (ts.tooLarge()) {
                this.myDrawString(g, I18n.tr("zoom in to load more tiles", new Object[0]), 120, 120);
            } else if (ts.tooSmall()) {
                this.myDrawString(g, I18n.tr("increase zoom level to see more detail", new Object[0]), 120, 120);
            }
        }
        if (noTilesAtZoom) {
            this.myDrawString(g, I18n.tr("No tiles at this zoom level", new Object[0]), 120, 120);
        }
        if (Main.isDebugEnabled()) {
            this.myDrawString(g, I18n.tr("Current zoom: {0}", this.currentZoomLevel), 50, 140);
            this.myDrawString(g, I18n.tr("Display zoom: {0}", displayZoomLevel), 50, 155);
            this.myDrawString(g, I18n.tr("Pixel scale: {0}", this.getScaleFactor(this.currentZoomLevel)), 50, 170);
            this.myDrawString(g, I18n.tr("Best zoom: {0}", Math.log(this.getScaleFactor(1)) / Math.log(2.0) / 2.0 + 1.0), 50, 185);
            if (this.tileLoader instanceof TMSCachedTileLoader) {
                TMSCachedTileLoader cachedTileLoader = (TMSCachedTileLoader)this.tileLoader;
                int offset = 185;
                for (String part : cachedTileLoader.getStats().split("\n")) {
                    this.myDrawString(g, I18n.tr("Cache stats: {0}", part), 50, offset += 15);
                }
            }
        }
    }

    Tile getTileForPixelpos(int px, int py) {
        int z;
        EastNorth botRight;
        if (Main.isDebugEnabled()) {
            Main.debug("getTileForPixelpos(" + px + ", " + py + ")");
        }
        MapView mv = Main.map.mapView;
        Point clicked = new Point(px, py);
        EastNorth topLeft = mv.getEastNorth(0, 0);
        TileSet ts = new TileSet(topLeft, botRight = mv.getEastNorth(mv.getWidth(), mv.getHeight()), z = this.currentZoomLevel);
        if (!ts.tooLarge()) {
            ts.loadAllTiles(false);
        }
        Tile clickedTile = null;
        for (Tile t1 : ts.allExistingTiles()) {
            Tile t2 = this.tempCornerTile(t1);
            Rectangle r = new Rectangle(this.pixelPos(t1));
            r.add(this.pixelPos(t2));
            if (Main.isDebugEnabled()) {
                Main.debug("r: " + r + " clicked: " + clicked);
            }
            if (!r.contains(clicked)) continue;
            clickedTile = t1;
            break;
        }
        if (clickedTile == null) {
            return null;
        }
        return clickedTile;
    }

    @Override
    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createActivateLayerAction(this), LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new ImageryLayer.OffsetAction(), new RenameLayerAction(this.getAssociatedFile(), this), Layer.SeparatorLayerAction.INSTANCE, new AutoLoadTilesAction(), new AutoZoomAction(), new ZoomToBestAction(), new ZoomToNativeLevelAction(), new LoadErroneusTilesAction(), new LoadAllTilesAction(), new LayerListPopup.InfoAction(this)};
    }

    @Override
    public String getToolTipText() {
        return I18n.tr("TMS layer ({0}), downloading in zoom {1}", this.getName(), this.currentZoomLevel);
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    @Override
    public boolean isChanged() {
        return this.needRedraw;
    }

    @Override
    public final boolean isProjectionSupported(Projection proj) {
        return "EPSG:3857".equals(proj.toCode()) || "EPSG:4326".equals(proj.toCode());
    }

    @Override
    public final String nameSupportedProjections() {
        return I18n.tr("EPSG:4326 and Mercator projection are supported", new Object[0]);
    }

    static {
        String defPath = null;
        try {
            defPath = new File(Main.pref.getCacheDirectory(), "tms").getAbsolutePath();
        }
        catch (SecurityException e) {
            Main.warn(e);
        }
        PROP_TILECACHE_DIR = new StringProperty("imagery.tms.tilecache", defPath);
        loaderFactory = new TileLoaderFactory(){

            @Override
            public TileLoader makeTileLoader(TileLoaderListener listener, Map<String, String> inputHeaders) {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("User-Agent", Version.getInstance().getFullAgentString());
                headers.put("Accept", "text/html, image/png, image/jpeg, image/gif, */*");
                if (inputHeaders != null) {
                    headers.putAll(inputHeaders);
                }
                try {
                    return new TMSCachedTileLoader(listener, "TMS", Main.pref.getInteger("socket.timeout.connect", 15) * 1000, Main.pref.getInteger("socket.timeout.read", 30) * 1000, headers, PROP_TILECACHE_DIR.get());
                }
                catch (IOException e) {
                    Main.warn(e);
                    return null;
                }
            }

            @Override
            public TileLoader makeTileLoader(TileLoaderListener listener) {
                return this.makeTileLoader(listener, null);
            }
        };
        InfoFont = new Font("sansserif", 1, 13);
    }

    private class DeepTileSet {
        final EastNorth topLeft;
        final EastNorth botRight;
        final int minZoom;
        final int maxZoom;
        private final TileSet[] tileSets;
        private final TileSetInfo[] tileSetInfos;

        public DeepTileSet(EastNorth topLeft, EastNorth botRight, int minZoom, int maxZoom) {
            this.topLeft = topLeft;
            this.botRight = botRight;
            this.minZoom = minZoom;
            this.maxZoom = maxZoom;
            this.tileSets = new TileSet[maxZoom - minZoom + 1];
            this.tileSetInfos = new TileSetInfo[maxZoom - minZoom + 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TileSet getTileSet(int zoom) {
            if (zoom < this.minZoom) {
                return TMSLayer.this.nullTileSet;
            }
            TileSet[] tileSetArray = this.tileSets;
            synchronized (this.tileSets) {
                TileSet ts = this.tileSets[zoom - this.minZoom];
                if (ts == null) {
                    this.tileSets[zoom - this.minZoom] = ts = new TileSet(this.topLeft, this.botRight, zoom);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return ts;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TileSetInfo getTileSetInfo(int zoom) {
            if (zoom < this.minZoom) {
                return new TileSetInfo();
            }
            TileSetInfo[] tileSetInfoArray = this.tileSetInfos;
            synchronized (this.tileSetInfos) {
                TileSetInfo tsi = this.tileSetInfos[zoom - this.minZoom];
                if (tsi == null) {
                    this.tileSetInfos[zoom - this.minZoom] = tsi = TMSLayer.getTileSetInfo(this.getTileSet(zoom));
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return tsi;
            }
        }
    }

    private static class TileSetInfo {
        public boolean hasVisibleTiles = false;
        public boolean hasOverzoomedTiles = false;
        public boolean hasLoadingTiles = false;

        private TileSetInfo() {
        }
    }

    private class TileSet {
        int x0;
        int x1;
        int y0;
        int y1;
        int zoom;
        int tileMax = -1;

        TileSet(EastNorth topLeft, EastNorth botRight, int zoom) {
            this(tMSLayer.getShiftedLatLon(topLeft), tMSLayer.getShiftedLatLon(botRight), zoom);
        }

        TileSet(LatLon topLeft, LatLon botRight, int zoom) {
            int tmp;
            this.zoom = zoom;
            if (zoom == 0) {
                return;
            }
            this.x0 = (int)TMSLayer.this.tileSource.lonToTileX(topLeft.lon(), zoom);
            this.y0 = (int)TMSLayer.this.tileSource.latToTileY(topLeft.lat(), zoom);
            this.x1 = (int)TMSLayer.this.tileSource.lonToTileX(botRight.lon(), zoom);
            this.y1 = (int)TMSLayer.this.tileSource.latToTileY(botRight.lat(), zoom);
            if (this.x0 > this.x1) {
                tmp = this.x0;
                this.x0 = this.x1;
                this.x1 = tmp;
            }
            if (this.y0 > this.y1) {
                tmp = this.y0;
                this.y0 = this.y1;
                this.y1 = tmp;
            }
            this.tileMax = (int)Math.pow(2.0, zoom);
            if (this.x0 < 0) {
                this.x0 = 0;
            }
            if (this.y0 < 0) {
                this.y0 = 0;
            }
            if (this.x1 > this.tileMax) {
                this.x1 = this.tileMax;
            }
            if (this.y1 > this.tileMax) {
                this.y1 = this.tileMax;
            }
        }

        boolean tooSmall() {
            return this.tilesSpanned() < 2.1;
        }

        boolean tooLarge() {
            return this.tilesSpanned() > 10.0;
        }

        boolean insane() {
            return this.tilesSpanned() > 100.0;
        }

        double tilesSpanned() {
            return Math.sqrt(1.0 * (double)this.size());
        }

        int size() {
            int x_span = this.x1 - this.x0 + 1;
            int y_span = this.y1 - this.y0 + 1;
            return x_span * y_span;
        }

        List<Tile> allExistingTiles() {
            return this.__allTiles(false);
        }

        List<Tile> allTilesCreate() {
            return this.__allTiles(true);
        }

        private List<Tile> __allTiles(boolean create) {
            if (this.zoom == 0 || this.insane()) {
                return Collections.emptyList();
            }
            ArrayList<Tile> ret = new ArrayList<Tile>();
            for (int x = this.x0; x <= this.x1; ++x) {
                for (int y = this.y0; y <= this.y1; ++y) {
                    Tile t = create ? TMSLayer.this.getOrCreateTile(x % this.tileMax, y % this.tileMax, this.zoom) : TMSLayer.this.getTile(x % this.tileMax, y % this.tileMax, this.zoom);
                    if (t == null) continue;
                    ret.add(t);
                }
            }
            return ret;
        }

        private List<Tile> allLoadedTiles() {
            ArrayList<Tile> ret = new ArrayList<Tile>();
            for (Tile t : this.allExistingTiles()) {
                if (!t.isLoaded()) continue;
                ret.add(t);
            }
            return ret;
        }

        void loadAllTiles(boolean force) {
            if (!TMSLayer.this.autoLoad && !force) {
                return;
            }
            for (Tile t : this.allTilesCreate()) {
                TMSLayer.this.loadTile(t, false);
            }
        }

        void loadAllErrorTiles(boolean force) {
            if (!TMSLayer.this.autoLoad && !force) {
                return;
            }
            for (Tile t : this.allTilesCreate()) {
                if (!t.hasError()) continue;
                TMSLayer.this.loadTile(t, true);
            }
        }
    }

    private class ZoomToBestAction
    extends AbstractAction {
        public ZoomToBestAction() {
            super(I18n.tr("Change resolution", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TMSLayer.this.setZoomLevel(TMSLayer.this.getBestZoom());
        }
    }

    private class ZoomToNativeLevelAction
    extends AbstractAction {
        public ZoomToNativeLevelAction() {
            super(I18n.tr("Zoom to native resolution", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            double new_factor = Math.sqrt(TMSLayer.this.getScaleFactor(TMSLayer.this.currentZoomLevel));
            Main.map.mapView.zoomToFactor(new_factor);
            TMSLayer.this.redraw();
        }
    }

    private class LoadErroneusTilesAction
    extends AbstractAction {
        public LoadErroneusTilesAction() {
            super(I18n.tr("Load All Error Tiles", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TMSLayer.this.loadAllErrorTiles(true);
            TMSLayer.this.redraw();
        }
    }

    private class LoadAllTilesAction
    extends AbstractAction {
        public LoadAllTilesAction() {
            super(I18n.tr("Load All Tiles", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TMSLayer.this.loadAllTiles(true);
            TMSLayer.this.redraw();
        }
    }

    private class AutoLoadTilesAction
    extends AbstractAction
    implements Layer.LayerAction {
        public AutoLoadTilesAction() {
            super(I18n.tr("Auto load tiles", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TMSLayer.this.autoLoad = !TMSLayer.this.autoLoad;
        }

        @Override
        public Component createMenuComponent() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(this);
            item.setSelected(TMSLayer.this.autoLoad);
            return item;
        }

        @Override
        public boolean supportLayers(List<Layer> layers) {
            return TMSLayer.actionSupportLayers(layers);
        }
    }

    private class AutoZoomAction
    extends AbstractAction
    implements Layer.LayerAction {
        public AutoZoomAction() {
            super(I18n.tr("Auto Zoom", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TMSLayer.this.autoZoom = !TMSLayer.this.autoZoom;
        }

        @Override
        public Component createMenuComponent() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(this);
            item.setSelected(TMSLayer.this.autoZoom);
            return item;
        }

        @Override
        public boolean supportLayers(List<Layer> layers) {
            return TMSLayer.actionSupportLayers(layers);
        }
    }

    public static interface TileLoaderFactory {
        public TileLoader makeTileLoader(TileLoaderListener var1);

        public TileLoader makeTileLoader(TileLoaderListener var1, Map<String, String> var2);
    }
}

