/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.actions.ToggleUploadDiscouragedLayerAction;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxConstants;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.ImmutableGpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.DatasetConsistencyTest;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.AbstractMapRenderer;
import org.openstreetmap.josm.data.osm.visitor.paint.MapRendererFactory;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.AbstractIOTask;
import org.openstreetmap.josm.gui.io.AbstractUploadDialog;
import org.openstreetmap.josm.gui.io.UploadDialog;
import org.openstreetmap.josm.gui.io.UploadLayerTask;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.tools.FilteredCollection;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.date.DateUtils;

public class OsmDataLayer
extends AbstractModifiableLayer
implements SelectionChangedListener,
DataSetListenerAdapter.Listener {
    public static final String REQUIRES_SAVE_TO_DISK_PROP = OsmDataLayer.class.getName() + ".requiresSaveToDisk";
    public static final String REQUIRES_UPLOAD_TO_SERVER_PROP = OsmDataLayer.class.getName() + ".requiresUploadToServer";
    private boolean requiresSaveToFile = false;
    private boolean requiresUploadToServer = false;
    private boolean isChanged = true;
    private int highlightUpdateCount;
    public final List<TestError> validationErrors = new ArrayList<TestError>();
    private static int dataLayerCounter = 0;
    private final CopyOnWriteArrayList<LayerStateChangeListener> layerStateChangeListeners = new CopyOnWriteArrayList();
    public final DataSet data;
    private ConflictCollection conflicts;
    private static volatile TexturePaint hatched;

    protected void setRequiresSaveToFile(boolean newValue) {
        boolean oldValue = this.requiresSaveToFile;
        this.requiresSaveToFile = newValue;
        if (oldValue != newValue) {
            this.propertyChangeSupport.firePropertyChange(REQUIRES_SAVE_TO_DISK_PROP, oldValue, newValue);
        }
    }

    protected void setRequiresUploadToServer(boolean newValue) {
        boolean oldValue = this.requiresUploadToServer;
        this.requiresUploadToServer = newValue;
        if (oldValue != newValue) {
            this.propertyChangeSupport.firePropertyChange(REQUIRES_UPLOAD_TO_SERVER_PROP, oldValue, newValue);
        }
    }

    public static String createNewName() {
        return I18n.tr("Data Layer {0}", ++dataLayerCounter);
    }

    public void addLayerStateChangeListener(LayerStateChangeListener listener) {
        if (listener != null) {
            this.layerStateChangeListeners.addIfAbsent(listener);
        }
    }

    public void removeLayerPropertyChangeListener(LayerStateChangeListener listener) {
        this.layerStateChangeListeners.remove(listener);
    }

    public static Color getBackgroundColor() {
        return Main.pref.getColor(I18n.marktr("background"), Color.BLACK);
    }

    public static Color getOutsideColor() {
        return Main.pref.getColor(I18n.marktr("outside downloaded area"), Color.YELLOW);
    }

    public static void createHatchTexture() {
        BufferedImage bi = new BufferedImage(15, 15, 2);
        Graphics2D big = bi.createGraphics();
        big.setColor(OsmDataLayer.getBackgroundColor());
        AlphaComposite comp = AlphaComposite.getInstance(3, 0.3f);
        big.setComposite(comp);
        big.fillRect(0, 0, 15, 15);
        big.setColor(OsmDataLayer.getOutsideColor());
        big.drawLine(0, 15, 15, 0);
        Rectangle r = new Rectangle(0, 0, 15, 15);
        hatched = new TexturePaint(bi, r);
    }

    public OsmDataLayer(DataSet data, String name, File associatedFile) {
        super(name);
        this.data = data;
        this.setAssociatedFile(associatedFile);
        this.conflicts = new ConflictCollection();
        data.addDataSetListener(new DataSetListenerAdapter(this));
        data.addDataSetListener(MultipolygonCache.getInstance());
        DataSet.addSelectionListener(this);
    }

    protected Icon getBaseIcon() {
        return ImageProvider.get("layer", "osmdata_small");
    }

    @Override
    public Icon getIcon() {
        Icon baseIcon = this.getBaseIcon();
        if (this.isUploadDiscouraged()) {
            return ImageProvider.overlay(baseIcon, new ImageIcon(ImageProvider.get("warning-small").getImage().getScaledInstance(8, 8, 4)), ImageProvider.OverlayPosition.SOUTHEAST);
        }
        return baseIcon;
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds box) {
        boolean virtual;
        this.isChanged = false;
        this.highlightUpdateCount = this.data.getHighlightUpdateCount();
        boolean active = mv.getActiveLayer() == this;
        boolean inactive = !active && Main.pref.getBoolean("draw.data.inactive_color", true);
        boolean bl = virtual = !inactive && mv.isVirtualNodesEnabled();
        if (active && Main.pref.getBoolean("draw.data.downloaded_area", true) && !this.data.dataSources.isEmpty()) {
            Rectangle b = mv.getBounds();
            b.grow(100, 100);
            Area a = new Area(b);
            for (Bounds bounds : this.data.getDataSourceBounds()) {
                if (bounds.isCollapsed()) continue;
                Point p1 = mv.getPoint(bounds.getMin());
                Point p2 = mv.getPoint(bounds.getMax());
                Rectangle r = new Rectangle(Math.min(p1.x, p2.x), Math.min(p1.y, p2.y), Math.abs(p2.x - p1.x), Math.abs(p2.y - p1.y));
                a.subtract(new Area(r));
            }
            g.setPaint(hatched);
            g.fill(a);
        }
        AbstractMapRenderer painter = MapRendererFactory.getInstance().createActiveRenderer(g, mv, inactive);
        painter.render(this.data, virtual, box);
        Main.map.conflictDialog.paintConflicts(g, mv);
    }

    @Override
    public String getToolTipText() {
        int nodes = new FilteredCollection<OsmPrimitive>((Collection<OsmPrimitive>)this.data.getNodes(), OsmPrimitive.nonDeletedPredicate).size();
        int ways = new FilteredCollection<OsmPrimitive>((Collection<OsmPrimitive>)this.data.getWays(), OsmPrimitive.nonDeletedPredicate).size();
        int rels = new FilteredCollection<OsmPrimitive>((Collection<OsmPrimitive>)this.data.getRelations(), OsmPrimitive.nonDeletedPredicate).size();
        String tool = I18n.trn("{0} node", "{0} nodes", nodes, nodes) + ", ";
        tool = tool + I18n.trn("{0} way", "{0} ways", ways, ways) + ", ";
        tool = tool + I18n.trn("{0} relation", "{0} relations", rels, rels);
        File f = this.getAssociatedFile();
        if (f != null) {
            tool = "<html>" + tool + "<br>" + f.getPath() + "</html>";
        }
        return tool;
    }

    @Override
    public void mergeFrom(Layer from) {
        PleaseWaitProgressMonitor monitor = new PleaseWaitProgressMonitor(I18n.tr("Merging layers", new Object[0]));
        monitor.setCancelable(false);
        if (from instanceof OsmDataLayer && ((OsmDataLayer)from).isUploadDiscouraged()) {
            this.setUploadDiscouraged(true);
        }
        this.mergeFrom(((OsmDataLayer)from).data, monitor);
        monitor.close();
    }

    public void mergeFrom(DataSet from) {
        this.mergeFrom(from, null);
    }

    public void mergeFrom(DataSet from, ProgressMonitor progressMonitor) {
        DataSetMerger visitor = new DataSetMerger(this.data, from);
        try {
            visitor.merge(progressMonitor);
        }
        catch (DataIntegrityProblemException e) {
            JOptionPane.showMessageDialog(Main.parent, e.getHtmlMessage() != null ? e.getHtmlMessage() : e.getMessage(), I18n.tr("Error", new Object[0]), 0);
            return;
        }
        Area a = this.data.getDataSourceArea();
        for (DataSource src : from.dataSources) {
            if (a != null && a.contains(src.bounds.asRect())) continue;
            this.data.dataSources.add(src);
        }
        if (this.data.getVersion() == null) {
            this.data.setVersion(from.getVersion());
        }
        int numNewConflicts = 0;
        for (Conflict<?> c : visitor.getConflicts()) {
            if (this.conflicts.hasConflict(c)) continue;
            ++numNewConflicts;
            this.conflicts.add(c);
        }
        if (Main.isDisplayingMapView()) {
            Main.map.mapView.repaint();
        }
        if (numNewConflicts > 0 && Main.map != null && Main.map.conflictDialog != null) {
            Main.map.conflictDialog.warnNumNewConflicts(numNewConflicts);
        }
    }

    @Override
    public boolean isMergable(Layer other) {
        return other instanceof OsmDataLayer;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor v) {
        for (Node n : this.data.getNodes()) {
            if (!n.isUsable()) continue;
            v.visit(n);
        }
    }

    public void cleanupAfterUpload(Collection<IPrimitive> processed) {
        if (processed == null || processed.isEmpty()) {
            return;
        }
        Main.main.undoRedo.clean(this);
        this.data.cleanupDeletedPrimitives();
        for (OsmPrimitive p : this.data.allPrimitives()) {
            if (!processed.contains(p)) continue;
            p.setModified(false);
        }
    }

    @Override
    public Object getInfoComponent() {
        DataCountVisitor counter = new DataCountVisitor();
        for (OsmPrimitive osm : this.data.allPrimitives()) {
            osm.accept(counter);
        }
        JPanel p = new JPanel(new GridBagLayout());
        String nodeText = I18n.trn("{0} node", "{0} nodes", counter.nodes, counter.nodes);
        if (counter.deletedNodes > 0) {
            nodeText = nodeText + " (" + I18n.trn("{0} deleted", "{0} deleted", counter.deletedNodes, counter.deletedNodes) + ")";
        }
        String wayText = I18n.trn("{0} way", "{0} ways", counter.ways, counter.ways);
        if (counter.deletedWays > 0) {
            wayText = wayText + " (" + I18n.trn("{0} deleted", "{0} deleted", counter.deletedWays, counter.deletedWays) + ")";
        }
        String relationText = I18n.trn("{0} relation", "{0} relations", counter.relations, counter.relations);
        if (counter.deletedRelations > 0) {
            relationText = relationText + " (" + I18n.trn("{0} deleted", "{0} deleted", counter.deletedRelations, counter.deletedRelations) + ")";
        }
        p.add((Component)new JLabel(I18n.tr("{0} consists of:", this.getName())), GBC.eol());
        p.add((Component)new JLabel(nodeText, ImageProvider.get("data", "node"), 0), GBC.eop().insets(15, 0, 0, 0));
        p.add((Component)new JLabel(wayText, ImageProvider.get("data", "way"), 0), GBC.eop().insets(15, 0, 0, 0));
        p.add((Component)new JLabel(relationText, ImageProvider.get("data", "relation"), 0), GBC.eop().insets(15, 0, 0, 0));
        p.add((Component)new JLabel(I18n.tr("API version: {0}", this.data.getVersion() != null ? this.data.getVersion() : I18n.tr("unset", new Object[0]))), GBC.eop().insets(15, 0, 0, 0));
        if (this.isUploadDiscouraged()) {
            p.add((Component)new JLabel(I18n.tr("Upload is discouraged", new Object[0])), GBC.eop().insets(15, 0, 0, 0));
        }
        return p;
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.addAll(Arrays.asList(LayerListDialog.getInstance().createActivateLayerAction(this), LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, LayerListDialog.getInstance().createMergeLayerAction(this), new Layer.LayerSaveAction(this), new Layer.LayerSaveAsAction(this)));
        if (ExpertToggleAction.isExpert()) {
            actions.addAll(Arrays.asList(new Layer.LayerGpxExportAction(this), new ConvertToGpxLayerAction()));
        }
        actions.addAll(Arrays.asList(Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(this.getAssociatedFile(), this)));
        if (ExpertToggleAction.isExpert() && Main.pref.getBoolean("data.layer.upload_discouragement.menu_item", false)) {
            actions.add(new ToggleUploadDiscouragedLayerAction(this));
        }
        actions.addAll(Arrays.asList(new ConsistencyTestAction(), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction(this)));
        return actions.toArray(new Action[actions.size()]);
    }

    public static GpxData toGpxData(DataSet data, File file) {
        GpxData gpxData = new GpxData();
        gpxData.storageFile = file;
        HashSet<Node> doneNodes = new HashSet<Node>();
        OsmDataLayer.waysToGpxData(data.getWays(), gpxData, doneNodes);
        OsmDataLayer.nodesToGpxData(data.getNodes(), gpxData, doneNodes);
        return gpxData;
    }

    private static void waysToGpxData(Collection<Way> ways, GpxData gpxData, HashSet<Node> doneNodes) {
        for (Way w : ways) {
            if (!w.isUsable()) continue;
            ArrayList<Collection<WayPoint>> trk = new ArrayList<Collection<WayPoint>>();
            HashMap<String, Object> trkAttr = new HashMap<String, Object>();
            if (w.get("name") != null) {
                trkAttr.put("name", w.get("name"));
            }
            ArrayList<WayPoint> trkseg = null;
            for (Node n : w.getNodes()) {
                if (!n.isUsable()) {
                    trkseg = null;
                    continue;
                }
                if (trkseg == null) {
                    trkseg = new ArrayList<WayPoint>();
                    trk.add(trkseg);
                }
                if (!n.isTagged()) {
                    doneNodes.add(n);
                }
                trkseg.add(OsmDataLayer.nodeToWayPoint(n));
            }
            gpxData.tracks.add(new ImmutableGpxTrack(trk, trkAttr));
        }
    }

    private static WayPoint nodeToWayPoint(Node n) {
        WayPoint wpt = new WayPoint(n.getCoor());
        OsmDataLayer.addDoubleIfPresent(wpt, n, "ele", new String[0]);
        if (!n.isTimestampEmpty()) {
            wpt.put("time", DateUtils.fromDate(n.getTimestamp()));
            wpt.setTime();
        }
        OsmDataLayer.addDoubleIfPresent(wpt, n, "magvar", new String[0]);
        OsmDataLayer.addDoubleIfPresent(wpt, n, "geoidheight", new String[0]);
        OsmDataLayer.addStringIfPresent(wpt, n, "name", new String[0]);
        OsmDataLayer.addStringIfPresent(wpt, n, "desc", "description");
        OsmDataLayer.addStringIfPresent(wpt, n, "cmt", "comment");
        OsmDataLayer.addStringIfPresent(wpt, n, "src", "source", "source:position");
        ArrayList<GpxLink> links = new ArrayList<GpxLink>();
        for (String key : new String[]{"link", "url", "website", "contact:website"}) {
            String value = n.get(key);
            if (value == null) continue;
            links.add(new GpxLink(value));
        }
        wpt.put("meta.links", links);
        OsmDataLayer.addStringIfPresent(wpt, n, "sym", "wpt_symbol");
        OsmDataLayer.addStringIfPresent(wpt, n, "type", new String[0]);
        OsmDataLayer.addStringIfPresent(wpt, n, "fix", "gps:fix");
        OsmDataLayer.addIntegerIfPresent(wpt, n, "sat", "gps:sat");
        OsmDataLayer.addDoubleIfPresent(wpt, n, "hdop", "gps:hdop");
        OsmDataLayer.addDoubleIfPresent(wpt, n, "vdop", "gps:vdop");
        OsmDataLayer.addDoubleIfPresent(wpt, n, "pdop", "gps:pdop");
        OsmDataLayer.addDoubleIfPresent(wpt, n, "ageofdgpsdata", "gps:ageofdgpsdata");
        OsmDataLayer.addIntegerIfPresent(wpt, n, "dgpsid", "gps:dgpsid");
        return wpt;
    }

    private static void nodesToGpxData(Collection<Node> nodes, GpxData gpxData, HashSet<Node> doneNodes) {
        ArrayList<Node> sortedNodes = new ArrayList<Node>(nodes);
        sortedNodes.removeAll(doneNodes);
        Collections.sort(sortedNodes);
        for (Node n : sortedNodes) {
            if (n.isIncomplete() || n.isDeleted()) continue;
            gpxData.waypoints.add(OsmDataLayer.nodeToWayPoint(n));
        }
    }

    private static void addIntegerIfPresent(WayPoint wpt, OsmPrimitive p, String gpxKey, String ... osmKeys) {
        ArrayList<String> possibleKeys = new ArrayList<String>(Arrays.asList(osmKeys));
        possibleKeys.add(0, gpxKey);
        for (String key : possibleKeys) {
            String value = p.get(key);
            if (value == null) continue;
            try {
                int i = Integer.parseInt(value);
                if ("sat".equals(gpxKey) && i < 0 || "dgpsid".equals(gpxKey) && (0 > i || i > 1023)) continue;
                wpt.put(gpxKey, value);
                break;
            }
            catch (NumberFormatException e) {
                if (!Main.isTraceEnabled()) continue;
                Main.trace(e.getMessage());
            }
        }
    }

    private static void addDoubleIfPresent(WayPoint wpt, OsmPrimitive p, String gpxKey, String ... osmKeys) {
        ArrayList<String> possibleKeys = new ArrayList<String>(Arrays.asList(osmKeys));
        possibleKeys.add(0, gpxKey);
        for (String key : possibleKeys) {
            String value = p.get(key);
            if (value == null) continue;
            try {
                double d = Double.parseDouble(value);
                if ("magvar".equals(gpxKey) && (!(0.0 <= d) || !(d < 360.0))) continue;
                wpt.put(gpxKey, value);
                break;
            }
            catch (NumberFormatException e) {
                if (!Main.isTraceEnabled()) continue;
                Main.trace(e.getMessage());
            }
        }
    }

    private static void addStringIfPresent(WayPoint wpt, OsmPrimitive p, String gpxKey, String ... osmKeys) {
        ArrayList<String> possibleKeys = new ArrayList<String>(Arrays.asList(osmKeys));
        possibleKeys.add(0, gpxKey);
        for (String key : possibleKeys) {
            String value = p.get(key);
            if (value == null || "fix".equals(gpxKey) && !GpxConstants.FIX_VALUES.contains(value)) continue;
            wpt.put(gpxKey, value);
            break;
        }
    }

    public GpxData toGpxData() {
        return OsmDataLayer.toGpxData(this.data, this.getAssociatedFile());
    }

    public boolean containsPoint(LatLon coor) {
        if (this.data.dataSources.isEmpty()) {
            return true;
        }
        boolean layer_bounds_point = false;
        for (DataSource src : this.data.dataSources) {
            if (!src.bounds.contains(coor)) continue;
            layer_bounds_point = true;
            break;
        }
        return layer_bounds_point;
    }

    public ConflictCollection getConflicts() {
        return this.conflicts;
    }

    @Override
    public boolean requiresUploadToServer() {
        return this.requiresUploadToServer;
    }

    @Override
    public boolean requiresSaveToFile() {
        return this.getAssociatedFile() != null && this.requiresSaveToFile;
    }

    @Override
    public void onPostLoadFromFile() {
        this.setRequiresSaveToFile(false);
        this.setRequiresUploadToServer(this.isModified());
    }

    public void onPostDownloadFromServer() {
        this.setRequiresSaveToFile(true);
        this.setRequiresUploadToServer(this.isModified());
    }

    @Override
    public boolean isChanged() {
        return this.isChanged || this.highlightUpdateCount != this.data.getHighlightUpdateCount();
    }

    @Override
    public void onPostSaveToFile() {
        this.setRequiresSaveToFile(false);
        this.setRequiresUploadToServer(this.isModified());
    }

    @Override
    public void onPostUploadToServer() {
        this.setRequiresUploadToServer(this.isModified());
    }

    @Override
    public void destroy() {
        DataSet.removeSelectionListener(this);
    }

    @Override
    public void processDatasetEvent(AbstractDatasetChangedEvent event) {
        this.isChanged = true;
        this.setRequiresSaveToFile(true);
        this.setRequiresUploadToServer(true);
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        this.isChanged = true;
    }

    @Override
    public void projectionChanged(Projection oldValue, Projection newValue) {
    }

    @Override
    public final boolean isUploadDiscouraged() {
        return this.data.isUploadDiscouraged();
    }

    public final void setUploadDiscouraged(boolean uploadDiscouraged) {
        if (uploadDiscouraged ^ this.isUploadDiscouraged()) {
            this.data.setUploadDiscouraged(uploadDiscouraged);
            for (LayerStateChangeListener l : this.layerStateChangeListeners) {
                l.uploadDiscouragedChanged(this, uploadDiscouraged);
            }
        }
    }

    @Override
    public final boolean isModified() {
        return this.data.isModified();
    }

    @Override
    public boolean isSavable() {
        return true;
    }

    @Override
    public boolean checkSaveConditions() {
        if (this.isDataSetEmpty() && 1 != GuiHelper.runInEDTAndWaitAndReturn(new Callable<Integer>(){

            @Override
            public Integer call() {
                ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr("Empty document", new Object[0]), new String[]{I18n.tr("Save anyway", new Object[0]), I18n.tr("Cancel", new Object[0])});
                dialog.setContent(I18n.tr("The document contains no data.", new Object[0]));
                dialog.setButtonIcons(new String[]{"save", "cancel"});
                return dialog.showDialog().getValue();
            }
        })) {
            return false;
        }
        ConflictCollection conflicts = this.getConflicts();
        return conflicts == null || conflicts.isEmpty() || 1 == GuiHelper.runInEDTAndWaitAndReturn(new Callable<Integer>(){

            @Override
            public Integer call() {
                ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr("Conflicts", new Object[0]), new String[]{I18n.tr("Reject Conflicts and Save", new Object[0]), I18n.tr("Cancel", new Object[0])});
                dialog.setContent(I18n.tr("There are unresolved conflicts. Conflicts will not be saved and handled as if you rejected all. Continue?", new Object[0]));
                dialog.setButtonIcons(new String[]{"save", "cancel"});
                return dialog.showDialog().getValue();
            }
        });
    }

    private boolean isDataSetEmpty() {
        if (this.data != null) {
            for (OsmPrimitive osm : this.data.allNonDeletedPrimitives()) {
                if (osm.isDeleted() && osm.isNewOrUndeleted()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public File createAndOpenSaveFileChooser() {
        return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save OSM file", new Object[0]), "osm");
    }

    @Override
    public AbstractIOTask createUploadTask(ProgressMonitor monitor) {
        UploadDialog dialog = UploadDialog.getUploadDialog();
        return new UploadLayerTask(dialog.getUploadStrategySpecification(), this, monitor, dialog.getChangeset());
    }

    @Override
    public AbstractUploadDialog getUploadDialog() {
        UploadDialog dialog = UploadDialog.getUploadDialog();
        dialog.setUploadedPrimitives(new APIDataSet(this.data));
        return dialog;
    }

    static {
        OsmDataLayer.createHatchTexture();
    }

    private class ConsistencyTestAction
    extends AbstractAction {
        public ConsistencyTestAction() {
            super(I18n.tr("Dataset consistency test", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String result = DatasetConsistencyTest.runTests(OsmDataLayer.this.data);
            if (result.length() == 0) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("No problems found", new Object[0]));
            } else {
                JPanel p = new JPanel(new GridBagLayout());
                p.add((Component)new JLabel(I18n.tr("Following problems found:", new Object[0])), GBC.eol());
                JosmTextArea info = new JosmTextArea(result, 20, 60);
                info.setCaretPosition(0);
                info.setEditable(false);
                p.add((Component)new JScrollPane(info), GBC.eop());
                JOptionPane.showMessageDialog(Main.parent, p, I18n.tr("Warning", new Object[0]), 2);
            }
        }
    }

    public class ConvertToGpxLayerAction
    extends AbstractAction {
        public ConvertToGpxLayerAction() {
            super(I18n.tr("Convert to GPX layer", new Object[0]), ImageProvider.get("converttogpx"));
            this.putValue("help", HelpUtil.ht("/Action/ConvertToGpxLayer"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Main.main.addLayer(new GpxLayer(OsmDataLayer.this.toGpxData(), I18n.tr("Converted from: {0}", OsmDataLayer.this.getName())));
            Main.main.removeLayer(OsmDataLayer.this);
        }
    }

    public static interface LayerStateChangeListener {
        public void uploadDiscouragedChanged(OsmDataLayer var1, boolean var2);
    }

    public static interface CommandQueueListener {
        public void commandChanged(int var1, int var2);
    }

    public static final class DataCountVisitor
    extends AbstractVisitor {
        public int nodes;
        public int ways;
        public int relations;
        public int deletedNodes;
        public int deletedWays;
        public int deletedRelations;

        @Override
        public void visit(Node n) {
            ++this.nodes;
            if (n.isDeleted()) {
                ++this.deletedNodes;
            }
        }

        @Override
        public void visit(Way w) {
            ++this.ways;
            if (w.isDeleted()) {
                ++this.deletedWays;
            }
        }

        @Override
        public void visit(Relation r) {
            ++this.relations;
            if (r.isDeleted()) {
                ++this.deletedRelations;
            }
        }
    }
}

