/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToolTip;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.notes.NoteComment;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.dialogs.NotesDialog;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.io.NoteExporter;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.I18n;

public class NoteLayer
extends AbstractModifiableLayer
implements MouseListener {
    private final NoteData noteData;

    public NoteLayer(List<Note> notes, String name) {
        super(name);
        this.noteData = new NoteData(notes);
    }

    public NoteLayer() {
        super(I18n.tr("Notes", new Object[0]));
        this.noteData = new NoteData();
    }

    @Override
    public void hookUpMapView() {
        Main.map.mapView.addMouseListener(this);
    }

    public NoteData getNoteData() {
        return this.noteData;
    }

    @Override
    public boolean isModified() {
        return this.noteData.isModified();
    }

    @Override
    public boolean requiresUploadToServer() {
        return this.isModified();
    }

    @Override
    public boolean isSavable() {
        return true;
    }

    @Override
    public boolean requiresSaveToFile() {
        Main.debug("associated notes file: " + this.getAssociatedFile());
        return this.getAssociatedFile() != null && this.isModified();
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds box) {
        for (Note note : this.noteData.getNotes()) {
            Point p = mv.getPoint(note.getLatLon());
            ImageIcon icon = null;
            icon = note.getId() < 0L ? NotesDialog.ICON_NEW_SMALL : (note.getState() == Note.State.closed ? NotesDialog.ICON_CLOSED_SMALL : NotesDialog.ICON_OPEN_SMALL);
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            g.drawImage(icon.getImage(), p.x - width / 2, p.y - height, Main.map.mapView);
        }
        if (this.noteData.getSelectedNote() != null) {
            StringBuilder sb = new StringBuilder("<html>");
            sb.append(I18n.tr("Note", new Object[0]));
            sb.append(" " + this.noteData.getSelectedNote().getId());
            List<NoteComment> comments = this.noteData.getSelectedNote().getComments();
            SimpleDateFormat dayFormat = new SimpleDateFormat("MMM d, yyyy");
            for (NoteComment comment : comments) {
                String commentText = comment.getText();
                if (commentText == null || commentText.trim().length() <= 0) continue;
                sb.append("<hr/>");
                String userName = XmlWriter.encode(comment.getUser().getName());
                if (userName == null || userName.trim().length() == 0) {
                    userName = "&lt;Anonymous&gt;";
                }
                sb.append(userName);
                sb.append(" on ");
                sb.append(dayFormat.format(comment.getCommentTimestamp()));
                sb.append(":<br/>");
                String htmlText = XmlWriter.encode(comment.getText(), true);
                htmlText = htmlText.replace("&#xA;", "<br/>");
                sb.append(htmlText);
            }
            sb.append("</html>");
            JToolTip toolTip = new JToolTip();
            toolTip.setTipText(sb.toString());
            Point p = mv.getPoint(this.noteData.getSelectedNote().getLatLon());
            g.setColor(ColorHelper.html2color(Main.pref.get("color.selected")));
            g.drawRect(p.x - 8, p.y - 16, 15, 15);
            int tx = p.x + 8 + 5;
            int ty = p.y - 16 - 1;
            g.translate(tx, ty);
            for (int x = 0; x < 2; ++x) {
                Dimension d = toolTip.getUI().getPreferredSize(toolTip);
                d.width = Math.min(d.width, mv.getWidth() * 1 / 2);
                if (d.width <= 0 || d.height <= 0) continue;
                toolTip.setSize(d);
                try {
                    toolTip.paint(g);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    Main.error(e, false);
                }
            }
            g.translate(-tx, -ty);
        }
    }

    @Override
    public Icon getIcon() {
        return NotesDialog.ICON_OPEN_SMALL;
    }

    @Override
    public String getToolTipText() {
        return this.noteData.getNotes().size() + " " + I18n.tr("Notes", new Object[0]);
    }

    @Override
    public void mergeFrom(Layer from) {
        throw new UnsupportedOperationException("Notes layer does not support merging yet");
    }

    @Override
    public boolean isMergable(Layer other) {
        return false;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    @Override
    public Object getInfoComponent() {
        StringBuilder sb = new StringBuilder();
        sb.append(I18n.tr("Notes layer", new Object[0]));
        sb.append("\n");
        sb.append(I18n.tr("Total notes:", new Object[0]));
        sb.append(" ");
        sb.append(this.noteData.getNotes().size());
        sb.append("\n");
        sb.append(I18n.tr("Changes need uploading?", new Object[0]));
        sb.append(" ");
        sb.append(this.isModified());
        return sb.toString();
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
        actions.add(LayerListDialog.getInstance().createShowHideLayerAction());
        actions.add(LayerListDialog.getInstance().createDeleteLayerAction());
        actions.add(new LayerListPopup.InfoAction(this));
        actions.add(new Layer.LayerSaveAction(this));
        actions.add(new Layer.LayerSaveAsAction(this));
        return actions.toArray(new Action[actions.size()]);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        Point clickPoint = e.getPoint();
        double snapDistance = 10.0;
        double minDistance = Double.MAX_VALUE;
        Note closestNote = null;
        for (Note note : this.noteData.getNotes()) {
            Point notePoint = Main.map.mapView.getPoint(note.getLatLon());
            notePoint.setLocation(notePoint.getX(), notePoint.getY() - 8.0);
            double dist = clickPoint.distanceSq(notePoint);
            if (!(minDistance > dist) || !(clickPoint.distance(notePoint) < snapDistance)) continue;
            minDistance = dist;
            closestNote = note;
        }
        this.noteData.setSelectedNote(closestNote);
    }

    @Override
    public File createAndOpenSaveFileChooser() {
        return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save GPX file", new Object[0]), NoteExporter.FILE_FILTER);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

