/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.GpxExportAction;
import org.openstreetmap.josm.actions.SaveAction;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.actions.SaveAsAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionChangeListener;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public abstract class Layer
implements ProjectionChangeListener,
MapViewPaintable,
Destroyable {
    public static final String VISIBLE_PROP = Layer.class.getName() + ".visible";
    public static final String OPACITY_PROP = Layer.class.getName() + ".opacity";
    public static final String NAME_PROP = Layer.class.getName() + ".name";
    public static final int ICON_SIZE = 16;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private boolean visible = true;
    private double opacity = 1.0;
    private boolean background = false;
    private String name;
    private File associatedFile;

    public Layer(String name) {
        this.setName(name);
    }

    public void hookUpMapView() {
    }

    @Override
    public abstract void paint(Graphics2D var1, MapView var2, Bounds var3);

    public abstract Icon getIcon();

    public Color getColor(boolean ignoreCustom) {
        return null;
    }

    public abstract String getToolTipText();

    public abstract void mergeFrom(Layer var1);

    public abstract boolean isMergable(Layer var1);

    public abstract void visitBoundingBox(BoundingXYVisitor var1);

    public abstract Object getInfoComponent();

    public boolean isInfoResizable() {
        return false;
    }

    public abstract Action[] getMenuEntries();

    @Override
    public void destroy() {
    }

    public File getAssociatedFile() {
        return this.associatedFile;
    }

    public void setAssociatedFile(File file) {
        this.associatedFile = file;
    }

    public String getName() {
        return this.name;
    }

    public final void setName(String name) {
        if (name == null) {
            name = "";
        }
        String oldValue = this.name;
        this.name = name;
        if (!this.name.equals(oldValue)) {
            this.propertyChangeSupport.firePropertyChange(NAME_PROP, oldValue, this.name);
        }
    }

    public boolean isBackgroundLayer() {
        return this.background;
    }

    public void setBackgroundLayer(boolean background) {
        this.background = background;
    }

    public void setVisible(boolean visible) {
        boolean oldValue = this.isVisible();
        this.visible = visible;
        if (visible && this.opacity == 0.0) {
            this.setOpacity(1.0);
        } else if (oldValue != this.isVisible()) {
            this.fireVisibleChanged(oldValue, this.isVisible());
        }
    }

    public boolean isVisible() {
        return this.visible && this.opacity != 0.0;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double opacity) {
        if (!(opacity >= 0.0) || !(opacity <= 1.0)) {
            throw new IllegalArgumentException("Opacity value must be between 0 and 1");
        }
        double oldOpacity = this.getOpacity();
        boolean oldVisible = this.isVisible();
        this.opacity = opacity;
        if (oldOpacity != this.getOpacity()) {
            this.fireOpacityChanged(oldOpacity, this.getOpacity());
        }
        if (oldVisible != this.isVisible()) {
            this.fireVisibleChanged(oldVisible, this.isVisible());
        }
    }

    public void toggleVisible() {
        this.setVisible(!this.isVisible());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    protected void fireVisibleChanged(boolean oldValue, boolean newValue) {
        this.propertyChangeSupport.firePropertyChange(VISIBLE_PROP, oldValue, newValue);
    }

    protected void fireOpacityChanged(double oldValue, double newValue) {
        this.propertyChangeSupport.firePropertyChange(OPACITY_PROP, oldValue, newValue);
    }

    public boolean isChanged() {
        return true;
    }

    public boolean isProjectionSupported(Projection proj) {
        return true;
    }

    public String nameSupportedProjections() {
        return I18n.tr("All projections are supported", new Object[0]);
    }

    @Override
    public void projectionChanged(Projection oldValue, Projection newValue) {
        if (!this.isProjectionSupported(newValue)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("The layer {0} does not support the new projection {1}.\n{2}\nChange the projection again or remove the layer.", this.getName(), newValue.toCode(), this.nameSupportedProjections()), I18n.tr("Warning", new Object[0]), 2);
        }
    }

    public void onPostLoadFromFile() {
    }

    public boolean isSavable() {
        return false;
    }

    public boolean checkSaveConditions() {
        return true;
    }

    public File createAndOpenSaveFileChooser() {
        return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save Layer", new Object[0]), "lay");
    }

    public static class LayerGpxExportAction
    extends AbstractAction {
        private Layer layer;

        public LayerGpxExportAction(Layer layer) {
            this.putValue("SmallIcon", ImageProvider.get("exportgpx"));
            this.putValue("ShortDescription", I18n.tr("Export the data to GPX file.", new Object[0]));
            this.putValue("Name", I18n.tr("Export to GPX...", new Object[0]));
            this.setEnabled(true);
            this.layer = layer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new GpxExportAction().export(this.layer);
        }
    }

    public static class LayerSaveAsAction
    extends AbstractAction {
        private Layer layer;

        public LayerSaveAsAction(Layer layer) {
            this.putValue("SmallIcon", ImageProvider.get("save_as"));
            this.putValue("ShortDescription", I18n.tr("Save the current data to a new file.", new Object[0]));
            this.putValue("Name", I18n.tr("Save As...", new Object[0]));
            this.setEnabled(true);
            this.layer = layer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SaveAsAction.getInstance().doSave(this.layer);
        }
    }

    public static class LayerSaveAction
    extends AbstractAction {
        private Layer layer;

        public LayerSaveAction(Layer layer) {
            this.putValue("SmallIcon", ImageProvider.get("save"));
            this.putValue("ShortDescription", I18n.tr("Save the current data.", new Object[0]));
            this.putValue("Name", I18n.tr("Save", new Object[0]));
            this.setEnabled(true);
            this.layer = layer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SaveAction.getInstance().doSave(this.layer);
        }
    }

    public static class SeparatorLayerAction
    extends AbstractAction
    implements LayerAction {
        public static final SeparatorLayerAction INSTANCE = new SeparatorLayerAction();

        @Override
        public void actionPerformed(ActionEvent e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Component createMenuComponent() {
            return new JSeparator();
        }

        @Override
        public boolean supportLayers(List<Layer> layers) {
            return false;
        }
    }

    public static interface MultiLayerAction {
        public Action getMultiLayerAction(List<Layer> var1);
    }

    public static interface LayerAction {
        public boolean supportLayers(List<Layer> var1);

        public Component createMenuComponent();
    }
}

