/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ImageryAdjustAction;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.data.preferences.ColorProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.MenuScroller;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public abstract class ImageryLayer
extends Layer {
    public static final ColorProperty PROP_FADE_COLOR = new ColorProperty(I18n.marktr("Imagery fade"), Color.white);
    public static final IntegerProperty PROP_FADE_AMOUNT = new IntegerProperty("imagery.fade_amount", 0);
    public static final IntegerProperty PROP_SHARPEN_LEVEL = new IntegerProperty("imagery.sharpen_level", 0);
    protected final ImageryInfo info;
    protected Icon icon;
    protected double dx = 0.0;
    protected double dy = 0.0;
    protected int sharpenLevel;
    private final ImageryAdjustAction adjustAction = new ImageryAdjustAction(this);

    public static Color getFadeColor() {
        return PROP_FADE_COLOR.get();
    }

    public static Color getFadeColorWithAlpha() {
        Color c = PROP_FADE_COLOR.get();
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), PROP_FADE_AMOUNT.get() * 255 / 100);
    }

    public ImageryLayer(ImageryInfo info) {
        super(info.getName());
        this.info = info;
        if (info.getIcon() != null) {
            this.icon = new ImageProvider(info.getIcon()).setOptional(true).setMaxHeight(16).setMaxWidth(16).get();
        }
        if (this.icon == null) {
            this.icon = ImageProvider.get("imagery_small");
        }
        this.sharpenLevel = PROP_SHARPEN_LEVEL.get();
    }

    public double getPPD() {
        if (!Main.isDisplayingMapView()) {
            return Main.getProjection().getDefaultZoomInPPD();
        }
        ProjectionBounds bounds = Main.map.mapView.getProjectionBounds();
        return (double)Main.map.mapView.getWidth() / (bounds.maxEast - bounds.minEast);
    }

    public double getDx() {
        return this.dx;
    }

    public double getDy() {
        return this.dy;
    }

    public void setOffset(double dx, double dy) {
        this.dx = dx;
        this.dy = dy;
    }

    public void displace(double dx, double dy) {
        this.setOffset(this.dx += dx, this.dy += dy);
    }

    public ImageryInfo getInfo() {
        return this.info;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public boolean isMergable(Layer other) {
        return false;
    }

    @Override
    public void mergeFrom(Layer from) {
    }

    @Override
    public Object getInfoComponent() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(this.getToolTipText()), GBC.eol());
        if (this.info != null) {
            String url = this.info.getUrl();
            if (url != null) {
                panel.add((Component)new JLabel(I18n.tr("URL: ", new Object[0])), GBC.std().insets(0, 5, 2, 0));
                panel.add((Component)new UrlLabel(url), GBC.eol().insets(2, 5, 10, 0));
            }
            if (this.dx != 0.0 || this.dy != 0.0) {
                panel.add((Component)new JLabel(I18n.tr("Offset: ", new Object[0]) + this.dx + ";" + this.dy), GBC.eol().insets(0, 5, 10, 0));
            }
        }
        return panel;
    }

    public static ImageryLayer create(ImageryInfo info) {
        if (info.getImageryType() == ImageryInfo.ImageryType.WMS || info.getImageryType() == ImageryInfo.ImageryType.HTML) {
            return new WMSLayer(info);
        }
        if (info.getImageryType() == ImageryInfo.ImageryType.TMS || info.getImageryType() == ImageryInfo.ImageryType.BING || info.getImageryType() == ImageryInfo.ImageryType.SCANEX) {
            return new TMSLayer(info);
        }
        throw new AssertionError();
    }

    public JMenuItem getOffsetMenuItem() {
        JMenu subMenu = new JMenu(I18n.trc("layer", "Offset"));
        subMenu.setIcon(ImageProvider.get("mapmode", "adjustimg"));
        return (JMenuItem)this.getOffsetMenuItem(subMenu);
    }

    public JComponent getOffsetMenuItem(JComponent subMenu) {
        JMenuItem adjustMenuItem = new JMenuItem(this.adjustAction);
        if (OffsetBookmark.allBookmarks.isEmpty()) {
            return adjustMenuItem;
        }
        subMenu.add(adjustMenuItem);
        subMenu.add(new JSeparator());
        boolean hasBookmarks = false;
        int menuItemHeight = 0;
        for (OffsetBookmark b : OffsetBookmark.allBookmarks) {
            if (!b.isUsable(this)) continue;
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(new ApplyOffsetAction(b));
            if (b.dx == this.dx && b.dy == this.dy) {
                item.setSelected(true);
            }
            subMenu.add(item);
            menuItemHeight = item.getPreferredSize().height;
            hasBookmarks = true;
        }
        if (menuItemHeight > 0) {
            if (subMenu instanceof JMenu) {
                MenuScroller.setScrollerFor((JMenu)subMenu);
            } else if (subMenu instanceof JPopupMenu) {
                MenuScroller.setScrollerFor((JPopupMenu)subMenu);
            }
        }
        return hasBookmarks ? subMenu : adjustMenuItem;
    }

    public BufferedImage sharpenImage(BufferedImage img) {
        if (this.sharpenLevel <= 0) {
            return img;
        }
        int width = img.getWidth(null);
        int height = img.getHeight(null);
        BufferedImage tmp = new BufferedImage(width, height, 1);
        tmp.getGraphics().drawImage(img, 0, 0, null);
        Kernel kernel = this.sharpenLevel == 1 ? new Kernel(3, 3, new float[]{-0.25f, -0.5f, -0.25f, -0.5f, 4.0f, -0.5f, -0.25f, -0.5f, -0.25f}) : new Kernel(3, 3, new float[]{-0.5f, -1.0f, -0.5f, -1.0f, 7.0f, -1.0f, -0.5f, -1.0f, -0.5f});
        ConvolveOp op = new ConvolveOp(kernel, 1, null);
        return op.filter(tmp, null);
    }

    public void drawErrorTile(BufferedImage img, String message) {
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setColor(Color.RED);
        g.fillRect(0, 0, img.getWidth(), img.getHeight());
        g.setFont(g.getFont().deriveFont(0).deriveFont(24.0f));
        g.setColor(Color.BLACK);
        String text = I18n.tr("ERROR", new Object[0]);
        g.drawString(text, (img.getWidth() - g.getFontMetrics().stringWidth(text)) / 2, g.getFontMetrics().getHeight() + 5);
        if (message != null) {
            float drawPosY = 2.5f * (float)g.getFontMetrics().getHeight() + 10.0f;
            if (!message.contains(" ")) {
                g.setFont(g.getFont().deriveFont(0).deriveFont(18.0f));
                g.drawString(message, 5, (int)drawPosY);
            } else {
                Hashtable<TextAttribute, Object> map = new Hashtable<TextAttribute, Object>();
                map.put(TextAttribute.FAMILY, "Serif");
                map.put(TextAttribute.SIZE, new Float(18.0));
                AttributedString vanGogh = new AttributedString(message, map);
                AttributedCharacterIterator paragraph = vanGogh.getIterator();
                int paragraphStart = paragraph.getBeginIndex();
                int paragraphEnd = paragraph.getEndIndex();
                FontRenderContext frc = g.getFontRenderContext();
                LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(paragraph, frc);
                float breakWidth = img.getWidth() - 10;
                lineMeasurer.setPosition(paragraphStart);
                while (lineMeasurer.getPosition() < paragraphEnd) {
                    TextLayout layout = lineMeasurer.nextLayout(breakWidth);
                    float drawPosX = layout.isLeftToRight() ? 0.0f : breakWidth - layout.getAdvance();
                    layout.draw(g, drawPosX, drawPosY += layout.getAscent());
                    drawPosY += layout.getDescent() + layout.getLeading();
                }
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.adjustAction.destroy();
    }

    public class OffsetAction
    extends AbstractAction
    implements Layer.LayerAction {
        @Override
        public void actionPerformed(ActionEvent e) {
        }

        @Override
        public Component createMenuComponent() {
            return ImageryLayer.this.getOffsetMenuItem();
        }

        @Override
        public boolean supportLayers(List<Layer> layers) {
            return false;
        }
    }

    class ApplyOffsetAction
    extends AbstractAction {
        private OffsetBookmark b;

        ApplyOffsetAction(OffsetBookmark b) {
            super(b.name);
            this.b = b;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            ImageryLayer.this.setOffset(this.b.dx, this.b.dy);
            Main.main.menu.imageryMenu.refreshOffsetMenu();
            Main.map.repaint();
        }
    }
}

