/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.CustomizeColor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.gpx.ChooseTrackVisibilityAction;
import org.openstreetmap.josm.gui.layer.gpx.ConvertToDataLayerAction;
import org.openstreetmap.josm.gui.layer.gpx.CustomizeDrawingAction;
import org.openstreetmap.josm.gui.layer.gpx.DownloadAlongTrackAction;
import org.openstreetmap.josm.gui.layer.gpx.DownloadWmsAlongTrackAction;
import org.openstreetmap.josm.gui.layer.gpx.GpxDrawHelper;
import org.openstreetmap.josm.gui.layer.gpx.ImportAudioAction;
import org.openstreetmap.josm.gui.layer.gpx.ImportImagesAction;
import org.openstreetmap.josm.gui.layer.gpx.MarkersFromNamedPointsAction;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.io.GpxImporter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.date.DateUtils;

public class GpxLayer
extends Layer {
    public GpxData data;
    private boolean isLocalFile;
    public boolean[] trackVisibility = new boolean[0];
    private final List<GpxTrack> lastTracks = new ArrayList<GpxTrack>();
    private int lastUpdateCount;
    private final GpxDrawHelper drawHelper;

    public GpxLayer(GpxData d) {
        super(d.getString("meta.name"));
        this.data = d;
        this.drawHelper = new GpxDrawHelper(this.data);
        this.ensureTrackVisibilityLength();
    }

    public GpxLayer(GpxData d, String name) {
        this(d);
        this.setName(name);
    }

    public GpxLayer(GpxData d, String name, boolean isLocal) {
        this(d);
        this.setName(name);
        this.isLocalFile = isLocal;
    }

    @Override
    public Color getColor(boolean ignoreCustom) {
        return this.drawHelper.getColor(this.getName(), ignoreCustom);
    }

    public static String getTimespanForTrack(GpxTrack trk) {
        Date[] bounds = GpxData.getMinMaxTimeForTrack(trk);
        String ts = "";
        if (bounds != null) {
            String latestDate;
            DateFormat df = DateUtils.getDateFormat(3);
            String earliestDate = df.format(bounds[0]);
            if (earliestDate.equals(latestDate = df.format(bounds[1]))) {
                DateFormat tf = DateUtils.getTimeFormat(3);
                ts = ts + earliestDate + " ";
                ts = ts + tf.format(bounds[0]) + " - " + tf.format(bounds[1]);
            } else {
                DateFormat dtf = DateUtils.getDateTimeFormat(3, 2);
                ts = ts + dtf.format(bounds[0]) + " - " + dtf.format(bounds[1]);
            }
            int diff = (int)(bounds[1].getTime() - bounds[0].getTime()) / 1000;
            ts = ts + String.format(" (%d:%02d)", diff / 3600, diff % 3600 / 60);
        }
        return ts;
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "gpx_small");
    }

    @Override
    public Object getInfoComponent() {
        StringBuilder info = new StringBuilder();
        if (this.data.attr.containsKey("name")) {
            info.append(I18n.tr("Name: {0}", this.data.get("meta.name"))).append("<br>");
        }
        if (this.data.attr.containsKey("desc")) {
            info.append(I18n.tr("Description: {0}", this.data.get("meta.desc"))).append("<br>");
        }
        if (!this.data.tracks.isEmpty()) {
            info.append("<table><thead align='center'><tr><td colspan='5'>" + I18n.trn("{0} track", "{0} tracks", this.data.tracks.size(), this.data.tracks.size()) + "</td></tr><tr align='center'><td>" + I18n.tr("Name", new Object[0]) + "</td><td>" + I18n.tr("Description", new Object[0]) + "</td><td>" + I18n.tr("Timespan", new Object[0]) + "</td><td>" + I18n.tr("Length", new Object[0]) + "</td><td>" + I18n.tr("URL", new Object[0]) + "</td></tr></thead>");
            for (GpxTrack trk : this.data.tracks) {
                info.append("<tr><td>");
                if (trk.getAttributes().containsKey("name")) {
                    info.append(trk.get("name"));
                }
                info.append("</td><td>");
                if (trk.getAttributes().containsKey("desc")) {
                    info.append(" ").append(trk.get("desc"));
                }
                info.append("</td><td>");
                info.append(GpxLayer.getTimespanForTrack(trk));
                info.append("</td><td>");
                info.append(NavigatableComponent.getSystemOfMeasurement().getDistText(trk.length()));
                info.append("</td><td>");
                if (trk.getAttributes().containsKey("url")) {
                    info.append(trk.get("url"));
                }
                info.append("</td></tr>");
            }
            info.append("</table><br><br>");
        }
        info.append(I18n.tr("Length: {0}", NavigatableComponent.getSystemOfMeasurement().getDistText(this.data.length()))).append("<br>");
        info.append(I18n.trn("{0} route, ", "{0} routes, ", this.data.routes.size(), this.data.routes.size())).append(I18n.trn("{0} waypoint", "{0} waypoints", this.data.waypoints.size(), this.data.waypoints.size())).append("<br>");
        final JScrollPane sp = new JScrollPane(new HtmlPanel(info.toString()));
        sp.setPreferredSize(new Dimension(sp.getPreferredSize().width + 20, 370));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                sp.getVerticalScrollBar().setValue(0);
            }
        });
        return sp;
    }

    @Override
    public boolean isInfoResizable() {
        return true;
    }

    @Override
    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new Layer.LayerSaveAction(this), new Layer.LayerSaveAsAction(this), new CustomizeColor(this), new CustomizeDrawingAction(this), new ImportImagesAction(this), new ImportAudioAction(this), new MarkersFromNamedPointsAction(this), new ConvertToDataLayerAction(this), new DownloadAlongTrackAction(this.data), new DownloadWmsAlongTrackAction(this.data), Layer.SeparatorLayerAction.INSTANCE, new ChooseTrackVisibilityAction(this), new RenameLayerAction(this.getAssociatedFile(), this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction(this)};
    }

    public boolean isLocalFile() {
        return this.isLocalFile;
    }

    @Override
    public String getToolTipText() {
        StringBuilder info = new StringBuilder().append("<html>");
        if (this.data.attr.containsKey("meta.name")) {
            info.append(I18n.tr("Name: {0}", this.data.get("meta.name"))).append("<br>");
        }
        if (this.data.attr.containsKey("meta.desc")) {
            info.append(I18n.tr("Description: {0}", this.data.get("meta.desc"))).append("<br>");
        }
        info.append(I18n.trn("{0} track, ", "{0} tracks, ", this.data.tracks.size(), this.data.tracks.size()));
        info.append(I18n.trn("{0} route, ", "{0} routes, ", this.data.routes.size(), this.data.routes.size()));
        info.append(I18n.trn("{0} waypoint", "{0} waypoints", this.data.waypoints.size(), this.data.waypoints.size())).append("<br>");
        info.append(I18n.tr("Length: {0}", NavigatableComponent.getSystemOfMeasurement().getDistText(this.data.length())));
        info.append("<br>");
        return info.append("</html>").toString();
    }

    @Override
    public boolean isMergable(Layer other) {
        return other instanceof GpxLayer;
    }

    private int sumUpdateCount() {
        int updateCount = 0;
        for (GpxTrack track : this.data.tracks) {
            updateCount += track.getUpdateCount();
        }
        return updateCount;
    }

    @Override
    public boolean isChanged() {
        if (this.data.tracks.equals(this.lastTracks)) {
            return this.sumUpdateCount() != this.lastUpdateCount;
        }
        return true;
    }

    public void filterTracksByDate(Date fromDate, Date toDate, boolean showWithoutDate) {
        int i = 0;
        long from = fromDate.getTime();
        long to = toDate.getTime();
        for (GpxTrack trk : this.data.tracks) {
            Date[] t = GpxData.getMinMaxTimeForTrack(trk);
            if (t == null) continue;
            long tm = t[1].getTime();
            this.trackVisibility[i] = tm == 0L && showWithoutDate || from <= tm && tm <= to;
            ++i;
        }
    }

    @Override
    public void mergeFrom(Layer from) {
        this.data.mergeFrom(((GpxLayer)from).data);
        this.drawHelper.dataChanged();
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds box) {
        this.lastUpdateCount = this.sumUpdateCount();
        this.lastTracks.clear();
        this.lastTracks.addAll(this.data.tracks);
        List<WayPoint> visibleSegments = this.listVisibleSegments(box);
        if (!visibleSegments.isEmpty()) {
            this.drawHelper.readPreferences(this.getName());
            this.drawHelper.drawAll(g, mv, visibleSegments);
            if (Main.map.mapView.getActiveLayer() == this) {
                this.drawHelper.drawColorBar(g, mv);
            }
        }
    }

    private List<WayPoint> listVisibleSegments(Bounds box) {
        WayPoint last = null;
        LinkedList<WayPoint> visibleSegments = new LinkedList<WayPoint>();
        this.ensureTrackVisibilityLength();
        for (Collection<WayPoint> segment : this.data.getLinesIterable(this.trackVisibility)) {
            for (WayPoint pt : segment) {
                Bounds b = new Bounds(pt.getCoor());
                if (pt.drawLine && last != null) {
                    b.extend(last.getCoor());
                }
                if (b.intersects(box)) {
                    if (last != null && (visibleSegments.isEmpty() || visibleSegments.getLast() != last)) {
                        if (last.drawLine) {
                            WayPoint l = new WayPoint(last);
                            l.drawLine = false;
                            visibleSegments.add(l);
                        } else {
                            visibleSegments.add(last);
                        }
                    }
                    visibleSegments.add(pt);
                }
                last = pt;
            }
        }
        return visibleSegments;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor v) {
        v.visit(this.data.recalculateBounds());
    }

    @Override
    public File getAssociatedFile() {
        return this.data.storageFile;
    }

    @Override
    public void setAssociatedFile(File file) {
        this.data.storageFile = file;
    }

    private void ensureTrackVisibilityLength() {
        int l = this.data.tracks.size();
        if (l == this.trackVisibility.length) {
            return;
        }
        int m = Math.min(l, this.trackVisibility.length);
        this.trackVisibility = Arrays.copyOf(this.trackVisibility, l);
        for (int i = m; i < l; ++i) {
            this.trackVisibility[i] = true;
        }
    }

    @Override
    public void projectionChanged(Projection oldValue, Projection newValue) {
        if (newValue == null) {
            return;
        }
        this.data.resetEastNorthCache();
    }

    @Override
    public boolean isSavable() {
        return true;
    }

    @Override
    public boolean checkSaveConditions() {
        return this.data != null;
    }

    @Override
    public File createAndOpenSaveFileChooser() {
        return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save GPX file", new Object[0]), GpxImporter.FILE_FILTER);
    }
}

