/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.tools.I18n;

public class UploadedObjectsSummaryPanel
extends JPanel {
    public static final String NUM_OBJECTS_TO_UPLOAD_PROP = UploadedObjectsSummaryPanel.class.getName() + ".numObjectsToUpload";
    private PrimitiveList lstAdd;
    private JLabel lblAdd;
    private JScrollPane spAdd;
    private PrimitiveList lstUpdate;
    private JLabel lblUpdate;
    private JScrollPane spUpdate;
    private PrimitiveList lstDelete;
    private JLabel lblDelete;
    private JScrollPane spDelete;

    protected void build() {
        this.setLayout(new GridBagLayout());
        OsmPrimitivRenderer renderer = new OsmPrimitivRenderer();
        this.lstAdd = new PrimitiveList();
        this.lstAdd.setCellRenderer(renderer);
        this.lstAdd.setVisibleRowCount(Math.min(this.lstAdd.getModel().getSize(), 10));
        this.spAdd = new JScrollPane(this.lstAdd);
        this.lblAdd = new JLabel(I18n.tr("Objects to add:", new Object[0]));
        this.lstUpdate = new PrimitiveList();
        this.lstUpdate.setCellRenderer(renderer);
        this.lstUpdate.setVisibleRowCount(Math.min(this.lstUpdate.getModel().getSize(), 10));
        this.spUpdate = new JScrollPane(this.lstUpdate);
        this.lblUpdate = new JLabel(I18n.tr("Objects to modify:", new Object[0]));
        this.lstDelete = new PrimitiveList();
        this.lstDelete.setCellRenderer(renderer);
        this.lstDelete.setVisibleRowCount(Math.min(this.lstDelete.getModel().getSize(), 10));
        this.spDelete = new JScrollPane(this.lstDelete);
        this.lblDelete = new JLabel(I18n.tr("Objects to delete:", new Object[0]));
    }

    public void setUploadedPrimitives(List<OsmPrimitive> add, List<OsmPrimitive> update, List<OsmPrimitive> delete) {
        this.lstAdd.getPrimitiveListModel().setPrimitives(add);
        this.lstUpdate.getPrimitiveListModel().setPrimitives(update);
        this.lstDelete.getPrimitiveListModel().setPrimitives(delete);
        GridBagConstraints gcLabel = new GridBagConstraints();
        gcLabel.fill = 2;
        gcLabel.weightx = 1.0;
        gcLabel.weighty = 0.0;
        gcLabel.anchor = 23;
        GridBagConstraints gcList = new GridBagConstraints();
        gcList.fill = 1;
        gcList.weightx = 1.0;
        gcList.weighty = 1.0;
        gcList.anchor = 10;
        this.removeAll();
        int y = -1;
        if (!add.isEmpty()) {
            ++y;
            gcLabel.gridy = y++;
            this.lblAdd.setText(I18n.trn("{0} object to add:", "{0} objects to add:", add.size(), add.size()));
            this.add((Component)this.lblAdd, gcLabel);
            gcList.gridy = y;
            this.add((Component)this.spAdd, gcList);
        }
        if (!update.isEmpty()) {
            ++y;
            gcLabel.gridy = y++;
            this.lblUpdate.setText(I18n.trn("{0} object to modify:", "{0} objects to modify:", update.size(), update.size()));
            this.add((Component)this.lblUpdate, gcLabel);
            gcList.gridy = y;
            this.add((Component)this.spUpdate, gcList);
        }
        if (!delete.isEmpty()) {
            ++y;
            gcLabel.gridy = y++;
            this.lblDelete.setText(I18n.trn("{0} object to delete:", "{0} objects to delete:", delete.size(), delete.size()));
            this.add((Component)this.lblDelete, gcLabel);
            gcList.gridy = y;
            this.add((Component)this.spDelete, gcList);
        }
        this.firePropertyChange(NUM_OBJECTS_TO_UPLOAD_PROP, 0, this.getNumObjectsToUpload());
    }

    public UploadedObjectsSummaryPanel() {
        this.build();
    }

    public int getNumObjectsToUpload() {
        return this.lstAdd.getModel().getSize() + this.lstUpdate.getModel().getSize() + this.lstDelete.getModel().getSize();
    }

    static class PrimitiveListModel
    extends AbstractListModel<OsmPrimitive> {
        private List<OsmPrimitive> primitives;

        public PrimitiveListModel() {
            this.primitives = new ArrayList<OsmPrimitive>();
        }

        public PrimitiveListModel(List<OsmPrimitive> primitives) {
            this.setPrimitives(primitives);
        }

        public void setPrimitives(List<OsmPrimitive> primitives) {
            this.primitives = primitives == null ? new ArrayList<OsmPrimitive>() : primitives;
            this.fireContentsChanged(this, 0, this.getSize());
        }

        @Override
        public OsmPrimitive getElementAt(int index) {
            if (this.primitives == null) {
                return null;
            }
            return this.primitives.get(index);
        }

        @Override
        public int getSize() {
            if (this.primitives == null) {
                return 0;
            }
            return this.primitives.size();
        }
    }

    static class PrimitiveList
    extends JList<OsmPrimitive> {
        public PrimitiveList() {
            super(new PrimitiveListModel());
        }

        public PrimitiveListModel getPrimitiveListModel() {
            return (PrimitiveListModel)this.getModel();
        }
    }
}

