/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

public enum UploadStrategy {
    INDIVIDUAL_OBJECTS_STRATEGY("individualobjects"),
    CHUNKED_DATASET_STRATEGY("chunked"),
    SINGLE_REQUEST_STRATEGY("singlerequest");

    private String preferenceValue;
    public static final UploadStrategy DEFAULT_UPLOAD_STRATEGY;

    private UploadStrategy(String preferenceValue) {
        this.preferenceValue = preferenceValue;
    }

    public static UploadStrategy fromPreference(String preferenceValue) {
        if (preferenceValue == null) {
            return null;
        }
        preferenceValue = preferenceValue.trim().toLowerCase();
        for (UploadStrategy strategy : UploadStrategy.values()) {
            if (!strategy.getPreferenceValue().equals(preferenceValue)) continue;
            return strategy;
        }
        return null;
    }

    public String getPreferenceValue() {
        return this.preferenceValue;
    }

    public static UploadStrategy getFromPreferences() {
        String v = Main.pref.get("osm-server.upload-strategy", null);
        if (v == null) {
            v = Main.pref.get("osm-server.atomic-upload", null);
            if (v != null) {
                Main.pref.removeFromCollection("osm-server.atomic-upload", v);
            } else {
                v = "";
            }
            v = v.trim().toLowerCase();
            if ("true".equals(v)) {
                return SINGLE_REQUEST_STRATEGY;
            }
            if ("false".equals(v)) {
                return INDIVIDUAL_OBJECTS_STRATEGY;
            }
            return DEFAULT_UPLOAD_STRATEGY;
        }
        UploadStrategy strategy = UploadStrategy.fromPreference(v);
        if (strategy == null) {
            Main.warn(I18n.tr("Unexpected value for key ''{0}'' in preferences, got ''{1}''", "osm-server.upload-strategy", v));
            return DEFAULT_UPLOAD_STRATEGY;
        }
        return strategy;
    }

    public static void saveToPreferences(UploadStrategy strategy) {
        Main.pref.put("osm-server.upload-strategy", strategy.getPreferenceValue());
    }

    static {
        DEFAULT_UPLOAD_STRATEGY = SINGLE_REQUEST_STRATEGY;
    }
}

