/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.openstreetmap.josm.gui.io.SaveLayersModel;
import org.openstreetmap.josm.gui.progress.ProgressRenderer;

class UploadAndSaveProgressRenderer
extends JPanel
implements PropertyChangeListener,
ProgressRenderer {
    private JLabel lblTaskTitle;
    private JLabel lblCustomText;
    private JProgressBar progressBar;

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(5, 0, 0, 5);
        this.lblTaskTitle = new JLabel("");
        this.add((Component)this.lblTaskTitle, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(5, 0, 0, 5);
        this.lblCustomText = new JLabel("");
        this.add((Component)this.lblCustomText, gc);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(5, 0, 0, 5);
        this.progressBar = new JProgressBar(0);
        this.add((Component)this.progressBar, gc);
    }

    public UploadAndSaveProgressRenderer() {
        this.build();
        this.setVisible(false);
    }

    @Override
    public void setCustomText(String message) {
        this.lblCustomText.setText(message);
        this.repaint();
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        this.progressBar.setIndeterminate(indeterminate);
        this.repaint();
    }

    @Override
    public void setMaximum(int maximum) {
        this.progressBar.setMaximum(maximum);
        this.repaint();
    }

    @Override
    public void setTaskTitle(String taskTitle) {
        this.lblTaskTitle.setText(taskTitle);
        this.repaint();
    }

    @Override
    public void setValue(int value) {
        this.progressBar.setValue(value);
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(SaveLayersModel.MODE_PROP)) {
            SaveLayersModel.Mode mode = (SaveLayersModel.Mode)((Object)evt.getNewValue());
            switch (mode) {
                case EDITING_DATA: {
                    this.setVisible(false);
                    break;
                }
                case UPLOADING_AND_SAVING: {
                    this.setVisible(true);
                }
            }
        }
        this.getParent().validate();
    }
}

