/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.gui.io.ChangesetCommentModel;
import org.openstreetmap.josm.gui.tagging.TagEditorPanel;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class TagSettingsPanel
extends JPanel
implements TableModelListener {
    private final TagEditorPanel pnlTagEditor = new TagEditorPanel(null);
    private final ChangesetCommentModel changesetCommentModel;
    private final ChangesetCommentModel changesetSourceModel;
    private final Map<String, String> defaultTags = new HashMap<String, String>();

    protected void build() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.pnlTagEditor, "Center");
    }

    public TagSettingsPanel(ChangesetCommentModel changesetCommentModel, ChangesetCommentModel changesetSourceModel) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(changesetCommentModel, "changesetCommentModel");
        CheckParameterUtil.ensureParameterNotNull(changesetSourceModel, "changesetSourceModel");
        this.changesetCommentModel = changesetCommentModel;
        this.changesetSourceModel = changesetSourceModel;
        this.changesetCommentModel.addObserver(new ChangesetCommentObserver("comment"));
        this.changesetSourceModel.addObserver(new ChangesetCommentObserver("source"));
        this.build();
        this.pnlTagEditor.getModel().addTableModelListener(this);
    }

    protected void setProperty(String key, String value) {
        String commentInTag;
        if (value == null) {
            value = "";
        }
        if ((value = value.trim()).equals(commentInTag = this.getTagEditorValue(key))) {
            return;
        }
        if (value.isEmpty()) {
            this.pnlTagEditor.getModel().delete(key);
            return;
        }
        TagModel tag = this.pnlTagEditor.getModel().get(key);
        if (tag == null) {
            tag = new TagModel(key, value);
            this.pnlTagEditor.getModel().add(tag);
        } else {
            this.pnlTagEditor.getModel().updateTagValue(tag, value);
        }
    }

    protected String getTagEditorValue(String key) {
        TagModel tag = this.pnlTagEditor.getModel().get(key);
        if (tag == null) {
            return null;
        }
        return tag.getValue();
    }

    public void initFromChangeset(Changeset cs) {
        Map<String, String> tags = this.getDefaultTags();
        if (cs != null) {
            tags.putAll(cs.getKeys());
        }
        if (tags.get("comment") == null) {
            tags.put("comment", this.getTagEditorValue("comment"));
        }
        if (tags.get("source") == null) {
            tags.put("source", this.getTagEditorValue("source"));
        }
        String agent = Version.getInstance().getAgentString(false);
        String created_by = tags.get("created_by");
        if (created_by == null || created_by.isEmpty()) {
            tags.put("created_by", agent);
        } else if (!created_by.contains(agent)) {
            tags.put("created_by", created_by + ";" + agent);
        }
        this.pnlTagEditor.getModel().initFromTags(tags);
    }

    public Map<String, String> getTags(boolean keepEmpty) {
        return this.pnlTagEditor.getModel().getTags(keepEmpty);
    }

    public Map<String, String> getDefaultTags() {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.putAll(this.defaultTags);
        return tags;
    }

    public void setDefaultTags(Map<String, String> tags) {
        this.defaultTags.clear();
        this.defaultTags.putAll(tags);
        this.tableChanged(null);
    }

    public void startUserInput() {
        this.pnlTagEditor.initAutoCompletion(Main.main.getEditLayer());
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.changesetCommentModel.setComment(this.getTagEditorValue("comment"));
        this.changesetSourceModel.setComment(this.getTagEditorValue("source"));
    }

    class ChangesetCommentObserver
    implements Observer {
        private final String key;

        ChangesetCommentObserver(String key) {
            this.key = key;
        }

        @Override
        public void update(Observable o, Object arg) {
            if (!(o instanceof ChangesetCommentModel)) {
                return;
            }
            String newValue = (String)arg;
            String oldValue = TagSettingsPanel.this.getTagEditorValue(this.key);
            if (oldValue == null) {
                oldValue = "";
            }
            if (!oldValue.equals(newValue)) {
                TagSettingsPanel.this.setProperty(this.key, (String)arg);
            }
        }
    }
}

