/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openstreetmap.josm.gui.io.ActionFlagsTableCell;
import org.openstreetmap.josm.gui.io.LayerNameAndFilePathTableCell;
import org.openstreetmap.josm.gui.io.SaveLayerInfo;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

class SaveLayersTableColumnModel
extends DefaultTableColumnModel {
    protected void build() {
        TableColumn col = null;
        LayerNameAndFilePathTableCell lnafptc = new LayerNameAndFilePathTableCell();
        col = new TableColumn(0);
        col.setHeaderValue(I18n.tr("Layer Name and File Path", new Object[0]));
        col.setResizable(true);
        col.setCellRenderer(lnafptc);
        col.setCellEditor(lnafptc);
        col.setPreferredWidth(324);
        this.addColumn(col);
        col = new TableColumn(1);
        col.setHeaderValue(I18n.tr("Recommended Actions", new Object[0]));
        col.setResizable(true);
        col.setCellRenderer(new RecommendedActionsTableCell());
        col.setPreferredWidth(150);
        this.addColumn(col);
        ActionFlagsTableCell aftc = new ActionFlagsTableCell();
        col = new TableColumn(2);
        col.setHeaderValue(I18n.tr("Actions To Take", new Object[0]));
        col.setResizable(true);
        col.setCellRenderer(aftc);
        col.setCellEditor(aftc);
        col.setPreferredWidth(100);
        this.addColumn(col);
    }

    public SaveLayersTableColumnModel() {
        this.build();
    }

    private static class RecommendedActionsTableCell
    implements TableCellRenderer {
        private final JPanel pnlEmpty = new JPanel();
        private final JLabel needsUpload = new JLabel(I18n.tr("should be uploaded", new Object[0]));
        private final JLabel needsSave = new JLabel(I18n.tr("should be saved", new Object[0]));
        private static final GBC defaultCellStyle = GBC.eol().fill(2).insets(2, 0, 2, 0);

        public RecommendedActionsTableCell() {
            this.pnlEmpty.setPreferredSize(new Dimension(1, 19));
            this.needsUpload.setPreferredSize(new Dimension(this.needsUpload.getPreferredSize().width, 19));
            this.needsSave.setPreferredSize(new Dimension(this.needsSave.getPreferredSize().width, 19));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JPanel panel = new JPanel(new GridBagLayout());
            SaveLayerInfo info = (SaveLayerInfo)value;
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            if (info.getLayer().requiresUploadToServer() && !info.getLayer().isUploadDiscouraged()) {
                panel.add((Component)this.needsUpload, defaultCellStyle);
                sb.append(I18n.tr("Layer ''{0}'' has modifications which should be uploaded to the server.", info.getName()));
            } else {
                panel.add((Component)this.pnlEmpty, defaultCellStyle);
                if (info.getLayer().requiresUploadToServer()) {
                    sb.append(I18n.tr("Layer ''{0}'' has modifications which are discouraged to be uploaded.", info.getName()));
                } else {
                    sb.append(I18n.tr("Layer ''{0}'' has no modifications to be uploaded.", info.getName()));
                }
            }
            sb.append("<br/>");
            if (info.getLayer().requiresSaveToFile()) {
                panel.add((Component)this.needsSave, defaultCellStyle);
                sb.append(I18n.tr("Layer ''{0}'' has modifications which should be saved to its associated file ''{1}''.", info.getName(), info.getFile().toString()));
            } else {
                panel.add((Component)this.pnlEmpty, defaultCellStyle);
                sb.append(I18n.tr("Layer ''{0}'' has no modifications to be saved.", info.getName()));
            }
            sb.append("</html>");
            panel.setToolTipText(sb.toString());
            return panel;
        }
    }
}

