/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.gui.io.SaveLayerInfo;
import org.openstreetmap.josm.gui.io.UploadOrSaveState;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class SaveLayersModel
extends DefaultTableModel {
    public static final String MODE_PROP = SaveLayerInfo.class.getName() + ".mode";
    private List<SaveLayerInfo> layerInfo;
    private Mode mode = Mode.EDITING_DATA;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    protected void fireModeChanged(Mode oldValue, Mode newValue) {
        this.support.firePropertyChange(MODE_PROP, (Object)oldValue, (Object)newValue);
    }

    public void setMode(Mode newValue) {
        Mode oldValue = this.mode;
        this.mode = newValue;
        this.fireModeChanged(oldValue, newValue);
    }

    public Mode getMode() {
        return this.mode;
    }

    public void populate(List<? extends AbstractModifiableLayer> layers) {
        this.layerInfo = new ArrayList<SaveLayerInfo>();
        if (layers == null) {
            return;
        }
        for (AbstractModifiableLayer abstractModifiableLayer : layers) {
            this.layerInfo.add(new SaveLayerInfo(abstractModifiableLayer));
        }
        Collections.sort(this.layerInfo, new Comparator<SaveLayerInfo>(){

            @Override
            public int compare(SaveLayerInfo o1, SaveLayerInfo o2) {
                return o1.compareTo(o2);
            }
        });
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        if (this.layerInfo == null) {
            return 0;
        }
        return this.layerInfo.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.layerInfo == null) {
            return null;
        }
        return this.layerInfo.get(row);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 0 || column == 2;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        switch (column) {
            case 0: {
                this.layerInfo.get(row).setFile((File)value);
                this.layerInfo.get(row).setDoSaveToFile(true);
                break;
            }
            case 2: {
                boolean[] values = (boolean[])value;
                this.layerInfo.get(row).setDoUploadToServer(values[0]);
                this.layerInfo.get(row).setDoSaveToFile(values[1]);
            }
        }
        this.fireTableDataChanged();
    }

    public List<SaveLayerInfo> getSafeLayerInfo() {
        return this.layerInfo;
    }

    public List<SaveLayerInfo> getLayersWithoutFilesAndSaveRequest() {
        ArrayList<SaveLayerInfo> ret = new ArrayList<SaveLayerInfo>();
        for (SaveLayerInfo info : this.layerInfo) {
            if (!info.isDoSaveToFile() || info.getFile() != null) continue;
            ret.add(info);
        }
        return ret;
    }

    public List<SaveLayerInfo> getLayersWithIllegalFilesAndSaveRequest() {
        ArrayList<SaveLayerInfo> ret = new ArrayList<SaveLayerInfo>();
        for (SaveLayerInfo info : this.layerInfo) {
            if (!info.isDoSaveToFile() || info.getFile() == null || !info.getFile().exists() || info.getFile().canWrite()) continue;
            ret.add(info);
        }
        return ret;
    }

    public List<SaveLayerInfo> getLayersWithConflictsAndUploadRequest() {
        ArrayList<SaveLayerInfo> ret = new ArrayList<SaveLayerInfo>();
        for (SaveLayerInfo info : this.layerInfo) {
            AbstractModifiableLayer l = info.getLayer();
            if (!info.isDoUploadToServer() || !(l instanceof OsmDataLayer) || ((OsmDataLayer)l).getConflicts().isEmpty()) continue;
            ret.add(info);
        }
        return ret;
    }

    public List<SaveLayerInfo> getLayersToUpload() {
        ArrayList<SaveLayerInfo> ret = new ArrayList<SaveLayerInfo>();
        for (SaveLayerInfo info : this.layerInfo) {
            if (!info.isDoUploadToServer()) continue;
            ret.add(info);
        }
        return ret;
    }

    public List<SaveLayerInfo> getLayersToSave() {
        ArrayList<SaveLayerInfo> ret = new ArrayList<SaveLayerInfo>();
        for (SaveLayerInfo info : this.layerInfo) {
            if (!info.isDoSaveToFile()) continue;
            ret.add(info);
        }
        return ret;
    }

    public void setUploadState(AbstractModifiableLayer layer, UploadOrSaveState state) {
        SaveLayerInfo info = this.getSaveLayerInfo(layer);
        if (info != null) {
            info.setUploadState(state);
        }
        this.fireTableDataChanged();
    }

    public void setSaveState(AbstractModifiableLayer layer, UploadOrSaveState state) {
        SaveLayerInfo info = this.getSaveLayerInfo(layer);
        if (info != null) {
            info.setSaveState(state);
        }
        this.fireTableDataChanged();
    }

    public SaveLayerInfo getSaveLayerInfo(AbstractModifiableLayer layer) {
        for (SaveLayerInfo info : this.layerInfo) {
            if (info.getLayer() != layer) continue;
            return info;
        }
        return null;
    }

    public void resetSaveAndUploadState() {
        for (SaveLayerInfo info : this.layerInfo) {
            info.setSaveState(null);
            info.setUploadState(null);
        }
    }

    public boolean hasUnsavedData() {
        for (SaveLayerInfo info : this.layerInfo) {
            if (info.isDoUploadToServer() && !UploadOrSaveState.OK.equals((Object)info.getUploadState())) {
                return true;
            }
            if (!info.isDoSaveToFile() || UploadOrSaveState.OK.equals((Object)info.getSaveState())) continue;
            return true;
        }
        return false;
    }

    public int getNumCancel() {
        int ret = 0;
        for (SaveLayerInfo info : this.layerInfo) {
            if (!UploadOrSaveState.CANCELED.equals((Object)info.getSaveState()) && !UploadOrSaveState.CANCELED.equals((Object)info.getUploadState())) continue;
            ++ret;
        }
        return ret;
    }

    public int getNumFailed() {
        int ret = 0;
        for (SaveLayerInfo info : this.layerInfo) {
            if (!UploadOrSaveState.FAILED.equals((Object)info.getSaveState()) && !UploadOrSaveState.FAILED.equals((Object)info.getUploadState())) continue;
            ++ret;
        }
        return ret;
    }

    public static enum Mode {
        EDITING_DATA,
        UPLOADING_AND_SAVING;

    }
}

