/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.io.AbstractIOTask;
import org.openstreetmap.josm.gui.io.AbstractUploadDialog;
import org.openstreetmap.josm.gui.io.SaveLayerInfo;
import org.openstreetmap.josm.gui.io.SaveLayerTask;
import org.openstreetmap.josm.gui.io.SaveLayersModel;
import org.openstreetmap.josm.gui.io.SaveLayersTable;
import org.openstreetmap.josm.gui.io.UploadAndSaveProgressRenderer;
import org.openstreetmap.josm.gui.io.UploadOrSaveState;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.SwingRenderingProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class SaveLayersDialog
extends JDialog
implements TableModelListener {
    private SaveLayersModel model;
    private UserAction action = UserAction.CANCEL;
    private UploadAndSaveProgressRenderer pnlUploadLayers;
    private SaveAndProceedAction saveAndProceedAction;
    private DiscardAndProceedAction discardAndProceedAction;
    private CancelAction cancelAction;
    private SaveAndUploadTask saveAndUploadTask;
    private JButton saveAndProceedActionButton = null;

    protected void build() {
        WindowGeometry geometry = WindowGeometry.centerOnScreen(new Dimension(650, 300));
        geometry.applySafe(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.model = new SaveLayersModel();
        SaveLayersTable table = new SaveLayersTable(this.model);
        JScrollPane pane = new JScrollPane(table);
        this.model.addPropertyChangeListener(table);
        table.getModel().addTableModelListener(this);
        this.getContentPane().add((Component)pane, "Center");
        this.getContentPane().add((Component)this.buildButtonRow(), "South");
        this.addWindowListener(new WindowClosingAdapter());
        this.setDefaultCloseOperation(2);
    }

    protected JPanel buildButtonRow() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout(1));
        this.saveAndProceedAction = new SaveAndProceedAction();
        this.model.addPropertyChangeListener(this.saveAndProceedAction);
        this.saveAndProceedActionButton = new JButton(this.saveAndProceedAction);
        pnl.add(this.saveAndProceedActionButton);
        this.discardAndProceedAction = new DiscardAndProceedAction();
        this.model.addPropertyChangeListener(this.discardAndProceedAction);
        pnl.add(new JButton(this.discardAndProceedAction));
        this.cancelAction = new CancelAction();
        pnl.add(new JButton(this.cancelAction));
        JPanel pnl2 = new JPanel();
        pnl2.setLayout(new BorderLayout());
        this.pnlUploadLayers = new UploadAndSaveProgressRenderer();
        pnl2.add((Component)this.pnlUploadLayers, "Center");
        this.model.addPropertyChangeListener(this.pnlUploadLayers);
        pnl2.add((Component)pnl, "South");
        return pnl2;
    }

    public void prepareForSavingAndUpdatingLayersBeforeExit() {
        this.setTitle(I18n.tr("Unsaved changes - Save/Upload before exiting?", new Object[0]));
        this.saveAndProceedAction.initForSaveAndExit();
        this.discardAndProceedAction.initForDiscardAndExit();
    }

    public void prepareForSavingAndUpdatingLayersBeforeDelete() {
        this.setTitle(I18n.tr("Unsaved changes - Save/Upload before deleting?", new Object[0]));
        this.saveAndProceedAction.initForSaveAndDelete();
        this.discardAndProceedAction.initForDiscardAndDelete();
    }

    public SaveLayersDialog(Component parent) {
        super((Window)JOptionPane.getFrameForComponent(parent), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
    }

    public UserAction getUserAction() {
        return this.action;
    }

    public SaveLayersModel getModel() {
        return this.model;
    }

    protected void launchSafeAndUploadTask() {
        SwingRenderingProgressMonitor monitor = new SwingRenderingProgressMonitor(this.pnlUploadLayers);
        monitor.beginTask(I18n.tr("Uploading and saving modified layers ...", new Object[0]));
        this.saveAndUploadTask = new SaveAndUploadTask(this.model, monitor);
        new Thread(this.saveAndUploadTask).start();
    }

    protected void cancelSafeAndUploadTask() {
        if (this.saveAndUploadTask != null) {
            this.saveAndUploadTask.cancel();
        }
        this.model.setMode(SaveLayersModel.Mode.EDITING_DATA);
    }

    protected void warnLayersWithConflictsAndUploadRequest(List<SaveLayerInfo> infos) {
        String msg = I18n.trn("<html>{0} layer has unresolved conflicts.<br>Either resolve them first or discard the modifications.<br>Layer with conflicts:</html>", "<html>{0} layers have unresolved conflicts.<br>Either resolve them first or discard the modifications.<br>Layers with conflicts:</html>", infos.size(), infos.size());
        JOptionPane.showConfirmDialog(Main.parent, new LayerListWarningMessagePanel(msg, infos), I18n.tr("Unsaved data and conflicts", new Object[0]), -1, 2);
    }

    protected void warnLayersWithoutFilesAndSaveRequest(List<SaveLayerInfo> infos) {
        String msg = I18n.trn("<html>{0} layer needs saving but has no associated file.<br>Either select a file for this layer or discard the changes.<br>Layer without a file:</html>", "<html>{0} layers need saving but have no associated file.<br>Either select a file for each of them or discard the changes.<br>Layers without a file:</html>", infos.size(), infos.size());
        JOptionPane.showConfirmDialog(Main.parent, new LayerListWarningMessagePanel(msg, infos), I18n.tr("Unsaved data and missing associated file", new Object[0]), -1, 2);
    }

    protected void warnLayersWithIllegalFilesAndSaveRequest(List<SaveLayerInfo> infos) {
        String msg = I18n.trn("<html>{0} layer needs saving but has an associated file<br>which cannot be written.<br>Either select another file for this layer or discard the changes.<br>Layer with a non-writable file:</html>", "<html>{0} layers need saving but have associated files<br>which cannot be written.<br>Either select another file for each of them or discard the changes.<br>Layers with non-writable files:</html>", infos.size(), infos.size());
        JOptionPane.showConfirmDialog(Main.parent, new LayerListWarningMessagePanel(msg, infos), I18n.tr("Unsaved data non-writable files", new Object[0]), -1, 2);
    }

    protected boolean confirmSaveLayerInfosOK() {
        List<SaveLayerInfo> layerInfos = this.model.getLayersWithConflictsAndUploadRequest();
        if (!layerInfos.isEmpty()) {
            this.warnLayersWithConflictsAndUploadRequest(layerInfos);
            return false;
        }
        layerInfos = this.model.getLayersWithoutFilesAndSaveRequest();
        if (!layerInfos.isEmpty()) {
            this.warnLayersWithoutFilesAndSaveRequest(layerInfos);
            return false;
        }
        layerInfos = this.model.getLayersWithIllegalFilesAndSaveRequest();
        if (!layerInfos.isEmpty()) {
            this.warnLayersWithIllegalFilesAndSaveRequest(layerInfos);
            return false;
        }
        return true;
    }

    protected void setUserAction(UserAction action) {
        this.action = action;
    }

    public void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void tableChanged(TableModelEvent arg0) {
        boolean dis;
        boolean bl = dis = this.model.getLayersToSave().isEmpty() && this.model.getLayersToUpload().isEmpty();
        if (this.saveAndProceedActionButton != null) {
            this.saveAndProceedActionButton.setEnabled(!dis);
        }
        this.saveAndProceedAction.redrawIcon();
    }

    protected class SaveAndUploadTask
    implements Runnable {
        private SaveLayersModel model;
        private ProgressMonitor monitor;
        private ExecutorService worker;
        private boolean canceled;
        private Future<?> currentFuture;
        private AbstractIOTask currentTask;

        public SaveAndUploadTask(SaveLayersModel model, ProgressMonitor monitor) {
            this.model = model;
            this.monitor = monitor;
            this.worker = Executors.newSingleThreadExecutor();
        }

        protected void uploadLayers(List<SaveLayerInfo> toUpload) {
            for (SaveLayerInfo layerInfo : toUpload) {
                AbstractModifiableLayer layer = layerInfo.getLayer();
                if (this.canceled) {
                    this.model.setUploadState(layer, UploadOrSaveState.CANCELED);
                    continue;
                }
                this.monitor.subTask(I18n.tr("Preparing layer ''{0}'' for upload ...", layerInfo.getName()));
                if (!UploadAction.checkPreUploadConditions(layer)) {
                    this.model.setUploadState(layer, UploadOrSaveState.FAILED);
                    continue;
                }
                AbstractUploadDialog dialog = layer.getUploadDialog();
                if (dialog != null) {
                    dialog.setVisible(true);
                    if (dialog.isCanceled()) {
                        this.model.setUploadState(layer, UploadOrSaveState.CANCELED);
                        continue;
                    }
                    dialog.rememberUserInput();
                }
                this.currentTask = layer.createUploadTask(this.monitor);
                if (this.currentTask == null) {
                    this.model.setUploadState(layer, UploadOrSaveState.FAILED);
                    continue;
                }
                this.currentFuture = this.worker.submit(this.currentTask);
                try {
                    this.currentFuture.get();
                }
                catch (CancellationException e) {
                    this.model.setUploadState(layer, UploadOrSaveState.CANCELED);
                }
                catch (Exception e) {
                    Main.error(e);
                    this.model.setUploadState(layer, UploadOrSaveState.FAILED);
                    ExceptionDialogUtil.explainException(e);
                }
                if (this.currentTask.isCanceled()) {
                    this.model.setUploadState(layer, UploadOrSaveState.CANCELED);
                } else if (this.currentTask.isFailed()) {
                    Main.error(this.currentTask.getLastException());
                    ExceptionDialogUtil.explainException(this.currentTask.getLastException());
                    this.model.setUploadState(layer, UploadOrSaveState.FAILED);
                } else {
                    this.model.setUploadState(layer, UploadOrSaveState.OK);
                }
                this.currentTask = null;
                this.currentFuture = null;
            }
        }

        protected void saveLayers(List<SaveLayerInfo> toSave) {
            for (SaveLayerInfo layerInfo : toSave) {
                if (this.canceled) {
                    this.model.setSaveState(layerInfo.getLayer(), UploadOrSaveState.CANCELED);
                    continue;
                }
                if (layerInfo.isDoCheckSaveConditions()) {
                    if (!layerInfo.getLayer().checkSaveConditions()) continue;
                    layerInfo.setDoCheckSaveConditions(false);
                }
                this.currentTask = new SaveLayerTask(layerInfo, this.monitor);
                this.currentFuture = this.worker.submit(this.currentTask);
                try {
                    this.currentFuture.get();
                }
                catch (CancellationException e) {
                    this.model.setSaveState(layerInfo.getLayer(), UploadOrSaveState.CANCELED);
                }
                catch (Exception e) {
                    Main.error(e);
                    this.model.setSaveState(layerInfo.getLayer(), UploadOrSaveState.FAILED);
                    ExceptionDialogUtil.explainException(e);
                }
                if (this.currentTask.isCanceled()) {
                    this.model.setSaveState(layerInfo.getLayer(), UploadOrSaveState.CANCELED);
                } else if (this.currentTask.isFailed()) {
                    if (this.currentTask.getLastException() != null) {
                        Main.error(this.currentTask.getLastException());
                        ExceptionDialogUtil.explainException(this.currentTask.getLastException());
                    }
                    this.model.setSaveState(layerInfo.getLayer(), UploadOrSaveState.FAILED);
                } else {
                    this.model.setSaveState(layerInfo.getLayer(), UploadOrSaveState.OK);
                }
                this.currentTask = null;
                this.currentFuture = null;
            }
        }

        protected void warnBecauseOfUnsavedData() {
            int numProblems = this.model.getNumCancel() + this.model.getNumFailed();
            if (numProblems == 0) {
                return;
            }
            String msg = I18n.trn("<html>An upload and/or save operation of one layer with modifications<br>was canceled or has failed.</html>", "<html>Upload and/or save operations of {0} layers with modifications<br>were canceled or have failed.</html>", numProblems, numProblems);
            JOptionPane.showMessageDialog(Main.parent, msg, I18n.tr("Incomplete upload and/or save", new Object[0]), 2);
        }

        @Override
        public void run() {
            GuiHelper.runInEDTAndWait(new Runnable(){

                @Override
                public void run() {
                    List<SaveLayerInfo> toSave;
                    SaveAndUploadTask.this.model.setMode(SaveLayersModel.Mode.UPLOADING_AND_SAVING);
                    List<SaveLayerInfo> toUpload = SaveAndUploadTask.this.model.getLayersToUpload();
                    if (!toUpload.isEmpty()) {
                        SaveAndUploadTask.this.uploadLayers(toUpload);
                    }
                    if (!(toSave = SaveAndUploadTask.this.model.getLayersToSave()).isEmpty()) {
                        SaveAndUploadTask.this.saveLayers(toSave);
                    }
                    SaveAndUploadTask.this.model.setMode(SaveLayersModel.Mode.EDITING_DATA);
                    if (SaveAndUploadTask.this.model.hasUnsavedData()) {
                        SaveAndUploadTask.this.warnBecauseOfUnsavedData();
                        SaveAndUploadTask.this.model.setMode(SaveLayersModel.Mode.EDITING_DATA);
                        if (SaveAndUploadTask.this.canceled) {
                            SaveLayersDialog.this.setUserAction(UserAction.CANCEL);
                            SaveLayersDialog.this.closeDialog();
                        }
                    } else {
                        SaveLayersDialog.this.setUserAction(UserAction.PROCEED);
                        SaveLayersDialog.this.closeDialog();
                    }
                }
            });
        }

        public void cancel() {
            if (this.currentTask != null) {
                this.currentTask.cancel();
            }
            this.canceled = true;
        }
    }

    final class SaveAndProceedAction
    extends AbstractAction
    implements PropertyChangeListener {
        private final Image save = ImageProvider.get("save").getImage();
        private final Image upld = ImageProvider.get("upload").getImage();
        private final Image saveDis = new BufferedImage(24, 24, 6);
        private final Image upldDis = new BufferedImage(24, 24, 6);

        public SaveAndProceedAction() {
            new JLabel(ImageProvider.get("save")).getDisabledIcon().paintIcon(new JPanel(), this.saveDis.getGraphics(), 0, 0);
            new JLabel(ImageProvider.get("upload")).getDisabledIcon().paintIcon(new JPanel(), this.upldDis.getGraphics(), 0, 0);
            this.initForSaveAndExit();
        }

        public void initForSaveAndExit() {
            this.putValue("Name", I18n.tr("Perform actions before exiting", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Exit JOSM with saving. Unsaved changes are uploaded and/or saved.", new Object[0]));
            this.putValue("BASE_ICON", ImageProvider.get("exit"));
            this.redrawIcon();
        }

        public void initForSaveAndDelete() {
            this.putValue("Name", I18n.tr("Perform actions before deleting", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Save/Upload layers before deleting. Unsaved changes are not lost.", new Object[0]));
            this.putValue("BASE_ICON", ImageProvider.get("dialogs", "delete"));
            this.redrawIcon();
        }

        public void redrawIcon() {
            try {
                Image base = ((ImageIcon)this.getValue("BASE_ICON")).getImage();
                BufferedImage newIco = new BufferedImage(72, 24, 6);
                Graphics2D g = newIco.createGraphics();
                g.drawImage(SaveLayersDialog.this.model.getLayersToUpload().isEmpty() ? this.upldDis : this.upld, 0, 0, 24, 24, null);
                g.drawImage(SaveLayersDialog.this.model.getLayersToSave().isEmpty() ? this.saveDis : this.save, 24, 0, 24, 24, null);
                g.drawImage(base, 48, 0, 24, 24, null);
                this.putValue("SmallIcon", new ImageIcon(newIco));
            }
            catch (Exception e) {
                this.putValue("SmallIcon", this.getValue("BASE_ICON"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SaveLayersDialog.this.confirmSaveLayerInfosOK()) {
                return;
            }
            SaveLayersDialog.this.launchSafeAndUploadTask();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(SaveLayersModel.MODE_PROP)) {
                SaveLayersModel.Mode mode = (SaveLayersModel.Mode)((Object)evt.getNewValue());
                switch (mode) {
                    case EDITING_DATA: {
                        this.setEnabled(true);
                        break;
                    }
                    case UPLOADING_AND_SAVING: {
                        this.setEnabled(false);
                    }
                }
            }
        }
    }

    class DiscardAndProceedAction
    extends AbstractAction
    implements PropertyChangeListener {
        public DiscardAndProceedAction() {
            this.initForDiscardAndExit();
        }

        public void initForDiscardAndExit() {
            this.putValue("Name", I18n.tr("Exit now!", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Exit JOSM without saving. Unsaved changes are lost.", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("exit"));
        }

        public void initForDiscardAndDelete() {
            this.putValue("Name", I18n.tr("Delete now!", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Delete layers without saving. Unsaved changes are lost.", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SaveLayersDialog.this.setUserAction(UserAction.PROCEED);
            SaveLayersDialog.this.closeDialog();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(SaveLayersModel.MODE_PROP)) {
                SaveLayersModel.Mode mode = (SaveLayersModel.Mode)((Object)evt.getNewValue());
                switch (mode) {
                    case EDITING_DATA: {
                        this.setEnabled(true);
                        break;
                    }
                    case UPLOADING_AND_SAVING: {
                        this.setEnabled(false);
                    }
                }
            }
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Close this dialog and resume editing in JOSM", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
            SaveLayersDialog.this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
            SaveLayersDialog.this.getRootPane().getActionMap().put("ESCAPE", this);
        }

        protected void cancelWhenInEditingModel() {
            SaveLayersDialog.this.setUserAction(UserAction.CANCEL);
            SaveLayersDialog.this.closeDialog();
        }

        protected void cancelWhenInSaveAndUploadingMode() {
            SaveLayersDialog.this.cancelSafeAndUploadTask();
        }

        public void cancel() {
            switch (SaveLayersDialog.this.model.getMode()) {
                case EDITING_DATA: {
                    this.cancelWhenInEditingModel();
                    break;
                }
                case UPLOADING_AND_SAVING: {
                    SaveLayersDialog.this.cancelSafeAndUploadTask();
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.cancel();
        }
    }

    class WindowClosingAdapter
    extends WindowAdapter {
        WindowClosingAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SaveLayersDialog.this.cancelAction.cancel();
        }
    }

    private static class LayerListWarningMessagePanel
    extends JPanel {
        private JLabel lblMessage;
        private JList<SaveLayerInfo> lstLayers;

        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridy = 0;
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            this.lblMessage = new JLabel();
            this.add((Component)this.lblMessage, gc);
            this.lblMessage.setHorizontalAlignment(2);
            this.lstLayers = new JList();
            this.lstLayers.setCellRenderer(new ListCellRenderer<SaveLayerInfo>(){
                final DefaultListCellRenderer def = new DefaultListCellRenderer();

                @Override
                public Component getListCellRendererComponent(JList<? extends SaveLayerInfo> list, SaveLayerInfo info, int index, boolean isSelected, boolean cellHasFocus) {
                    this.def.setIcon(info.getLayer().getIcon());
                    this.def.setText(info.getName());
                    return this.def;
                }
            });
            gc.gridx = 0;
            gc.gridy = 1;
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            this.add(this.lstLayers, gc);
        }

        public LayerListWarningMessagePanel(String msg, List<SaveLayerInfo> infos) {
            this.build();
            this.lblMessage.setText(msg);
            this.lstLayers.setListData((SaveLayerInfo[])infos.toArray(new SaveLayerInfo[0]));
        }
    }

    public static enum UserAction {
        PROCEED,
        CANCEL;

    }
}

