/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.SaveAction;
import org.openstreetmap.josm.gui.io.AbstractIOTask;
import org.openstreetmap.josm.gui.io.SaveLayerInfo;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class SaveLayerTask
extends AbstractIOTask {
    private SaveLayerInfo layerInfo;
    private ProgressMonitor parentMonitor;

    protected SaveLayerTask(SaveLayerInfo layerInfo, ProgressMonitor monitor) {
        CheckParameterUtil.ensureParameterNotNull(layerInfo, "layerInfo");
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.layerInfo = layerInfo;
        this.parentMonitor = monitor;
    }

    @Override
    public void run() {
        try {
            this.parentMonitor.subTask(I18n.tr("Saving layer to ''{0}'' ...", this.layerInfo.getFile().toString()));
            if (!SaveAction.doSave(this.layerInfo.getLayer(), this.layerInfo.getFile(), this.layerInfo.isDoCheckSaveConditions())) {
                this.setFailed(true);
                return;
            }
            if (!this.isCanceled()) {
                this.layerInfo.getLayer().onPostSaveToFile();
            }
        }
        catch (Exception e) {
            Main.error(e);
            this.setLastException(e);
        }
    }

    @Override
    public void cancel() {
        this.setCanceled(true);
    }
}

