/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.io.File;
import org.openstreetmap.josm.gui.io.UploadOrSaveState;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;

class SaveLayerInfo
implements Comparable<SaveLayerInfo> {
    private AbstractModifiableLayer layer;
    private boolean doCheckSaveConditions;
    private boolean doSaveToFile;
    private boolean doUploadToServer;
    private File file;
    private UploadOrSaveState uploadState;
    private UploadOrSaveState saveState;

    public SaveLayerInfo(AbstractModifiableLayer layer) {
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        this.layer = layer;
        this.doCheckSaveConditions = true;
        this.doSaveToFile = layer.requiresSaveToFile();
        this.doUploadToServer = layer.requiresUploadToServer() && !layer.isUploadDiscouraged();
        this.file = layer.getAssociatedFile();
    }

    public AbstractModifiableLayer getLayer() {
        return this.layer;
    }

    public boolean isDoCheckSaveConditions() {
        return this.doCheckSaveConditions;
    }

    public void setDoCheckSaveConditions(boolean doCheckSaveConditions) {
        this.doCheckSaveConditions = doCheckSaveConditions;
    }

    public boolean isDoSaveToFile() {
        return this.doSaveToFile;
    }

    public void setDoSaveToFile(boolean doSaveToFile) {
        this.doSaveToFile = doSaveToFile;
    }

    public boolean isDoUploadToServer() {
        return this.doUploadToServer;
    }

    public void setDoUploadToServer(boolean doUploadToServer) {
        this.doUploadToServer = doUploadToServer;
    }

    public boolean isDoSaveAndUpload() {
        return this.isDoSaveToFile() && this.isDoUploadToServer();
    }

    public String getName() {
        return this.layer.getName() == null ? "" : this.layer.getName();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public int compareTo(SaveLayerInfo o) {
        if (this.isDoSaveAndUpload()) {
            if (o.isDoSaveAndUpload()) {
                return this.getName().compareTo(o.getName());
            }
            return -1;
        }
        if (o.isDoSaveAndUpload()) {
            return 1;
        }
        if (this.isDoUploadToServer()) {
            if (o.isDoUploadToServer()) {
                return this.getName().compareTo(o.getName());
            }
            return -1;
        }
        if (o.isDoUploadToServer()) {
            return 1;
        }
        if (this.isDoSaveToFile()) {
            if (o.isDoSaveToFile()) {
                return this.getName().compareTo(o.getName());
            }
            return -1;
        }
        if (o.isDoSaveToFile()) {
            return 1;
        }
        return this.getName().compareTo(o.getName());
    }

    public UploadOrSaveState getUploadState() {
        return this.uploadState;
    }

    public void setUploadState(UploadOrSaveState uploadState) {
        this.uploadState = uploadState;
    }

    public UploadOrSaveState getSaveState() {
        return this.saveState;
    }

    public void setSaveState(UploadOrSaveState saveState) {
        this.saveState = saveState;
    }

    public void resetUploadAndSaveState() {
        this.uploadState = null;
        this.saveState = null;
    }
}

