/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.gui.io.SaveLayerInfo;
import org.openstreetmap.josm.gui.util.CellEditorSupport;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

class LayerNameAndFilePathTableCell
extends JPanel
implements TableCellEditor,
TableCellRenderer {
    private static final Color colorError = new Color(255, 197, 197);
    private static final String separator = System.getProperty("file.separator");
    private static final String ellipsis = "\u2026" + separator;
    private final JLabel lblLayerName = new JLabel();
    private final JLabel lblFilename = new JLabel("");
    private final JosmTextField tfFilename = new JosmTextField();
    private final JButton btnFileChooser = new JButton(new LaunchFileChooserAction());
    private static final GBC defaultCellStyle = GBC.eol().fill(2).insets(2, 0, 2, 0);
    private final CellEditorSupport cellEditorSupport = new CellEditorSupport(this);
    private File value;

    public LayerNameAndFilePathTableCell() {
        this.setLayout(new GridBagLayout());
        this.lblLayerName.setPreferredSize(new Dimension(this.lblLayerName.getPreferredSize().width, 19));
        this.lblLayerName.setFont(this.lblLayerName.getFont().deriveFont(1));
        this.lblFilename.setPreferredSize(new Dimension(this.lblFilename.getPreferredSize().width, 19));
        this.lblFilename.setOpaque(true);
        this.tfFilename.setToolTipText(I18n.tr("Either edit the path manually in the text field or click the \"...\" button to open a file chooser.", new Object[0]));
        this.tfFilename.setPreferredSize(new Dimension(this.tfFilename.getPreferredSize().width, 19));
        this.tfFilename.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                LayerNameAndFilePathTableCell.this.tfFilename.selectAll();
            }
        });
        this.tfFilename.setBorder(BorderFactory.createLineBorder(this.getBackground()));
        this.btnFileChooser.setPreferredSize(new Dimension(20, 19));
        this.btnFileChooser.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.removeAll();
        SaveLayerInfo info = (SaveLayerInfo)value;
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(this.addLblLayerName(info));
        sb.append("<br>");
        this.add((Component)this.btnFileChooser, GBC.std());
        sb.append(this.addLblFilename(info));
        sb.append("</html>");
        this.setToolTipText(sb.toString());
        return this;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.removeAll();
        SaveLayerInfo info = (SaveLayerInfo)value;
        value = info.getFile();
        this.tfFilename.setText(value == null ? "" : value.toString());
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(this.addLblLayerName(info));
        sb.append("<br/>");
        this.add((Component)this.btnFileChooser, GBC.std());
        this.add((Component)this.tfFilename, GBC.eol().fill(2).insets(1, 0, 0, 0));
        this.tfFilename.selectAll();
        sb.append(this.tfFilename.getToolTipText());
        sb.append("</html>");
        this.setToolTipText(sb.toString());
        return this;
    }

    private static boolean canWrite(File f) {
        if (f == null) {
            return false;
        }
        if (f.isDirectory()) {
            return false;
        }
        if (f.exists() && f.canWrite()) {
            return true;
        }
        return !f.exists() && f.getParentFile() != null && f.getParentFile().canWrite();
    }

    private String addLblLayerName(SaveLayerInfo info) {
        this.lblLayerName.setIcon(info.getLayer().getIcon());
        this.lblLayerName.setText(info.getName());
        this.add((Component)this.lblLayerName, defaultCellStyle);
        return I18n.tr("The bold text is the name of the layer.", new Object[0]);
    }

    private String addLblFilename(SaveLayerInfo info) {
        String tooltip = "";
        boolean error = false;
        if (info.getFile() == null) {
            error = info.isDoSaveToFile();
            this.lblFilename.setText(I18n.tr("Click here to choose save path", new Object[0]));
            this.lblFilename.setFont(this.lblFilename.getFont().deriveFont(2));
            tooltip = I18n.tr("Layer ''{0}'' is not backed by a file", info.getName());
        } else {
            String t = info.getFile().getPath();
            this.lblFilename.setText(this.makePathFit(t));
            tooltip = info.getFile().getAbsolutePath();
            if (info.isDoSaveToFile() && !LayerNameAndFilePathTableCell.canWrite(info.getFile())) {
                error = true;
                tooltip = I18n.tr("File ''{0}'' is not writable. Please enter another file name.", info.getFile().getPath());
            }
        }
        this.lblFilename.setBackground(error ? colorError : this.getBackground());
        this.btnFileChooser.setBackground(error ? colorError : this.getBackground());
        this.add((Component)this.lblFilename, defaultCellStyle);
        return I18n.tr("Click cell to change the file path.", new Object[0]) + "<br/>" + tooltip;
    }

    private String makePathFit(String t) {
        int txtwidth;
        boolean hasEllipsis = false;
        while (t != null && !t.isEmpty() && (txtwidth = this.lblFilename.getFontMetrics(this.lblFilename.getFont()).stringWidth(t)) >= this.lblFilename.getWidth() && t.lastIndexOf(separator) >= ellipsis.length()) {
            t = hasEllipsis ? t.substring(ellipsis.length()) : t;
            t = ellipsis + t.substring(t.indexOf(separator) + 1);
            hasEllipsis = true;
        }
        return t;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.cellEditorSupport.addCellEditorListener(l);
    }

    @Override
    public void cancelCellEditing() {
        this.cellEditorSupport.fireEditingCanceled();
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.cellEditorSupport.removeCellEditorListener(l);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.value = this.tfFilename.getText() == null || this.tfFilename.getText().trim().isEmpty() ? null : new File(this.tfFilename.getText());
        this.cellEditorSupport.fireEditingStopped();
        return true;
    }

    private class LaunchFileChooserAction
    extends AbstractAction {
        public LaunchFileChooserAction() {
            this.putValue("Name", "...");
            this.putValue("ShortDescription", I18n.tr("Launch a file chooser to select a file", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File f = SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Select filename", new Object[0]), "osm");
            if (f != null) {
                LayerNameAndFilePathTableCell.this.tfFilename.setText(f.toString());
                LayerNameAndFilePathTableCell.this.stopCellEditing();
            }
        }
    }
}

