/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadPrimitivesTask
extends PleaseWaitRunnable {
    private DataSet ds;
    private boolean canceled;
    private Exception lastException;
    private final List<PrimitiveId> ids;
    private Set<PrimitiveId> missingPrimitives;
    private final OsmDataLayer layer;
    private final boolean fullRelation;
    private MultiFetchServerObjectReader multiObjectReader;
    private OsmServerObjectReader objectReader;

    public DownloadPrimitivesTask(OsmDataLayer layer, List<PrimitiveId> ids, boolean fullRelation) throws IllegalArgumentException {
        this(layer, ids, fullRelation, null);
    }

    public DownloadPrimitivesTask(OsmDataLayer layer, List<PrimitiveId> ids, boolean fullRelation, ProgressMonitor progressMonitor) throws IllegalArgumentException {
        super(I18n.tr("Download objects", new Object[0]), progressMonitor, false);
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        this.ids = ids;
        this.layer = layer;
        this.fullRelation = fullRelation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        DownloadPrimitivesTask downloadPrimitivesTask = this;
        synchronized (downloadPrimitivesTask) {
            if (this.multiObjectReader != null) {
                this.multiObjectReader.cancel();
            }
            if (this.objectReader != null) {
                this.objectReader.cancel();
            }
        }
    }

    @Override
    protected void finish() {
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
            return;
        }
        GuiHelper.runInEDTAndWait(new Runnable(){

            @Override
            public void run() {
                DownloadPrimitivesTask.this.layer.mergeFrom(DownloadPrimitivesTask.this.ds);
                if (Main.map != null) {
                    AutoScaleAction.zoomTo(DownloadPrimitivesTask.this.ds.allPrimitives());
                }
                DownloadPrimitivesTask.this.layer.onPostDownloadFromServer();
            }
        });
    }

    protected void initMultiFetchReader(MultiFetchServerObjectReader reader) {
        this.getProgressMonitor().indeterminateSubTask(I18n.tr("Initializing nodes to download ...", new Object[0]));
        for (PrimitiveId id : this.ids) {
            OsmPrimitive osm = this.layer.data.getPrimitiveById(id);
            if (osm == null) {
                switch (id.getType()) {
                    case NODE: {
                        osm = new Node(id.getUniqueId());
                        break;
                    }
                    case WAY: {
                        osm = new Way(id.getUniqueId());
                        break;
                    }
                    case RELATION: {
                        osm = new Relation(id.getUniqueId());
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            reader.append(osm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        this.ds = new DataSet();
        try {
            DownloadPrimitivesTask downloadPrimitivesTask;
            DownloadPrimitivesTask downloadPrimitivesTask2 = this;
            synchronized (downloadPrimitivesTask2) {
                if (this.canceled) {
                    return;
                }
                this.multiObjectReader = new MultiFetchServerObjectReader();
            }
            this.initMultiFetchReader(this.multiObjectReader);
            DataSet theirDataSet = this.multiObjectReader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
            this.missingPrimitives = this.multiObjectReader.getMissingPrimitives();
            downloadPrimitivesTask2 = this;
            synchronized (downloadPrimitivesTask2) {
                this.multiObjectReader = null;
            }
            DataSetMerger merger = new DataSetMerger(this.ds, theirDataSet);
            merger.merge();
            for (Relation r : this.ds.getRelations()) {
                if (this.canceled) {
                    return;
                }
                if (!r.isIncomplete() && !r.hasIncompleteMembers()) continue;
                downloadPrimitivesTask = this;
                synchronized (downloadPrimitivesTask) {
                    if (this.canceled) {
                        return;
                    }
                    this.objectReader = new OsmServerObjectReader(r.getId(), OsmPrimitiveType.RELATION, this.fullRelation);
                }
                theirDataSet = this.objectReader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
                downloadPrimitivesTask = this;
                synchronized (downloadPrimitivesTask) {
                    this.objectReader = null;
                }
                merger = new DataSetMerger(this.ds, theirDataSet);
                merger.merge();
            }
            for (Way w : this.ds.getWays()) {
                if (this.canceled) {
                    return;
                }
                if (!w.hasIncompleteNodes()) continue;
                downloadPrimitivesTask = this;
                synchronized (downloadPrimitivesTask) {
                    if (this.canceled) {
                        return;
                    }
                    this.objectReader = new OsmServerObjectReader(w.getId(), OsmPrimitiveType.WAY, true);
                }
                theirDataSet = this.objectReader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
                downloadPrimitivesTask = this;
                synchronized (downloadPrimitivesTask) {
                    this.objectReader = null;
                }
                merger = new DataSetMerger(this.ds, theirDataSet);
                merger.merge();
            }
        }
        catch (Exception e) {
            if (this.canceled) {
                return;
            }
            this.lastException = e;
        }
    }

    public Set<PrimitiveId> getMissingPrimitives() {
        return this.missingPrimitives;
    }
}

