/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.io.IOException;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.OsmServerChangesetReader;
import org.openstreetmap.josm.io.OsmServerUserInfoReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadOpenChangesetsTask
extends PleaseWaitRunnable {
    private boolean canceled;
    private OsmServerChangesetReader reader;
    private List<Changeset> changesets;
    private Exception lastException;
    private Component parent;

    public DownloadOpenChangesetsTask(Component parent) {
        super(parent, I18n.tr("Downloading open changesets ...", new Object[0]), false);
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        DownloadOpenChangesetsTask downloadOpenChangesetsTask = this;
        synchronized (downloadOpenChangesetsTask) {
            if (this.reader != null) {
                this.reader.cancel();
            }
        }
    }

    @Override
    protected void finish() {
        if (JosmUserIdentityManager.getInstance().isAnonymous()) {
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this.parent), "<html>" + I18n.tr("Could not retrieve the list of your open changesets because<br>JOSM does not know your identity.<br>You have either chosen to work anonymously or you are not entitled<br>to know the identity of the user on whose behalf you are working.", new Object[0]) + "</html>", I18n.tr("Missing user identity", new Object[0]), 0);
            return;
        }
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
            return;
        }
        if (this.changesets.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("There are no open changesets", new Object[0]), I18n.tr("No open changesets", new Object[0]), 1);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChangesetCache.getInstance().update(DownloadOpenChangesetsTask.this.changesets);
            }
        });
    }

    protected void refreshUserIdentity() {
        JosmUserIdentityManager im = JosmUserIdentityManager.getInstance();
        try {
            OsmServerUserInfoReader infoReader = new OsmServerUserInfoReader();
            UserInfo info = infoReader.fetchUserInfo(this.getProgressMonitor().createSubTaskMonitor(1, false));
            im.setFullyIdentified(info.getDisplayName(), info);
        }
        catch (OsmTransferException e) {
            if (im.isFullyIdentified()) {
                im.setPartiallyIdentified(im.getUserName());
            }
            Main.warn(I18n.tr("Failed to retrieve user infos for the current JOSM user. Exception was: {0}", e.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            JosmUserIdentityManager im = JosmUserIdentityManager.getInstance();
            if (im.isAnonymous()) {
                this.refreshUserIdentity();
            } else if (!im.isFullyIdentified() && im.isPartiallyIdentified()) {
                this.refreshUserIdentity();
            }
            if (this.canceled) {
                return;
            }
            DownloadOpenChangesetsTask downloadOpenChangesetsTask = this;
            synchronized (downloadOpenChangesetsTask) {
                this.reader = new OsmServerChangesetReader();
            }
            ChangesetQuery query = new ChangesetQuery().beingOpen(true);
            if (im.isAnonymous()) {
                return;
            }
            query = im.isFullyIdentified() ? query.forUser(im.getUserId()) : query.forUser(im.getUserName());
            this.changesets = this.reader.queryChangesets(query, this.getProgressMonitor().createSubTaskMonitor(1, false));
        }
        catch (Exception e) {
            if (this.canceled) {
                return;
            }
            this.lastException = e;
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

