/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class DownloadFileTask
extends PleaseWaitRunnable {
    private final String address;
    private final File file;
    private final boolean mkdir;
    private final boolean unpack;
    private boolean canceled;
    private HttpURLConnection downloadConnection;

    public DownloadFileTask(Component parent, String address, File file, boolean mkdir, boolean unpack) {
        super(parent, I18n.tr("Downloading file", new Object[0]), false);
        this.address = address;
        this.file = file;
        this.mkdir = mkdir;
        this.unpack = unpack;
    }

    private synchronized void closeConnectionIfNeeded() {
        if (this.downloadConnection != null) {
            this.downloadConnection.disconnect();
        }
        this.downloadConnection = null;
    }

    @Override
    protected void cancel() {
        this.canceled = true;
        this.closeConnectionIfNeeded();
    }

    @Override
    protected void finish() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download() throws DownloadException {
        try {
            int size;
            File newDir;
            if (this.mkdir && !(newDir = this.file.getParentFile()).exists()) {
                newDir.mkdirs();
            }
            URL url = new URL(this.address);
            DownloadFileTask downloadFileTask = this;
            synchronized (downloadFileTask) {
                this.downloadConnection = Utils.openHttpConnection(url);
                this.downloadConnection.setRequestProperty("Cache-Control", "no-cache");
                this.downloadConnection.connect();
                size = this.downloadConnection.getContentLength();
            }
            this.progressMonitor.setTicksCount(100);
            this.progressMonitor.subTask(I18n.tr("Downloading File {0}: {1} bytes...", this.file.getName(), size));
            try (InputStream in = this.downloadConnection.getInputStream();
                 FileOutputStream out = new FileOutputStream(this.file);){
                byte[] buffer = new byte[32768];
                int count = 0;
                int p1 = 0;
                int p2 = 0;
                int read = in.read(buffer);
                while (read != -1) {
                    ((OutputStream)out).write(buffer, 0, read);
                    count += read;
                    if (this.canceled) {
                        break;
                    }
                    p2 = 100 * count / size;
                    if (p2 != p1) {
                        this.progressMonitor.setTicks(p2);
                        p1 = p2;
                    }
                    read = in.read(buffer);
                }
            }
            if (!this.canceled) {
                Main.info(I18n.tr("Download finished", new Object[0]));
                if (this.unpack) {
                    Main.info(I18n.tr("Unpacking {0} into {1}", this.file.getAbsolutePath(), this.file.getParent()));
                    DownloadFileTask.unzipFileRecursively(this.file, this.file.getParent());
                    this.file.delete();
                }
            }
        }
        catch (MalformedURLException e) {
            String msg = I18n.tr("Cannot download file ''{0}''. Its download link ''{1}'' is not a valid URL. Skipping download.", this.file.getName(), this.address);
            Main.warn(msg);
            throw new DownloadException(msg);
        }
        catch (IOException e) {
            if (this.canceled) {
                return;
            }
            throw new DownloadException(e.getMessage());
        }
        finally {
            this.closeConnectionIfNeeded();
        }
    }

    @Override
    protected void realRun() throws SAXException, IOException {
        if (this.canceled) {
            return;
        }
        try {
            this.download();
        }
        catch (DownloadException e) {
            Main.error(e);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public static void unzipFileRecursively(File file, String dir) throws IOException {
        try (ZipFile zf = new ZipFile(file, StandardCharsets.UTF_8);){
            Enumeration<? extends ZipEntry> es = zf.entries();
            while (es.hasMoreElements()) {
                ZipEntry ze = es.nextElement();
                File newFile = new File(dir, ze.getName());
                if (ze.isDirectory()) {
                    newFile.mkdirs();
                    continue;
                }
                InputStream is = zf.getInputStream(ze);
                Throwable throwable = null;
                try {
                    BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(newFile));
                    Throwable throwable2 = null;
                    try {
                        int read;
                        byte[] buffer = new byte[8192];
                        while ((read = is.read(buffer)) != -1) {
                            ((OutputStream)os).write(buffer, 0, read);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (os == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((OutputStream)os).close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                            continue;
                        }
                        ((OutputStream)os).close();
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
    }

    private static class DownloadException
    extends Exception {
        public DownloadException(String msg) {
            super(msg);
        }
    }
}

