/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.io.ChangesetCommentModel;
import org.openstreetmap.josm.gui.io.UploadParameterSummaryPanel;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class BasicUploadSettingsPanel
extends JPanel {
    public static final String HISTORY_KEY = "upload.comment.history";
    public static final String HISTORY_LAST_USED_KEY = "upload.comment.last-used";
    public static final String HISTORY_MAX_AGE_KEY = "upload.comment.max-age";
    public static final String SOURCE_HISTORY_KEY = "upload.source.history";
    private final HistoryComboBox hcbUploadComment = new HistoryComboBox();
    private final HistoryComboBox hcbUploadSource = new HistoryComboBox();
    private final UploadParameterSummaryPanel pnlUploadParameterSummary = new UploadParameterSummaryPanel();
    private final ChangesetCommentModel changesetCommentModel;
    private final ChangesetCommentModel changesetSourceModel;

    protected JPanel buildUploadCommentPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        JMultilineLabel commentLabel = new JMultilineLabel("<html><b>" + I18n.tr("Provide a brief comment for the changes you are uploading:", new Object[0]));
        pnl.add((Component)commentLabel, GBC.eol().insets(0, 5, 10, 3).fill(2));
        this.hcbUploadComment.setToolTipText(I18n.tr("Enter an upload comment", new Object[0]));
        this.hcbUploadComment.setMaxTextLength(255);
        LinkedList<String> cmtHistory = new LinkedList<String>(Main.pref.getCollection(HISTORY_KEY, new LinkedList<String>()));
        Collections.reverse(cmtHistory);
        this.hcbUploadComment.setPossibleItems(cmtHistory);
        CommentModelListener commentModelListener = new CommentModelListener(this.hcbUploadComment, this.changesetCommentModel);
        this.hcbUploadComment.getEditor().addActionListener(commentModelListener);
        this.hcbUploadComment.getEditor().getEditorComponent().addFocusListener(commentModelListener);
        pnl.add((Component)this.hcbUploadComment, GBC.eol().fill(2));
        JMultilineLabel sourceLabel = new JMultilineLabel("<html><b>" + I18n.tr("Specify the data source for the changes", new Object[0]) + "</b> (<a href=\"urn:changeset-source\">" + I18n.tr("obtain from current layers", new Object[0]) + "</a>)<b>:</b>");
        sourceLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                    BasicUploadSettingsPanel.this.hcbUploadSource.setText(Main.map.mapView.getLayerInformationForSourceTag());
                    BasicUploadSettingsPanel.this.changesetSourceModel.setComment(BasicUploadSettingsPanel.this.hcbUploadSource.getText());
                }
            }
        });
        pnl.add((Component)sourceLabel, GBC.eol().insets(0, 8, 10, 3).fill(2));
        this.hcbUploadSource.setToolTipText(I18n.tr("Enter a source", new Object[0]));
        this.hcbUploadSource.setMaxTextLength(255);
        LinkedList<String> sourceHistory = new LinkedList<String>(Main.pref.getCollection(SOURCE_HISTORY_KEY, Arrays.asList("knowledge", "survey", "Bing")));
        Collections.reverse(sourceHistory);
        this.hcbUploadSource.setPossibleItems(sourceHistory);
        CommentModelListener sourceModelListener = new CommentModelListener(this.hcbUploadSource, this.changesetSourceModel);
        this.hcbUploadSource.getEditor().addActionListener(sourceModelListener);
        this.hcbUploadSource.getEditor().getEditorComponent().addFocusListener(sourceModelListener);
        pnl.add((Component)this.hcbUploadSource, GBC.eol().fill(2));
        return pnl;
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.add((Component)this.buildUploadCommentPanel(), "North");
        this.add((Component)this.pnlUploadParameterSummary, "Center");
    }

    public BasicUploadSettingsPanel(ChangesetCommentModel changesetCommentModel, ChangesetCommentModel changesetSourceModel) {
        CheckParameterUtil.ensureParameterNotNull(changesetCommentModel, "changesetCommentModel");
        CheckParameterUtil.ensureParameterNotNull(changesetSourceModel, "changesetSourceModel");
        this.changesetCommentModel = changesetCommentModel;
        this.changesetSourceModel = changesetSourceModel;
        changesetCommentModel.addObserver(new ChangesetCommentObserver(this.hcbUploadComment));
        changesetSourceModel.addObserver(new ChangesetCommentObserver(this.hcbUploadSource));
        this.build();
    }

    public void setUploadTagDownFocusTraversalHandlers(Action handler) {
        this.setHistoryComboBoxDownFocusTraversalHandler(handler, this.hcbUploadComment);
        this.setHistoryComboBoxDownFocusTraversalHandler(handler, this.hcbUploadSource);
    }

    public void setHistoryComboBoxDownFocusTraversalHandler(final Action handler, final HistoryComboBox hcb) {
        hcb.getEditor().addActionListener(handler);
        hcb.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    handler.actionPerformed(new ActionEvent(hcb, 0, "focusDown"));
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
    }

    public void rememberUserInput() {
        this.hcbUploadComment.addCurrentItemToHistory();
        Main.pref.putCollection(HISTORY_KEY, this.hcbUploadComment.getHistory());
        Main.pref.putInteger(HISTORY_LAST_USED_KEY, (int)(System.currentTimeMillis() / 1000L));
        this.hcbUploadSource.addCurrentItemToHistory();
        Main.pref.putCollection(SOURCE_HISTORY_KEY, this.hcbUploadSource.getHistory());
    }

    public void startUserInput() {
        this.hcbUploadComment.requestFocusInWindow();
        this.hcbUploadComment.getEditor().getEditorComponent().requestFocusInWindow();
    }

    public void initEditingOfUploadComment() {
        this.hcbUploadComment.getEditor().selectAll();
        this.hcbUploadComment.requestFocusInWindow();
    }

    public UploadParameterSummaryPanel getUploadParameterSummaryPanel() {
        return this.pnlUploadParameterSummary;
    }

    static class ChangesetCommentObserver
    implements Observer {
        private final HistoryComboBox destination;

        ChangesetCommentObserver(HistoryComboBox destination) {
            this.destination = destination;
        }

        @Override
        public void update(Observable o, Object arg) {
            if (!(o instanceof ChangesetCommentModel)) {
                return;
            }
            String newComment = (String)arg;
            if (!this.destination.getText().equals(newComment)) {
                this.destination.setText(newComment);
            }
        }
    }

    static class CommentModelListener
    extends FocusAdapter
    implements ActionListener {
        final HistoryComboBox source;
        final ChangesetCommentModel destination;

        CommentModelListener(HistoryComboBox source, ChangesetCommentModel destination) {
            this.source = source;
            this.destination = destination;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.destination.setComment(this.source.getText());
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.destination.setComment(this.source.getText());
        }
    }
}

