/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.io.SaveLayerInfo;
import org.openstreetmap.josm.gui.util.CellEditorSupport;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

class ActionFlagsTableCell
extends JPanel
implements TableCellEditor,
TableCellRenderer {
    private final JCheckBox[] checkBoxes = new JCheckBox[2];
    private final CellEditorSupport cellEditorSupport = new CellEditorSupport(this);
    private ActionListener al = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ActionFlagsTableCell.this.cellEditorSupport.fireEditingStopped();
        }
    };

    public ActionFlagsTableCell() {
        this.checkBoxes[0] = new JCheckBox(I18n.tr("Upload", new Object[0]));
        this.checkBoxes[1] = new JCheckBox(I18n.tr("Save", new Object[0]));
        this.setLayout(new GridBagLayout());
        ActionMap am = this.getActionMap();
        for (final JCheckBox b : this.checkBoxes) {
            this.add((Component)b, GBC.eol().fill(2));
            b.setPreferredSize(new Dimension(b.getPreferredSize().width, 19));
            b.addActionListener(this.al);
            am.put(b.getText(), new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    b.setSelected(!b.isSelected());
                    ActionFlagsTableCell.this.cellEditorSupport.fireEditingStopped();
                }
            });
        }
        this.setToolTipText(I18n.tr("<html>Select which actions to perform for this layer, if you click the leftmost button.<br/>Check \"upload\" to upload the changes to the OSM server.<br/>Check \"Save\" to save the layer to the file specified on the left.</html>", new Object[0]));
    }

    protected void updateCheckboxes(Object v) {
        if (v != null && this.checkBoxes[0] != null && this.checkBoxes[1] != null) {
            boolean[] values = v instanceof SaveLayerInfo ? new boolean[]{((SaveLayerInfo)v).isDoUploadToServer(), ((SaveLayerInfo)v).isDoSaveToFile()} : (boolean[])v;
            this.checkBoxes[0].setSelected(values[0]);
            this.checkBoxes[1].setSelected(values[1]);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.updateCheckboxes(value);
        return this;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.cellEditorSupport.addCellEditorListener(l);
    }

    @Override
    public void cancelCellEditing() {
        this.cellEditorSupport.fireEditingCanceled();
    }

    @Override
    public Object getCellEditorValue() {
        boolean[] values = new boolean[]{this.checkBoxes[0].isSelected(), this.checkBoxes[1].isSelected()};
        return values;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.cellEditorSupport.removeCellEditorListener(l);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.cellEditorSupport.fireEditingStopped();
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.updateCheckboxes(value);
        return this;
    }
}

