/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.DateUtils;

public class VersionInfoPanel
extends JPanel
implements Observer {
    private PointInTimeType pointInTimeType;
    private HistoryBrowserModel model;
    private JMultilineLabel lblInfo;
    private UrlLabel lblUser;
    private UrlLabel lblChangeset;
    private JPanel pnlChangesetSource;
    private JLabel lblSource;
    private JTextArea lblChangesetComment;
    private JTextArea lblChangesetSource;

    protected static JTextArea buildTextArea(String tooltip) {
        JTextArea lbl = new JTextArea();
        lbl.setLineWrap(true);
        lbl.setWrapStyleWord(true);
        lbl.setEditable(false);
        lbl.setOpaque(false);
        lbl.setToolTipText(tooltip);
        return lbl;
    }

    protected static JLabel buildLabel(String text, String tooltip, JTextArea textArea) {
        JLabel lbl = new JLabel("<html><p style='margin-top:" + textArea.getMargin().top + "'>" + text + "</html>");
        lbl.setFont(textArea.getFont());
        lbl.setToolTipText(tooltip);
        return lbl;
    }

    protected static JPanel buildTextPanel(JLabel label, JTextArea textArea) {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.add((Component)label, GBC.std().anchor(18));
        pnl.add((Component)textArea, GBC.eol().fill());
        return pnl;
    }

    protected void build() {
        JPanel pnl1 = new JPanel(new BorderLayout());
        this.lblInfo = new JMultilineLabel("");
        pnl1.add((Component)this.lblInfo, "Center");
        JPanel pnlUserAndChangeset = new JPanel(new GridLayout(2, 2));
        this.lblUser = new UrlLabel("", 2);
        pnlUserAndChangeset.add(new JLabel(I18n.tr("User:", new Object[0])));
        pnlUserAndChangeset.add(this.lblUser);
        pnlUserAndChangeset.add(new JLabel(I18n.tr("Changeset:", new Object[0])));
        this.lblChangeset = new UrlLabel("", 2);
        pnlUserAndChangeset.add(this.lblChangeset);
        this.lblChangesetComment = VersionInfoPanel.buildTextArea(I18n.tr("Changeset comment", new Object[0]));
        this.lblChangesetSource = VersionInfoPanel.buildTextArea(I18n.tr("Changeset source", new Object[0]));
        this.lblSource = VersionInfoPanel.buildLabel(I18n.tr("<b>Source</b>:", new Object[0]), I18n.tr("Changeset source", new Object[0]), this.lblChangesetSource);
        this.pnlChangesetSource = VersionInfoPanel.buildTextPanel(this.lblSource, this.lblChangesetSource);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        this.add((Component)pnl1, gc);
        gc.gridy = 1;
        gc.weighty = 0.0;
        this.add((Component)pnlUserAndChangeset, gc);
        gc.gridy = 2;
        this.add((Component)this.lblChangesetComment, gc);
        gc.gridy = 3;
        this.add((Component)this.pnlChangesetSource, gc);
    }

    protected HistoryOsmPrimitive getPrimitive() {
        if (this.model == null || this.pointInTimeType == null) {
            return null;
        }
        return this.model.getPointInTime(this.pointInTimeType);
    }

    protected String getInfoText() {
        String text;
        HistoryOsmPrimitive primitive = this.getPrimitive();
        if (primitive == null) {
            return "";
        }
        if (this.model.isLatest(primitive)) {
            OsmDataLayer editLayer = Main.main.getEditLayer();
            text = I18n.tr("<html>Version <strong>{0}</strong> currently edited in layer ''{1}''</html>", Long.toString(primitive.getVersion()), editLayer == null ? I18n.tr("unknown", new Object[0]) : editLayer.getName());
        } else {
            String date = "?";
            if (primitive.getTimestamp() != null) {
                date = DateUtils.formatDateTime(primitive.getTimestamp(), 3, 3);
            }
            text = I18n.tr("<html>Version <strong>{0}</strong> created on <strong>{1}</strong></html>", Long.toString(primitive.getVersion()), date);
        }
        return text;
    }

    public VersionInfoPanel() {
        this.pointInTimeType = null;
        this.model = null;
        this.build();
    }

    public VersionInfoPanel(HistoryBrowserModel model, PointInTimeType pointInTimeType) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "pointInTimeType");
        CheckParameterUtil.ensureParameterNotNull(model, "model");
        this.model = model;
        this.pointInTimeType = pointInTimeType;
        model.addObserver(this);
        this.build();
    }

    protected static String getUserUrl(String username) throws UnsupportedEncodingException {
        return Main.getBaseUserUrl() + "/" + URLEncoder.encode(username, "UTF-8").replaceAll("\\+", "%20");
    }

    @Override
    public void update(Observable o, Object arg) {
        Changeset cs;
        block10: {
            this.lblInfo.setText(this.getInfoText());
            HistoryOsmPrimitive primitive = this.getPrimitive();
            cs = primitive.getChangeset();
            if (!this.model.isLatest(primitive)) {
                User user = primitive.getUser();
                String url = Main.getBaseBrowseUrl() + "/changeset/" + primitive.getChangesetId();
                this.lblChangeset.setUrl(url);
                this.lblChangeset.setDescription(Long.toString(primitive.getChangesetId()));
                String username = "";
                if (user != null) {
                    username = user.getName();
                }
                this.lblUser.setDescription(username);
                try {
                    if (user != null && user != User.getAnonymous()) {
                        this.lblUser.setUrl(VersionInfoPanel.getUserUrl(username));
                        break block10;
                    }
                    this.lblUser.setUrl(null);
                }
                catch (UnsupportedEncodingException e) {
                    Main.error(e);
                    this.lblUser.setUrl(null);
                }
            } else {
                String username = JosmUserIdentityManager.getInstance().getUserName();
                if (username == null) {
                    this.lblUser.setDescription(I18n.tr("anonymous", new Object[0]));
                    this.lblUser.setUrl(null);
                } else {
                    this.lblUser.setDescription(username);
                    try {
                        this.lblUser.setUrl(VersionInfoPanel.getUserUrl(username));
                    }
                    catch (UnsupportedEncodingException e) {
                        Main.error(e);
                        this.lblUser.setUrl(null);
                    }
                }
                this.lblChangeset.setDescription(I18n.tr("none", new Object[0]));
                this.lblChangeset.setUrl(null);
            }
        }
        Changeset oppCs = this.model.getPointInTime(this.pointInTimeType.opposite()).getChangeset();
        VersionInfoPanel.updateText(cs, "comment", this.lblChangesetComment, null, oppCs, this.lblChangesetComment);
        VersionInfoPanel.updateText(cs, "source", this.lblChangesetSource, this.lblSource, oppCs, this.pnlChangesetSource);
    }

    protected static void updateText(Changeset cs, String attr, JTextArea textArea, JLabel label, Changeset oppCs, JComponent container) {
        String text;
        String string = text = cs != null ? cs.get(attr) : null;
        if (label != null) {
            label.setVisible(text != null && !Utils.strip(text).isEmpty());
        }
        textArea.setText(text);
        container.setVisible(text != null || oppCs != null && oppCs.get(attr) != null);
    }
}

