/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.tools.Diff;
import org.openstreetmap.josm.tools.Utils;

class TwoColumnDiff {
    public List<Item> referenceDiff;
    public List<Item> currentDiff;
    Object[] reference;
    Object[] current;

    public TwoColumnDiff(Object[] reference, Object[] current) {
        this.reference = Utils.copyArray(reference);
        this.current = Utils.copyArray(current);
        this.referenceDiff = new ArrayList<Item>();
        this.currentDiff = new ArrayList<Item>();
        this.diff();
    }

    private void diff() {
        Diff diff = new Diff(this.reference, this.current);
        Diff.Change script = diff.diff_2(false);
        this.twoColumnDiffFromScript(script, this.reference, this.current);
    }

    private void twoColumnDiffFromScript(Diff.Change script, Object[] a, Object[] b) {
        int ia = 0;
        int ib = 0;
        while (script != null) {
            int deleted = script.deleted;
            int inserted = script.inserted;
            while (ia < script.line0 && ib < script.line1) {
                Item cell = new Item(Item.DiffItemType.SAME, a[ia]);
                this.referenceDiff.add(cell);
                this.currentDiff.add(cell);
                ++ia;
                ++ib;
            }
            while (inserted > 0 || deleted > 0) {
                if (inserted > 0 && deleted > 0) {
                    this.referenceDiff.add(new Item(Item.DiffItemType.CHANGED, a[ia++]));
                    this.currentDiff.add(new Item(Item.DiffItemType.CHANGED, b[ib++]));
                } else if (inserted > 0) {
                    this.referenceDiff.add(new Item(Item.DiffItemType.EMPTY, null));
                    this.currentDiff.add(new Item(Item.DiffItemType.INSERTED, b[ib++]));
                } else if (deleted > 0) {
                    this.referenceDiff.add(new Item(Item.DiffItemType.DELETED, a[ia++]));
                    this.currentDiff.add(new Item(Item.DiffItemType.EMPTY, null));
                }
                --inserted;
                --deleted;
            }
            script = script.link;
        }
        while (ia < a.length && ib < b.length) {
            this.referenceDiff.add(new Item(Item.DiffItemType.SAME, a[ia++]));
            this.currentDiff.add(new Item(Item.DiffItemType.SAME, b[ib++]));
        }
    }

    public static class Item {
        public final Object value;
        public final DiffItemType state;

        public Item(DiffItemType state, Object value) {
            this.state = state;
            this.value = state == DiffItemType.EMPTY ? null : value;
        }

        public static enum DiffItemType {
            INSERTED(new Color(221, 255, 221)),
            DELETED(new Color(255, 197, 197)),
            CHANGED(new Color(255, 234, 213)),
            SAME(new Color(234, 234, 234)),
            EMPTY(new Color(234, 234, 234));

            private final Color color;

            private DiffItemType(Color color) {
                this.color = color;
            }

            public Color getColor() {
                return this.color;
            }
        }
    }
}

