/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.gui.history.DiffTableModel;
import org.openstreetmap.josm.gui.history.TwoColumnDiff;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RelationMemberListTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color BGCOLOR_EMPTY_ROW = new Color(234, 234, 234);
    public static final Color BGCOLOR_NOT_IN_OPPOSITE = new Color(255, 197, 197);
    public static final Color BGCOLOR_IN_OPPOSITE = new Color(255, 234, 213);
    public static final Color BGCOLOR_SELECTED = new Color(143, 170, 255);
    private Map<OsmPrimitiveType, ImageIcon> icons;

    public RelationMemberListTableCellRenderer() {
        this.setOpaque(true);
        this.icons = new HashMap<OsmPrimitiveType, ImageIcon>();
        this.icons.put(OsmPrimitiveType.NODE, ImageProvider.get("data", "node"));
        this.icons.put(OsmPrimitiveType.WAY, ImageProvider.get("data", "way"));
        this.icons.put(OsmPrimitiveType.RELATION, ImageProvider.get("data", "relation"));
    }

    protected void renderIcon(RelationMemberData member) {
        if (member == null) {
            this.setIcon(null);
        } else {
            this.setIcon(this.icons.get((Object)member.getMemberType()));
        }
    }

    protected void renderRole(TwoColumnDiff.Item diffItem, int row, boolean isSelected) {
        String text = "";
        Color bgColor = diffItem.state.getColor();
        RelationMemberData member = (RelationMemberData)diffItem.value;
        text = member == null ? "" : member.getRole();
        this.setText(text);
        this.setToolTipText(text);
        this.setBackground(bgColor);
    }

    protected void renderPrimitive(TwoColumnDiff.Item diffItem, int row, boolean isSelected) {
        String text = "";
        Color bgColor = diffItem.state.getColor();
        RelationMemberData member = (RelationMemberData)diffItem.value;
        text = "";
        if (member != null) {
            switch (member.getMemberType()) {
                case NODE: {
                    text = I18n.tr("Node {0}", member.getMemberId());
                    break;
                }
                case WAY: {
                    text = I18n.tr("Way {0}", member.getMemberId());
                    break;
                }
                case RELATION: {
                    text = I18n.tr("Relation {0}", member.getMemberId());
                }
            }
        }
        this.setText(text);
        this.setToolTipText(text);
        this.setBackground(bgColor);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TwoColumnDiff.Item member = (TwoColumnDiff.Item)value;
        this.renderIcon((RelationMemberData)member.value);
        switch (column) {
            case 0: {
                this.renderRole(member, row, isSelected);
                break;
            }
            case 1: {
                this.renderPrimitive(member, row, isSelected);
            }
        }
        return this;
    }

    protected DiffTableModel getRelationMemberTableModel(JTable table) {
        return (DiffTableModel)table.getModel();
    }
}

