/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.history.TwoColumnDiff;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class NodeListTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color BGCOLOR_SELECTED = new Color(143, 170, 255);
    private ImageIcon nodeIcon;

    public NodeListTableCellRenderer() {
        this.setOpaque(true);
        this.nodeIcon = ImageProvider.get("data", "node");
        this.setIcon(this.nodeIcon);
    }

    protected void renderNode(TwoColumnDiff.Item item, boolean isSelected) {
        String text = "";
        Color bgColor = Color.WHITE;
        this.setIcon(this.nodeIcon);
        if (item.value != null) {
            text = I18n.tr("Node {0}", item.value.toString());
        }
        bgColor = item.state.getColor();
        if (item.state == TwoColumnDiff.Item.DiffItemType.EMPTY) {
            text = "";
            this.setIcon(null);
        }
        if (isSelected) {
            bgColor = BGCOLOR_SELECTED;
        }
        this.setText(text);
        this.setBackground(bgColor);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.renderNode((TwoColumnDiff.Item)value, isSelected);
        return this;
    }
}

